/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.beans.viewer;

import com.ibm.ecm.beans.viewer.DocLoadInfo;
import com.ibm.ecm.beans.viewer.DroppableDocument;
import com.ibm.ecm.beans.viewer.StreamingDocServicesCallbacks;
import com.ibm.ecm.beans.viewer.SubRequest;
import com.ibm.ecm.beans.viewer.SubResponse;
import com.ibm.ecm.beans.viewer.ViewServicesInfo;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.viewer.PageImageMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.MimeTypeUtil;
import com.ibm.ecm.util.SecurityTokenManager;
import com.ibm.ecm.util.Util;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.CMBStreamingDocServices;
import com.ibm.mm.viewer.CMBStreamingDocServicesCallbacks;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.imageio.IIOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.commons.codec.binary.Base64;

public class DocServicesSessionBean
implements Serializable,
HttpSessionBindingListener {
    private static final long serialVersionUID = 1L;
    private static final int SCROLLBAR_WIDTH = 18;
    private transient CMBStreamingDocServices streamingDocServices;
    private transient Hashtable docURLtoDocMap;
    private transient Hashtable docLoadInfoMap;
    private transient LinkedList docList;
    private transient StreamingDocServicesCallbacks streamingDocServicesCallbacks;
    protected transient HttpSession _session;

    public DocServicesSessionBean(HttpSession session) {
        this._session = session;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private synchronized void init() {
        methodName = "init";
        Logger.logEntry((Object)this, methodName, this._session);
        if (this.streamingDocServices == null) {
            block12: {
                Logger.logInfo((Object)this, methodName, this._session, "streamingDocServices is null, constructing streamingDocServices");
                this.streamingDocServicesCallbacks = new StreamingDocServicesCallbacks(this);
                enginePropertiesStream = this.getClass().getResourceAsStream("DocServices.properties");
                engineProperties = new Properties();
                try {
                    engineProperties.load(enginePropertiesStream);
                    enginePropertiesStream.close();
                    var6_4 = null;
                    ** if (enginePropertiesStream == null) goto lbl-1000
                }
                catch (Throwable var5_11) {
                    var6_6 = null;
                    if (enginePropertiesStream != null) {
                        try {
                            enginePropertiesStream.close();
                        }
                        catch (IOException e) {
                            Logger.logError((Object)this, methodName, this._session, (Throwable)e);
                        }
                    }
                    throw var5_11;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        enginePropertiesStream.close();
                    }
                    catch (IOException e) {
                        Logger.logError((Object)this, methodName, this._session, (Throwable)e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block12;
                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, this._session, (Throwable)e);
                        var6_5 = null;
                        if (enginePropertiesStream != null) {
                            try {
                                enginePropertiesStream.close();
                            }
                            catch (IOException e) {
                                Logger.logError((Object)this, methodName, this._session, (Throwable)e);
                            }
                        }
                    }
                }
            }
            this.streamingDocServices = new CMBStreamingDocServices(this.streamingDocServicesCallbacks, engineProperties);
            this.streamingDocServices.setPreferredPageFormats(new String[]{"image/png"});
            this.docURLtoDocMap = new Hashtable<K, V>();
            this.docLoadInfoMap = new Hashtable<K, V>();
            this.docList = new LinkedList<E>();
        }
        Logger.logExit((Object)this, methodName, this._session);
    }

    private String getSecurityTokenParameter(HttpServletRequest request, String urlDelimiter) {
        String securityTokenParameter = "";
        if (BaseMediator.isSecureServiceEnabled(request)) {
            securityTokenParameter = "security_token=" + new SecurityTokenManager().generateToken(request);
            if (urlDelimiter != null) {
                securityTokenParameter = urlDelimiter + securityTokenParameter;
            }
        }
        return securityTokenParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageCount(String cookieProperty, URL contextURL, String docURLString, String contentType, String serverType, HttpServletRequest request, HttpServletResponse response) {
        String methodName = "getPageCount";
        Logger.logEntry((Object)this, methodName, this._session);
        if (this.streamingDocServices == null) {
            this.init();
        }
        try {
            CMBStreamingDocServices cMBStreamingDocServices = this.streamingDocServices;
            synchronized (cMBStreamingDocServices) {
                DroppableDocument droppableDocument = this.loadDocument(cookieProperty, contextURL, docURLString, contentType, serverType, request, response);
                CMBDocument cmbDocument = droppableDocument.getDocument();
                if (cmbDocument.getCanPaginate()) {
                    int pageCount = cmbDocument.getPageCount();
                    Logger.logInfo((Object)this, methodName, this._session, "pageCount = " + pageCount);
                    Logger.logExit((Object)this, methodName, this._session);
                    return pageCount;
                }
                Logger.logInfo((Object)this, methodName, this._session, "could not paginate, assuming pageCount = 1");
                Logger.logExit((Object)this, methodName, this._session);
                return 1;
            }
        }
        catch (Throwable e) {
            Logger.logError((Object)this, methodName, this._session, e);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewServicesInfo getViewServicesInfo(String cookieProperty, URL contextURL, String docURLString, String contentType, String serverType, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "getViewServicesInfo";
        Logger.logEntry((Object)this, methodName, this._session);
        if (this.streamingDocServices == null) {
            this.init();
        }
        CMBStreamingDocServices cMBStreamingDocServices = this.streamingDocServices;
        synchronized (cMBStreamingDocServices) {
            DroppableDocument droppableDocument = this.loadDocument(cookieProperty, contextURL, docURLString, contentType, serverType, request, response);
            CMBDocument cmbDocument = droppableDocument.getDocument();
            int pageCount = cmbDocument.getCanPaginate() ? cmbDocument.getPageCount() : 1;
            CMBPage page = cmbDocument.getPage(1);
            ViewServicesInfo viewServicesInfo = new ViewServicesInfo(pageCount, cmbDocument.getCanRotate(), cmbDocument.getCanEnhance(), cmbDocument.getCanInvert(), cmbDocument.getCanShowAnnotations(), page.getCanBalance(), cmbDocument.getCanPrint(), cmbDocument.getCanManipulatePages(), 0.1, 10.0);
            Logger.logInfo((Object)this, methodName, this._session, viewServicesInfo.toString());
            Logger.logExit((Object)this, methodName, this._session);
            return viewServicesInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePage(String cookieProperty, URL contextURL, String docURLString, String contentType, String serverType, int pageNo, double scale, int rotation, boolean inverted, float brightness, float contrast, int displayableWidth, int displayableHeight, HttpServletRequest request, HttpServletResponse response) {
        String methodName = "writePage";
        Logger.logEntry((Object)this, methodName, this._session);
        Logger.logInfo((Object)this, methodName, this._session, "docURLString=" + docURLString + " contentType=" + contentType + " serverType=" + serverType + " pageNo=" + pageNo + " scale=" + scale + " rotation=" + rotation + " invert=" + inverted + " brightness=" + brightness + " contrast=" + contrast + " displayableWidth=" + displayableWidth + "displayableHeight=" + displayableHeight);
        if (this.streamingDocServices == null) {
            this.init();
        }
        try {
            rotation %= 4;
            rotation = (rotation + 4) % 4;
            CMBStreamingDocServices cMBStreamingDocServices = this.streamingDocServices;
            synchronized (cMBStreamingDocServices) {
                DroppableDocument droppableDocument = this.loadDocument(cookieProperty, contextURL, docURLString, contentType, serverType, request, response);
                CMBDocument cmbDocument = droppableDocument.getDocument();
                CMBPage cmbPage = cmbDocument.getPage(pageNo);
                if (cmbDocument.getCanEnhance()) {
                    cmbDocument.setEnhance(true);
                }
                if (scale == -1.0) {
                    if (rotation == 1 || rotation == 3) {
                        scale = (double)displayableWidth / (cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        int newheight = (int)(scale * cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        if (newheight > displayableHeight) {
                            scale = (double)(displayableWidth - 18) / (cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        }
                    } else {
                        scale = (double)displayableWidth / (cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        int newheight = (int)(scale * cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        if (newheight > displayableHeight) {
                            scale = (double)(displayableWidth - 18) / (cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        }
                    }
                } else if (scale == -2.0) {
                    if (rotation == 1 || rotation == 3) {
                        scale = (double)displayableHeight / (cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        int newwidth = (int)(scale * cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        if (newwidth > displayableWidth) {
                            scale = (double)(displayableHeight - 18) / (cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        }
                    } else {
                        scale = (double)displayableHeight / (cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        int newwidth = (int)(scale * cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        if (newwidth > displayableWidth) {
                            scale = (double)(displayableHeight - 18) / (cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        }
                    }
                } else if (scale == -3.0) {
                    double bestHeightScale;
                    double bestWidthScale;
                    if (rotation == 1 || rotation == 3) {
                        bestWidthScale = (double)displayableWidth / (cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        bestHeightScale = (double)displayableHeight / (cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                    } else {
                        bestWidthScale = (double)displayableWidth / (cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        bestHeightScale = (double)displayableHeight / (cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                    }
                    scale = bestWidthScale < bestHeightScale ? bestWidthScale : bestHeightScale;
                }
                cmbDocument.setPreferredScale(scale);
                cmbDocument.setRotation(rotation);
                cmbDocument.setInvert(inverted);
                cmbPage.setBrightness(Math.max(0, Math.min((int)(brightness * 100.0f), 200)));
                cmbPage.setContrast(Math.max(0, Math.min((int)(contrast * 100.0f), 200)));
                String mimeType = cmbPage.getWriteMimeType();
                ServletOutputStream outStream = response.getOutputStream();
                if (mimeType != null) {
                    response.setContentType(mimeType);
                }
                Logger.logInfo((Object)this, methodName, this._session, "Writing page " + pageNo + " as " + mimeType);
                cmbPage.write((OutputStream)outStream);
                outStream.close();
                Logger.logInfo((Object)this, methodName, this._session, "Page written successfully");
            }
            Logger.logExit((Object)this, methodName, this._session);
        }
        catch (Throwable e) {
            if (e instanceof SocketException || e.getCause() != null && e.getCause() instanceof SocketException || e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof SocketException) {
                Logger.logInfo((Object)this, methodName, this._session, "socket exception" + e.getMessage());
                return;
            }
            if (e instanceof IIOException) {
                Logger.logInfo((Object)this, methodName, this._session, "IIOException" + e.getMessage());
                return;
            }
            Logger.logError((Object)this, methodName, this._session, e);
            if (e instanceof OutOfMemoryError) {
                response.setStatus(413);
            } else {
                response.setStatus(500);
            }
            try {
                if (e instanceof OutOfMemoryError) {
                    String errorMessage = MessageUtil.getMessage(request, "viewingServices.writePageOutOfMemory  " + MessageUtil.getMessage(request, "viewingServices.writePageOutOfMemory.explanation"));
                    CMBStreamingDocServices cmbStreamingDocServices = new CMBStreamingDocServices(new DummyStreamingDocServicesCallbacks(), null);
                    ByteArrayInputStream instream = new ByteArrayInputStream(errorMessage.getBytes());
                    CMBDocument cmbDocument = cmbStreamingDocServices.loadDocument(instream, 1, "text/plain", "text/plain", null, null);
                    cmbDocument.setEnhance(true);
                    cmbDocument.setPreferredScale(1.0);
                    CMBPage cmbPage = cmbDocument.getPage(1);
                    response.resetBuffer();
                    ServletOutputStream outStream = response.getOutputStream();
                    String mimeType = cmbPage.getWriteMimeType();
                    response.setContentType(mimeType);
                    cmbPage.write((OutputStream)outStream);
                    outStream.close();
                    cmbStreamingDocServices.dropDocument(cmbDocument);
                } else {
                    response.resetBuffer();
                }
            }
            catch (Throwable e2) {
                Logger.logInfo((Object)this, methodName, this._session, "Subsequent error occurred generating error page: " + e2.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPageImage(String cookieProperty, URL contextURL, String docURLString, String contentType, String serverType, int pageNo, double scale, int rotation, boolean inverted, float brightness, float contrast, int displayableWidth, int displayableHeight, HttpServletRequest request, HttpServletResponse response, PageImageMediator mediator) {
        String methodName = "writePage";
        Logger.logEntry((Object)this, methodName, this._session);
        Logger.logInfo((Object)this, methodName, this._session, "docURLString=" + docURLString + " contentType=" + contentType + " serverType=" + serverType + " pageNo=" + pageNo + " scale=" + scale + " rotation=" + rotation + " invert=" + inverted + " brightness=" + brightness + " contrast=" + contrast + " displayableWidth=" + displayableWidth + "displayableHeight=" + displayableHeight);
        if (this.streamingDocServices == null) {
            this.init();
        }
        try {
            rotation %= 4;
            rotation = (rotation + 4) % 4;
            CMBStreamingDocServices cMBStreamingDocServices = this.streamingDocServices;
            synchronized (cMBStreamingDocServices) {
                DroppableDocument droppableDocument = this.loadDocument(cookieProperty, contextURL, docURLString, contentType, serverType, request, response);
                CMBDocument cmbDocument = droppableDocument.getDocument();
                CMBPage cmbPage = cmbDocument.getPage(pageNo);
                if (cmbDocument.getCanEnhance()) {
                    cmbDocument.setEnhance(true);
                }
                if (scale == -1.0) {
                    if (rotation == 1 || rotation == 3) {
                        scale = (double)displayableWidth / (cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        int newheight = (int)(scale * cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        if (newheight > displayableHeight) {
                            scale = (double)(displayableWidth - 18) / (cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        }
                    } else {
                        scale = (double)displayableWidth / (cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        int newheight = (int)(scale * cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        if (newheight > displayableHeight) {
                            scale = (double)(displayableWidth - 18) / (cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        }
                    }
                } else if (scale == -2.0) {
                    if (rotation == 1 || rotation == 3) {
                        scale = (double)displayableHeight / (cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        int newwidth = (int)(scale * cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        if (newwidth > displayableWidth) {
                            scale = (double)(displayableHeight - 18) / (cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        }
                    } else {
                        scale = (double)displayableHeight / (cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        int newwidth = (int)(scale * cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        if (newwidth > displayableWidth) {
                            scale = (double)(displayableHeight - 18) / (cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        }
                    }
                } else if (scale == -3.0) {
                    double bestHeightScale;
                    double bestWidthScale;
                    if (rotation == 1 || rotation == 3) {
                        bestWidthScale = (double)displayableWidth / (cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                        bestHeightScale = (double)displayableHeight / (cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                    } else {
                        bestWidthScale = (double)displayableWidth / (cmbPage.getWidth() * (double)cmbDocument.getDisplayResolution());
                        bestHeightScale = (double)displayableHeight / (cmbPage.getHeight() * (double)cmbDocument.getDisplayResolution());
                    }
                    scale = bestWidthScale < bestHeightScale ? bestWidthScale : bestHeightScale;
                }
                cmbDocument.setPreferredScale(scale);
                cmbDocument.setRotation(rotation);
                cmbDocument.setInvert(inverted);
                cmbPage.setBrightness(Math.max(0, Math.min((int)(brightness * 100.0f), 200)));
                cmbPage.setContrast(Math.max(0, Math.min((int)(contrast * 100.0f), 200)));
                String mimeType = cmbPage.getWriteMimeType();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedOutputStream bfi = new BufferedOutputStream(baos);
                if (mimeType != null) {
                    response.setContentType(mimeType);
                }
                Logger.logInfo((Object)this, methodName, this._session, "Writing page " + pageNo + " as " + mimeType);
                cmbPage.write(bfi);
                bfi.close();
                StringBuffer imageBuffer = new StringBuffer("data:" + mimeType + ";base64,");
                imageBuffer.append(Base64.encodeBase64String((byte[])baos.toByteArray()));
                mediator.setImage(imageBuffer.toString());
                Logger.logInfo((Object)this, methodName, this._session, "Page written successfully");
            }
            Logger.logExit((Object)this, methodName, this._session);
        }
        catch (Throwable e) {
            if (e instanceof SocketException || e.getCause() != null && e.getCause() instanceof SocketException || e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof SocketException) {
                Logger.logInfo((Object)this, methodName, this._session, "socket exception" + e.getMessage());
                return;
            }
            if (e instanceof IIOException) {
                Logger.logInfo((Object)this, methodName, this._session, "IIOException" + e.getMessage());
                return;
            }
            Logger.logError((Object)this, methodName, this._session, e);
            if (e instanceof OutOfMemoryError) {
                response.setStatus(413);
            } else {
                response.setStatus(500);
            }
            try {
                if (e instanceof OutOfMemoryError) {
                    String errorMessage = MessageUtil.getMessage(request, "viewingServices.writePageOutOfMemory  " + MessageUtil.getMessage(request, "viewingServices.writePageOutOfMemory.explanation"));
                    CMBStreamingDocServices cmbStreamingDocServices = new CMBStreamingDocServices(new DummyStreamingDocServicesCallbacks(), null);
                    ByteArrayInputStream instream = new ByteArrayInputStream(errorMessage.getBytes());
                    CMBDocument cmbDocument = cmbStreamingDocServices.loadDocument(instream, 1, "text/plain", "text/plain", null, null);
                    cmbDocument.setEnhance(true);
                    cmbDocument.setPreferredScale(1.0);
                    CMBPage cmbPage = cmbDocument.getPage(1);
                    response.resetBuffer();
                    ServletOutputStream outStream = response.getOutputStream();
                    String mimeType = cmbPage.getWriteMimeType();
                    response.setContentType(mimeType);
                    cmbPage.write((OutputStream)outStream);
                    outStream.close();
                    cmbStreamingDocServices.dropDocument(cmbDocument);
                } else {
                    response.resetBuffer();
                }
            }
            catch (Throwable e2) {
                Logger.logInfo((Object)this, methodName, this._session, "Subsequent error occurred generating error page: " + e2.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertDocuments(String cookieProperty, URL contextURL, String[] docURLStrings, String[] contentTypes, String[] serverTypes, String targetContentType, HttpServletRequest request, HttpServletResponse response) {
        String methodName = "convertDocument";
        Logger.logEntry((Object)this, methodName, this._session);
        if (this.streamingDocServices == null) {
            this.init();
        }
        try {
            CMBStreamingDocServices cMBStreamingDocServices = this.streamingDocServices;
            synchronized (cMBStreamingDocServices) {
                String tempFileName;
                File tempFile = File.createTempFile("ContentNavigator", ".zip");
                String responseFileName = tempFileName = tempFile.getPath();
                tempFile.delete();
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tempFileName));
                String errorMessage = null;
                CMBDocument cmbDocument = null;
                DocLoadInfo docLoadInfo = null;
                String originalFileName = "";
                for (int i = 0; i < docURLStrings.length && errorMessage == null; ++i) {
                    Logger.logInfo((Object)this, methodName, this._session, "docURLString=" + docURLStrings[i] + " contentType=" + contentTypes[i] + " targetContentType=" + targetContentType);
                    DroppableDocument droppableDocument = this.loadDocument(cookieProperty, contextURL, docURLStrings[i], contentTypes[i], serverTypes[i], request, response);
                    cmbDocument = droppableDocument.getDocument();
                    if (targetContentType != null) {
                        this.streamingDocServices.setPreferredFormats(new String[]{targetContentType});
                    } else {
                        this.streamingDocServices.setPreferredFormats(new String[]{"text/html", "text/plain"});
                    }
                    String mimeType = cmbDocument.getWriteMimeType();
                    docLoadInfo = (DocLoadInfo)this.docLoadInfoMap.get(cmbDocument);
                    originalFileName = docLoadInfo.getOriginalFileName();
                    if (mimeType == null) {
                        errorMessage = MessageUtil.getMessage(request, "download.cannotConvert", (Object[])new String[]{originalFileName});
                        errorMessage = errorMessage + "\n" + MessageUtil.getMessage(request, "download.cannotConvert.explanation", (Object[])new String[]{originalFileName, MimeTypeUtil.getExtFromMimeType(cmbDocument.getMimeType()).toUpperCase()});
                        errorMessage = errorMessage + "\n" + MessageUtil.getMessage(request, "download.cannotConvert.userResponse");
                        continue;
                    }
                    String fileName = originalFileName;
                    if (fileName.lastIndexOf(46) > -1) {
                        fileName = fileName.substring(0, fileName.lastIndexOf(46));
                        fileName = fileName + "." + MimeTypeUtil.getExtFromMimeType(mimeType);
                    }
                    int attemptCount = 0;
                    boolean noException = false;
                    String zipEntryName = fileName;
                    while (attemptCount < docURLStrings.length && !noException) {
                        try {
                            zos.putNextEntry(new ZipEntry(zipEntryName));
                            noException = true;
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add document to temp zip file: " + zipEntryName);
                        }
                        catch (ZipException ze) {
                            int index = fileName.lastIndexOf(46);
                            zipEntryName = fileName.substring(0, index) + "(" + (attemptCount + 2) + ")" + fileName.substring(index);
                            ++attemptCount;
                        }
                    }
                    if (!noException) continue;
                    if (errorMessage == null) {
                        Logger.logInfo((Object)this, methodName, this._session, "Converting document to type " + cmbDocument.getWriteMimeType());
                        try {
                            cmbDocument.write((OutputStream)zos, request.getContextPath() + "/getConvertedDocumentResource.do?docUrl=" + URLEncoder.encode(docURLStrings[i]) + this.getSecurityTokenParameter(request, "&") + "&resourceId=");
                            Logger.logInfo((Object)this, methodName, this._session, "Converted document successfully");
                        }
                        catch (CMBDocumentEngineException cmbee) {
                            Logger.logError((Object)this, methodName, this._session, "Conversion failed for document: " + cmbee.getLocalizedMessage());
                            errorMessage = MessageUtil.getMessage(request, "download.cannotConvert", (Object[])new String[]{originalFileName});
                            errorMessage = errorMessage + "\n" + MessageUtil.getMessage(request, "download.cannotConvert.explanation", (Object[])new String[]{originalFileName, MimeTypeUtil.getExtFromMimeType(cmbDocument.getMimeType()).toUpperCase()});
                            errorMessage = errorMessage + "\n" + MessageUtil.getMessage(request, "download.cannotConvert.userResponse");
                        }
                    }
                    zos.closeEntry();
                    if (i != 0) continue;
                    responseFileName = fileName;
                }
                try {
                    zos.close();
                }
                catch (ZipException ze) {
                    // empty catch block
                }
                if (errorMessage == null) {
                    int index = responseFileName.lastIndexOf(46);
                    if (index > -1) {
                        responseFileName = responseFileName.substring(0, index);
                    }
                    tempFile = new File(tempFileName);
                    response.setHeader("Content-Type", "application/octet-stream");
                    response.setHeader("Content-Disposition", Util.getContentDispositionHeader(request, responseFileName + ".zip"));
                    response.setContentLength((int)tempFile.length());
                    ServletOutputStream outputStream = response.getOutputStream();
                    Util.copyStream(new FileInputStream(tempFile), (OutputStream)outputStream, true);
                } else {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "errorMessage: " + errorMessage);
                    request.setAttribute("downloadConversion", (Object)"true");
                    request.setAttribute("downloadFileName", (Object)originalFileName);
                    request.setAttribute("downloadFileType", (Object)MimeTypeUtil.getExtFromMimeType(cmbDocument.getMimeType()).toUpperCase());
                    response.setHeader("Content-Disposition", "inline");
                    response.sendError(501, errorMessage);
                }
                tempFile.delete();
            }
        }
        catch (Throwable e) {
            String errorMessage;
            if (e instanceof SocketException || e.getCause() != null && e.getCause() instanceof SocketException || e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof SocketException) {
                Logger.logInfo((Object)this, methodName, this._session, "socket exception" + e.getMessage());
                return;
            }
            Logger.logError((Object)this, methodName, this._session, e);
            if (e instanceof OutOfMemoryError) {
                errorMessage = MessageUtil.getMessage(request, "viewingServices.writePageOutOfMemory") + "  " + MessageUtil.getMessage(request, "viewingServices.writePageOutOfMemory.explanation");
            } else if (e instanceof HttpException) {
                HttpException httpException = (HttpException)e;
                errorMessage = MessageUtil.getMessage(request, "viewingServices.httpErrorOnRetrieve") + "  " + MessageUtil.getMessage(request, "viewingServices.httpErrorOnRetrieve.explanation", (Object[])new String[]{Integer.toString(httpException.getStatusCode()), httpException.getMessage()});
            } else {
                errorMessage = MessageUtil.getMessage(request, "viewingServices.convertDocError") + "  " + MessageUtil.getMessage(request, "viewingServices.convertDocError.explanation", (Object[])new String[]{e.getClass().getName() + ": " + e.getMessage()});
            }
            try {
                if (e instanceof OutOfMemoryError) {
                    response.sendError(413, errorMessage);
                } else {
                    response.sendError(500, errorMessage);
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        Logger.logExit((Object)this, methodName, this._session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertDocument(String cookieProperty, URL contextURL, String docURLString, String contentType, String serverType, String targetContentType, HttpServletRequest request, HttpServletResponse response) {
        String methodName = "convertDocument";
        Logger.logEntry((Object)this, methodName, this._session);
        Logger.logInfo((Object)this, methodName, this._session, "docURLString=" + docURLString + " contentType=" + contentType + " targetContentType=" + targetContentType);
        if (this.streamingDocServices == null) {
            this.init();
        }
        try {
            CMBStreamingDocServices cMBStreamingDocServices = this.streamingDocServices;
            synchronized (cMBStreamingDocServices) {
                DroppableDocument droppableDocument = this.loadDocument(cookieProperty, contextURL, docURLString, contentType, serverType, request, response);
                CMBDocument cmbDocument = droppableDocument.getDocument();
                if (targetContentType != null) {
                    this.streamingDocServices.setPreferredFormats(new String[]{targetContentType});
                } else {
                    this.streamingDocServices.setPreferredFormats(new String[]{"text/html", "text/plain"});
                }
                DocLoadInfo docLoadInfo = (DocLoadInfo)this.docLoadInfoMap.get(cmbDocument);
                String originalFileName = docLoadInfo.getOriginalFileName();
                String errorMessage = null;
                if (cmbDocument.getWriteMimeType() == null) {
                    Logger.logInfo((Object)this, methodName, this._session, "Cannot convert document to requested mimetype");
                    errorMessage = MessageUtil.getMessage(request, "viewingServices.cannotConvert", (Object[])new String[]{cmbDocument.getMimeType(), targetContentType});
                } else {
                    String mimeType = cmbDocument.getWriteMimeType();
                    if (mimeType != null) {
                        response.setContentType(mimeType);
                        String fileName = originalFileName;
                        if (fileName.lastIndexOf(46) > -1) {
                            fileName = fileName.substring(0, fileName.lastIndexOf(46));
                        }
                        fileName = fileName + "." + MimeTypeUtil.getExtFromMimeType(mimeType);
                        response.setHeader("Content-Disposition", Util.getContentDispositionHeader(request, fileName));
                    }
                    Logger.logInfo((Object)this, methodName, this._session, "Converting document to type " + mimeType);
                    try {
                        ConversionOutputStream outStream = new ConversionOutputStream(response);
                        cmbDocument.write((OutputStream)outStream, request.getContextPath() + "/getConvertedDocumentResource.do?docUrl=" + URLEncoder.encode(docURLString) + this.getSecurityTokenParameter(request, "&") + "&resourceId=");
                        ((OutputStream)outStream).close();
                        Logger.logInfo((Object)this, methodName, this._session, "Converted document successfully");
                    }
                    catch (CMBDocumentEngineException cmbee) {
                        Logger.logError((Object)this, methodName, this._session, "Conversion failed for document: " + cmbee.getLocalizedMessage());
                        errorMessage = MessageUtil.getMessage(request, "viewingServices.cannotConvert", (Object[])new String[]{cmbDocument.getMimeType(), targetContentType});
                    }
                }
                if (errorMessage != null) {
                    String disposition = request.getParameter("disposition");
                    if (disposition != null && disposition.equals("attachment")) {
                        errorMessage = MessageUtil.getMessage(request, "download.cannotConvert", (Object[])new String[]{originalFileName});
                        errorMessage = errorMessage + "\n" + MessageUtil.getMessage(request, "download.cannotConvert.explanation", (Object[])new String[]{originalFileName, MimeTypeUtil.getExtFromMimeType(cmbDocument.getMimeType()).toUpperCase()});
                        errorMessage = errorMessage + "\n" + MessageUtil.getMessage(request, "download.cannotConvert.userResponse");
                        request.setAttribute("downloadConversion", (Object)"true");
                        request.setAttribute("downloadFileName", (Object)originalFileName);
                        request.setAttribute("downloadFileType", (Object)MimeTypeUtil.getExtFromMimeType(cmbDocument.getMimeType()).toUpperCase());
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "errorMessage: " + errorMessage);
                    response.setHeader("Content-Disposition", "inline");
                    response.sendError(501, errorMessage);
                }
            }
        }
        catch (Throwable e) {
            String errorMessage;
            if (e instanceof SocketException || e.getCause() != null && e.getCause() instanceof SocketException || e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof SocketException) {
                Logger.logInfo((Object)this, methodName, this._session, "socket exception" + e.getMessage());
                return;
            }
            Logger.logError((Object)this, methodName, this._session, e);
            if (e instanceof OutOfMemoryError) {
                errorMessage = MessageUtil.getMessage(request, "viewingServices.writePageOutOfMemory") + "  " + MessageUtil.getMessage(request, "viewingServices.writePageOutOfMemory.explanation");
            } else if (e instanceof HttpException) {
                HttpException httpException = (HttpException)e;
                errorMessage = MessageUtil.getMessage(request, "viewingServices.httpErrorOnRetrieve") + "  " + MessageUtil.getMessage(request, "viewingServices.httpErrorOnRetrieve.explanation", (Object[])new String[]{Integer.toString(httpException.getStatusCode()), httpException.getMessage()});
            } else {
                errorMessage = MessageUtil.getMessage(request, "viewingServices.convertDocError") + "  " + MessageUtil.getMessage(request, "viewingServices.convertDocError.explanation", (Object[])new String[]{e.getClass().getName() + ": " + e.getMessage()});
            }
            try {
                if (e instanceof OutOfMemoryError) {
                    response.sendError(413, errorMessage);
                } else {
                    response.sendError(500, errorMessage);
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        Logger.logExit((Object)this, methodName, this._session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConvertedDocumentResource(String cookieProperty, URL contextURL, String docURLString, String resourceId, HttpServletRequest request, HttpServletResponse response) {
        String methodName = "writeConvertedDocumentResource";
        Logger.logEntry((Object)this, methodName, this._session);
        Logger.logInfo((Object)this, methodName, this._session, "docURLString=" + docURLString + " resourceId=" + resourceId);
        if (this.streamingDocServices == null) {
            this.init();
        }
        try {
            CMBStreamingDocServices cMBStreamingDocServices = this.streamingDocServices;
            synchronized (cMBStreamingDocServices) {
                DroppableDocument droppableDocument = this.loadDocument(cookieProperty, contextURL, docURLString, null, null, request, response);
                CMBDocument cmbDocument = droppableDocument.getDocument();
                ServletOutputStream outStream = response.getOutputStream();
                String mimeType = cmbDocument.getResourceMimeType(resourceId);
                if (mimeType != null) {
                    response.setContentType(mimeType);
                }
                Logger.logInfo((Object)this, methodName, this._session, "writing resource as mimetype " + mimeType);
                cmbDocument.writeResource((OutputStream)outStream, resourceId);
                outStream.close();
                Logger.logInfo((Object)this, methodName, this._session, "resource written successfully");
            }
        }
        catch (Throwable e) {
            if (e instanceof SocketException || e.getCause() != null && e.getCause() instanceof SocketException || e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof SocketException) {
                Logger.logInfo((Object)this, methodName, this._session, "socket exception" + e.getMessage());
                return;
            }
            Logger.logError((Object)this, methodName, this._session, e);
            response.setStatus(500);
            try {
                String errorMessage = MessageUtil.getMessage(request, "viewingServices.error", (Object[])new String[]{e.getClass().getName() + ": " + e.getMessage()});
                CMBStreamingDocServices cmbStreamingDocServices = new CMBStreamingDocServices(new DummyStreamingDocServicesCallbacks(), null);
                ByteArrayInputStream instream = new ByteArrayInputStream(errorMessage.getBytes());
                CMBDocument cmbDocument = cmbStreamingDocServices.loadDocument(instream, 1, "text/plain", "text/plain", null, null);
                cmbDocument.setEnhance(true);
                cmbDocument.setPreferredScale(1.0);
                CMBPage cmbPage = cmbDocument.getPage(1);
                response.resetBuffer();
                ServletOutputStream outStream = response.getOutputStream();
                String mimeType = cmbPage.getWriteMimeType();
                response.setContentType(mimeType);
                cmbPage.write((OutputStream)outStream);
                outStream.close();
                cmbStreamingDocServices.dropDocument(cmbDocument);
            }
            catch (Throwable e2) {
                Logger.logDebug((Object)this, methodName, this._session, "Subsequent error occurred generating error page: " + e2.getMessage());
            }
        }
        Logger.logExit((Object)this, methodName, this._session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DroppableDocument loadDocument(String cookieProperty, URL contextURL, String docURLString, String contentType, String serverType, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "loadDocument";
        Logger.logEntry((Object)this, methodName, this._session);
        CMBDocument cmbDocument = null;
        DroppableDocument droppableDocument = null;
        CMBStreamingDocServices cMBStreamingDocServices = this.streamingDocServices;
        synchronized (cMBStreamingDocServices) {
            SoftReference<DroppableDocument> docSoftRef = (SoftReference<DroppableDocument>)this.docURLtoDocMap.get(docURLString);
            if (docSoftRef != null && (droppableDocument = (DroppableDocument)docSoftRef.get()) != null) {
                cmbDocument = droppableDocument.getDocument();
                Logger.logInfo((Object)this, methodName, this._session, "Soft reference found for document, reusing previously loaded document");
            }
            if (docSoftRef == null || cmbDocument == null) {
                SoftReference oldDocSoftRef;
                DroppableDocument oldDroppableDocument;
                int lastPartPageCount;
                int partPageCount;
                URL docURL;
                Logger.logInfo((Object)this, methodName, this._session, "Soft reference not found or invalid, loading document");
                try {
                    if (serverType != null && serverType.equals("od")) {
                        Logger.logInfo((Object)this, methodName, this._session, "Adding transform=native and include_segment_info to Url for OD");
                        docURL = new URL(contextURL, docURLString + "&transform=native&include_segment_info=true");
                    } else {
                        Logger.logInfo((Object)this, methodName, this._session, "Adding transform=native");
                        docURL = new URL(contextURL, docURLString + "&transform=native");
                    }
                }
                catch (MalformedURLException e) {
                    Logger.logInfo((Object)this, methodName, this._session, "MalformedURLException -- assuming local resource");
                    docURL = this.getClass().getResource("/" + docURLString);
                }
                if (docURL == null) {
                    Logger.logInfo((Object)this, methodName, this._session, "The docURL could not be formed.  Throwing illegal argument exception");
                    throw new IllegalArgumentException("Not able to open document at URL: " + docURLString);
                }
                DocInfo docInfo = new DocInfo(contentType);
                InputStream instream = this.getContentFromService(docURLString, docURL, cookieProperty, request, response, docInfo);
                int contentLength = docInfo.contentLength;
                contentType = docInfo.contentType;
                String contentEncoding = docInfo.contentEncoding;
                int partCount = docInfo.partCount;
                if (serverType != null && serverType.equals("od")) {
                    Logger.logDebug((Object)this, methodName, this._session, "Getting od segment info headers");
                    partCount = docInfo.odPartCount;
                    partPageCount = docInfo.odPartPageCount;
                    lastPartPageCount = docInfo.odPartLastPageCount;
                    if (partCount <= 0 || partCount > 100000) {
                        throw new Exception(MessageUtil.getMessage(request, "viewingServices.unreasonablePartCount") + "  " + MessageUtil.getMessage(request, "viewingServices.unreasonablePartCount.explanation"));
                    }
                } else {
                    partPageCount = 0;
                    lastPartPageCount = 0;
                }
                Logger.logInfo((Object)this, methodName, this._session, "partCount: " + partCount + " partPageCount: " + partPageCount + " lastPartPageCount:" + lastPartPageCount + " contentLength: " + contentLength + " contentType: " + contentType + " contentEncoding: " + contentEncoding);
                if (contentEncoding == null) {
                    contentEncoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
                    Logger.logInfo((Object)this, methodName, this._session, "Content encoding not set, assuming " + contentEncoding);
                }
                Logger.logDebug((Object)this, methodName, this._session, "Invoking streamingDocServices.loadDocument");
                cmbDocument = this.streamingDocServices.loadDocument(instream, contentLength, partCount, contentType, contentType, null, null, contentEncoding);
                Logger.logDebug((Object)this, methodName, this._session, "loadDocument completed successfully");
                droppableDocument = new DroppableDocument(this.streamingDocServices, cmbDocument);
                docSoftRef = new SoftReference<DroppableDocument>(droppableDocument);
                this.docList.add(docSoftRef);
                if (this.docList.size() > 1 && (oldDroppableDocument = (DroppableDocument)(oldDocSoftRef = (SoftReference)this.docList.remove(0)).get()) != null) {
                    oldDocSoftRef.clear();
                    oldDroppableDocument.dropDocument();
                }
                this.docURLtoDocMap.put(docURLString, docSoftRef);
                DocLoadInfo docLoadInfo = new DocLoadInfo(cookieProperty, contextURL, docURLString, contentType, serverType, partCount, partPageCount, lastPartPageCount);
                docLoadInfo.setOriginalFileName((String)request.getAttribute("filename"));
                this.docLoadInfoMap.put(cmbDocument, docLoadInfo);
                SubRequestThread subRequestThread = (SubRequestThread)request.getAttribute("SubRequestThread");
                if (subRequestThread != null) {
                    cmbDocument.getPage(1).isValid();
                    try {
                        subRequestThread.join();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (cmbDocument != null) {
                DocLoadInfo docLoadInfo = this.getDocLoadInfo(cmbDocument);
                docLoadInfo.setLastRequestResponse(request, response);
            }
        }
        Logger.logExit((Object)this, methodName, this._session);
        return droppableDocument;
    }

    public void valueBound(HttpSessionBindingEvent arg0) {
    }

    public void valueUnbound(HttpSessionBindingEvent arg0) {
        String methodName = "valueUnbound";
        Logger.logEntry((Object)this, methodName, this._session);
        if (this.streamingDocServices != null) {
            this.streamingDocServices.terminate();
        }
        Logger.logExit((Object)this, methodName, this._session);
    }

    String getContentType(String docURLString, String contentType) {
        String methodName = "getContentType";
        Logger.logEntry((Object)this, methodName, this._session);
        if (!(contentType == null || contentType.equals("application/binary") || contentType.equals("text/plain") || contentType.equals("content/unknown"))) {
            if (contentType.indexOf(59) > 0) {
                contentType = contentType.substring(0, contentType.indexOf(59)).trim();
            }
            Logger.logDebug((Object)this, methodName, this._session, "Using content type as supplied: " + contentType);
        } else {
            String extension = docURLString.substring(docURLString.lastIndexOf(46) + 1);
            contentType = this.guessContentType(extension);
            Logger.logDebug((Object)this, methodName, this._session, "Guessing content type from extension: " + contentType);
        }
        Logger.logExit((Object)this, methodName, this._session);
        return contentType;
    }

    private String getContentEncoding(URLConnection docUrlConnection) {
        String contentEncoding = docUrlConnection.getContentEncoding();
        if (contentEncoding == null) {
            String contentType = docUrlConnection.getContentType();
            if (contentType != null && contentType.indexOf("charset=") > 0) {
                contentEncoding = contentType.substring(contentType.indexOf("charset=") + 8).trim();
            }
            if (contentEncoding == null) {
                contentEncoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
            }
        }
        return contentEncoding;
    }

    private String guessContentType(String extension) {
        if ((extension = extension.toLowerCase()).equals("gif")) {
            return "image/gif";
        }
        if (extension.equals("jpg") || extension.equals("jpeg")) {
            return "image/jpeg";
        }
        if (extension.equals("tif") || extension.equals("tiff")) {
            return "image/tiff";
        }
        if (extension.equals("pdf")) {
            return "application/pdf";
        }
        if (extension.equals("mda")) {
            return "application/vnd.ibm.modcap";
        }
        if (extension.equals("afp")) {
            return "application/afp";
        }
        if (extension.equals("txt")) {
            return "text/plain";
        }
        if (extension.equals("htm") || extension.equals("html")) {
            return "text/html";
        }
        if (extension.equals("rtf")) {
            return "text/richtext";
        }
        if (extension.equals("doc")) {
            return "application/msword";
        }
        if (extension.equals("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (extension.equals("lwp")) {
            return "application/vnd.lotus-wordpro";
        }
        if (extension.equals("123")) {
            return "application/vnd.lotus-1-2-3";
        }
        if (extension.equals("prz")) {
            return "application/vnd.lotus-freelance";
        }
        if (extension.equals("xls")) {
            return "application/vnd.ms-excel";
        }
        if (extension.equals("wp")) {
            return "application/wordperfect5.1";
        }
        if (extension.equals("bmp")) {
            return "image/bmp";
        }
        if (extension.equals("pcx")) {
            return "image/pcx";
        }
        if (extension.equals("dcx")) {
            return "image/dcx";
        }
        if (extension.equals("xml")) {
            return "text/xml";
        }
        if (extension.equals("lin")) {
            return "application/line";
        }
        return "application/binary";
    }

    public DocLoadInfo getDocLoadInfo(CMBDocument document) {
        return (DocLoadInfo)this.docLoadInfoMap.get(document);
    }

    public InputStream getContentFromService(String docURLString, URL docURL, String cookieProperty, HttpServletRequest request, HttpServletResponse response, DocInfo docInfo) throws IOException, HttpException, ServletException {
        HttpURLConnection httpDocUrlConnection;
        String methodName = "getContentFromService";
        Logger.logInfo((Object)this, "getContentFromService", this._session, "Attempting to open the connection to the docURL.");
        URLConnection docUrlConnection = docURL.openConnection();
        docUrlConnection.setRequestProperty("Connection", "close");
        if (cookieProperty != null) {
            Logger.logInfo((Object)this, "getContentFromService", this._session, "Setting COOKIE property: " + cookieProperty);
            docUrlConnection.setRequestProperty("COOKIE", cookieProperty);
        }
        Logger.logInfo((Object)this, "getContentFromService", this._session, "Connecting");
        docUrlConnection.connect();
        if (docUrlConnection instanceof HttpURLConnection && (httpDocUrlConnection = (HttpURLConnection)docUrlConnection).getResponseCode() != 200) {
            throw new HttpException(httpDocUrlConnection.getResponseCode(), httpDocUrlConnection.getResponseMessage());
        }
        String fileName = "unknown";
        String responseDisposition = docUrlConnection.getHeaderField("Content-Disposition");
        if (responseDisposition != null) {
            if (responseDisposition.indexOf("filename=") > -1) {
                fileName = responseDisposition.substring(responseDisposition.indexOf("filename=") + "filename=".length());
                if (fileName.charAt(0) == '\"') {
                    fileName = fileName.substring(1, fileName.length() - 1);
                }
            } else if (responseDisposition.indexOf("filename*=UTF-8''") > -1) {
                fileName = responseDisposition.substring(responseDisposition.indexOf("filename*=UTF-8''") + "filename*=UTF-8''".length());
                fileName = URLDecoder.decode(fileName, "utf-8");
            }
        }
        request.setAttribute("filename", (Object)fileName);
        Logger.logInfo((Object)this, "getContentFromService", this._session, "Getting an input stream.");
        InputStream instream = docUrlConnection.getInputStream();
        if (docInfo != null) {
            docInfo.contentLength = docUrlConnection.getContentLength();
            docInfo.contentType = this.getContentType(docURLString, docUrlConnection.getContentType());
            docInfo.contentEncoding = this.getContentEncoding(docUrlConnection);
            if (docUrlConnection instanceof HttpURLConnection) {
                HttpURLConnection httpDocUrlConnection2 = (HttpURLConnection)docUrlConnection;
                docInfo.partCount = httpDocUrlConnection2.getHeaderFieldInt("Part-Count", 1);
                docInfo.odPartCount = httpDocUrlConnection2.getHeaderFieldInt("Segment-Count", 1);
                docInfo.odPartPageCount = httpDocUrlConnection2.getHeaderFieldInt("Segment-Page-Count", 0);
                docInfo.odPartLastPageCount = httpDocUrlConnection2.getHeaderFieldInt("Segment-Last-Page-Count", 0);
                if (docInfo.odPartCount < 1) {
                    docInfo.odPartCount = 1;
                }
            }
        }
        return instream;
    }

    public static class DocInfo {
        public int contentLength;
        public String contentType;
        public String contentEncoding;
        public int partCount;
        public int odPartCount;
        public int odPartPageCount;
        public int odPartLastPageCount;

        public DocInfo() {
        }

        public DocInfo(String contentType) {
            this.contentType = contentType;
        }
    }

    public class HttpException
    extends Exception {
        int statusCode;

        HttpException(int statusCode, String message) {
            super(message);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }

    private class DummyStreamingDocServicesCallbacks
    extends CMBStreamingDocServicesCallbacks {
        private DummyStreamingDocServicesCallbacks() {
        }

        public InputStream getAnnotation(CMBDocument document, int annotationNumber) {
            return null;
        }

        public InputStream getForm(CMBDocument document, String formName) {
            return null;
        }

        public InputStream getPart(CMBDocument document, int partNumber, StringBuffer outMimeType) {
            return null;
        }

        public InputStream getResources(CMBDocument document) {
            return null;
        }

        public void trace(String message) {
        }

        public boolean traceEnabled() {
            return false;
        }
    }

    private class SubRequestThread
    extends Thread {
        RequestDispatcher dispatcher;
        SubRequest subRequest;
        SubResponse subResponse;
        Throwable exception;

        public SubRequestThread(RequestDispatcher dispatcher, SubRequest subRequest, SubResponse subResponse) {
            super("DocServicesSessionBean.SubRequestThread");
            this.dispatcher = dispatcher;
            this.subRequest = subRequest;
            this.subResponse = subResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block8: {
                String methodName = "run";
                Logger.logInfo((Object)this, methodName, DocServicesSessionBean.this._session, "Invoking servlet");
                this.dispatcher.include((ServletRequest)this.subRequest, (ServletResponse)this.subResponse);
                Logger.logInfo((Object)this, methodName, DocServicesSessionBean.this._session, "Returned from servlet");
                Object var4_2 = null;
                try {
                    this.subResponse.getOutputStream().close();
                }
                catch (Exception e2) {}
                break block8;
                {
                    catch (Throwable e) {
                        this.exception = e;
                        Object var4_3 = null;
                        try {
                            this.subResponse.getOutputStream().close();
                        }
                        catch (Exception e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    try {
                        this.subResponse.getOutputStream().close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public void start() {
            super.start();
            this.subResponse.waitForHeader();
        }
    }

    private class ConversionOutputStream
    extends OutputStream {
        HttpServletResponse response;
        OutputStream out = null;

        public ConversionOutputStream(HttpServletResponse response) {
            this.response = response;
        }

        public void write(int b) throws IOException {
            if (this.out == null) {
                this.out = this.response.getOutputStream();
            }
            this.out.write(b);
        }

        public void flush() throws IOException {
            if (this.out != null) {
                this.out.flush();
            }
        }

        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
            }
        }
    }
}

