/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.beans.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKResults;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkResultSetCursor;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class CMSearchResults
implements Serializable {
    private static final long serialVersionUID = -4009598504794959468L;
    private WCDateFormat wcDateFormats = null;
    private int _pageSize = 50;
    private String currentItemType = null;
    private Vector itemTypes = null;
    private int _curItemIdx = 0;
    private Vector _hitList = new Vector(100, 100);
    private transient Vector pageRes = new Vector(this._pageSize, 100);
    private int cntInPage = 0;
    private CMConnection _connection;
    private String _nameAttr = null;
    private Vector _itemGroup;
    private boolean MIMEtypesIncluded = true;
    private boolean isWorkflowResults = false;
    private HttpServletRequest request;

    public CMSearchResults(HttpServletRequest request, CMConnection connection) {
        this._connection = connection;
        this.request = request;
    }

    public int getPageSize() {
        return this._pageSize;
    }

    public void setPageSize(int newSize) {
        this._pageSize = newSize;
    }

    public CMConnection getConnection() {
        return this._connection;
    }

    public int getCount() {
        return this._hitList.size();
    }

    public void resetCurrentHitItem() {
        this._curItemIdx = 0;
    }

    public String getPidString() throws Exception {
        String methodName = "getItems";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (this._curItemIdx >= this._hitList.size()) {
            throw new Exception();
        }
        CMItem itemObj = (CMItem)this._hitList.elementAt(this._curItemIdx - 1);
        DKDDO obj = itemObj.getDDO();
        String pidStr = obj.getPidObject().pidString();
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return pidStr;
    }

    public CMItem getItem(String pidString) {
        String methodName = "getItems";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        for (int i = 0; i < this._hitList.size(); ++i) {
            CMItem itemObj = (CMItem)this._hitList.elementAt(i);
            if (!itemObj.getPidString().equals(pidString)) continue;
            return itemObj;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return null;
    }

    public CMItem[] getItems() {
        String methodName = "getItems";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (this._hitList.size() == 0) {
            return new CMItem[0];
        }
        int cnt = this._hitList.size();
        CMItem[] itemList = null;
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "hitlist size = " + cnt);
        if (this.getCurrentItemType() == null || this.isWorkflowResults) {
            itemList = new CMItem[cnt];
            for (int i = 0; i < cnt; ++i) {
                itemList[i] = (CMItem)this._hitList.elementAt(i);
            }
        } else {
            String entity = null;
            Vector<CMItem> items = new Vector<CMItem>();
            for (int i = 0; i < cnt; ++i) {
                CMItem item = (CMItem)this._hitList.elementAt(i);
                entity = item.getEntityName();
                if (!entity.equalsIgnoreCase(this.getCurrentItemType())) continue;
                items.add(item);
            }
            itemList = new CMItem[items.size()];
            for (int counter = 0; counter < items.size(); ++counter) {
                itemList[counter] = (CMItem)items.elementAt(counter);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return itemList;
    }

    public synchronized void removeItem(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this._hitList.size() || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this._hitList.removeElementAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newResults(Object resultObj, boolean mimeTypesIncluded, boolean attrsRetrieved, boolean linksRetrieved, boolean _partsRetrieved) throws Exception {
        String methodName = "newResults";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        DKDatastoreICM dKDatastoreICM = this._connection.getDatastore();
        synchronized (dKDatastoreICM) {
            this.clearResults();
            this._nameAttr = "";
            this.appendResults(resultObj, attrsRetrieved, linksRetrieved, _partsRetrieved);
        }
        this.MIMEtypesIncluded = mimeTypesIncluded;
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public void newResults(Object resultObj, boolean attrsRetrieved, boolean linksRetrieved, boolean _partsRetrieved) throws Exception {
        String methodName = "newResults";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        this.newResults(resultObj, true, attrsRetrieved, linksRetrieved, _partsRetrieved);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void appendResults(Object resultList, boolean attrsRetrieved, boolean linksRetrieved, boolean _partsRetrieved) throws Exception {
        methodName = "appendResults";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        var6_6 = this._connection.getDatastore();
        synchronized (var6_6) {
            block27: {
                block28: {
                    if (resultList == null) {
                        return;
                    }
                    if (!(resultList instanceof dkResultSetCursor)) break block28;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Processing dkResultSetCursor");
                    pCur = (dkResultSetCursor)resultList;
                    if (pCur == null) break block27;
                    while (pCur.isValid() && !pCur.isEnd()) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking pCur.fetchNext()");
                        ddo = pCur.fetchNext();
                        if (ddo == null) continue;
                        this._appendDDOToResults(ddo, attrsRetrieved, linksRetrieved, _partsRetrieved);
                    }
                    var11_16 = null;
                    try {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking pCur.destroy()");
                        pCur.close();
                        pCur.destroy();
                    }
                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                    break block27;
                    {
                        catch (Exception ex) {
                            try {
                                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking pCur.destroy()");
                                pCur.destroy();
                            }
                            catch (Exception e) {
                                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                            }
                            pCur = null;
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ex);
                            var11_17 = null;
                            try {
                                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking pCur.destroy()");
                                pCur.close();
                                pCur.destroy();
                            }
                            catch (Exception e) {
                                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                            }
                            break block27;
                        }
                    }
                    catch (Throwable var10_25) {
                        var11_18 = null;
                        try {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking pCur.destroy()");
                            pCur.close();
                            pCur.destroy();
                        }
                        catch (Exception e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        }
                        throw var10_25;
                    }
                }
                if (resultList instanceof DKResults) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Processing DKResults");
                    try {
                        res = (DKResults)resultList;
                        iter = res.createIterator();
                        while (iter.more()) {
                            ddo = (DKDDO)iter.next();
                            if (ddo == null) continue;
                            this._appendDDOToResults(ddo, attrsRetrieved, linksRetrieved, _partsRetrieved);
                        }
                    }
                    catch (Exception ex) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ex);
                    }
                } else if (resultList instanceof List) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Processing Vector of DDO's");
                    try {
                        res = (List)resultList;
                        nItems = res.size();
                        if (nItems <= 0) ** GOTO lbl98
                        findType = res.get(0);
                        if (findType instanceof CMItem) {
                            for (i = 0; i < nItems; ++i) {
                                if (res.get(i) == null) continue;
                                this._appendItemToResults((CMItem)res.get(i));
                            }
                        }
                        if (!(findType instanceof DKDDO)) ** GOTO lbl98
                        for (i = 0; i < nItems; ++i) {
                            if (res.get(i) == null) continue;
                            this._appendDDOToResults((DKDDO)res.get(i), attrsRetrieved, linksRetrieved, _partsRetrieved);
                        }
                    }
                    catch (Exception ex) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ex);
                    }
                } else {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, "Unsupported collection type!!!!");
                }
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _appendDDOToResults(DKDDO ddo, boolean attrsRetrieved, boolean linksRetrieved, boolean _partsRetrieved) throws DKUsageError, Exception {
        String methodName = "_appendDDOToResults";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (ddo != null) {
            DKDatastoreICM dKDatastoreICM = this._connection.getDatastore();
            synchronized (dKDatastoreICM) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Creating WCitem");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "ddo: " + ddo + " _connection.getDatastore(): " + this._connection.getDatastore() + " _nameAttr: " + this._nameAttr);
                CMItem item = new CMItem(this.request, this._connection, ddo, this._nameAttr, attrsRetrieved, linksRetrieved, _partsRetrieved);
                item.setDateFormats(this.getWcDateFormats());
                if (ddo.dataCount() > 0) {
                    if (ddo.isDataSet((short)1) && !"CHILD".equals(ddo.getDataNameSpace((short)1))) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "The item is already retrieved");
                        item.setRetrieved(true);
                    } else {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "The item is not already retrieved");
                        item.setRetrieved(false);
                    }
                } else {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "The item is not already retrieved.  ddo.dataCount() >! 0");
                    item.setRetrieved(false);
                }
                this._appendItemToResults(item);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private void _appendItemToResults(CMItem item) {
        String methodName = "_appendItemToResults";
        if (item != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "add item: " + item.getPidString());
            this._hitList.addElement(item);
            this.pageRes.addElement(item);
            if (!item.isRetrieved()) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "The item is not retrieved");
                if (this._itemGroup == null) {
                    this._itemGroup = new Vector();
                }
                item.setItemGroup(this._itemGroup);
                this._itemGroup.addElement(item);
            }
            ++this.cntInPage;
        }
        if (this.cntInPage == this._pageSize) {
            this._itemGroup = null;
        }
    }

    public synchronized void clearResults() {
        this._hitList.removeAllElements();
        this.pageRes.removeAllElements();
        this._itemGroup = null;
        this._curItemIdx = 0;
        this.cntInPage = 0;
    }

    public String getCurrentItemType() {
        if (this.currentItemType == null && this.getItemTypes() != null) {
            return (String)this.getItemTypes().get(0);
        }
        return this.currentItemType;
    }

    public void setCurrentItemType(String currentItemType) {
        this.currentItemType = currentItemType;
    }

    public Vector getItemTypes() {
        return this.itemTypes;
    }

    public void setItemTypes(Vector itemTypes) {
        this.itemTypes = itemTypes;
    }

    public WCDateFormat getWcDateFormats() {
        return this.wcDateFormats;
    }

    public void setWcDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    public Vector get_itemGroup() {
        return this._itemGroup;
    }

    public void set_itemGroup(Vector group) {
        this._itemGroup = group;
    }

    public boolean areMIMETypesIncluded() {
        return this.MIMEtypesIncluded;
    }

    public void setIsWorkflowResults(boolean isWorkflowResults) {
        this.isWorkflowResults = isWorkflowResults;
    }

    public void sortOnNewest() {
        Object[] items = this._hitList.toArray();
        Arrays.sort(items, new Comparator(){

            public int compare(Object o1, Object o2) {
                Timestamp t2;
                CMItem i1 = (CMItem)o1;
                CMItem i2 = (CMItem)o2;
                Timestamp t1 = i1.getLastChangedTimestamp();
                if (t1.after(t2 = i2.getLastChangedTimestamp())) {
                    return -1;
                }
                if (t1.before(t2)) {
                    return 1;
                }
                return 0;
            }
        });
        this._hitList = new Vector();
        for (int i = 0; i < items.length; ++i) {
            this._hitList.add(items[i]);
        }
    }
}

