/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.beans.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.configuration.UserActionMacroConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.mediator.cm.CMCriteriasMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.ecm.util.cm.CMSearchConstants;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKAttrGroupDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKItemTypeDefICM;
import com.ibm.mm.sdk.common.DKNVPair;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKResults;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDatastoreDef;
import com.ibm.mm.sdk.common.dkEntityDef;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.common.dkResultSetCursor;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMQueryService
implements Serializable {
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss");
    private static final long serialVersionUID = 1L;
    private boolean searchForCheckedItems = false;
    private boolean searchForFolders = false;
    private boolean searchForDocuments = false;
    public static final String LATEST_VERSION = "LATEST_VERSION";
    public static final String ALL_VERSIONS = "ALL_VERSIONS";
    private String _qryString = "";
    private DKNVPair[] _dkNVPairs = null;
    private int _maxResults = -1;
    private int _retrieveOption = 4;
    private String _version = "ALL_VERSIONS";
    private DKDatastoreICM _dsICM = null;
    private int _threshold = 10;
    private HttpServletRequest request;
    private CMConnection connection;
    private String sortBy = null;
    private boolean sortDescending = false;
    private boolean _propertyTextSearchAnded = false;

    public CMQueryService(HttpServletRequest request, DKDatastoreICM _dsICM) {
        this(request, null, _dsICM);
    }

    public CMQueryService(HttpServletRequest request, CMConnection connection, DKDatastoreICM _dsICM) {
        this.request = request;
        this.connection = connection;
        this.setDataStore(_dsICM);
    }

    public synchronized void setDataStore(DKDatastoreICM dsICM) {
        this._dsICM = dsICM;
    }

    public int getCallbackThreshold() {
        return this._threshold;
    }

    public synchronized void setCallbackThreshold(int value) {
        this._threshold = value;
    }

    public int getMaxResults() {
        return this._maxResults;
    }

    public synchronized void setMaxResults(int max) {
        this._maxResults = max;
    }

    int getRetrieveOption() {
        return this._retrieveOption;
    }

    synchronized void setRetrieveOption(int max) {
        this._retrieveOption = max;
    }

    public String getVersion() {
        return this._version;
    }

    public synchronized void setVersion(String version) {
        this._version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateQueryExpression(SearchTemplate searchTemplate, boolean matchAllCriteria, MessageResources resources, Locale locale) throws Exception {
        String methodName = "generateQueryExpression";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        DKDatastoreICM dKDatastoreICM = this._dsICM;
        synchronized (dKDatastoreICM) {
            String qExpr = null;
            String entityName = searchTemplate.getFirstClassName();
            ArrayList<QueryCriterion> criteria = CMCriteriasMediator.getQueryCriteria(this.request, searchTemplate, this, resources, locale);
            List<SearchTemplate.SearchFolder> folders = searchTemplate.getFolders();
            DKPidICM folderPid = null;
            boolean searchSubfolders = false;
            if (folders != null && !folders.isEmpty()) {
                SearchTemplate.SearchFolder folder = folders.get(0);
                folderPid = new DKPidICM(folder.getId());
                searchSubfolders = folder.isSearchSubfolders();
            }
            this._lookupDataTypes(entityName, criteria);
            qExpr = this._generateXPathQuery(searchTemplate, criteria, matchAllCriteria, folderPid, searchSubfolders);
            Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
            return qExpr;
        }
    }

    public String addQueryConditions(String query) {
        String methodName = "_addQueryConditions";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (query == null) {
            return query;
        }
        String[] condition = new String[4];
        condition[0] = this.isSearchForCheckedItems() ? "ICMCHECKEDOUT" : null;
        condition[2] = this.isSearchForFolders() ? "@SEMANTICTYPE =2" : null;
        condition[3] = this.isSearchForDocuments() ? "@SEMANTICTYPE!=2" : null;
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "queryString = " + query);
        for (int i = 0; i < condition.length; ++i) {
            if (condition[i] == null) continue;
            StringBuffer sb = new StringBuffer(query.trim());
            String temp = query.trim();
            int pos1 = temp.indexOf(91);
            int pos3 = temp.indexOf("(/") > -1 ? temp.indexOf(41) : temp.indexOf(32);
            int pos2 = temp.indexOf(93);
            boolean hasCriteria = false;
            if (pos2 - pos1 > 1) {
                hasCriteria = true;
            }
            if (pos1 > -1) {
                if (hasCriteria) {
                    sb.insert(pos1 + 1, condition[i] + " AND ");
                } else {
                    sb.insert(pos1 + 1, condition[i]);
                }
            } else if (pos3 > -1) {
                sb.insert(pos3 + 1, "[" + condition[i] + "] ");
            } else {
                sb.append(" [" + condition[i] + "]");
            }
            query = sb.toString();
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "queryString = " + query);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return query;
    }

    private dkEntityDef getEntityDef(String entityName) throws Exception {
        String methodName = "getEntityDef";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Entity Name: " + entityName);
        dkDatastoreDef dsDef = this._dsICM.datastoreDef();
        dkCollection _entityList = dsDef.listEntities();
        dkIterator iterator = _entityList.createIterator();
        dkEntityDef entity = null;
        boolean found = false;
        while (iterator.more()) {
            entity = (dkEntityDef)iterator.next();
            if (entity instanceof DKComponentTypeDefICM) {
                found = entity.getName().equals(entityName);
            }
            if (!found) continue;
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Found entity: " + found);
            break;
        }
        if (!found) {
            entity = null;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _lookupDataTypes(String entityName, ArrayList<QueryCriterion> criteria) throws Exception {
        String methodName = "_lookupDataTypes";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        DKDatastoreICM dKDatastoreICM = this._dsICM;
        synchronized (dKDatastoreICM) {
            String nameSeparator = "/";
            HashMap<String, DKAttrDefICM> attribMap = null;
            if (entityName.equals("$common")) {
                DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)this._dsICM.datastoreDef();
                dkCollection attributes = dsDefICM.listAttrs();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Retrieved all attributes");
                dkIterator dkIterator2 = attributes.createIterator();
                DKAttrDefICM attrib = null;
                attribMap = new HashMap<String, DKAttrDefICM>();
                while (dkIterator2.more()) {
                    attrib = (DKAttrDefICM)dkIterator2.next();
                    attribMap.put(attrib.getName(), attrib);
                }
                for (QueryCriterion crit : criteria) {
                    attrib = (DKAttrDefICM)attribMap.get(crit._name);
                    if (attrib == null) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Attribute not found: " + crit._name);
                        continue;
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Criterion types set for attribute: " + crit._name);
                    crit.setTypes(attrib);
                }
            } else {
                DKComponentTypeDefICM entityDef = (DKComponentTypeDefICM)this._dsICM.datastoreDef().retrieveEntity(entityName);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "EntityName = " + entityName);
                if (entityDef != null) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, " criteria.length = " + criteria.size());
                    block5: for (QueryCriterion crit : criteria) {
                        DKAttrDefICM attrDef = null;
                        if (crit == null) continue;
                        if (crit._name.indexOf(".") < 0) {
                            if (crit._type != 0) continue;
                            attrDef = (DKAttrDefICM)entityDef.getAttr(crit._name);
                        } else {
                            String attrGroupName = crit._name.substring(0, crit._name.indexOf("."));
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "attribute[" + crit._name.substring(crit._name.indexOf(".") + 1) + "] from group[" + attrGroupName + "]");
                            DKAttrGroupDefICM attrGroupDef = (DKAttrGroupDefICM)entityDef.getAttrGroup(attrGroupName);
                            if (attrGroupDef != null) {
                                Vector groupAttrs = attrGroupDef.getAttrs();
                                Enumeration enumGroupAttrs = groupAttrs.elements();
                                while (enumGroupAttrs.hasMoreElements() && ((attrDef = (DKAttrDefICM)enumGroupAttrs.nextElement()) == null || !attrDef.getName().equals(crit._name))) {
                                }
                            } else {
                                attrDef = (DKAttrDefICM)entityDef.getAttr(crit._name);
                            }
                        }
                        if (attrDef != null) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Setting attribute Def " + crit._name + " on QueryCriterion");
                            crit.setTypes(attrDef);
                            continue;
                        }
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Child attribute Def " + crit._name);
                        StringTokenizer tok = new StringTokenizer(crit._name, nameSeparator);
                        if (tok.countTokens() <= 1) continue;
                        int tokCount = 0;
                        DKComponentTypeDefICM curEnt = entityDef;
                        while (tok.hasMoreTokens()) {
                            String curTok = tok.nextToken();
                            ++tokCount;
                            if (tok.hasMoreTokens()) {
                                DKSequentialCollection compTypes = (DKSequentialCollection)curEnt.listSubEntities();
                                if (compTypes == null) continue;
                                dkIterator childCompIter = compTypes.createIterator();
                                DKComponentTypeDefICM subEntity = null;
                                while (childCompIter.more()) {
                                    DKComponentTypeDefICM compType = (DKComponentTypeDefICM)childCompIter.next();
                                    if (!compType.getName().equals(curTok)) continue;
                                    subEntity = compType;
                                    break;
                                }
                                if (subEntity == null) continue block5;
                                curEnt = subEntity;
                                continue;
                            }
                            DKAttrDefICM endAtt = (DKAttrDefICM)curEnt.getAttr(curTok);
                            if (endAtt == null) continue;
                            crit.setTypes(endAtt);
                        }
                    }
                }
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private String getEntityDefName(String entityName) throws Exception {
        String name;
        dkEntityDef entityDef = this.getEntityDef(entityName);
        if (entityDef == null) {
            Logger.logDebug((Object)this, "getEntityDefName", (ServletRequest)this.request, "No Entity Def found.  Assuming ICM$FOLDER");
            name = "ICM$FOLDER";
        } else {
            name = entityDef.getName();
        }
        return name;
    }

    private String _generateXPathQuery(SearchTemplate searchTemplate, ArrayList<QueryCriterion> criteria, boolean matchAllCriteria, DKPidICM folderPid, boolean searchSubfolders) throws Exception {
        String generatedTSStr;
        String tsText;
        String userActionExp;
        SearchTemplate.UserAction[] userActions;
        String methodName = "_generateXPathQuery";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        String qs = null;
        dkEntityDef entityDef = null;
        boolean isTextSearchRankEnabled = false;
        Vector<String> textSearchTerms = null;
        String firstEntityName = searchTemplate.getFirstClassName();
        boolean isAllItemTypeSearch = firstEntityName.equals("$common");
        if (isAllItemTypeSearch) {
            qs = "/*";
        } else {
            entityDef = this.getEntityDef(firstEntityName);
            List<SearchTemplate.SearchClass> classes = searchTemplate.getClasses();
            if (classes.size() > 1) {
                qs = "";
                for (SearchTemplate.SearchClass sc : classes) {
                    String entityName = sc.getName();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "entityName: " + entityName);
                    if (!qs.isEmpty()) {
                        qs = qs + " | ";
                    }
                    qs = qs + "/" + this.getEntityDefName(entityName);
                }
                qs = "(" + qs + ")";
            } else {
                qs = "/" + this.getEntityDefName(firstEntityName);
            }
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "qs : " + qs);
        String conjunction = " AND ";
        if (!matchAllCriteria) {
            conjunction = " OR ";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "conjunction : " + conjunction);
        String condition = "";
        boolean multiTerms = false;
        long size = criteria.size();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "criteria.length : " + size);
        if (size > 0L) {
            multiTerms = true;
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "multiTerms : " + multiTerms);
        int conditionCount = 0;
        for (QueryCriterion criterion : criteria) {
            boolean valueSpecified = false;
            boolean referenced = false;
            for (int j = 0; j < criterion._values.length; ++j) {
                if ((criterion._values[j] == null || criterion._values[j].length() <= 0) && !criterion._operator.equals("IS NULL") && !criterion._operator.equals("IS NOT NULL")) continue;
                valueSpecified = true;
            }
            if (!valueSpecified) continue;
            ++conditionCount;
            boolean bl = referenced = entityDef != null && this._isReferenceAttribute(entityDef, criterion._name);
            if (condition.length() > 0) {
                condition = condition + conjunction;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "condition: " + condition);
            }
            if (multiTerms) {
                condition = condition + "(";
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "condition: " + condition);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "crit._operator: " + criterion._operator);
            if (criterion._operator.equals("contains-text") || criterion._operator.equals("contains-text-basic")) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "crit._values[0]: " + criterion._values[0]);
                if (criterion._values[0] != null && criterion._values[0].indexOf("\"") != -1) {
                    criterion._values[0] = criterion._values[0].replaceAll("\"", "'");
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "crit._values[0]: " + criterion._values[0]);
                String textSearchExpression = this._generateContainsTextExpression(criterion, referenced);
                condition = condition + textSearchExpression;
                if (textSearchTerms == null) {
                    textSearchTerms = new Vector();
                }
                textSearchTerms.addElement(textSearchExpression);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "contains-text or  contains-text-basic");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "condition: " + condition);
            } else {
                if (criterion._values[0] != null && criterion._values[0].indexOf("\"") != -1) {
                    criterion._values[0] = criterion._values[0].replaceAll("\"", "\"\"");
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "invoking _generateRegularExpression ");
                condition = condition + this._generateRegularExpression(criterion, referenced);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "condition: " + condition);
            }
            if (!multiTerms) continue;
            condition = condition + ")";
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "multiTerms is true so add a )");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "condition: " + condition);
        }
        SearchTemplate.Macros macros = searchTemplate.getMacros();
        if (macros != null && (userActions = macros.getUserActions()) != null && userActions.length > 0 && userActions[0] != null && (userActionExp = this.generateUserActionExpression(userActions[0])) != null) {
            if (conditionCount > 0) {
                condition = matchAllCriteria || conditionCount == 1 ? condition + " AND " : "(" + condition + ") AND ";
            }
            condition = condition + userActionExp;
            conditionCount = 1;
        }
        if (folderPid != null) {
            if (conditionCount > 0) {
                condition = matchAllCriteria || conditionCount == 1 ? condition + " AND " : "(" + condition + ") AND ";
            }
            condition = condition + "./INBOUNDLINK[@LINKTYPE=\"DKFolder\"]/@SOURCEITEMREF => " + folderPid.getObjectType() + "[@ITEMID=\"" + folderPid.getItemId() + "\"]";
        }
        if (this._version != null && !this._version.equals(ALL_VERSIONS)) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Versions not equal to ALL_VERSIONS");
            if (condition.length() > 0 && !this._version.equals(LATEST_VERSION) && this._version != null) {
                condition = condition + " AND ";
            }
            if (this._version.equals(LATEST_VERSION) || this._version == null) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "version equals LATEST_VERSION or is null");
            } else {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "version not equal to latest and is not null ");
                condition = condition + "@VERSIONID = " + this._version + "";
            }
        }
        SearchTemplate.TextSearchCriterion tsCriteria = searchTemplate.getFirstTextSearchCriterion();
        if (condition.length() > 0) {
            if (!isAllItemTypeSearch && this.getTextSearchType(this._dsICM, this.request).equalsIgnoreCase(SearchTemplate.TextSearchType.basic.toString()) && entityDef != null && entityDef.isTextSearchable()) {
                if (tsCriteria != null) {
                    String tsText2 = tsCriteria.getText();
                    if (tsText2 != null && tsText2.trim().length() > 0) {
                        String generatedTSStr2 = this._generateTextSearchQuery(tsText2, (DKItemTypeDefICM)entityDef);
                        if (generatedTSStr2 != null && generatedTSStr2.trim().length() > 0) {
                            if (textSearchTerms == null) {
                                textSearchTerms = new Vector<String>();
                            }
                            textSearchTerms.add(0, generatedTSStr2);
                            qs = this.isPropertyTextSearchAnded() ? qs + "[" + condition + " AND " + generatedTSStr2 + "]" : qs + "[" + condition + " OR " + generatedTSStr2 + "]";
                        } else {
                            qs = qs + "[" + condition + "]";
                        }
                    } else {
                        qs = qs + "[" + condition + "]";
                    }
                } else {
                    qs = qs + "[" + condition + "]";
                }
            } else {
                qs = qs + "[" + condition + "]";
            }
        } else if (!isAllItemTypeSearch && this.getTextSearchType(this._dsICM, this.request).equalsIgnoreCase(SearchTemplate.TextSearchType.basic.toString()) && entityDef != null && entityDef.isTextSearchable() && tsCriteria != null && (tsText = tsCriteria.getText()) != null && tsText.trim().length() > 0 && (generatedTSStr = this._generateTextSearchQuery(tsText, (DKItemTypeDefICM)entityDef)) != null && generatedTSStr.trim().length() > 0) {
            if (textSearchTerms == null) {
                textSearchTerms = new Vector();
            }
            textSearchTerms.add(0, generatedTSStr);
            qs = qs + "[" + generatedTSStr + "]";
        }
        if (!(this.sortBy == null || this.sortBy.length() <= 0 || this.sortBy.equals("!Name") && entityDef == null)) {
            if (this.sortBy.equals("!MimeTypeIcon")) {
                this.sortBy = CMBaseUtil.getNameAttrForEntity(this.request, (DKComponentTypeDefICM)entityDef);
            } else if (this.sortBy.equals("!Name")) {
                this.sortBy = CMBaseUtil.getNameAttrForEntity(this.request, (DKComponentTypeDefICM)entityDef);
                if (this.sortBy == null) {
                    this.sortBy = entityDef.listAttrNames()[0];
                }
            } else if (this.sortBy.equals("Rank")) {
                isTextSearchRankEnabled = true;
            }
            if (!isTextSearchRankEnabled) {
                if (isAllItemTypeSearch) {
                    qs = qs + "[@LASTCHANGEDUSERID]";
                }
                try {
                    CMSearchConstants.SystemAttribute sa = CMSearchConstants.SystemAttribute.valueOf(this.sortBy);
                    qs = qs + " SORTBY (@" + sa.getAttributeName() + (this.sortDescending ? " DESCENDING" : " ASCENDING") + ")";
                }
                catch (Exception e) {
                    qs = qs + " SORTBY (@" + this.sortBy + (this.sortDescending ? " DESCENDING" : " ASCENDING") + ")";
                }
            } else if (textSearchTerms != null) {
                boolean isDocModel;
                boolean bl = isDocModel = ((String)textSearchTerms.get(0)).indexOf(".//ICMPARTS/@TIEREF") >= 0;
                if (isDocModel) {
                    if (textSearchTerms.size() > 1) {
                        qs = qs + " SORTBY ( ";
                        String tsTerm1 = (String)textSearchTerms.get(1);
                        String tsTerm2 = tsTerm1.replace("contains-text-basic", "score-basic");
                        int index = tsTerm2.lastIndexOf(61);
                        qs = qs + tsTerm2.substring(0, index);
                        qs = qs + " )";
                    }
                } else {
                    qs = qs + " SORTBY ( ";
                    String tsTerm1 = (String)textSearchTerms.get(0);
                    String tsTerm2 = tsTerm1.replace("contains-text-basic", "score-basic");
                    int index = tsTerm2.lastIndexOf(61);
                    qs = qs + tsTerm2.substring(0, index);
                    qs = qs + " )";
                }
                textSearchTerms.removeAllElements();
                textSearchTerms = null;
                isTextSearchRankEnabled = false;
            } else {
                isTextSearchRankEnabled = false;
            }
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "condAdded is true so qs now =  " + qs);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return qs;
    }

    private String _generateContainsTextExpression(QueryCriterion crit, boolean referenced) {
        String methodName = "_generateContainsTextExpression";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        String expr = "";
        if (crit._values != null && crit._values.length >= 1) {
            expr = expr + crit._operator + "(";
            expr = crit._name.equalsIgnoreCase("Document_Contents") ? expr + ".//ICMPARTS/@TIEREF" : expr + this._generateAttrSyntax(crit._name, referenced);
            expr = expr + ", \"";
            expr = expr + crit._values[0];
            expr = expr + "\")=1";
            if (crit._name.equalsIgnoreCase("Document_Contents")) {
                expr = expr + " OR ";
                expr = expr + crit._operator + "(";
                expr = expr + "@TIEREF";
                expr = expr + ", \"";
                expr = expr + " '" + crit._values[0] + "' ";
                expr = expr + "\")=1";
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return expr;
    }

    public String _generateNotEqualExpression(dkEntityDef entityDef, QueryCriterion crit, String op) {
        String methodName = "generateNotEqualExpression";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        String doubleQuote = "\"";
        String space = " ";
        String notEqualExpr = null;
        String booleanOperator = " OR ";
        String queryString = crit._values[0];
        String attributeStr = crit._name;
        short attrType = crit._type;
        attributeStr = "'" + attributeStr + "'";
        attributeStr = "@" + attributeStr;
        if (!this._isQuoteNeededForType(attrType)) {
            doubleQuote = "";
        }
        notEqualExpr = "((" + attributeStr + space + op + space + doubleQuote + queryString + doubleQuote + ")" + booleanOperator + "(" + attributeStr + " IS NULL ))";
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "notEqualExpr = " + notEqualExpr);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return notEqualExpr;
    }

    private String _generateRegularExpression(QueryCriterion crit, boolean referenced) throws Exception {
        String attribName;
        String methodName = "_generateRegularExpression";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        String expr = attribName = this._generateAttrSyntax(crit._name, referenced);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "expr: " + expr);
        if (expr.indexOf("=>") < 0) {
            expr = expr + " " + crit._operator + " ";
            if (this._isUnaryOperator(crit._operator)) {
                return expr;
            }
            if (crit._values.length > 0) {
                if (this.isMultiValueOperator(crit._operator)) {
                    expr = this.generateMultiValueExpression(attribName, crit);
                } else {
                    boolean rangeOp = this.isRangeOperator(crit._operator);
                    if (!rangeOp && crit._type == 9) {
                        expr = this.generateTimestampExpression(attribName, crit._operator, crit._values[0]);
                    } else {
                        String quote = "";
                        boolean useQuotes = this._useQuotes(crit);
                        if (useQuotes) {
                            quote = "\"";
                        }
                        expr = expr + quote + crit._values[0] + quote;
                        if (rangeOp && crit._values.length > 1) {
                            expr = expr + " AND " + quote + crit._values[1] + quote;
                        }
                    }
                }
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return expr;
    }

    private String generateMultiValueExpression(String name, QueryCriterion criterion) throws Exception {
        String exp;
        short type = criterion._type;
        if (type == 9) {
            boolean in = criterion._operator.equals("IN");
            String op = in ? "=" : "!=";
            String join = in ? " OR " : " AND ";
            exp = "(";
            for (int i = 0; i < criterion._values.length; ++i) {
                if (i > 0) {
                    exp = exp + join;
                }
                exp = exp + this.generateTimestampExpression(name, op, criterion._values[i]);
            }
            exp = exp + ")";
        } else {
            boolean useQuotes = this._useQuotes(criterion);
            exp = name + " " + criterion._operator + " (";
            for (int i = 0; i < criterion._values.length; ++i) {
                if (i > 0) {
                    exp = exp + ",";
                }
                exp = exp + (useQuotes ? "\"" + criterion._values[i] + "\"" : criterion._values[i]);
            }
            exp = exp + ")";
        }
        return exp;
    }

    private String generateTimestampExpression(String name, String operator, String value) throws Exception {
        String exp = "";
        String currentDay = "\"" + value + "\"";
        String nextDay = "\"" + this.getNextDay(value) + "\"";
        if (operator.equals("=")) {
            exp = exp + "(" + name + " >= " + currentDay + " AND ";
            exp = exp + name + " < " + nextDay + ")";
        } else if (operator.equals("<=")) {
            exp = exp + name + " < " + nextDay;
        } else if (operator.equals("!=")) {
            exp = exp + "(" + name + " < " + currentDay + " OR ";
            exp = exp + name + " >= " + nextDay + ")";
        } else {
            exp = operator.equals(">") ? exp + name + " >= " + nextDay : exp + name + " " + operator + " " + currentDay;
        }
        return exp;
    }

    private String getNextDay(String xqueryDateString) throws Exception {
        Date srcDate = DateUtil.parseXQueryDateString(xqueryDateString);
        long time = srcDate.getTime();
        String nextDay = DateUtil.getXQueryDateString(new Date(time += 86400000L));
        return nextDay;
    }

    private String _generateAttrSyntax(String criterionName, Boolean referenced) {
        String methodName = "_generateAttrSyntax";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "criterionName = " + criterionName + ", referenced = " + referenced);
        int index = criterionName.indexOf("/");
        if (index > -1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "We have child components!");
            int lastIndex = criterionName.lastIndexOf("/");
            String attName = criterionName.substring(lastIndex + 1);
            String entName = criterionName.substring(0, lastIndex);
            String attString = ".//" + entName + "/@" + attName;
            if (referenced.booleanValue()) {
                attString = attString + " => " + attName;
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
            return attString;
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "We do not have child components!");
        String attString = "@" + criterionName;
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "attString : " + attString);
        if (referenced.booleanValue()) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Is a reference attribute");
            attString = attString + " => " + criterionName;
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "attString : " + attString);
        } else {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Is not a reference attribute");
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return attString;
    }

    private boolean _useQuotes(QueryCriterion crit) {
        boolean value = false;
        if (crit._stringType != 0 || this._isQuoteNeededForType(crit._type)) {
            value = true;
        }
        return value;
    }

    private boolean _isReferenceAttribute(dkEntityDef entityDef, String attName) throws Exception {
        boolean isRefAttr = false;
        dkCollection attrList = ((DKComponentTypeDefICM)entityDef).listAttrGroups();
        dkIterator iter = attrList.createIterator();
        while (iter.more()) {
            DKAttrGroupDefICM attrGroupDef = (DKAttrGroupDefICM)iter.next();
            if (!attrGroupDef.getName().equals(attName)) continue;
            if (!attrGroupDef.isReferenceAttributeGroup()) break;
            isRefAttr = true;
            break;
        }
        return isRefAttr;
    }

    private boolean _isNumericType(short type) {
        return type == 3 || type == 4 || type == 5 || type == 6 || type == 10;
    }

    private boolean _isQuoteNeededForType(int dataType) {
        return dataType == 1 || dataType == 2 || dataType == 7 || dataType == 8 || dataType == 9 || dataType == 19 || dataType == 0;
    }

    public boolean isMultiValueOperator(String operator) {
        String[] multiValueOperators = new String[]{"IN", "NOTIN", "NOT IN"};
        for (int i = 0; i < multiValueOperators.length; ++i) {
            String multiValueOp = multiValueOperators[i];
            if (!operator.equals(multiValueOp)) continue;
            return true;
        }
        return false;
    }

    public boolean isRangeOperator(String operator) {
        String[] rangeOperators = new String[]{"BETWEEN", "NOTBETWEEN", "NOT BETWEEN"};
        for (int i = 0; i < rangeOperators.length; ++i) {
            String rangeOp = rangeOperators[i];
            if (!operator.equals(rangeOp)) continue;
            return true;
        }
        return false;
    }

    private boolean _isUnaryOperator(String operator) {
        String[] unaryOperators = new String[]{"EXISTS", "NOT EXISTS", "IS NULL", "IS NOT NULL"};
        for (int i = 0; i < unaryOperators.length; ++i) {
            String unaryOp = unaryOperators[i];
            if (!operator.equals(unaryOp)) continue;
            return true;
        }
        return false;
    }

    public DKNVPair[] get_dkNVPairs() {
        return this._dkNVPairs;
    }

    public void set_dkNVPairs(DKNVPair[] pairs) {
        this._dkNVPairs = pairs;
    }

    public String getQueryString() {
        return this._qryString;
    }

    private String _generateTextSearchQuery(String criteria, DKItemTypeDefICM itDef) {
        StringBuffer buf = new StringBuffer();
        if (criteria.indexOf("\"") != -1) {
            criteria = criteria.replaceAll("\"", "'");
        }
        if (itDef.getClassification() == 1 || itDef.getClassification() == 3) {
            buf.append("contains-text-basic(@TIEREF,\"");
            buf.append(criteria);
            buf.append("\")=1");
        } else if (itDef.getClassification() == 2) {
            buf.append("contains-text-basic(.//ICMPARTS/@TIEREF,\"");
            buf.append(criteria);
            buf.append("\")=1");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DKResults evaluate(String qryString, DKNVPair[] dkNVPairs) throws Exception {
        String methodName = "evaluate";
        DKDatastoreICM dKDatastoreICM = this._dsICM;
        synchronized (dKDatastoreICM) {
            Logger.logDebug((Object)this, "evaluate", (ServletRequest)this.request, "Query string is not replaced: " + qryString);
            DKResults res = (DKResults)this._dsICM.evaluate(qryString, (short)7, dkNVPairs);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public dkResultSetCursor execute(String query, DKNVPair[] dknvPairs) throws Exception {
        String methodName = "execute";
        DKDatastoreICM dKDatastoreICM = this._dsICM;
        synchronized (dKDatastoreICM) {
            query = this.addQueryConditions(query);
            Logger.logDebug((Object)this, "execute", (ServletRequest)this.request, "Query string is not replaced: " + query);
            dkResultSetCursor curs = this._dsICM.execute(query, (short)7, dknvPairs);
            return curs;
        }
    }

    public void printCursorQueryResults(dkResultSetCursor cursor) throws Exception {
        DKDDO ddo;
        String methodName = "printCursorQueryResults";
        String itemId = "";
        while ((ddo = cursor.fetchNext()) != null) {
            itemId = ((DKPidICM)ddo.getPidObject()).getItemId();
            Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "     - Item ID:  " + itemId + "  (" + ddo.getPidObject().getObjectType() + ")");
        }
        Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "Accessed Result Set Cursor.");
    }

    public boolean isSearchForCheckedItems() {
        return this.searchForCheckedItems;
    }

    public void setSearchForCheckedItems(boolean searchForCheckedItems) {
        this.searchForCheckedItems = searchForCheckedItems;
    }

    public boolean isSearchForFolders() {
        return this.searchForFolders;
    }

    public void setSearchForFolders(boolean searchForFoldersOnly) {
        this.searchForFolders = searchForFoldersOnly;
    }

    public boolean isSearchForDocuments() {
        return this.searchForDocuments;
    }

    public void setSearchForDocuments(boolean searchForDocuments) {
        this.searchForDocuments = searchForDocuments;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public boolean isSortDescending() {
        return this.sortDescending;
    }

    public void setSortDescending(boolean sortDescending) {
        this.sortDescending = sortDescending;
    }

    public String getTextSearchType(DKDatastoreICM connection, HttpServletRequest request) {
        if (connection == null) {
            return "";
        }
        String type = "";
        boolean isTSEnabled = false;
        try {
            isTSEnabled = connection.textSearchEnabled();
        }
        catch (Exception e) {
            Logger.logDebug(CMQueryService.class, "getTextSearchType", (ServletRequest)request, "Failed to get the value of SearchType");
            return "";
        }
        if (isTSEnabled) {
            type = SearchTemplate.TextSearchType.basic.toString();
        }
        return type;
    }

    public void setPropertyTextSearchAnded(boolean propertyTextSearchAnded) {
        this._propertyTextSearchAnded = propertyTextSearchAnded;
    }

    public boolean isPropertyTextSearchAnded() {
        return this._propertyTextSearchAnded;
    }

    private String generateUserActionExpression(SearchTemplate.UserAction userAction) throws Exception {
        String[] dates;
        String operator;
        Map<String, UserActionMacroConfig> configMap = this.getMacroConfigMap(UserActionMacroConfig.class);
        if (configMap == null || configMap.isEmpty()) {
            return null;
        }
        UserActionMacroConfig config = configMap.get(userAction.getAction());
        if (config == null || config.isEmpty()) {
            return null;
        }
        String exp = "";
        String[] users = userAction.getUsers();
        if (users != null && users.length > 0) {
            String userExp = "";
            int count = 0;
            for (String user : users) {
                if (user == null || user.isEmpty()) continue;
                if (user.equals("{ME}")) {
                    if (this.connection == null) continue;
                    user = this.connection.getUserid().toUpperCase();
                }
                if (!userExp.isEmpty()) {
                    userExp = userExp + ",";
                }
                userExp = userExp + "\"" + user + "\"";
                ++count;
            }
            if (count > 0) {
                exp = exp + config.getUserProperty() + (count == 1 ? " = " + userExp : " IN (" + userExp + ")");
            }
        }
        if ((operator = CMCriteriasMediator.getOperatorFromDisplayValue(this.request, userAction.getDateOperator())) == null) {
            operator = "=";
        }
        if ((dates = userAction.getDates()) != null && dates.length > 0 && dates[0] != null && !dates[0].isEmpty()) {
            boolean isRangeOperator = this.isRangeOperator(operator);
            String attribName = config.getDateProperty();
            String date1 = DateUtil.getXQueryDateString(DateUtil.parseISODate(dates[0], true));
            if (!exp.isEmpty()) {
                exp = exp + " AND ";
            }
            if (isRangeOperator && dates.length > 1 && dates[1] != null && !dates[1].isEmpty()) {
                String date2 = DateUtil.getXQueryDateString(DateUtil.parseISODate(dates[1], true));
                exp = exp + "(" + attribName + " " + operator + " \"" + date1 + "\" AND \"" + date2 + "\")";
            } else {
                if (isRangeOperator) {
                    operator = "=";
                }
                exp = exp + this.generateTimestampExpression(attribName, operator, date1);
            }
        }
        if (exp.isEmpty() && config.isReserved()) {
            exp = exp + "ICMCHECKEDOUT";
        }
        return !exp.isEmpty() ? exp : null;
    }

    private <T extends ConfigurationObject> Map<String, T> getMacroConfigMap(Class<T> configClass) throws ConfigurationException, MissingValueException {
        String appName = this.request.getParameter("application");
        if (appName == null || appName.isEmpty()) {
            appName = "navigator";
        }
        SettingsConfig settingsConfig = Config.getSettingsConfig(appName);
        return settingsConfig.getMacrosMap(appName, configClass);
    }

    public class QueryCriterion {
        String _name;
        String[] _values;
        String _operator;
        short _type = 0;
        int _stringType = 0;

        public QueryCriterion(String name, String op, String[] values) {
            this._name = name;
            this._operator = op;
            this._values = values;
            this.normalize();
        }

        public void setTypes(DKAttrDefICM attr) {
            this._type = attr.getType();
            this._stringType = attr.getStringType();
            this.normalizeValues();
        }

        private void normalize() {
            String methodName = "normalize";
            if (this._name != null) {
                try {
                    CMSearchConstants.SystemAttribute sa = CMSearchConstants.SystemAttribute.valueOf(this._name);
                    this._name = sa.getAttributeName();
                    this._type = sa.getType();
                }
                catch (Exception e) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)CMQueryService.this.request, "Name is not system attribute: " + this._name);
                }
            }
            this.normalizeValues();
        }

        private void normalizeValues() {
            String methodName = "normalizeValues";
            Logger.logEntry((Object)this, methodName, (ServletRequest)CMQueryService.this.request);
            if (this._values != null && this._values.length > 0 && (this._type == 7 || this._type == 8 || this._type == 9 || this._type == 6)) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)CMQueryService.this.request, "Found a date/time/timestamp format.");
                WCDateFormat defaultFormats = WCDateFormat.getDefaultDateFormats(CMQueryService.this.request);
                String[] values = new String[this._values.length];
                Date tempDate = null;
                for (int iCounter = 0; iCounter < this._values.length; ++iCounter) {
                    if (this._values[iCounter] == null || this._values[iCounter].length() <= 0) continue;
                    try {
                        switch (this._type) {
                            case 9: {
                                tempDate = new Date(Long.parseLong(this._values[iCounter]));
                                values[iCounter] = ((SimpleDateFormat)defaultFormats.getTimestampFormat()).format(tempDate);
                                break;
                            }
                            case 7: {
                                tempDate = new Date(Long.parseLong(this._values[iCounter]));
                                values[iCounter] = ((SimpleDateFormat)defaultFormats.getDateFormat()).format(tempDate);
                                break;
                            }
                            case 8: {
                                tempDate = new Date(Long.parseLong(this._values[iCounter]));
                                values[iCounter] = ((SimpleDateFormat)defaultFormats.getTimeFormat()).format(tempDate);
                                break;
                            }
                            case 6: {
                                String value = this._values[iCounter];
                                if (value.indexOf(46) < 0) {
                                    value = value + ".0";
                                }
                                values[iCounter] = value;
                            }
                        }
                    }
                    catch (Exception pe) {
                        Logger.logWarning((Object)this, methodName, (ServletRequest)CMQueryService.this.request, "Exception: " + pe);
                        values[iCounter] = this._values[iCounter];
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)CMQueryService.this.request, "_values[]=" + this._values[iCounter]);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)CMQueryService.this.request, "values[]=" + values[iCounter]);
                }
                this._values = values;
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)CMQueryService.this.request);
        }
    }
}

