/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.beans.cm;

import com.ibm.mm.sdk.common.DKLobICM;
import com.ibm.mm.sdk.common.DKNVPair;
import com.ibm.mm.sdk.common.DKTextICM;
import com.ibm.mm.sdk.common.dkXDO;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;

public class CMObject {
    private DKLobICM xdo;
    private boolean isStream;
    private HashMap _encodingMap;

    public CMObject(byte[] content, String mimeType) throws Exception {
        this.xdo = new DKLobICM();
        this.xdo.setContent(content);
        this.xdo.setMimeType(mimeType);
    }

    public CMObject(InputStream inputStream, long length, String mimeType) throws Exception {
        this.xdo = new DKLobICM();
        DKNVPair[] dknv = new DKNVPair[]{new DKNVPair("STREAM", (Object)inputStream), new DKNVPair("LENGTH", (Object)new Long(length))};
        this.xdo.setAddLocation(dknv);
        this.xdo.setContent(null);
        this.xdo.setMimeType(mimeType);
        this.isStream = true;
    }

    public CMObject(dkXDO xdo) {
        this.xdo = (DKLobICM)xdo;
        this.isStream = true;
    }

    public dkXDO getXDO() {
        return this.xdo;
    }

    public void setXDO(dkXDO xdo) {
        this.xdo = (DKLobICM)xdo;
        this.isStream = true;
    }

    private byte[] getByteArrayFromInputStream(InputStream is) throws Exception {
        byte[] content = null;
        long size = this.getSize();
        if (size > 0L && size < 4096L) {
            content = new byte[(int)size];
            is.read(content);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int nBytes = is.read(buf);
            while (nBytes > -1) {
                baos.write(buf, 0, nBytes);
                nBytes = is.read(buf);
            }
            content = baos.toByteArray();
        }
        return content;
    }

    public byte[] getByteArrayData() throws Exception {
        InputStream is;
        byte[] content;
        if (this.xdo.getMimeType() == null) {
            this.xdo.retrieve(1);
        }
        if ((content = this.xdo.getContent()) == null && (is = this.getDataStream()) != null) {
            content = this.getByteArrayFromInputStream(is);
        }
        return content;
    }

    public InputStream getDataStream() throws Exception {
        if (!this.isStream) {
            return null;
        }
        if (this.xdo.getMimeType() == null) {
            this.xdo.retrieve(1);
        }
        InputStream stream = this.xdo.getInputStream(-1, -1, -1);
        return stream;
    }

    public String getOriginalFileName() throws Exception {
        if (this.xdo.getMimeType() == null) {
            this.xdo.retrieve(1);
        }
        return this.xdo.getOrgFileName();
    }

    public long getSize() throws Exception {
        if (this.xdo.getMimeType() == null) {
            this.xdo.retrieve(1);
        }
        return this.xdo.getSize();
    }

    public String getMimeType() throws Exception {
        if (this.xdo.getMimeType() == null) {
            this.xdo.retrieve(1);
        }
        return this.xdo.getMimeType();
    }

    public URL getContentURL() throws Exception {
        if (this.xdo.getMimeType() == null) {
            this.xdo.retrieve(1);
        }
        String urlString = this.xdo.getContentURL(256, -1, -1);
        URL contentUrl = new URL(urlString);
        return contentUrl;
    }

    public int getCCSID() {
        return ((DKTextICM)this.xdo).getCCSID();
    }

    public String getEncoding() throws Exception {
        if (this.xdo.getMimeType() == null) {
            this.xdo.retrieve(1);
        }
        if (this.xdo instanceof DKTextICM) {
            int ccsid = ((DKTextICM)this.xdo).getCCSID();
            if (this._encodingMap == null) {
                this._encodingMap = new HashMap(40);
                this._encodingMap.put(1089, "ISO-8859-6");
                this._encodingMap.put(1256, "windows-1256");
                this._encodingMap.put(914, "ISO-8859-4");
                this._encodingMap.put(921, "ISO-8859-13");
                this._encodingMap.put(1257, "windows-1257");
                this._encodingMap.put(1392, "GB18030");
                this._encodingMap.put(936, "windows-936");
                this._encodingMap.put(1382, "EUC-CN");
                this._encodingMap.put(947, "Big5");
                this._encodingMap.put(950, "windows-950");
                this._encodingMap.put(960, "EUC-TW");
                this._encodingMap.put(1250, "windows-1250");
                this._encodingMap.put(912, "ISO-8859-2");
                this._encodingMap.put(1251, "windows-1251");
                this._encodingMap.put(915, "ISO-8859-5");
                this._encodingMap.put(878, "KOI8-R");
                this._encodingMap.put(813, "ISO-8859-7");
                this._encodingMap.put(1253, "windows-1253");
                this._encodingMap.put(8859, "ISO-8859-8");
                this._encodingMap.put(1255, "windows-1255");
                this._encodingMap.put(952, "EUC-JP");
                this._encodingMap.put(932, "Shift_JIS");
                this._encodingMap.put(949, "windows-949");
                this._encodingMap.put(970, "EUC-KR");
                this._encodingMap.put(913, "ISO-8859-3");
                this._encodingMap.put(874, "windows-874");
                this._encodingMap.put(920, "ISO-8859-9");
                this._encodingMap.put(1254, "windows-1254");
                this._encodingMap.put(1200, "UTF-16");
                this._encodingMap.put(1208, "UTF-8");
                this._encodingMap.put(367, "US-ASCII");
                this._encodingMap.put(1258, "windows-1258");
                this._encodingMap.put(819, "ISO-8859-1");
                this._encodingMap.put(923, "ISO-8859-15");
                this._encodingMap.put(1252, "windows-1252");
            }
            String encoding = (String)this._encodingMap.get(ccsid);
            return encoding;
        }
        return null;
    }

    public String getPartType() {
        return this.xdo.getPidObject().getObjectType();
    }

    public void setPartType(String partType) throws Exception {
        this.xdo.setObjectType(partType);
    }

    public String getObjectType() {
        return this.xdo.getObjectType();
    }
}

