/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.beans.cm;

import com.ibm.ecm.beans.cm.CMAttributeDef;
import com.ibm.ecm.beans.cm.CMBeansConstants;
import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.beans.cm.CMObject;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.ecm.util.cm.CMItemComparator;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKDate;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKFolder;
import com.ibm.mm.sdk.common.DKItemTypeDefICM;
import com.ibm.mm.sdk.common.DKItemTypeRelationDefICM;
import com.ibm.mm.sdk.common.DKItemTypeViewDefICM;
import com.ibm.mm.sdk.common.DKLobICM;
import com.ibm.mm.sdk.common.DKNVPair;
import com.ibm.mm.sdk.common.DKParts;
import com.ibm.mm.sdk.common.DKPid;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.DKSequentialIterator;
import com.ibm.mm.sdk.common.DKTextICM;
import com.ibm.mm.sdk.common.DKTime;
import com.ibm.mm.sdk.common.DKTimestamp;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.DKWorkPackageICM;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDataObjectBase;
import com.ibm.mm.sdk.common.dkDatastore;
import com.ibm.mm.sdk.common.dkDatastoreExt;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.common.dkXDO;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.awt.Image;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMItem
implements Serializable,
CMBeansConstants,
Cloneable {
    private transient Vector<CMItem> _itemList;
    private DKWorkPackageICM workPackage;
    private transient DKDDO _ddo;
    private boolean _getLatestVersion = false;
    private String _name = null;
    private short _nameType = 1;
    private Vector _attrValues;
    private Hashtable _attrMultiValues;
    private Hashtable _attrItems;
    private Hashtable _attrObjects;
    private Vector _attrNames;
    private Vector _attrTypes;
    private HashSet<String> _knownFolderedEntities = null;
    private short _itemType = 0;
    private String _mimeType = "UNKNOWN";
    private Image _itemThumbnail;
    private String _entityName = "";
    private boolean _entityNameChanged;
    static int ITEM_STATE_NEW = 0;
    public static final String UNKNOWN_MIME_TYPE = "UNKNOWN";
    private static final long LENGTH_OF_EMPTY_BOOKMARK_SET = 2L;
    static int ITEM_STATE_NEED_RETRIEVE = 1;
    static int ITEM_STATE_RETRIEVED = 2;
    static int ITEM_STATE_UPDATED = 3;
    static int ITEM_STATE_DELETED = 4;
    public static short ITEM_TYPE_VERSION_CONTROL_NEVER = 0;
    public static short ITEM_TYPE_VERSION_CONTROL_ALWAYS = 1;
    public static short ITEM_TYPE_VERSION_CONTROL_BY_APPLICATION = (short)2;
    private WCDateFormat wcDateFormat = null;
    private HttpServletRequest request;
    String _pidstring = null;
    boolean invalidPid = false;
    private String _serverName = "";
    public boolean _attrsRetrieved;
    boolean _linksRetrieved;
    boolean _ICMFolderContentsRetrieved;
    private String _serverType = "";
    private int _rank;
    protected String _nameAttr;
    private String _version = "";
    private Timestamp _createTimestamp = CM_TIMESTAMP_UNDEFINED;
    private String _createUserid = CM_USERID_UNDEFINED;
    private Timestamp _lastChangedTimestamp = CM_TIMESTAMP_UNDEFINED;
    private String _aclCode = CM_ACLCODE_UNDEFINED;
    private String _semanticType = CM_SEMANTICTYPE_UNDEFINED;
    private String _lastChangedUserid = CM_USERID_UNDEFINED;
    private transient Vector _contentList;
    private transient Vector _annotationList;
    private transient Vector _noteLogList;
    transient boolean _partsRetrieved;
    private int _itemState;
    private Vector _itemGroup;
    private String _parentPath = "";
    private CMItem _parent = null;
    boolean _traceEnabled = false;
    private DKAttrDefICM attr = null;
    private boolean hasBookmarks = false;
    private CMConnection _connection;
    private DKPid _pid;

    public CMItem(HttpServletRequest request, CMConnection connection) {
        this._connection = connection;
        this._ddo = null;
        this._itemType = 0;
        this._entityName = null;
        this._attrsRetrieved = true;
        this._linksRetrieved = true;
        this._ICMFolderContentsRetrieved = true;
        this._partsRetrieved = true;
        this.request = request;
    }

    public CMItem(HttpServletRequest request, CMConnection connection, DKDDO ddoObj, String attrName) {
        this._connection = connection;
        this.request = request;
        this.setItem(ddoObj, attrName);
    }

    public CMItem(HttpServletRequest request, CMConnection connection, DKDDO ddoObj, String attrName, boolean attrsRetrieved, boolean linksRetrieved, boolean _partsRetrieved) throws Exception {
        this._connection = connection;
        this.request = request;
        this.setItem(ddoObj, attrName, attrsRetrieved, linksRetrieved, _partsRetrieved);
    }

    public void setItem(DKDDO ddoObj, String attrName) {
        this._ddo = ddoObj;
        this._nameAttr = attrName;
        this._itemType = 0;
        this._pid = ddoObj.getPidObject();
        this._extractInfoFromPid(this._pid);
        this._entityName = null;
        this._attrsRetrieved = false;
        this._partsRetrieved = false;
        this.setItemState(ITEM_STATE_RETRIEVED);
    }

    public void setItem(DKDDO ddoObj, String attrName, boolean attrsRetrieved, boolean linksRetrieved, boolean partsRetrieved) throws Exception {
        this._ddo = ddoObj;
        this._nameAttr = attrName;
        this._itemType = 0;
        this._pid = ddoObj.getPidObject();
        this._extractInfoFromPid(this._pid);
        this._entityName = null;
        this._attrsRetrieved = false;
        if (attrsRetrieved) {
            this.setItemState(ITEM_STATE_RETRIEVED);
            this._retrieveAttrs();
        } else {
            this.setItemState(ITEM_STATE_NEED_RETRIEVE);
        }
        this._linksRetrieved = linksRetrieved;
        this._ICMFolderContentsRetrieved = false;
        this._partsRetrieved = partsRetrieved;
        if (this._partsRetrieved) {
            this._sortRetrievedParts();
        }
    }

    public CMItem(HttpServletRequest request, CMConnection connection, String pidString) {
        String methodName = "CMItem";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        this._connection = connection;
        try {
            this._pidstring = pidString;
            this._pid = CMBaseUtil.makeDKPid(pidString);
            this._extractInfoFromPid(this._pid);
            this._entityName = null;
            this._ddo = null;
            this._extractUseridTimestampInfo();
        }
        catch (Exception ex) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)ex);
        }
        this.setItemState(ITEM_STATE_NEED_RETRIEVE);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    CMItem(HttpServletRequest request, CMConnection connection, String urlString, String dsType, String dsName) {
        String methodName = "CMItem";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        this._connection = connection;
        this._itemType = 1;
        try {
            this._pidstring = urlString;
            this._pid = new DKPid(dsType, dsName, "URL", urlString);
            this._extractInfoFromPid(this._pid);
            this._ddo = new DKDDO(this._pid);
            this._ddo.addProperty("item-type", (Object)new Short(1));
            short data_id = this._ddo.addData("DKParts");
            this._ddo.addDataProperty(data_id, "type", (Object)new Short(1073));
            this._contentList = new Vector(0);
            this.setItemState(ITEM_STATE_RETRIEVED);
        }
        catch (Exception ex) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)ex);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    public boolean isCheckedOut() throws Exception {
        boolean isCheckedOut = false;
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (!"".equals(this.getCheckedOutUserid())) {
            isCheckedOut = true;
        }
        return isCheckedOut;
    }

    public String getCheckedOutUserid() throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        String userid = null;
        try {
            short propId = this._ddo.propertyId("Checked_Out_UserID");
            if (propId > 0) {
                userid = (String)this._ddo.getProperty(propId);
            }
        }
        catch (DKUsageError dKUsageError) {
            // empty catch block
        }
        if (userid == null) {
            userid = "";
        }
        return userid;
    }

    public String getCheckedOutTimestamp() throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        Object timestamp = null;
        try {
            timestamp = this._ddo.getPropertyByName("Checked_Out_TS");
        }
        catch (DKUsageError dKUsageError) {
            // empty catch block
        }
        if (timestamp == null) {
            timestamp = "";
        }
        return timestamp.toString();
    }

    public String getName() throws Exception {
        String methodName = "getName";
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (this._name == null && this.getDDO() != null) {
            List<Object> nameAndType = CMBaseUtil.getNameAndNameTypeForDdo(this.getDDO());
            this._name = (String)nameAndType.get(0);
            this._nameType = (Short)nameAndType.get(1);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "name: " + this._name);
        return this._name;
    }

    public short getNameType() throws Exception {
        return this._nameType;
    }

    public void setNameAndType(String name, short nameType) {
        this._name = name;
        this._nameType = nameType;
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public String getPidString() {
        if (this._pid == null) {
            return null;
        }
        return this._pid.pidString();
    }

    public String getIdString() {
        if (this._pid == null) {
            return null;
        }
        return this._pid.getIdString();
    }

    public String getPrimaryIdString() {
        if (this._pid == null) {
            return null;
        }
        return this._pid.getPrimaryId();
    }

    public void setPidString(String pidString) {
        String methodName = "setPidString";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            this._pid = CMBaseUtil.makeDKPid(pidString);
            this._entityName = null;
            this._extractInfoFromPid(this._pid);
        }
        catch (DKException dkex) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)dkex);
            throw new IllegalArgumentException(dkex.getMessage());
        }
        catch (Exception ex) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ex);
        }
        this.setRetrieved(false);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public int getAttrCount() throws Exception {
        String methodName = "getAttrCount";
        if (this._attrNames == null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "_attrNames == null, invoking _initializeAttrVectors");
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "_attrsRetrieved equals false");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking _retrieveAttrs");
            this._retrieveAttrs();
        }
        return this._attrNames.size();
    }

    public String[] getAttrNames() throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        Object[] names = new String[this._attrNames.size()];
        this._attrNames.copyInto(names);
        return names;
    }

    public String[] getAttrName() throws Exception {
        return this.getAttrNames();
    }

    public boolean isAttr(String name) throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        return this._attrNames.contains(name);
    }

    public boolean isMultiValuedAttr(String name) throws Exception {
        if (this._attrMultiValues == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        return this._attrMultiValues.containsKey(name);
    }

    public String[] getAttrValues() throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        Object[] values = new String[this._attrValues.size()];
        this._attrValues.copyInto(values);
        return values;
    }

    public String[] getAttrValues(String attr) throws Exception {
        String methodName = "getAttrValues";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (this._attrMultiValues != null && this._attrMultiValues.containsKey(attr)) {
            Vector vec = (Vector)this._attrMultiValues.get(attr);
            String[] values = new String[vec.size()];
            for (int i = 0; i < vec.size(); ++i) {
                values[i] = (String)vec.elementAt(i);
            }
            return values;
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "The item is not MVA");
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return null;
    }

    public String getAttrValue(int index) throws ArrayIndexOutOfBoundsException, Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (index >= this._attrValues.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (String)this._attrValues.elementAt(index);
    }

    public void setRetrieved(boolean isRetrieved) {
        if (isRetrieved) {
            this.setItemState(ITEM_STATE_RETRIEVED);
        } else {
            this.setItemState(ITEM_STATE_NEED_RETRIEVE);
            this._attrsRetrieved = false;
            this._linksRetrieved = false;
            this._ICMFolderContentsRetrieved = false;
            this._partsRetrieved = false;
        }
    }

    public boolean isRetrieved() {
        return this._itemState != ITEM_STATE_NEED_RETRIEVE;
    }

    public boolean equals(Object itemObj) {
        if (this._pid == null || this._ddo == null) {
            return super.equals(itemObj);
        }
        if (!(itemObj instanceof CMItem)) {
            return false;
        }
        CMItem item = (CMItem)itemObj;
        String pidString = item.getPidString();
        short itemType = item.getItemType();
        if (this.getItemType() != itemType) {
            return false;
        }
        return this.getPidString().equals(pidString);
    }

    boolean equalsIgnoreCase(Object itemObj) {
        boolean result = this.equals(itemObj);
        if (result) {
            return true;
        }
        if (!(itemObj instanceof CMItem)) {
            return false;
        }
        CMItem item = (CMItem)itemObj;
        String id = this._pid.getIdString();
        String id2 = item.getPidString();
        return this._pid.getDatastoreType().equals(item.getPidObject().getDatastoreType()) && this._pid.getDatastoreName().equalsIgnoreCase(item.getPidObject().getDatastoreName()) && this._pid.getObjectType().equals(item.getPidObject().getObjectType()) && id.equals(id2);
    }

    public int hashCode() {
        String pidString = this.getPidString();
        return pidString != null ? pidString.hashCode() : super.hashCode();
    }

    public int getRanking() {
        return this._rank;
    }

    public short getItemType() {
        String methodName = "getItemType";
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            try {
                this._retrieveAttrs();
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        if (this._itemType == 0 && this._ddo != null) {
            this._itemType = this._retrieveDDOExtractItemType(this._ddo);
        }
        return this._itemType;
    }

    public String getMimeType() throws Exception {
        String methodName = "getMimeType";
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            try {
                this._retrieveAttrs();
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        if (this._mimeType == UNKNOWN_MIME_TYPE && this._ddo != null) {
            this._mimeType = this._retrieveDDOMimeTypeType(this._ddo);
        }
        if (this.getItemType() == 2) {
            this._mimeType = "folder";
        } else if (this._mimeType == null) {
            this._mimeType = "item";
        }
        return this._mimeType;
    }

    public void setItemType(short itemType) {
        this._itemType = itemType;
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public void addAttr(String attr, String value, short type) throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        this._attrNames.addElement(attr);
        this._attrTypes.addElement(new Short(type));
        this._attrValues.addElement(value);
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public void addAttr(String attr, CMItem[] value, short type) throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (this._attrNames.contains(attr)) {
            // empty if block
        }
        this._attrNames.addElement(attr);
        this._attrTypes.addElement(new Short(type));
        Vector<CMItem> v = new Vector<CMItem>();
        for (int i = 0; i < value.length; ++i) {
            v.addElement(value[i]);
            value[i].setParentPath(this._parentPath, attr);
            value[i].setParent(this);
        }
        this._attrItems.put(attr, v);
        this._attrValues.addElement("");
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public void addAttr(String attr, CMObject[] value, short type) throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (this._attrNames.contains(attr)) {
            // empty if block
        }
        this._attrNames.addElement(attr);
        this._attrTypes.addElement(new Short(type));
        Vector<CMObject> v = new Vector<CMObject>();
        for (int i = 0; i < value.length; ++i) {
            v.addElement(value[i]);
        }
        this._attrObjects.put(attr, v);
        this._attrValues.addElement("");
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public void addAttrItem(String attr, CMItem item) throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (!this._attrNames.contains(attr)) {
            // empty if block
        }
        int attrIndex = this._attrNames.indexOf(attr);
        Vector v = !this._attrItems.containsKey(attr) ? new Vector() : (Vector)this._attrItems.get(attr);
        item.setParentPath(this._parentPath, attr);
        item.setParent(this);
        v.addElement(item);
        this._attrItems.put(attr, v);
        this._attrValues.setElementAt("", attrIndex);
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public void addAttrObject(String attr, CMObject object) throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (!this._attrNames.contains(attr)) {
            // empty if block
        }
        int attrIndex = this._attrNames.indexOf(attr);
        Vector v = !this._attrObjects.containsKey(attr) ? new Vector() : (Vector)this._attrObjects.get(attr);
        v.addElement(object);
        this._attrObjects.put(attr, v);
        this._attrValues.setElementAt("", attrIndex);
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public void setAttrNames(String[] names) {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (this._attrNames.size() != 0) {
            this._attrNames.removeAllElements();
        }
        for (int i = 0; i < names.length; ++i) {
            this._attrNames.addElement(names[i]);
        }
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public void setAttrValues(String[] attrValues) {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (this._attrValues.size() != 0) {
            this._attrValues.removeAllElements();
        }
        for (int i = 0; i < attrValues.length; ++i) {
            this._attrValues.addElement(attrValues[i]);
        }
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public void setAttrTypes(short[] attrTypes) {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (this._attrTypes.size() != 0) {
            this._attrTypes.removeAllElements();
        }
        for (int i = 0; i < attrTypes.length; ++i) {
            this._attrTypes.addElement(new Short(attrTypes[i]));
        }
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public void removeAllAttrs() {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        this.setItemState(ITEM_STATE_RETRIEVED);
        this._attrNames.removeAllElements();
        this._attrTypes.removeAllElements();
        this._attrValues.removeAllElements();
        this._attrItems.clear();
        this._attrObjects.clear();
        this._attrMultiValues.clear();
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public String getAttrValue(String attr) throws Exception {
        String methodName = "getAttrValue";
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Retrieving attributes");
            this._retrieveAttrs();
        }
        if (this._attrNames != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "attr: " + attr + ", _attrValues: " + this._attrValues.toString());
            int index = this._attrNames.indexOf(attr);
            if (index > -1 && index < this._attrValues.size()) {
                String value = (String)this._attrValues.elementAt(index);
                return value;
            }
        }
        return null;
    }

    public short[] getAttrType() throws Exception {
        return this.getAttrTypes();
    }

    public short[] getAttrTypes() throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        short[] types = new short[this._attrNames.size()];
        for (int j = 0; j < this._attrTypes.size(); ++j) {
            types[j] = (Short)this._attrTypes.elementAt(j);
        }
        return types;
    }

    public short getAttrType(String attr) throws Exception {
        int index;
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (this._attrNames != null && (index = this._attrNames.indexOf(attr)) > -1 && index < this._attrTypes.size()) {
            short type = (Short)this._attrTypes.elementAt(index);
            return type;
        }
        return 0;
    }

    public void setAttrValue(String attr, String value) throws Exception {
        int index;
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (this._attrNames.size() > 0 && (index = this._attrNames.indexOf(attr)) > -1 && index < this._attrTypes.size()) {
            this._attrValues.setElementAt(value, index);
            this.setItemState(ITEM_STATE_UPDATED);
            return;
        }
    }

    public void setAttrItems(String attr, CMItem[] items) throws Exception {
        int i;
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        Vector<CMItem> v = new Vector<CMItem>();
        for (i = 0; items != null && i < items.length; ++i) {
            v.addElement(items[i]);
            items[i].setParentPath(this._parentPath, attr);
            items[i].setParent(this);
        }
        this._attrItems.put(attr, v);
        if (this._attrNames.size() > 0) {
            for (i = 0; i < this._attrNames.size(); ++i) {
                String name = (String)this._attrNames.elementAt(i);
                if (!name.equals(attr)) continue;
                this._attrValues.setElementAt("", i);
                this.setItemState(ITEM_STATE_UPDATED);
                return;
            }
        }
    }

    public void setAttrObjects(String attr, CMObject[] objects) throws Exception {
        int i;
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        Vector<CMObject> v = new Vector<CMObject>();
        for (i = 0; objects != null && i < objects.length; ++i) {
            v.addElement(objects[i]);
        }
        this._attrObjects.put(attr, v);
        if (this._attrNames.size() > 0) {
            for (i = 0; i < this._attrNames.size(); ++i) {
                String name = (String)this._attrNames.elementAt(i);
                if (!name.equals(attr)) continue;
                this._attrValues.setElementAt("", i);
                this.setItemState(ITEM_STATE_UPDATED);
                return;
            }
        }
    }

    public CMItem[] getAttrItems(String attr) throws Exception {
        CMItem[] items = null;
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (!this._attrNames.contains(attr)) {
            // empty if block
        }
        if (this._attrItems != null && this._attrItems.containsKey(attr)) {
            Vector vec = (Vector)this._attrItems.get(attr);
            items = new CMItem[vec.size()];
            for (int i = 0; i < vec.size(); ++i) {
                items[i] = (CMItem)vec.elementAt(i);
                items[i].setDateFormats(this.getDateFormats());
            }
            return items;
        }
        return new CMItem[0];
    }

    public CMObject[] getAttrObjects(String attr) throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (this._attrObjects != null && this._attrObjects.containsKey(attr)) {
            Vector vec = (Vector)this._attrObjects.get(attr);
            CMObject[] objects = new CMObject[vec.size()];
            for (int i = 0; i < vec.size(); ++i) {
                objects[i] = (CMObject)vec.elementAt(i);
            }
            return objects;
        }
        return new CMObject[0];
    }

    public void removeAttr(String attrName) throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (this._attrNames.contains(attrName)) {
            int index = this._attrNames.indexOf(attrName);
            this._attrNames.removeElement(attrName);
            this._attrValues.removeElementAt(index);
            this._attrTypes.removeElementAt(index);
            if (this._attrItems.containsKey(attrName)) {
                this._attrItems.remove(attrName);
            }
            if (this._attrObjects.containsKey(attrName)) {
                this._attrObjects.remove(attrName);
            }
            if (this._attrMultiValues.containsKey(attrName)) {
                this._attrMultiValues.remove(attrName);
            }
            this.setItemState(ITEM_STATE_UPDATED);
        }
    }

    public void removeAttrItem(String attrName, CMItem item) throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        int attrIndex = this._attrNames.indexOf(attrName);
        if (!this._attrItems.containsKey(attrName)) {
            // empty if block
        }
        Vector v = (Vector)this._attrItems.get(attrName);
        v.removeElement(item);
        this._attrItems.put(attrName, v);
        this._attrValues.setElementAt("", attrIndex);
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public void removeAttrObject(String attrName, CMObject object) throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        int attrIndex = this._attrNames.indexOf(attrName);
        if (!this._attrObjects.containsKey(attrName)) {
            // empty if block
        }
        Vector v = (Vector)this._attrObjects.get(attrName);
        v.removeElement(object);
        this._attrObjects.put(attrName, v);
        this._attrValues.setElementAt("", attrIndex);
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public Timestamp getCreateTimestamp() {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            try {
                this._retrieveAttrs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._createTimestamp;
    }

    public String getCreateUserid() {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            try {
                this._retrieveAttrs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._createUserid;
    }

    public Timestamp getLastChangedTimestamp() {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            try {
                this._retrieveAttrs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._lastChangedTimestamp;
    }

    public String getLastChangedUserid() {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            try {
                this._retrieveAttrs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._lastChangedUserid;
    }

    public String getAclCode() {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            try {
                this._retrieveAttrs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._aclCode;
    }

    public String getSemanticType() {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            try {
                this._retrieveAttrs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._semanticType;
    }

    public void setEntityName(String newEntityName) {
        if (this._entityName == null) {
            if (newEntityName != null) {
                this._entityNameChanged = true;
            }
        } else if (!this._entityName.equals(newEntityName)) {
            this._entityNameChanged = true;
        }
        this._entityName = newEntityName;
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public String getEntityName() {
        if (this._entityName == null || this._entityName.length() == 0) {
            if (this._pid != null) {
                this._entityName = CMBaseUtil._getEntityName(this._pid.getObjectType());
            } else {
                return null;
            }
        }
        return this._entityName;
    }

    public boolean getFirstPartVersionControlByApp() {
        String methodName = "getPartVersionControlByApp";
        try {
            if (this.getVersionControl() == 0) {
                return false;
            }
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)this.getDDO().getDatastore().datastoreDef();
            DKItemTypeDefICM entityDef = (DKItemTypeDefICM)dsDefICM.retrieveEntity(this.getEntityName());
            if (entityDef.getClassification() == 1) {
                return this.getVersionControlByApp();
            }
            int policy = 0;
            String partType = this.getFirstPartType();
            if (entityDef != null && entityDef instanceof DKItemTypeDefICM && partType != null) {
                dkCollection relations = entityDef.listItemTypeRelations();
                dkIterator iter = relations.createIterator();
                while (iter.more()) {
                    DKItemTypeRelationDefICM relation = (DKItemTypeRelationDefICM)iter.next();
                    if (relation == null || !partType.equals(relation.getTargetItemTypeName())) continue;
                    policy = relation.getVersionControl();
                    break;
                }
            }
            switch (policy) {
                case 2: {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "icm base part version control policy = By Application");
                    return true;
                }
                case 0: {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "icm base part version control policy = Never");
                    return false;
                }
                case 1: {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "icm base part version control policy = Always");
                    return false;
                }
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, e.getLocalizedMessage());
        }
        return false;
    }

    public String getFirstPartType() throws Exception {
        String methodName = "getFirstPartType";
        String partType = "ICMBASE";
        if (this.getContents() != null && this.getContents().size() > 0) {
            partType = this.getContent(0).getObjectType();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "icm part type for this item = " + partType);
        }
        return partType;
    }

    public boolean getVersionControlByApp() {
        String methodName = "getVersionControlByApp";
        try {
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)this.getDDO().getDatastore().datastoreDef();
            DKComponentTypeDefICM compType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(this.getEntityName());
            short versionControl = 0;
            if (compType instanceof DKItemTypeDefICM) {
                versionControl = ((DKItemTypeDefICM)compType).getVersionControl();
            } else if (compType instanceof DKItemTypeViewDefICM) {
                versionControl = ((DKItemTypeViewDefICM)compType).getVersionControl();
            }
            switch (versionControl) {
                case 2: {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "version control policy = By Application");
                    return true;
                }
                case 0: {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "version control policy = Never");
                    return false;
                }
                case 1: {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "version control policy = Always");
                    return false;
                }
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, e.getLocalizedMessage());
        }
        return false;
    }

    public short getVersionControl() {
        String methodName = "getVersionControl";
        try {
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)this.getDDO().getDatastore().datastoreDef();
            DKComponentTypeDefICM compType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(this.getEntityName());
            short versionControl = 0;
            if (compType instanceof DKItemTypeDefICM) {
                versionControl = ((DKItemTypeDefICM)compType).getVersionControl();
            } else if (compType instanceof DKItemTypeViewDefICM) {
                versionControl = ((DKItemTypeViewDefICM)compType).getVersionControl();
            }
            switch (versionControl) {
                case 2: {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "version control policy = By Application");
                    return ITEM_TYPE_VERSION_CONTROL_BY_APPLICATION;
                }
                case 0: {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "version control policy = Never");
                    return ITEM_TYPE_VERSION_CONTROL_NEVER;
                }
                case 1: {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "version control policy = Always");
                    return ITEM_TYPE_VERSION_CONTROL_ALWAYS;
                }
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, e.getLocalizedMessage());
        }
        return -1;
    }

    public String getServerName() throws Exception {
        return this._serverName;
    }

    public void setServerName(String name) {
        this._serverName = name;
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public String getServerType() throws Exception {
        return this._serverType;
    }

    public void setServerType(String type) {
        this._serverType = type;
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public Image getThumbnail() {
        return this._itemThumbnail;
    }

    public void setThumbnail(Image thumbnail) {
        this._itemThumbnail = thumbnail;
        this.setItemState(ITEM_STATE_UPDATED);
    }

    public String getVersion() {
        String version = "";
        if (this._pid.getIdStringCount() >= 3) {
            try {
                version = this._pid.getIdString(2);
            }
            catch (DKException e) {
                version = "";
            }
        }
        return version;
    }

    public CMConnection getConnection() {
        return this._connection;
    }

    public String getAttrName(int index) throws Exception {
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (index >= this._attrNames.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (String)this._attrNames.elementAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolderItem(CMItem anItem) throws Exception {
        String methodName = "removeFolderItem";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (this.getItemType() == 2 || this.isFolder()) {
            DKDatastoreICM dKDatastoreICM = this._connection.getDatastore();
            synchronized (dKDatastoreICM) {
                this.listFolderItems();
                short data_id = 0;
                data_id = this._ddo.dataId("DKFolder");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "DKFolder dataId = " + data_id);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "_itemList contains #-" + this._itemList.size() + "/[" + this._itemList.capacity() + "]-# items");
                DKDDO ddoObj = null;
                if (this._itemList.contains(anItem)) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "_itemList.contains(anItem)");
                    CMItem folderMemberItem = this._itemList.elementAt(this._itemList.indexOf(anItem));
                    folderMemberItem.setDateFormats(this.getDateFormats());
                    ddoObj = folderMemberItem.getDDO();
                } else {
                    String itemPrimaryId = anItem.getPrimaryIdString();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Looking for " + itemPrimaryId);
                    for (int i = 0; i < this._itemList.size(); ++i) {
                        String primaryId = this._itemList.elementAt(i).getPrimaryIdString();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "found       " + primaryId);
                        if (!itemPrimaryId.equals(primaryId)) continue;
                        ddoObj = this._itemList.elementAt(i).getDDO();
                        break;
                    }
                }
                if (data_id != 0) {
                    DKFolder f = null;
                    f = (DKFolder)this._ddo.getData(data_id);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "BEFORE - items in folder=" + f.cardinality());
                    f.removeMember(this._ddo, ddoObj);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "AFTER  - items in folder=" + f.cardinality());
                    this._ddo.setData(data_id, (Object)f);
                }
                this._itemList.removeElement(anItem);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public List<CMItem> listFolderItems() throws Exception {
        return this.listFolderItems(10, null, false);
    }

    public boolean isFolder() throws Exception {
        return this._ddo.dataId("ATTR", "DKFolder") > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CMItem> listFolderItems(int pagesize, String entityName, boolean foldersOnly) throws Exception {
        String methodName = "listFolderItems";
        if (pagesize < 1) {
            pagesize = 50;
        }
        DKDatastoreICM dKDatastoreICM = this._connection.getDatastore();
        synchronized (dKDatastoreICM) {
            try {
                if (this._itemList == null) {
                    DKFolder object = null;
                    if (this._ddo.dataId("DKFolder") > 0) {
                        short dataid = this._ddo.dataId("ATTR", "DKFolder");
                        object = (DKFolder)this._ddo.getData(dataid);
                    }
                    if (object == null) {
                        this._retrieveICMFolderContents();
                        this.setItemState(ITEM_STATE_RETRIEVED);
                    }
                    short numDataItems = this._ddo.dataCount();
                    String entity = this._ddo.getPidObject().getObjectType();
                    this._itemList = new Vector();
                    Vector<CMItem> itemgroup = null;
                    for (short j = 1; j <= numDataItems; j = (short)(j + 1)) {
                        Object obj = this._ddo.getData(j);
                        if (!(obj instanceof dkCollection) || !this._ddo.getDataName(j).equals("DKFolder")) continue;
                        dkCollection coll = (dkCollection)obj;
                        if (this._ddo.getDatastore() != null && coll.cardinality() <= 0) {
                            this._retrieveICMFolderContents();
                            obj = this._ddo.getData(j);
                        }
                        dkIterator iter = coll.createIterator();
                        while (iter.more()) {
                            dkDataObjectBase obj2 = (dkDataObjectBase)iter.next();
                            if (obj2.protocol() != 5 && obj2.protocol() != 13) continue;
                            String attrName = "";
                            DKDDO subDDO = (DKDDO)obj2;
                            DKPid subPid = subDDO.getPidObject();
                            String objType = subPid.getObjectType();
                            if (objType.equals(entity)) {
                                attrName = this._nameAttr;
                            }
                            CMItem item = new CMItem(this.request, this._connection, subDDO, attrName);
                            item._itemState = ITEM_STATE_NEED_RETRIEVE;
                            if (foldersOnly && (!foldersOnly || item.getItemType() != 2)) continue;
                            item.setDateFormats(this.getDateFormats());
                            if (entityName == null || item.getEntityName().equals(entityName)) {
                                this._itemList.addElement(item);
                            }
                            this.getKnownFolderedEntities().add(objType);
                            if (itemgroup == null || itemgroup.size() >= pagesize) {
                                itemgroup = new Vector<CMItem>(pagesize);
                            }
                            item.setItemGroup(itemgroup);
                            itemgroup.addElement(item);
                        }
                    }
                }
            }
            catch (Exception ex) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ex);
            }
            if (this._itemList != null && this._itemList.size() > 0) {
                this._retrieveItemGroup(this._itemList, true);
            } else {
                this._itemList = new Vector();
            }
        }
        return (Vector)this._itemList.clone();
    }

    public CMItem getFolderItem(int index) throws Exception {
        if (this._itemList == null) {
            this.listFolderItems();
        }
        if (index >= this._itemList.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this._itemList.elementAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector listRefFolders() throws Exception {
        Vector<CMItem> items = new Vector<CMItem>();
        DKDatastoreICM dKDatastoreICM = this._connection.getDatastore();
        synchronized (dKDatastoreICM) {
            try {
                dkDatastoreExt dsExt = (dkDatastoreExt)this._connection.getDatastore().getExtension("DATASTORE_EXTENSION");
                short propId = this._ddo.propertyId("link type selection");
                if (propId > 0) {
                    this._ddo.setProperty(this._ddo.propertyId("link type selection"), (Object)"DKFolder");
                } else {
                    this._ddo.addProperty("link type selection", (Object)"DKFolder");
                }
                propId = this._ddo.propertyId("record folder sources");
                if (propId > 0) {
                    this._ddo.setProperty(this._ddo.propertyId("record folder sources"), (Object)"TRUE");
                } else {
                    this._ddo.addProperty("record folder sources", (Object)"TRUE");
                }
                this._ddo.retrieve(4100);
                DKSequentialCollection coll = new DKSequentialCollection();
                propId = this._ddo.propertyId("folder sources");
                if (propId > 0) {
                    coll = (dkCollection)this._ddo.getProperty(propId);
                }
                dkIterator iter = coll.createIterator();
                while (iter.more()) {
                    DKDDO ddoFolder = (DKDDO)iter.next();
                    ddoFolder.retrieve();
                    CMItem item = new CMItem(this.request, this._connection, ddoFolder, "");
                    item.setDateFormats(this.getDateFormats());
                    items.addElement(item);
                }
                return items;
            }
            catch (Exception exception) {
                return items;
            }
        }
    }

    public Object clone() {
        CMItem newItem = null;
        try {
            newItem = (CMItem)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this._copyValuesForClone(this, newItem);
        return newItem;
    }

    private void _copyValuesForClone(CMItem origItem, CMItem newItem) {
        String key;
        Enumeration keys;
        if (origItem._attrNames != null) {
            newItem._attrNames = (Vector)origItem._attrNames.clone();
        }
        if (origItem._attrTypes != null) {
            newItem._attrTypes = (Vector)origItem._attrTypes.clone();
        }
        if (origItem._attrValues != null) {
            newItem._attrValues = (Vector)origItem._attrValues.clone();
        }
        if (origItem._itemList != null) {
            newItem.setFolderItems((Vector)origItem._itemList.clone());
        }
        if (origItem._attrMultiValues != null) {
            newItem._attrMultiValues = new Hashtable();
            keys = origItem._attrMultiValues.keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                newItem._attrMultiValues.put(key, origItem._attrMultiValues.get(key));
            }
        }
        if (origItem._attrObjects != null) {
            newItem._attrObjects = new Hashtable();
            keys = origItem._attrObjects.keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                newItem._attrObjects.put(key, origItem._attrObjects.get(key));
            }
        }
        if (origItem._attrItems != null) {
            newItem._attrItems = new Hashtable();
            keys = origItem._attrItems.keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                Vector origAttrItems = (Vector)origItem._attrItems.get(key);
                if (origAttrItems == null) {
                    origAttrItems = new Vector();
                }
                Vector<Object> newAttrItems = new Vector<Object>();
                for (int i = 0; i < origAttrItems.size(); ++i) {
                    CMItem origAttrItem = (CMItem)origAttrItems.elementAt(i);
                    newAttrItems.addElement(origAttrItem.clone());
                }
                newItem._attrItems.put(key, newAttrItems);
            }
        }
    }

    private void _deleteChildrenAndRefAttrs() throws Exception {
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (this._attrItems != null && this._attrItems.size() > 0) {
            Enumeration keys = this._attrItems.keys();
            while (keys.hasMoreElements()) {
                String attrName = (String)keys.nextElement();
                this.setAttrItems(attrName, null);
            }
        }
    }

    private void _retrieveLinks() throws DKException, Exception {
        if (this._linksRetrieved) {
            return;
        }
        if (this._ddo.getDatastore() != null) {
            this._ddo.getDatastore().retrieveObject((dkDataObject)this._ddo, 6144);
            this._linksRetrieved = true;
        }
    }

    public void sortFolderItems(String server, String entity, String attribute, boolean ascending) {
        if (this._itemList != null) {
            CMItemComparator comp = new CMItemComparator(server, entity, attribute, ascending, this._connection.getDatastore(), this.getDateFormats());
            CMBaseUtil._sortItemList(this._itemList, comp);
        }
    }

    public void sortFolderItems(Comparator comparator) {
        if (this._itemList != null) {
            CMBaseUtil._sortItemList(this._itemList, comparator);
        }
    }

    public String toString() {
        int attrCount = 0;
        int contentCount = 0;
        if (this._attrNames != null) {
            attrCount = this._attrNames.size();
        }
        if (this._contentList != null) {
            contentCount = this._contentList.size();
        }
        return "CMItem[name=" + this._name + ",itemType=" + this._itemType + ",entityName=" + this._entityName + ",serverName=" + this._serverName + ",serverType=" + this._serverType + ",itemState=" + this._itemState + ",attrsRetrieved=" + this._attrsRetrieved + ",partsRetrieved=" + this._partsRetrieved + ",attrCount=" + attrCount + ",contentCount=" + contentCount + ",pidString={" + (this._pid != null ? this._pid.pidString() : "null") + "}]";
    }

    ArrayList getItemsPerLevel(ArrayList nodes, String[] path, int level) throws Exception {
        String childname = path[level];
        ArrayList<CMItem> nodesOnLevel = new ArrayList<CMItem>();
        for (int i = 0; i < nodes.size(); ++i) {
            CMItem aitem = (CMItem)nodes.get(i);
            if (!aitem.isAttr(childname)) continue;
            CMItem[] citems = aitem.getAttrItems(childname);
            for (int j = 0; j < citems.length; ++j) {
                nodesOnLevel.add(citems[j]);
            }
        }
        if (path.length > level + 2) {
            return this.getItemsPerLevel(nodesOnLevel, path, ++level);
        }
        return nodesOnLevel;
    }

    void setDDO(DKDDO ddoObj, int itemState) {
        this._ddo = ddoObj;
        this._entityNameChanged = false;
        try {
            this._pid = ddoObj.getPidObject();
            this._extractInfoFromPid(this._pid);
            this._entityName = null;
            this._itemState = itemState;
            this._attrsRetrieved = false;
            this._linksRetrieved = false;
            this._ICMFolderContentsRetrieved = false;
            this._partsRetrieved = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setNameColumn(String attrName) {
        this._nameAttr = attrName;
    }

    public DKDDO getDDO() {
        return this._ddo;
    }

    void setFolderItems(Vector itemList) {
        this._itemList = itemList;
    }

    void clearForReUse() {
        this.removeAllAttrs();
        this._pid = null;
        this._ddo = null;
        this._serverType = "";
        this._itemState = ITEM_STATE_NEW;
        this._attrsRetrieved = false;
        this._linksRetrieved = false;
        this._ICMFolderContentsRetrieved = false;
        this._partsRetrieved = false;
        this._serverName = "";
        this._rank = 0;
        this._entityName = "";
        this._itemThumbnail = null;
        this._itemType = 0;
        this._createTimestamp = CM_TIMESTAMP_UNDEFINED;
        this._createUserid = CM_USERID_UNDEFINED;
        this._lastChangedTimestamp = CM_TIMESTAMP_UNDEFINED;
        this._lastChangedUserid = CM_USERID_UNDEFINED;
        this._aclCode = CM_ACLCODE_UNDEFINED;
        this._semanticType = CM_SEMANTICTYPE_UNDEFINED;
        this._name = "";
        this._itemGroup = null;
        if (this._itemList != null) {
            this._itemList.removeAllElements();
        }
        if (this._noteLogList != null) {
            this._noteLogList.removeAllElements();
        }
        if (this._contentList != null) {
            this._contentList.removeAllElements();
        }
    }

    public String getParentPath() {
        return this._parentPath;
    }

    void setParentPath(String parentItemPath, String attr) {
        this._parentPath = parentItemPath;
        this._parentPath = this._parentPath.length() == 0 ? attr : parentItemPath + "/" + attr;
    }

    public CMItem getParent() {
        return this._parent;
    }

    void setParent(CMItem parent) {
        this._parent = parent;
    }

    int getItemState() {
        return this._itemState;
    }

    public void setItemState(int newItemState) {
        if (newItemState == ITEM_STATE_NEW) {
            if (this._itemState != ITEM_STATE_NEW) {
                throw new IllegalStateException("CMItem represents an existing item on the server.");
            }
        } else if (newItemState == ITEM_STATE_NEED_RETRIEVE) {
            if (this._itemState == ITEM_STATE_NEW) {
                this._itemState = ITEM_STATE_NEED_RETRIEVE;
            } else if (this._itemState != ITEM_STATE_NEED_RETRIEVE) {
                if (this._itemState == ITEM_STATE_RETRIEVED) {
                    this._itemState = ITEM_STATE_NEED_RETRIEVE;
                } else if (this._itemState == ITEM_STATE_UPDATED) {
                    this._itemState = ITEM_STATE_NEED_RETRIEVE;
                } else if (this._itemState == ITEM_STATE_DELETED) {
                    // empty if block
                }
            }
        } else if (newItemState == ITEM_STATE_RETRIEVED) {
            if (this._itemState == ITEM_STATE_NEW) {
                this._itemState = ITEM_STATE_RETRIEVED;
            } else if (this._itemState == ITEM_STATE_NEED_RETRIEVE) {
                this._itemState = ITEM_STATE_RETRIEVED;
            } else if (this._itemState != ITEM_STATE_RETRIEVED) {
                if (this._itemState == ITEM_STATE_UPDATED) {
                    this._itemState = ITEM_STATE_RETRIEVED;
                } else if (this._itemState == ITEM_STATE_DELETED) {
                    // empty if block
                }
            }
        } else if (newItemState == ITEM_STATE_UPDATED) {
            if (this._itemState != ITEM_STATE_NEW && this._itemState != ITEM_STATE_NEED_RETRIEVE) {
                if (this._itemState == ITEM_STATE_RETRIEVED) {
                    this._itemState = ITEM_STATE_UPDATED;
                } else if (this._itemState != ITEM_STATE_UPDATED && this._itemState == ITEM_STATE_DELETED) {
                    // empty if block
                }
            }
        } else if (newItemState == ITEM_STATE_DELETED && this._itemState != ITEM_STATE_NEW) {
            if (this._itemState == ITEM_STATE_NEED_RETRIEVE) {
                this._itemState = ITEM_STATE_DELETED;
            } else if (this._itemState == ITEM_STATE_RETRIEVED) {
                this._itemState = ITEM_STATE_DELETED;
            } else if (this._itemState == ITEM_STATE_UPDATED) {
                this._itemState = ITEM_STATE_DELETED;
            } else if (this._itemState == ITEM_STATE_DELETED) {
                // empty if block
            }
        }
    }

    void setICMFolderContentsRetrieved(boolean retrieved) {
        this._ICMFolderContentsRetrieved = retrieved;
    }

    public void sortMultiValues(String attrName, Comparator comparator) throws Exception {
        Vector vec;
        if (this._attrMultiValues != null && this._attrMultiValues.containsKey(attrName) && (vec = (Vector)this._attrMultiValues.get(attrName)) != null && vec.size() > 0) {
            Object first = vec.elementAt(0);
            if (first instanceof CMItem) {
                CMBaseUtil._sortItemList(vec, comparator);
            } else {
                Collections.sort(vec, comparator);
            }
        }
        if (this._attrNames.contains(attrName)) {
            return;
        }
    }

    public void sortChildren(String attrName, Comparator comparator) throws Exception {
        if (!this._attrsRetrieved) {
            this._retrieveAttrs();
        }
        if (this._attrItems != null && this._attrItems.containsKey(attrName)) {
            Vector vec = (Vector)this._attrItems.get(attrName);
            CMBaseUtil._sortItemList(vec, comparator);
        }
        if (this._attrNames.contains(attrName)) {
            return;
        }
    }

    private void _extractInfoFromPid(DKPid pid) {
        this._serverName = pid.getDatastoreName();
        this._serverType = pid.getDatastoreType();
    }

    private void _extractItemType() {
        if (this._itemState == ITEM_STATE_NEED_RETRIEVE) {
            this._itemType = 0;
            return;
        }
        if (this._ddo == null) {
            return;
        }
        try {
            Object obj;
            short val;
            short propID = this._ddo.propertyId("item-type");
            this._itemType = propID > 0 ? ((val = ((Short)(obj = this._ddo.getProperty(propID))).shortValue()) == 2 ? (short)2 : (val == 1 ? (short)1 : (val == 4 ? (short)4 : (short)4))) : (short)4;
        }
        catch (Exception e) {
            this._itemType = (short)4;
        }
    }

    private void _extractUseridTimestampInfo() {
        Object obj;
        short propID;
        if (this._ddo == null) {
            this._createTimestamp = CM_TIMESTAMP_UNDEFINED;
            this._createUserid = CM_USERID_UNDEFINED;
            this._lastChangedTimestamp = CM_TIMESTAMP_UNDEFINED;
            this._lastChangedUserid = CM_USERID_UNDEFINED;
            return;
        }
        try {
            propID = this._ddo.propertyId("SYSROOTATTRS.CREATETS");
            if (propID != 0) {
                obj = this._ddo.getProperty(propID);
                this._createTimestamp = (Timestamp)obj;
            } else {
                this._createTimestamp = CM_TIMESTAMP_UNDEFINED;
            }
        }
        catch (Exception e) {
            this._createTimestamp = CM_TIMESTAMP_UNDEFINED;
        }
        try {
            propID = this._ddo.propertyId("SYSROOTATTRS.CREATEUSERID");
            if (propID != 0) {
                obj = this._ddo.getProperty(propID);
                this._createUserid = (String)obj;
            } else {
                this._createUserid = CM_USERID_UNDEFINED;
            }
        }
        catch (Exception e) {
            this._createUserid = CM_USERID_UNDEFINED;
        }
        try {
            short propID2 = this._ddo.propertyId("SYSROOTATTRS.LASTCHANGEDTS");
            if (propID2 != 0) {
                obj = this._ddo.getProperty(propID2);
                this._lastChangedTimestamp = (Timestamp)obj;
            } else {
                this._lastChangedTimestamp = CM_TIMESTAMP_UNDEFINED;
            }
        }
        catch (Exception e) {
            this._lastChangedTimestamp = CM_TIMESTAMP_UNDEFINED;
        }
        try {
            short propID3 = this._ddo.propertyId("SYSROOTATTRS.LASTCHANGEDUSERID");
            if (propID3 != 0) {
                obj = this._ddo.getProperty(propID3);
                this._lastChangedUserid = (String)obj;
            } else {
                this._lastChangedUserid = CM_USERID_UNDEFINED;
            }
        }
        catch (Exception e) {
            this._lastChangedUserid = CM_USERID_UNDEFINED;
        }
    }

    private void _extractSystemAttributesInfo() {
        Object obj;
        short propID;
        if (this._ddo == null) {
            this._aclCode = CM_ACLCODE_UNDEFINED;
            this._semanticType = CM_SEMANTICTYPE_UNDEFINED;
            return;
        }
        try {
            propID = this._ddo.propertyId("SYSROOTATTRS.ACLCODE");
            if (propID != 0) {
                obj = this._ddo.getProperty(propID);
                this._aclCode = (String)obj;
            } else {
                this._aclCode = CM_ACLCODE_UNDEFINED;
            }
        }
        catch (Exception e) {
            this._aclCode = CM_ACLCODE_UNDEFINED;
        }
        try {
            propID = this._ddo.propertyId("semantic-type");
            if (propID != 0) {
                obj = this._ddo.getProperty(propID);
                this._semanticType = (String)obj;
            } else {
                this._semanticType = CM_SEMANTICTYPE_UNDEFINED;
            }
        }
        catch (Exception e) {
            this._semanticType = CM_SEMANTICTYPE_UNDEFINED;
        }
    }

    private void _initializeAttrVectors() {
        this._attrNames = new Vector();
        this._attrTypes = new Vector();
        this._attrValues = new Vector();
        this._attrMultiValues = new Hashtable();
        this._attrItems = new Hashtable();
        this._attrObjects = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _retrieveAttrs() throws Exception {
        String methodName = "_retrieveAttrs";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (this._attrNames == null) {
            this._initializeAttrVectors();
        }
        if (this._pid == null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "_pid is null");
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "_connection.getDatastore() = " + this._connection.getDatastore());
        try {
            DKDDO _ddo;
            if (this._ddo == null) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "DDO is null");
                _ddo = CMBaseUtil.makeDDOForPid(this._pid.pidString(), this._connection.getDatastore());
                this.setDDO(_ddo, ITEM_STATE_NEED_RETRIEVE);
            }
            if (this._itemState == ITEM_STATE_NEED_RETRIEVE) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "_itemState: ITEM_STATE_NEED_RETRIEVE");
                if (this._itemGroup != null) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "_itemGroup != null");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "invoking _retrieveItemGroup");
                    _ddo = this._connection.getDatastore();
                    synchronized (_ddo) {
                        this._retrieveItemGroup(this._itemGroup, false);
                    }
                }
                if (this._itemState == ITEM_STATE_NEED_RETRIEVE) {
                    if (this._ddo.getDatastore() != null) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "invoking  _ddo.getDatastore().retrieveObject(_ddo,DKConstant.DK_CM_CONTENT_ITEMTREE_NO_LINKS)");
                        _ddo = this._connection.getDatastore();
                        synchronized (_ddo) {
                            DKPidICM pidICM = (DKPidICM)this._ddo.getPidObject();
                            if (pidICM.getVersionNumber().equals("0")) {
                                pidICM.setVersionNumber("1");
                                this._ddo.getDatastore().retrieveObject((dkDataObject)this._ddo, 288);
                            } else {
                                this._ddo.getDatastore().retrieveObject((dkDataObject)this._ddo, 32);
                            }
                        }
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "invoking _ddo.retrieve()");
                    _ddo = this._connection.getDatastore();
                    synchronized (_ddo) {
                        this._ddo.retrieve();
                    }
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "setting ITEM_STATE_RETRIEVED");
                this._itemState = ITEM_STATE_RETRIEVED;
            }
            this._extractItemType();
            this._extractUseridTimestampInfo();
            this._extractSystemAttributesInfo();
            this._attrNames.clear();
            this._attrTypes.clear();
            this._attrValues.clear();
            this._attrItems.clear();
            this._attrObjects.clear();
            this._attrMultiValues.clear();
            Object names = null;
            Object types = null;
            this._extractAndOrderICMAttrValues(this._ddo);
            this._attrsRetrieved = true;
        }
        catch (Exception ex) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ex);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private void _retrieveAttrValue(String name, Short type, Object value, int index, DKAttrDefICM attr) throws Exception {
        String methodName = "_retrieveAttrValue";
        Logger.logEntry((Object)this, "_retrieveAttrValue", (ServletRequest)this.request, "name: " + name + ", value instanceof: " + (value != null ? value.getClass() : null) + ", type: " + type + ", index: " + index);
        if (value == null) {
            if (index != -1) {
                this._attrValues.add(index, new String(""));
            } else {
                this._attrValues.addElement(new String(""));
            }
            return;
        }
        if (value instanceof dkCollection) {
            Vector<Object> v = new Vector<Object>();
            dkIterator iter = ((dkCollection)value).createIterator();
            while (iter.more()) {
                Object curObj = iter.next();
                if (curObj instanceof DKDDO) {
                    CMItem attrItem = new CMItem(this.request, this._connection);
                    attrItem.setParentPath(this._parentPath, name);
                    attrItem.setParent(this);
                    attrItem.setDDO((DKDDO)curObj, ITEM_STATE_RETRIEVED);
                    attrItem.seDKAttrDefICM(attr);
                    attrItem.setDateFormats(this.getDateFormats());
                    v.addElement(attrItem);
                    continue;
                }
                if (curObj == null) {
                    curObj = "";
                }
                v.addElement(curObj.toString());
            }
            if (type == 1072) {
                this._attrItems.put(name, v);
            } else {
                this._attrMultiValues.put(name, v);
            }
            if (index != -1) {
                this._attrValues.add(index, "");
            } else {
                this._attrValues.addElement("");
            }
        } else if (value instanceof DKDDO) {
            CMItem attrItem = new CMItem(this.request, this._connection);
            attrItem.setParentPath(this._parentPath, name);
            attrItem.setParent(this);
            attrItem.setDDO((DKDDO)value, ITEM_STATE_NEED_RETRIEVE);
            attrItem.setDateFormats(this.getDateFormats());
            Vector<CMItem> v = new Vector<CMItem>();
            v.addElement(attrItem);
            this._attrItems.put(name, v);
            if (index != -1) {
                this._attrValues.add(index, "");
            } else {
                this._attrValues.addElement("");
            }
        } else if (value instanceof dkXDO) {
            CMObject attrObject = new CMObject((dkXDO)value);
            Vector<CMObject> v = new Vector<CMObject>();
            v.addElement(attrObject);
            this._attrObjects.put(name, v);
            if (index != -1) {
                this._attrValues.add(index, "");
            } else {
                this._attrValues.addElement("");
            }
        } else if (value instanceof dkDataObject) {
            if (index != -1) {
                this._attrValues.add(index, "");
            } else {
                this._attrValues.addElement("");
            }
        } else if (value instanceof byte[]) {
            if (type == 11) {
                String mimetype = "application/binary";
                CMObject attrObject = new CMObject((byte[])value, mimetype);
                Vector<CMObject> v = new Vector<CMObject>();
                v.addElement(attrObject);
                this._attrObjects.put(name, v);
                if (index != -1) {
                    this._attrValues.add(index, "");
                } else {
                    this._attrValues.addElement("");
                }
            } else if (index != -1) {
                this._attrValues.add(index, new String((byte[])value));
            } else {
                this._attrValues.addElement(new String((byte[])value));
            }
        } else if (value instanceof DKDate || value instanceof DKTime || value instanceof DKTimestamp) {
            String newstring = value instanceof DKDate ? DateUtil.getISODateString((java.util.Date)((DKDate)value), false) : (value instanceof DKTime ? DateUtil.getISODateString((java.util.Date)((DKTime)value), false) : DateUtil.getISODateString((java.util.Date)((DKTimestamp)value), true));
            if (index != -1) {
                this._attrValues.add(index, newstring);
            } else {
                this._attrValues.addElement(newstring);
            }
        } else if (index != -1) {
            this._attrValues.add(index, value.toString());
        } else {
            this._attrValues.addElement(value.toString());
        }
        Logger.logExit((Object)this, "_retrieveAttrValue", (ServletRequest)this.request, "attrValues: " + this._attrValues.toString());
    }

    private void _retrieveItemGroup(Vector items, boolean retrievePartsAttributes) throws Exception, DKException, Exception {
        String methodName = "_retrieveItemGroup";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        boolean isItemGroupVector = items == this._itemGroup;
        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.getConnection().getDatastore());
        dkRetrieveOptions.baseAttributes(true);
        dkRetrieveOptions.childAttributes(true);
        dkRetrieveOptions.childListOneLevel(true);
        dkRetrieveOptions.basePropertyAclName(true);
        dkRetrieveOptions.resourceContent(false);
        dkRetrieveOptions.basePropertyCheckedOutDetails(true);
        dkRetrieveOptions.partsList(true);
        dkRetrieveOptions.partsAttributes(retrievePartsAttributes);
        dkRetrieveOptions.behaviorPartsAttributesCoreOnly(retrievePartsAttributes);
        dkRetrieveOptions.functionVersionLatest(this._getLatestVersion);
        dkRetrieveOptions.behaviorIgnoreNoneFoundError(true);
        CMItem._retrieveItemGroup(this.request, items.toArray(new CMItem[0]), dkRetrieveOptions, isItemGroupVector);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public static void retrieveItemGroup(HttpServletRequest request, CMItem[] items, DKRetrieveOptionsICM options) throws Exception {
        try {
            CMItem._retrieveItemGroup(request, items, options, false);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private static void _retrieveItemGroup(HttpServletRequest request, CMItem[] items, DKRetrieveOptionsICM options, boolean isItemGroupVector) throws Exception, DKException, Exception {
        String methodName = "_retrieveItemGroup";
        Logger.logEntry(CMItem.class, methodName, (ServletRequest)request);
        if (items != null && items.length > 0) {
            CMItem item;
            CMItem firstItem = items[0];
            CMItem._fillInDDO(firstItem);
            dkDatastoreIntICM ds = (dkDatastoreIntICM)firstItem._ddo.getDatastore();
            DKSequentialCollection ddoCollection = new DKSequentialCollection();
            for (int i = 0; i < items.length; ++i) {
                item = items[i];
                CMItem._fillInDDO(item);
                DKPidICM pidICM = (DKPidICM)item._ddo.getPidObject();
                if (pidICM.getVersionNumber().equals("0")) {
                    pidICM.setVersionNumber("1");
                    if (options != null) {
                        options.functionVersionLatest(true);
                    }
                } else if (options != null) {
                    options.functionVersionLatest(false);
                }
                ddoCollection.addElement((Object)item._ddo);
            }
            if (options == null) {
                try {
                    Logger.logDebug(CMItem.class, methodName, (ServletRequest)request, "ds.retrieveObjects(ddoCollection, options.dkNVPair())");
                    ds.retrieveObjects((dkCollection)ddoCollection, 32);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {}
            } else {
                try {
                    Logger.logDebug(CMItem.class, methodName, (ServletRequest)request, "ds.retrieveObjects(ddoCollection, options.dkNVPair())");
                    ds.retrieveObjects((dkCollection)ddoCollection, options.dkNVPair());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (isItemGroupVector) {
                CMItem[] itemsClone = (CMItem[])items.clone();
                for (int i = 0; i < itemsClone.length; ++i) {
                    CMItem item2 = itemsClone[i];
                    DKNVPair opr = (DKNVPair)item2._ddo.getPropertyByName("last_operation");
                    if (opr.getName().equals("RETRIEVE") && opr.getValue().equals("FAIL")) {
                        if (item2._itemGroup != null) {
                            for (int j = 0; j < item2._itemGroup.size(); ++j) {
                                if (item2._itemGroup.elementAt(j) != item2) continue;
                                item2._itemGroup.removeElementAt(j);
                                --j;
                            }
                        }
                        item2._itemGroup = null;
                        continue;
                    }
                    item2.setDDO(item2._ddo, ITEM_STATE_RETRIEVED);
                }
            } else {
                Logger.logDebug(CMItem.class, methodName, (ServletRequest)request, "Setting state to retrieved");
                for (int i = 0; i < items.length; ++i) {
                    item = items[i];
                    item.setDDO(item._ddo, ITEM_STATE_RETRIEVED);
                }
            }
        }
        Logger.logExit(CMItem.class, methodName, (ServletRequest)request);
    }

    private static void _fillInDDO(CMItem item) throws Exception {
        if (item._ddo == null) {
            try {
                DKDDO _ddo = CMBaseUtil.makeDDOForPid(item.getPidString(), item.getConnection().getDatastore());
                item.setDDO(_ddo, ITEM_STATE_NEED_RETRIEVE);
            }
            catch (DKException dKException) {
                // empty catch block
            }
        }
    }

    private void _retrieveICMFolderContents() throws DKException, Exception {
        if (this._ICMFolderContentsRetrieved) {
            return;
        }
        if (this._ddo.getDatastore() != null) {
            DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.getConnection().getDatastore());
            dkRetrieveOptions.baseAttributes(true);
            dkRetrieveOptions.basePropertyAclName(true);
            dkRetrieveOptions.resourceContent(false);
            dkRetrieveOptions.basePropertyCheckedOutDetails(true);
            dkRetrieveOptions.partsList(true);
            dkRetrieveOptions.partsAttributes(true);
            dkRetrieveOptions.behaviorPartsAttributesCoreOnly(true);
            dkRetrieveOptions.linksOutbound(true);
            dkRetrieveOptions.functionVersionLatest(this._getLatestVersion);
            this._ddo.retrieve(dkRetrieveOptions.dkNVPair());
            this._ICMFolderContentsRetrieved = true;
        }
    }

    private void _sortAttributes() {
        String methodName = "_sortAttributes";
        CMItemComparator comparator = null;
        if (comparator == null) {
            comparator = new CMItemComparator("", true, this._connection.getDatastore(), this.getDateFormats());
        }
        try {
            String[] names = this.getAttrNames();
            short[] types = this.getAttrTypes();
            for (int i = 0; i < names.length; ++i) {
                comparator.setContextAttribute(names[i]);
                comparator.setContextItem(this);
                if (types[i] == 1072) {
                    this.sortChildren(names[i], comparator);
                    continue;
                }
                if (!this._attrMultiValues.containsKey(names[i])) continue;
                this.sortMultiValues(names[i], comparator);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
    }

    private void _extractAndOrderICMAttrValues(DKDDO ddo) throws Exception {
        String methodName = "_extractAndOrderICMAttrValues";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)this._connection.getDatastore().datastoreDef();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "getEntityName() = " + this.getEntityName());
        CMEntity entity = this._connection.getEntity(this.getEntityName());
        CMAttributeDef[] attrs = entity.getAttributes(true);
        try {
            this._attrNames = new Vector(attrs.length);
            this._attrTypes = new Vector(attrs.length);
            this._attrValues = new Vector(attrs.length);
            for (int i = 0; i < attrs.length; ++i) {
                Short type;
                CMAttributeDef attr = attrs[i];
                String sname = attr.getName();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "sname = " + sname);
                String lname = attr.getDkAttrDef().getDescription();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "lname = " + lname);
                short dataid = ddo.dataId("ATTR", sname);
                this._attrNames.add(i, sname);
                if (dataid != 0) {
                    type = (Short)ddo.getDataPropertyByName(dataid, "type");
                    this._attrTypes.add(i, type);
                    this._retrieveAttrValue(sname, type, ddo.getData(dataid), i, attr.getDkAttrDef());
                    continue;
                }
                dataid = ddo.dataId("CHILD", sname);
                if (dataid != 0) {
                    type = (Short)ddo.getDataPropertyByName(dataid, "type");
                    this._attrTypes.add(i, type);
                    this._retrieveAttrValue(sname, type, ddo.getData(dataid), i, attr.getDkAttrDef());
                    continue;
                }
                this._attrTypes.add(i, attr.getType());
                this._attrValues.add(i, new String(""));
            }
        }
        catch (Exception ex) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ex);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    Vector getContents() throws Exception {
        this._retrieveAndSortParts();
        return this._contentList;
    }

    public int getContentCount() throws Exception {
        this._retrieveAndSortParts();
        return this._contentList.size();
    }

    public CMObject getContent(int i) throws Exception {
        this._retrieveAndSortParts();
        return (CMObject)this._contentList.get(i);
    }

    Vector getAnnotationList() throws Exception {
        this._retrieveAndSortParts();
        return this._annotationList;
    }

    public int getAnnotationCount() throws Exception {
        this._retrieveAndSortParts();
        return this._annotationList.size();
    }

    Vector getNoteLogList() throws Exception {
        this._retrieveAndSortParts();
        return this._noteLogList;
    }

    public int getNoteLogCount() throws Exception {
        this._retrieveAndSortParts();
        return this._noteLogList.size();
    }

    public Vector getItemGroup() {
        return this._itemGroup;
    }

    public void setItemGroup(Vector itemGroup) {
        this._itemGroup = itemGroup;
    }

    private String _retrieveDDOMimeTypeType(DKDDO ddo) throws Exception {
        String methodName = "_retrieveDDOMimeTypeType";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        String itemMimeType = null;
        boolean isFolder = false;
        short dataid = ddo.propertyId("semantic-type");
        if (dataid != 0) {
            boolean bl = isFolder = (Integer)ddo.getProperty(dataid) == 2;
        }
        if (!isFolder) {
            boolean bl = isFolder = ddo.dataId("ATTR", "DKFolder") != 0;
        }
        if (!isFolder) {
            if (ddo instanceof DKLobICM) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Is resource item");
                itemMimeType = ((DKLobICM)ddo).getMimeType();
            } else {
                String documentItemId = ((DKPidICM)ddo.getPidObject()).getItemId();
                dataid = ddo.dataId("ATTR", "DKParts");
                if (dataid != 0) {
                    DKRetrieveOptionsICM retrieveOptions;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "ddo has parts");
                    DKParts dkParts = (DKParts)ddo.getData(dataid);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Document (" + documentItemId + ") Parts:");
                    dkIterator iter = dkParts.createIterator();
                    Vector<DKDDO> basePartsList = new Vector<DKDDO>();
                    int annotationCount = 0;
                    while (iter.more()) {
                        DKDDO _ddo = (DKDDO)iter.next();
                        String pidObjectType = _ddo.getPidObject().getObjectType();
                        if (pidObjectType.startsWith("ICMBASE")) {
                            basePartsList.addElement(_ddo);
                            continue;
                        }
                        if (!pidObjectType.equalsIgnoreCase("ICMANNOTATION") || ++annotationCount != 2) continue;
                        DKLobICM lob = (DKLobICM)_ddo;
                        if (lob.getSize() == 0L) {
                            retrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this._connection.getDatastore());
                            retrieveOptions.behaviorIgnoreNoneFoundError(true);
                            retrieveOptions.baseAttributes(true);
                            retrieveOptions.basePropertyAclName(true);
                            retrieveOptions.functionVersionLatest(this._getLatestVersion);
                            DKNVPair[] pair = retrieveOptions.dkNVPair();
                            lob.retrieve(pair);
                        }
                        if (lob.getSize() <= 2L) continue;
                        this.setHasBookmarks(true);
                    }
                    int numBaseParts = basePartsList.size();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "partList size = " + numBaseParts);
                    String firstPartMimeType = null;
                    if (numBaseParts > 0) {
                        if (numBaseParts == 1) {
                            DKLobICM xdo = (DKLobICM)basePartsList.get(0);
                            firstPartMimeType = xdo.getMimeType();
                            if (firstPartMimeType != null) {
                                itemMimeType = firstPartMimeType;
                            } else if (!this._partsRetrieved) {
                                retrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this._connection.getDatastore());
                                retrieveOptions.behaviorIgnoreNoneFoundError(true);
                                retrieveOptions.baseAttributes(true);
                                retrieveOptions.basePropertyAclName(true);
                                retrieveOptions.functionVersionLatest(this._getLatestVersion);
                                xdo.retrieve(retrieveOptions.dkNVPair());
                                itemMimeType = xdo.getMimeType();
                            }
                        } else {
                            if (!this._partsRetrieved) {
                                DKSequentialCollection coll = new DKSequentialCollection();
                                for (int i = 0; i < numBaseParts; ++i) {
                                    DKLobICM xdo = (DKLobICM)basePartsList.get(i);
                                    if (xdo.getMimeType() != null) continue;
                                    coll.addElement((Object)xdo);
                                }
                                if (coll.cardinality() > 0) {
                                    DKRetrieveOptionsICM retrieveOptions2 = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this._connection.getDatastore());
                                    retrieveOptions2.behaviorIgnoreNoneFoundError(true);
                                    retrieveOptions2.baseAttributes(true);
                                    retrieveOptions2.basePropertyAclName(true);
                                    retrieveOptions2.functionVersionLatest(this._getLatestVersion);
                                    this._connection.getDatastore().retrieveObjects((dkCollection)coll, retrieveOptions2.dkNVPair());
                                }
                            }
                            for (int i = 0; i < numBaseParts; ++i) {
                                DKLobICM xdo = (DKLobICM)basePartsList.get(i);
                                String partMimeType = xdo.getMimeType();
                                if (partMimeType == null || partMimeType.isEmpty()) continue;
                                if (firstPartMimeType == null) {
                                    firstPartMimeType = partMimeType;
                                    continue;
                                }
                                if (firstPartMimeType.equalsIgnoreCase(partMimeType)) continue;
                                firstPartMimeType = "application/binary";
                                break;
                            }
                            if (firstPartMimeType != null) {
                                itemMimeType = firstPartMimeType;
                            }
                        }
                    } else {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Has no base parts");
                    }
                } else {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Has no parts");
                }
            }
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "itemMimeType: " + itemMimeType);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return itemMimeType;
    }

    private short _retrieveDDOExtractItemType(DKDDO ddo) {
        String methodName = "_retrieveDDOExtractItemType";
        int val = 0;
        try {
            Object obj;
            DKPidICM pidICM = (DKPidICM)this._ddo.getPidObject();
            if (pidICM.getVersionNumber().equals("0")) {
                pidICM.setVersionNumber("1");
                ddo.retrieve(258);
            } else {
                ddo.retrieve(2);
            }
            short propID = ddo.propertyId("item-type");
            val = propID > 0 ? ((val = ((Short)(obj = ddo.getProperty(propID))).shortValue()) == 2 ? 2 : (val == 1 ? 1 : (val == 4 ? 4 : 4))) : 4;
        }
        catch (Exception ex) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ex);
            return (short)val;
        }
        return (short)val;
    }

    DKPid getPidObject() {
        return this._pid;
    }

    void setInvalidPid(boolean invalid) {
        this.invalidPid = invalid;
    }

    boolean isInvalidPid() {
        return this.invalidPid;
    }

    void setPidObjectNull() {
        this._pid = null;
    }

    void seDKAttrDefICM(DKAttrDefICM attr) {
        this.attr = attr;
    }

    public WCDateFormat getDateFormats() {
        return this.wcDateFormat;
    }

    public void setDateFormats(WCDateFormat wcDateFormat) {
        this.wcDateFormat = wcDateFormat;
    }

    public boolean containsItemType(String itemTypeName) {
        boolean doesContain;
        block3: {
            doesContain = false;
            try {
                if (!this.isFolder() || this._itemList == null) break block3;
                Enumeration<CMItem> enumFolderItems = this._itemList.elements();
                while (enumFolderItems.hasMoreElements()) {
                    CMItem currentItem = enumFolderItems.nextElement();
                    if (!currentItem.getEntityName().equals(itemTypeName)) continue;
                    doesContain = true;
                    break;
                }
            }
            catch (Exception e) {
                doesContain = false;
            }
        }
        return doesContain;
    }

    public HashSet<String> getKnownFolderedEntities() {
        if (this._knownFolderedEntities == null) {
            this._knownFolderedEntities = new HashSet(1);
        }
        return this._knownFolderedEntities;
    }

    public void setKnownFolderedEntities(HashSet folderedEntities) {
        this._knownFolderedEntities = folderedEntities;
    }

    public DKWorkPackageICM getWorkPackage() {
        return this.workPackage;
    }

    public void setWorkPackage(DKWorkPackageICM workPackage) {
        this.workPackage = workPackage;
    }

    public void zeroVersionInPid() {
        if (this._pid == null) {
            return;
        }
        ((DKPidICM)this._pid).setVersionNumber("0");
    }

    public boolean hasBookmarks() {
        return this.hasBookmarks;
    }

    public void setHasBookmarks(boolean hasBookmarks) {
        this.hasBookmarks = hasBookmarks;
    }

    private void _sortRetrievedParts() throws Exception {
        DKParts f;
        this._contentList = new Vector();
        this._annotationList = new Vector();
        this._noteLogList = new Vector();
        for (int i = 1; i <= this._ddo.dataCount(); ++i) {
            Object obj = this._ddo.getData((short)i);
            if (obj == null) continue;
            String dataName = this._ddo.getDataName((short)i);
            if (obj instanceof DKParts || obj instanceof DKDDO || !(obj instanceof dkXDO)) continue;
            CMObject dataObj = new CMObject((dkXDO)obj);
            this._contentList.addElement(dataObj);
        }
        short data_id = this._ddo.dataId("DKParts");
        if (data_id != 0 && (f = (DKParts)this._ddo.getData(data_id)) != null) {
            if (!this._partsRetrieved && 0 != f.cardinality()) {
                this._connection.getDatastore().retrieveObjects((dkCollection)f, 1);
            }
            dkIterator iter = f.createIterator();
            while (iter.more()) {
                CMObject dataObj;
                dkXDO pXDO = (dkXDO)iter.next();
                int affiliatedType = pXDO.getAffiliatedType();
                if (affiliatedType == 0 && pXDO instanceof DKLobICM) {
                    DKRetrieveOptionsICM retrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this._connection.getDatastore());
                    retrieveOptions.behaviorIgnoreNoneFoundError(true);
                    retrieveOptions.baseAttributes(true);
                    ((DKDatastoreICM)pXDO.getDatastore()).retrieveObject((dkDataObject)pXDO, retrieveOptions.dkNVPair());
                    affiliatedType = pXDO.getAffiliatedType();
                }
                if (affiliatedType == 8) {
                    dataObj = new CMObject(pXDO);
                    this._annotationList.addElement(dataObj);
                    continue;
                }
                if (affiliatedType == 64) {
                    CMObject noteDataObj = new CMObject(pXDO);
                    this._noteLogList.addElement(noteDataObj);
                    continue;
                }
                dataObj = new CMObject(pXDO);
                this._contentList.addElement(dataObj);
            }
        }
        if (this._ddo instanceof dkXDO) {
            CMObject dataObj = new CMObject((dkXDO)this._ddo);
            this._contentList.addElement(dataObj);
        }
    }

    private void _retrieveAndSortParts() throws Exception {
        if (!this._partsRetrieved) {
            int options = 32;
            this._ddo.getDatastore().retrieveObject((dkDataObject)this._ddo, options);
            if (this.getItemState() != ITEM_STATE_UPDATED) {
                this.setItemState(ITEM_STATE_RETRIEVED);
            }
            this._partsRetrieved = true;
        }
        this._sortRetrievedParts();
    }

    public void lock() throws Exception {
        dkDatastoreExt dsExt = (dkDatastoreExt)this._connection.getDatastore().getExtension("DATASTORE_EXTENSION");
        dsExt.checkOut((dkDataObject)this._ddo);
    }

    public boolean isLocked() throws Exception {
        dkDatastoreExt dsExt = (dkDatastoreExt)this._connection.getDatastore().getExtension("DATASTORE_EXTENSION");
        return dsExt.isCheckedOut((dkDataObject)this._ddo);
    }

    public void unlock() throws Exception {
        dkDatastoreExt dsExt = (dkDatastoreExt)this._connection.getDatastore().getExtension("DATASTORE_EXTENSION");
        dsExt.unlockCheckedOut((dkDataObject)this._ddo);
    }

    public CMObject[] getNoteLogs() throws Exception {
        Vector notelogList = this.getNoteLogList();
        Object[] notelogs = new CMObject[notelogList.size()];
        notelogList.copyInto(notelogs);
        return notelogs;
    }

    public CMObject getAnnotation(int partNum) throws Exception {
        Vector annotationList = this.getAnnotationList();
        return (CMObject)annotationList.get(partNum);
    }

    public void updateAnnotation(int index, CMObject annotation, boolean newVersion) throws Exception {
        this._retrieveAndSortParts();
        CMObject oldAnnot = (CMObject)this._annotationList.elementAt(index);
        DKPid partPid = oldAnnot.getXDO().getPidObject();
        this._updateICMPart(partPid, annotation, newVersion);
        this._annotationList.setElementAt(annotation, index);
    }

    public void updateContent(int index, CMObject content, boolean newVersion) throws Exception {
        this._retrieveAndSortParts();
        CMObject oldContent = (CMObject)this._contentList.elementAt(index);
        DKPid partPid = oldContent.getXDO().getPidObject();
        this._updateICMPart(partPid, content, newVersion);
        this._contentList.setElementAt(content, index);
    }

    public void addAnnotation(CMObject object) throws Exception {
        DKLobICM xdo = this._addICMPart("ICMANNOTATION", object);
        object.setXDO((dkXDO)xdo);
    }

    public void addNoteLog(CMObject object) throws Exception {
        DKLobICM xdo = this._addICMPart("ICMNOTELOG", object);
        object.setXDO((dkXDO)xdo);
    }

    private final DKLobICM _addICMPart(String partType, CMObject data) throws Exception {
        DKDDO ddo = this._ddo;
        data.getXDO().setDatastore(ddo.getDatastore());
        DKLobICM xdo = this._createLobICM(ddo, partType, data);
        xdo.setMimeType(data.getMimeType());
        short dataId = ddo.dataId("ATTR", "DKParts");
        DKParts parts = (DKParts)ddo.getData(dataId);
        parts.addElement((Object)xdo);
        dkDatastore datastore = ddo.getDatastore();
        datastore.updateObject((dkDataObject)ddo, 0);
        return xdo;
    }

    private final DKLobICM _createLobICM(DKDDO ddo, String partType, CMObject data) throws Exception {
        String orifile;
        InputStream is;
        dkDatastoreIntICM dsICM = (dkDatastoreIntICM)ddo.getDatastore();
        DKLobICM xdo = (DKLobICM)dsICM.createDDO(partType, 13);
        DKParts parts = this._createPartsCollectionIfNotExists(ddo);
        xdo.setPartNumber(parts.cardinality() + 1);
        if (xdo instanceof DKTextICM && data.getCCSID() != -1) {
            ((DKTextICM)xdo).setCCSID(data.getCCSID());
        }
        if ((is = data.getDataStream()) != null) {
            DKNVPair[] dknv = new DKNVPair[]{new DKNVPair("STREAM", (Object)is), new DKNVPair("LENGTH", (Object)new Long(data.getSize()))};
            xdo.setAddLocation(dknv);
            orifile = data.getOriginalFileName();
            if (orifile != null) {
                xdo.setOrgFileName(orifile);
            }
        } else {
            byte[] byteArrayData = data.getByteArrayData();
            if (byteArrayData != null && byteArrayData.length > 0) {
                orifile = data.getOriginalFileName();
                if (orifile != null) {
                    xdo.setOrgFileName(orifile);
                }
                xdo.setContent(byteArrayData);
            }
        }
        if (partType.equals("ICMANNOTATION")) {
            xdo.setAffiliatedType(8);
        } else if (partType.equals("ICMNOTELOG")) {
            xdo.setAffiliatedType(64);
        } else {
            xdo.setAffiliatedType(128);
        }
        DKPid ddopid = ddo.getPidObject();
        String primaryId = ddopid.getPrimaryId();
        DKPid xdopid = xdo.getPidObject();
        xdopid.setPrimaryId(primaryId);
        xdo.setPidObject(xdopid);
        return xdo;
    }

    private DKParts _createPartsCollectionIfNotExists(DKDDO ddo) throws DKUsageError {
        DKParts partColl = null;
        short dataId = ddo.dataId("ATTR", "DKParts");
        if (dataId == 0) {
            dataId = ddo.addData("ATTR", "DKParts");
            ddo.addDataProperty(dataId, "type", (Object)new Short(1073));
            partColl = new DKParts();
            ddo.setData(dataId, (Object)partColl);
        } else {
            partColl = (DKParts)ddo.getData(dataId);
            if (partColl == null) {
                partColl = new DKParts();
                ddo.setData(dataId, (Object)partColl);
            }
        }
        return partColl;
    }

    private void _updateICMPart(DKPid partPid, CMObject data, boolean newversion) throws Exception {
        DKDDO ddoObj = this._ddo;
        data.getXDO().setDatastore(ddoObj.getDatastore());
        short data_id = ddoObj.dataId("DKParts");
        DKParts parts = (DKParts)ddoObj.getData(data_id);
        DKSequentialIterator iter = (DKSequentialIterator)parts.createIterator();
        DKLobICM part = null;
        while (iter.more()) {
            DKTextICM textPart;
            part = (DKLobICM)iter.next();
            DKPid thispid = part.getPidObject();
            if (!thispid.equals((Object)partPid)) continue;
            InputStream is = data.getDataStream();
            if (is != null) {
                DKNVPair[] dknv = new DKNVPair[]{new DKNVPair("STREAM", (Object)is), new DKNVPair("LENGTH", (Object)new Long(data.getSize()))};
                part.setUpdateLocation(dknv);
            } else if (data.getByteArrayData() != null) {
                part.setContent(data.getByteArrayData());
            }
            part.setMimeType(data.getMimeType());
            if (part instanceof DKTextICM && (textPart = (DKTextICM)part).getCCSID() != data.getCCSID()) {
                textPart.setCCSID(data.getCCSID());
            }
            part.setContentChanged(true);
            break;
        }
        if (newversion) {
            part.setNewVersion(newversion);
            ddoObj.update(2);
        } else {
            ddoObj.update();
        }
    }

    private void _deleteICMPart(DKPid pid) throws Exception {
        DKDDO ddoObj = this._ddo;
        short data_id = ddoObj.dataId("DKParts");
        DKParts parts = (DKParts)ddoObj.getData(data_id);
        DKSequentialIterator iter = (DKSequentialIterator)parts.createIterator();
        while (iter.more()) {
            DKLobICM part = (DKLobICM)iter.next();
            DKPid thispid = part.getPidObject();
            if (!thispid.equals((Object)pid)) continue;
            parts.removeElementAt((dkIterator)iter);
            break;
        }
        ddoObj.update();
    }

    static class AttributeComparator
    implements Comparator {
        String _server;
        String _entity;
        String _attribute;
        int _attrIndex;
        boolean _ascending;
        String _pattern;
        Collator _nlsCollator = Collator.getInstance();
        HttpServletRequest request;

        AttributeComparator(HttpServletRequest request, String attribute, boolean ascending) {
            this._server = null;
            this._entity = null;
            this._attribute = attribute;
            this._attrIndex = -1;
            this._ascending = ascending;
            this.request = request;
        }

        AttributeComparator(String server, String entity, String attribute, boolean ascending) {
            this._server = server;
            this._entity = entity;
            this._attribute = attribute;
            this._attrIndex = -1;
            this._ascending = ascending;
        }

        public int compare(Object o1, Object o2) {
            String methodName = "compare";
            try {
                CMItem item1 = (CMItem)o1;
                CMItem item2 = (CMItem)o2;
                if (this._entity != null) {
                    if (!item1.getServerName().equals(this._server) && !item2.getServerName().equals(this._server)) {
                        return 0;
                    }
                    if (!item1.getEntityName().equals(this._entity) && !item2.getEntityName().equals(this._entity)) {
                        return 0;
                    }
                    if (!item1.getEntityName().equals(this._entity)) {
                        return -1;
                    }
                    if (!item2.getEntityName().equals(this._entity)) {
                        return 1;
                    }
                }
                if (this._attrIndex < 0) {
                    String[] attrNames = item1.getAttrName();
                    for (int i = 0; this._attrIndex == -1 && i < attrNames.length; ++i) {
                        if (!attrNames[i].equals(this._attribute)) continue;
                        this._attrIndex = i;
                    }
                    if (this._attrIndex < 0) {
                        return 0;
                    }
                }
                String temp1 = item1.getAttrValue(this._attrIndex);
                String temp2 = item2.getAttrValue(this._attrIndex);
                short type1 = item1.getAttrType(this._attribute);
                short type2 = item2.getAttrType(this._attribute);
                Object attr1 = this.attributeValueAsObject(temp1, type1);
                Object attr2 = this.attributeValueAsObject(temp2, type2);
                if (this._ascending) {
                    return this.compareValues(attr1, attr2);
                }
                return -this.compareValues(attr1, attr2);
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                return 0;
            }
        }

        public Object attributeValueAsObject(String value, short type) {
            if (type == 2) {
                return value.trim();
            }
            if (type == 1) {
                return value.trim();
            }
            if (type == 7) {
                try {
                    Date sqlDate = Date.valueOf(value);
                    return new DisplayableDate(sqlDate.getTime(), DateFormat.getDateInstance(3, Locale.getDefault()));
                }
                catch (Exception e) {
                    return value;
                }
            }
            if (type == 8) {
                try {
                    Time sqlTime = Time.valueOf(value.replace('.', ':'));
                    return new DisplayableTime(sqlTime.getTime(), DateFormat.getTimeInstance(2, Locale.getDefault()));
                }
                catch (Exception e) {
                    return value;
                }
            }
            if (type == 3) {
                try {
                    return this.formatForCurrentLocale(value);
                }
                catch (ParseException e) {
                    try {
                        return Short.valueOf(value);
                    }
                    catch (NumberFormatException ex) {
                        return value;
                    }
                }
            }
            if (type == 4) {
                try {
                    return this.formatForCurrentLocale(value);
                }
                catch (ParseException e) {
                    try {
                        return Long.valueOf(value);
                    }
                    catch (NumberFormatException ex) {
                        return value;
                    }
                }
            }
            if (type == 5) {
                try {
                    return this.formatForCurrentLocale(value);
                }
                catch (ParseException e) {
                    try {
                        return Float.valueOf(value);
                    }
                    catch (NumberFormatException ex) {
                        return value;
                    }
                }
            }
            if (type == 10) {
                try {
                    return this.formatForCurrentLocale(value);
                }
                catch (ParseException e) {
                    try {
                        return Double.valueOf(value);
                    }
                    catch (NumberFormatException ex) {
                        return value;
                    }
                }
            }
            if (type == 6) {
                try {
                    return this.formatForCurrentLocale(value);
                }
                catch (ParseException e) {
                    try {
                        return Double.valueOf(value);
                    }
                    catch (NumberFormatException ex) {
                        return value;
                    }
                }
            }
            return value;
        }

        Object formatForCurrentLocale(String value) throws ParseException {
            ParsePosition pos;
            NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
            Number num = nf.parse(value, pos = new ParsePosition(0));
            if (num == null || pos.getIndex() < value.length()) {
                throw new ParseException(value, pos.getIndex());
            }
            return num;
        }

        private int compareValues(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof String && o2 instanceof String) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                int result = this._nlsCollator.compare(s1, s2);
                if (result < 0) {
                    return -1;
                }
                if (result > 0) {
                    return 1;
                }
                return 0;
            }
            if (o1 instanceof Number && o2 instanceof Number) {
                Number n2;
                double d2;
                Number n1 = (Number)o1;
                double d1 = n1.doubleValue();
                if (d1 < (d2 = (n2 = (Number)o2).doubleValue())) {
                    return -1;
                }
                if (d1 > d2) {
                    return 1;
                }
                return 0;
            }
            if (o1 instanceof java.util.Date && o2 instanceof java.util.Date) {
                java.util.Date d2;
                long n2;
                java.util.Date d1 = (java.util.Date)o1;
                long n1 = d1.getTime();
                if (n1 < (n2 = (d2 = (java.util.Date)o2).getTime())) {
                    return -1;
                }
                if (n1 > n2) {
                    return 1;
                }
                return 0;
            }
            if (o1 instanceof Boolean & o2 instanceof Boolean) {
                Boolean bool2;
                boolean b2;
                Boolean bool1 = (Boolean)o1;
                boolean b1 = bool1;
                if (b1 == (b2 = (bool2 = (Boolean)o2).booleanValue())) {
                    return 0;
                }
                if (b1) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        class DisplayableTime
        extends java.util.Date {
            DateFormat timeFormat;

            public DisplayableTime(long time, DateFormat format) {
                super(time);
                this.timeFormat = format;
            }

            public String toString() {
                return this.timeFormat.format(this);
            }
        }

        class DisplayableDate
        extends java.util.Date {
            DateFormat dateFormat;

            public DisplayableDate(long time, DateFormat format) {
                super(time);
                this.dateFormat = format;
            }

            public String toString() {
                return this.dateFormat.format(this);
            }
        }
    }
}

