/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.beans.cm;

import com.ibm.ecm.beans.cm.CMAttributeDef;
import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKAttrGroupDefICM;
import com.ibm.mm.sdk.common.DKCommonPrivilege;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeViewDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKItemTypeDefICM;
import com.ibm.mm.sdk.common.DKItemTypeRelationDefICM;
import com.ibm.mm.sdk.common.DKItemTypeViewDefICM;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastore;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkEntityDef;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.server.DKDatastoreExtICM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class CMEntity {
    CMConnection _connection;
    dkEntityDef _entityDef;
    CMAttributeDef[] _attributeDefs;
    DKCommonPrivilege _privilege;

    public CMEntity(CMConnection connection, dkEntityDef entityDef) {
        this._connection = connection;
        this._entityDef = entityDef;
    }

    public String getName() {
        return this._entityDef.getName();
    }

    public String getDKDescription() throws Exception {
        return this._entityDef.getDescription();
    }

    public String getDisplayName() {
        String description = null;
        try {
            description = this._entityDef.getDescription();
        }
        catch (Exception e) {
            description = this._entityDef.getName();
        }
        return description;
    }

    public boolean isRoot() {
        if (this._entityDef != null && this._entityDef instanceof DKComponentTypeDefICM) {
            return ((DKComponentTypeDefICM)this._entityDef).isRoot();
        }
        return true;
    }

    public boolean isHierarchical() {
        return this._entityDef != null && this._entityDef instanceof DKItemTypeDefICM && ((DKItemTypeDefICM)this._entityDef).isHierarchical();
    }

    public boolean isForFoldersOnly() {
        return this._entityDef != null && this._entityDef instanceof DKItemTypeDefICM && ((DKItemTypeDefICM)this._entityDef).foldersOnly();
    }

    public boolean isNotForFolders() {
        return this._entityDef != null && this._entityDef instanceof DKItemTypeDefICM && ((DKItemTypeDefICM)this._entityDef).isHierarchical() && ((DKItemTypeDefICM)this._entityDef).foldersNotAllowed();
    }

    public boolean isTextSearchable() {
        return this._entityDef != null && this._entityDef.isTextSearchable();
    }

    public boolean isView() {
        return this._entityDef != null && this._entityDef instanceof DKItemTypeViewDefICM;
    }

    public String[] getPartTypes() throws Exception {
        if (this._entityDef instanceof DKItemTypeDefICM) {
            if (((DKItemTypeDefICM)this._entityDef).getClassification() != 2) {
                return new String[0];
            }
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)this._entityDef.getDatastore().datastoreDef();
            DKItemTypeDefICM itemtype = (DKItemTypeDefICM)this._entityDef;
            dkCollection relations = itemtype.listItemTypeRelations();
            dkIterator relIter = relations.createIterator();
            DKItemTypeDefICM pEnt = null;
            ArrayList<String> partTypes = new ArrayList<String>();
            int i = 0;
            while (relIter.more()) {
                DKItemTypeRelationDefICM relation = (DKItemTypeRelationDefICM)relIter.next();
                int targettypeid = relation.getTargetItemTypeID();
                pEnt = (DKItemTypeDefICM)dsDefICM.retrieveEntity(targettypeid);
                if (pEnt != null) {
                    partTypes.add(pEnt.getName());
                }
                ++i;
            }
            return partTypes.toArray(new String[0]);
        }
        if (this._entityDef != null && this._entityDef instanceof DKItemTypeViewDefICM) {
            String baseentity = ((DKItemTypeViewDefICM)this._entityDef).getItemTypeName();
            return this._connection.getEntity(baseentity).getPartTypes();
        }
        return new String[0];
    }

    public int getClassification() {
        int classification = -1;
        if (this._entityDef != null) {
            if (this._entityDef instanceof DKItemTypeDefICM) {
                classification = ((DKItemTypeDefICM)this._entityDef).getClassification();
            } else if (this._entityDef instanceof DKComponentTypeViewDefICM) {
                classification = ((DKItemTypeViewDefICM)this._entityDef).getClassification();
            }
        }
        return classification;
    }

    public CMEntity[] getSubEntities() throws Exception {
        if (!this._entityDef.hasSubEntities()) {
            return new CMEntity[0];
        }
        dkCollection collection = this._entityDef.listSubEntities();
        dkIterator iterator = collection.createIterator();
        CMEntity[] subEntities = new CMEntity[collection.cardinality()];
        int i = 0;
        while (iterator.more()) {
            dkEntityDef entity = (dkEntityDef)iterator.next();
            subEntities[i] = new CMEntity(this._connection, entity);
            ++i;
        }
        return subEntities;
    }

    public CMAttributeDef[] getAttributes() throws Exception {
        return this.getAttributes(false);
    }

    public CMAttributeDef[] getAttributes(boolean includeChildComponents) throws Exception {
        if (this._attributeDefs == null) {
            if (includeChildComponents) {
                AttrDefNode root = this._extractICMAttrDefs(this._entityDef);
                root.orderChildren();
                this._attributeDefs = new CMAttributeDef[root.regulars.size()];
                for (int i = 0; i < root.regulars.size(); ++i) {
                    this._attributeDefs[i] = (CMAttributeDef)root.regulars.get(i);
                }
            } else {
                dkCollection gColl;
                Vector<CMAttributeDef> attrs = null;
                DKComponentTypeDefICM compDef = (DKComponentTypeDefICM)this._entityDef;
                dkCollection coll = compDef.listAllAttributes();
                attrs = new Vector<CMAttributeDef>();
                if (coll != null) {
                    attrs.ensureCapacity(coll.cardinality());
                    dkIterator iter = coll.createIterator();
                    while (iter.more()) {
                        DKAttrDefICM attr = (DKAttrDefICM)iter.next();
                        CMAttributeDef cmbAttr = new CMAttributeDef(this._connection, attr);
                        cmbAttr.setSequence(attr.getSequenceNo());
                        attrs.add(cmbAttr);
                    }
                }
                if ((gColl = compDef.listAttrGroups(99)) != null) {
                    DKAttrGroupDefICM aAttrGroup = null;
                    dkIterator gIter = gColl.createIterator();
                    attrs.ensureCapacity(attrs.size() + gColl.cardinality());
                    while (gIter.more()) {
                        aAttrGroup = (DKAttrGroupDefICM)gIter.next();
                        if (!aAttrGroup.isReferenceAttributeGroup()) continue;
                        short index = (short)aAttrGroup.getReferenceSequenceNumber();
                        DKAttrDefICM refAttr = new DKAttrDefICM((dkDatastore)this._connection.getDatastore());
                        refAttr.setType((short)48);
                        refAttr.setName(aAttrGroup.getName());
                        String langCode = this._connection.getLanguageCode();
                        String description = CMEntity.getDKDescription(aAttrGroup, langCode);
                        refAttr.setDescription(description);
                        CMAttributeDef cmbAttr = new CMAttributeDef(this._connection, refAttr);
                        cmbAttr.setSequence(index);
                        cmbAttr.setReferenceAttr(true);
                        attrs.add(cmbAttr);
                    }
                }
                Collections.sort(attrs, new AttrDefComparator());
                this._attributeDefs = new CMAttributeDef[attrs.size()];
                attrs.toArray(this._attributeDefs);
                if (this._attributeDefs == null) {
                    this._attributeDefs = new CMAttributeDef[0];
                }
            }
        }
        return this._attributeDefs;
    }

    private AttrDefNode _extractICMAttrDefs(dkEntityDef def) throws Exception {
        dkCollection gColl;
        DKComponentTypeDefICM deficm;
        dkCollection coll;
        dkCollection dCol;
        AttrDefNode node = new AttrDefNode();
        if (def.hasSubEntities() && (dCol = def.listSubEntities()) != null) {
            dkIterator dIter = dCol.createIterator();
            while (dIter.more()) {
                DKComponentTypeDefICM subEntDef = (DKComponentTypeDefICM)dIter.next();
                String nonDisplayName = subEntDef.getName();
                String langCode = this._connection.getLanguageCode();
                String displayName = subEntDef.getDescription(langCode);
                DKAttrDefICM ccAttr = new DKAttrDefICM((dkDatastore)this._connection.getDatastore());
                ccAttr.setType((short)48);
                ccAttr.setName(nonDisplayName);
                ccAttr.setDescription(displayName);
                ccAttr.setId((short)subEntDef.getIntId());
                CMAttributeDef cmbAttr = new CMAttributeDef(this._connection, ccAttr);
                AttrDefNode subnode = this._extractICMAttrDefs((dkEntityDef)subEntDef);
                node.children.add(cmbAttr);
                node.nodes.add(subnode);
            }
        }
        if ((coll = (deficm = (DKComponentTypeDefICM)def).listAllAttributes()) != null) {
            dkIterator iter = coll.createIterator();
            DKAttrDefICM attr = null;
            while (iter.more()) {
                attr = (DKAttrDefICM)iter.next();
                CMAttributeDef cmbAttr = new CMAttributeDef(this._connection, attr);
                short index = attr.getSequenceNo();
                cmbAttr.setSequence(index);
                node.regulars.add(cmbAttr);
            }
        }
        if ((gColl = deficm.listAttrGroups(99)) != null) {
            DKAttrGroupDefICM aAttrGroup = null;
            dkIterator gIter = gColl.createIterator();
            while (gIter.more()) {
                aAttrGroup = (DKAttrGroupDefICM)gIter.next();
                if (!aAttrGroup.isReferenceAttributeGroup()) continue;
                short index = (short)aAttrGroup.getReferenceSequenceNumber();
                DKAttrDefICM refAttr = new DKAttrDefICM((dkDatastore)this._connection.getDatastore());
                refAttr.setType((short)48);
                refAttr.setName(aAttrGroup.getName());
                String langCode = this._connection.getLanguageCode();
                String description = aAttrGroup.getDescription(langCode);
                refAttr.setDescription(description);
                CMAttributeDef cmbAttr = new CMAttributeDef(this._connection, refAttr);
                cmbAttr.setReferenceAttr(true);
                cmbAttr.setSequence(index);
                node.regulars.add(cmbAttr);
            }
        }
        return node;
    }

    private static String getDKDescription(DKAttrGroupDefICM attrGroupDef, String langCode) throws Exception {
        String description = null;
        dkDatastore ds = attrGroupDef.getDatastore();
        if (ds instanceof dkDatastoreIntICM) {
            if (langCode.equalsIgnoreCase(((dkDatastoreIntICM)ds).languageCode())) {
                description = attrGroupDef.getDescription();
            } else {
                description = attrGroupDef.getDescription(langCode);
                if (description == null || description.length() == 0) {
                    description = attrGroupDef.getDescription();
                }
            }
        } else {
            description = attrGroupDef.getDescription();
        }
        return description;
    }

    public short getPartTypeVersionPolicy(String partType) throws Exception {
        short policy = 0;
        if (this._entityDef != null && this._entityDef instanceof DKItemTypeDefICM && partType != null) {
            dkCollection relations = ((DKItemTypeDefICM)this._entityDef).listItemTypeRelations();
            dkIterator iter = relations.createIterator();
            while (iter.more()) {
                DKItemTypeRelationDefICM relation = (DKItemTypeRelationDefICM)iter.next();
                if (relation == null || !partType.equals(relation.getTargetItemTypeName())) continue;
                policy = relation.getVersionControl();
                break;
            }
        }
        return policy;
    }

    public short getVersionControl() throws Exception {
        if (this._entityDef != null && this._entityDef instanceof DKItemTypeDefICM) {
            return ((DKItemTypeDefICM)this._entityDef).getVersionControl();
        }
        if (this._entityDef != null && this._entityDef instanceof DKItemTypeViewDefICM) {
            return ((DKItemTypeViewDefICM)this._entityDef).getVersionControl();
        }
        return 0;
    }

    public boolean isItemTypeLevelACL() {
        try {
            if (this._entityDef instanceof DKItemTypeDefICM) {
                return CMBaseUtil.isItemTypeLevelACL(this._entityDef);
            }
            return CMBaseUtil.isItemTypeLevelACL(((DKItemTypeViewDefICM)this._entityDef).getParent());
        }
        catch (Exception e) {
            Logger.logError((Object)this, "isItemTypeLevelACL", "Failed to determine if the item type supports item level security", (Throwable)e);
            return false;
        }
    }

    public DKCommonPrivilege getPrivilege() throws Exception {
        if (this._privilege == null) {
            DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)this._entityDef;
            DKDDO itemTypePrivDDO = CMBaseUtil.getDDO4ICMItemTypePrivilege(itemType);
            DKDatastoreExtICM dsExt = (DKDatastoreExtICM)this._connection.getDatastore().getExtension("DATASTORE_EXTENSION");
            this._privilege = dsExt.getCommonItemPrivilege((dkDataObject)itemTypePrivDDO);
        }
        return this._privilege;
    }

    public DKComponentTypeDefICM getItemType() {
        return (DKComponentTypeDefICM)this._entityDef;
    }

    public short getItemTypeClassification() {
        short itemTypeClassification = CMBaseUtil.getClassification((DKComponentTypeDefICM)this._entityDef);
        return itemTypeClassification;
    }

    public boolean getHasAnnotationpart() throws Exception {
        return CMBaseUtil.containsPartType(this._connection.getDatastore(), (DKComponentTypeDefICM)this._entityDef, "ICMANNOTATION");
    }

    public boolean getHasItemTypeACL() throws Exception {
        boolean hasItemTypeACL = CMBaseUtil.isItemTypeLevelACL((dkEntityDef)((DKComponentTypeDefICM)this._entityDef));
        return hasItemTypeACL;
    }

    public boolean getIsHierarchical() {
        boolean isHierarchical = false;
        if (this._entityDef instanceof DKItemTypeDefICM) {
            isHierarchical = ((DKItemTypeDefICM)this._entityDef).isHierarchical();
        }
        return isHierarchical;
    }

    class AttrDefNode {
        Vector regulars = new Vector();
        Vector children = new Vector();
        Vector nodes = new Vector();
        short leftMostSequence = (short)-1;

        AttrDefNode() {
        }

        short checkDupe(short seq) {
            if (seq == -1) {
                return (short)(this.regulars.size() + 1);
            }
            for (int i = 0; i < this.regulars.size(); ++i) {
                if (((CMAttributeDef)this.regulars.get(i)).getSequence() != seq) continue;
                return (short)(this.regulars.size() + 1);
            }
            return seq;
        }

        void orderChildren() {
            if (this.children.size() == 0 && this.regulars.size() > 0) {
                this.leftMostSequence = ((CMAttributeDef)this.regulars.firstElement()).getSequence();
                Collections.sort(this.regulars, new AttrDefComparator());
            }
            if (this.children.size() == 0) {
                return;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                AttrDefNode node = (AttrDefNode)this.nodes.get(i);
                node.orderChildren();
                short seq = this.checkDupe(node.leftMostSequence);
                CMAttributeDef attr = (CMAttributeDef)this.children.get(i);
                attr.setSequence(seq);
                this.regulars.addElement(attr);
            }
            Collections.sort(this.regulars, new AttrDefComparator());
            this.leftMostSequence = ((CMAttributeDef)this.regulars.firstElement()).getSequence();
        }
    }

    private class AttrDefComparator
    implements Comparator {
        public short LESS_THAN = (short)-1;
        public short EQUAL = 0;
        public short GREATER_THAN = 1;

        private AttrDefComparator() {
        }

        public int compare(Object o1, Object o2) {
            CMAttributeDef attr1 = (CMAttributeDef)o1;
            CMAttributeDef attr2 = (CMAttributeDef)o2;
            if (attr1.getSequence() > attr2.getSequence()) {
                return this.GREATER_THAN;
            }
            if (attr1.getSequence() == attr2.getSequence()) {
                return this.EQUAL;
            }
            return this.LESS_THAN;
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass().getName().equals(this.getClass().getName());
        }
    }
}

