/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.beans.cm;

import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMObject;
import com.ibm.ecm.beans.cm.CMQueryService;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKConfigurationMgmtICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKDate;
import com.ibm.mm.sdk.common.DKFolder;
import com.ibm.mm.sdk.common.DKItemTypeDefICM;
import com.ibm.mm.sdk.common.DKItemTypeRelationDefICM;
import com.ibm.mm.sdk.common.DKItemTypeViewDefICM;
import com.ibm.mm.sdk.common.DKLobICM;
import com.ibm.mm.sdk.common.DKNVPair;
import com.ibm.mm.sdk.common.DKParts;
import com.ibm.mm.sdk.common.DKPid;
import com.ibm.mm.sdk.common.DKRMConfigurationMgmtICM;
import com.ibm.mm.sdk.common.DKResults;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSMSCollectionDefICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.DKSequentialIterator;
import com.ibm.mm.sdk.common.DKStorageManageInfoICM;
import com.ibm.mm.sdk.common.DKTextICM;
import com.ibm.mm.sdk.common.DKTime;
import com.ibm.mm.sdk.common.DKTimestamp;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastore;
import com.ibm.mm.sdk.common.dkDatastoreDef;
import com.ibm.mm.sdk.common.dkDatastoreExt;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkEntityDef;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.common.dkServerDef;
import com.ibm.mm.sdk.common.dkXDO;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.auth.callback.WSCallbackHandlerImpl;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionBindingEvent;

public class CMConnection {
    private static final String RECORD_TYPE_CONTENT = "Content";
    private static final String RECORD_TYPE_PLAIN = "Plain";
    private boolean allItemTypesSortNotSupported = false;
    private DKDatastoreICM datastore;
    private String userid;
    private String languageCode;
    private String[] _entityNames;
    private CMEntity[] _entities;
    boolean _updateItemFlag;
    private String dataStoreRecordType = null;

    public static synchronized String[] listDataSources() throws Exception {
        String[] serverNames = null;
        DKDatastoreICM datastore = new DKDatastoreICM();
        dkCollection collection = datastore.listDataSources();
        serverNames = new String[collection.cardinality()];
        dkIterator iterator = collection.createIterator();
        for (int i = 0; i < serverNames.length; ++i) {
            dkServerDef serverDef = (dkServerDef)iterator.next();
            serverNames[i] = serverDef.getName();
        }
        return serverNames;
    }

    public static CMConnection login(String serverName, String userid, String password, String connectString) throws Exception {
        return CMConnection._connect(serverName, userid, password, null, connectString);
    }

    public static CMConnection changePassword(String serverName, String userid, String password, String newPassword, String connectString) throws Exception {
        return CMConnection._connect(serverName, userid, password, newPassword, connectString);
    }

    private static CMConnection _connect(String serverName, String userid, String password, String newPassword, String connectString) throws Exception {
        if (newPassword != null && newPassword.length() != 0) {
            connectString = connectString != null && connectString.length() > 0 ? connectString.concat(";NPWD=" + newPassword) : new String("NPWD=" + newPassword);
        }
        if (connectString == null) {
            connectString = "";
        }
        DKDatastoreICM datastore = new DKDatastoreICM();
        datastore.connect(serverName, userid, password, connectString);
        CMConnection connection = new CMConnection(datastore, userid, datastore.languageCode());
        return connection;
    }

    public static CMConnection trustedLogin(String serverName, HttpServletRequest request) throws Exception {
        String method = "trustedLogin";
        String userid = "";
        String principal = WSSubject.getCallerPrincipal();
        if (principal != null && principal.length() > 0) {
            userid = principal;
        } else {
            userid = null;
            String ltpaTokenCookie = CMConnection.getLtpaToken(request);
            if (ltpaTokenCookie == null) {
                throw new AuthenticationException("LTPA token cookie not found.");
            }
            byte[] ltpaToken = WSSecurityHelper.convertCookieStringToBytes((String)ltpaTokenCookie);
            LoginContext lc = new LoginContext("WSLogin", (CallbackHandler)new WSCallbackHandlerImpl(ltpaToken));
            String name = null;
            lc.login();
            Subject s = lc.getSubject();
            Set<WSPrincipal> ps = s.getPrincipals(WSPrincipal.class);
            if (ps.isEmpty()) {
                throw new AuthenticationException("LTPA token validation failed.  Login succeeded using WSLogin login module but no Principal was found in the Subject.");
            }
            Iterator<WSPrincipal> it = ps.iterator();
            if (it.hasNext()) {
                WSPrincipal p = it.next();
                name = p.getName();
            }
            if (name == null) {
                throw new AuthenticationException("LTPA token validation failed.  Login succeeded using WSLogin login module, but the name in the first Principal of the Subject is null.");
            }
            name = CMConnection._getNameFromFormat(name);
            if (userid == null) {
                userid = name;
            }
            if (!userid.equals(name)) {
                throw new AuthenticationException("Userid " + userid + " in principal does not match the userid " + name + " requested");
            }
        }
        CMConnection connection = CMConnection._connect(serverName, userid, "", null, null);
        Logger.logDebug(CMConnection.class, method, (ServletRequest)request, "Trusted logon for server " + serverName + "  with userId=" + userid + " successful. Connection object is " + connection);
        return connection;
    }

    private static String getLtpaToken(HttpServletRequest request) {
        int i;
        Cookie[] cookies = request.getCookies();
        String cookievalue = null;
        for (i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals("LtpaToken2")) continue;
            cookievalue = cookies[i].getValue();
            break;
        }
        if (cookievalue == null) {
            for (i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("LtpaToken")) continue;
                cookievalue = cookies[i].getValue();
                break;
            }
        }
        return cookievalue;
    }

    private static String _getNameFromFormat(String userName) {
        StringTokenizer stoken = new StringTokenizer(userName);
        String first = stoken.nextToken("=");
        String second = "";
        if (userName.equals(first)) {
            stoken = new StringTokenizer(userName);
            first = stoken.nextToken("/");
            second = stoken.nextToken("/");
        } else {
            second = stoken.nextToken("=");
            stoken = new StringTokenizer(second);
            second = stoken.nextToken(",");
        }
        return second;
    }

    public CMConnection(DKDatastoreICM datastore, String userid, String languageCode) {
        this.datastore = datastore;
        this.userid = userid;
        this.languageCode = languageCode;
    }

    public String getUserid() {
        return this.userid;
    }

    public DKDatastoreICM getDatastore() {
        return this.datastore;
    }

    public boolean isConnected() {
        return this.datastore.isConnected();
    }

    public void setDataStoreRecordType(String dataStoreRecordType) {
        this.dataStoreRecordType = dataStoreRecordType;
    }

    public String getDataStoreRecordType() {
        if (this.dataStoreRecordType == null) {
            boolean isRecordsManagerEnabled;
            this.dataStoreRecordType = this.datastore == null ? RECORD_TYPE_PLAIN : ((isRecordsManagerEnabled = CMUtil.isRecordsManagerEnabled(this.datastore)) ? RECORD_TYPE_CONTENT : RECORD_TYPE_PLAIN);
        }
        return this.dataStoreRecordType;
    }

    public boolean isRecordsManagerEnabled() {
        String dataStoreRecordType = this.getDataStoreRecordType();
        return dataStoreRecordType != null && dataStoreRecordType.equals(RECORD_TYPE_CONTENT);
    }

    public CMEntity getEntity(String entityName) throws Exception {
        dkEntityDef dkEntity = this._findEntityDef(entityName);
        CMEntity entity = new CMEntity(this, dkEntity);
        return entity;
    }

    public String[] getEntityNames() throws Exception {
        if (this._entityNames == null) {
            Vector<Object> entList = new Vector<Object>();
            DKDatastoreDefICM def = (DKDatastoreDefICM)this.datastore.datastoreDef();
            dkIterator iter = def.listItemTypeViews().createIterator();
            while (iter.more()) {
                DKItemTypeViewDefICM entDef = (DKItemTypeViewDefICM)iter.next();
                if (entDef.getComponentViewId() < 1000) continue;
                entList.addElement(entDef.getName());
            }
            Object[] sp = new String[entList.size()];
            entList.copyInto(sp);
            entList = new Vector(sp.length);
            for (int i = 0; i < sp.length; ++i) {
                if (((String)sp[i]).startsWith("*ICM")) continue;
                entList.addElement(sp[i]);
            }
            this._entityNames = new String[entList.size()];
            entList.copyInto(this._entityNames);
        }
        return this._entityNames;
    }

    public CMEntity[] getEntities() throws Exception {
        if (this._entities == null) {
            String[] names = this.getEntityNames();
            if (names == null) {
                this._entities = new CMEntity[0];
            } else {
                DKDatastoreDefICM def = (DKDatastoreDefICM)this.datastore.datastoreDef();
                dkCollection entityList = def.listEntities();
                ArrayList<CMEntity> entities = new ArrayList<CMEntity>(names.length);
                dkIterator iter = entityList.createIterator();
                block2: while (iter.more()) {
                    dkEntityDef entDef = (dkEntityDef)iter.next();
                    for (int i = 0; i < names.length; ++i) {
                        if (entDef instanceof DKComponentTypeDefICM) {
                            try {
                                if (!entDef.getName().equals(names[i])) continue;
                                entities.add(new CMEntity(this, entDef));
                                continue block2;
                            }
                            catch (Exception e) {
                                continue;
                            }
                        }
                        if (!entDef.getName().equals(names[i])) continue;
                        entities.add(new CMEntity(this, entDef));
                        continue block2;
                    }
                }
                this._entities = entities.toArray(new CMEntity[entities.size()]);
            }
        }
        return this._entities;
    }

    public CMItem retrieveItem(String itemPid, HttpServletRequest request, DKRetrieveOptionsICM options) throws Exception {
        DKDDO ddo = this.datastore.createDDOFromPID(itemPid);
        this.datastore.retrieveObject((dkDataObject)ddo, options.dkNVPair());
        CMItem item = new CMItem(request, this, ddo, null, options.baseAttributes(), options.linksOutbound(), options.partsAttributes());
        return item;
    }

    public CMItem[] getAllVersions(String itemPid, HttpServletRequest request) throws Exception {
        String entName = CMBaseUtil._getEntityName(itemPid);
        DKPid dkpid = CMBaseUtil.makeDKPid(itemPid);
        String itemId = dkpid.getIdString(0);
        String queryString = "/" + entName + "[@ITEMID=\"" + itemId + "\"]";
        CMQueryService privateQuery = new CMQueryService(request, this.datastore);
        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.datastore);
        dkRetrieveOptions.behaviorIgnoreNoneFoundError(true);
        dkRetrieveOptions.baseAttributes(true);
        dkRetrieveOptions.basePropertyAclName(true);
        dkRetrieveOptions.functionVersionLatest(true);
        DKResults dkResults = privateQuery.evaluate(queryString, dkRetrieveOptions.dkNVPair());
        CMSearchResults results = new CMSearchResults(request, this);
        results.newResults(dkResults, true, false, false);
        CMItem[] items = results.getItems();
        return items;
    }

    public void reindexItem(CMItem item, String newItemTypeName, boolean keepInAutoFolder, boolean updateStorageCollection, HttpServletRequest request) throws Exception {
        int options = 0;
        if (keepInAutoFolder) {
            options = 65536;
        }
        DKDDO pDDO = item.getDDO();
        DKDDO newDDO = this._createDDOForItem(item, false, newItemTypeName);
        newDDO.setDatastore((dkDatastore)this.datastore);
        dkDatastoreExt dsExt = (dkDatastoreExt)this.datastore.getExtension("DATASTORE_EXTENSION");
        dsExt.moveObject((dkDataObject)pDDO, (dkDataObject)newDDO, options);
        item.setDDO(newDDO, CMItem.ITEM_STATE_RETRIEVED);
        if (updateStorageCollection) {
            DKItemTypeDefICM newEntity = (DKItemTypeDefICM)this.getEntity((String)newItemTypeName)._entityDef;
            short classification = newEntity.getClassification();
            if (classification == 1) {
                short code2;
                short code1;
                DKLobICM lob = (DKLobICM)item.getDDO();
                lob.retrieve();
                if (newEntity.getDefaultRMCode() == lob.getRMCode() && (code1 = (short)lob.getCollCode()) != (code2 = newEntity.getDefaultCollCode())) {
                    this._changeSMSCollection(lob, code2, newEntity.getDefaultRMCode());
                }
            } else if (classification == 2) {
                this._changeSMSCollectionParts(item, newEntity);
            }
        }
    }

    private void _changeSMSCollection(DKLobICM lob, short newCollectionCode, short rmCode) throws Exception {
        DKDatastoreICM dsICM = this.datastore;
        DKConfigurationMgmtICM mgmt = (DKConfigurationMgmtICM)dsICM.datastoreDef().datastoreAdmin().configurationManagement();
        DKRMConfigurationMgmtICM rmMgmt = mgmt.rmConfigurationMgmt();
        dkCollection smsDefs = rmMgmt.listSMSCollections(rmCode);
        boolean found = false;
        dkIterator iter = smsDefs.createIterator();
        while (!found && iter.more()) {
            DKSMSCollectionDefICM smsDef = (DKSMSCollectionDefICM)iter.next();
            if (smsDef.getSMSCollectionCode() != newCollectionCode) continue;
            found = true;
            String collectionName = smsDef.getName();
            lob.retrieve();
            DKStorageManageInfoICM storageInfo = (DKStorageManageInfoICM)lob.getExtension("DKStorageManageInfoICM");
            storageInfo.setCollectionName(collectionName);
            lob.setCollCode((int)newCollectionCode);
            lob.changeStorage();
        }
        if (!found) {
            // empty if block
        }
    }

    private void _changeSMSCollectionParts(CMItem item, DKItemTypeDefICM newEntity) throws Exception {
        DKDDO ddo = item.getDDO();
        DKDatastoreICM dsICM = this.datastore;
        DKConfigurationMgmtICM mgmt = (DKConfigurationMgmtICM)dsICM.datastoreDef().datastoreAdmin().configurationManagement();
        DKRMConfigurationMgmtICM rmMgmt = mgmt.rmConfigurationMgmt();
        dkCollection relations = newEntity.listItemTypeRelations();
        ddo.retrieve();
        short dataId = ddo.dataId("ATTR", "DKParts");
        if (dataId > 0) {
            DKParts parts = (DKParts)ddo.getData(dataId);
            DKSequentialIterator iter = (DKSequentialIterator)parts.createIterator();
            boolean partUpdated = false;
            block0: while (iter.more()) {
                DKLobICM part = (DKLobICM)iter.next();
                part.retrieve();
                int oldRMCode = part.getRMCode();
                int oldColl = part.getCollCode();
                String partType = part.getObjectType();
                dkIterator relIter = relations.createIterator();
                while (relIter.more()) {
                    DKItemTypeRelationDefICM relation = (DKItemTypeRelationDefICM)relIter.next();
                    if (relation == null || !relation.getTargetItemTypeName().equals(partType)) continue;
                    short rmCode = relation.getDefaultRMCode();
                    short collCode = relation.getDefaultCollCode();
                    if (oldRMCode != rmCode || oldColl == collCode) continue block0;
                    String collectionName = this._getCollectionName(rmMgmt, rmCode, collCode);
                    DKStorageManageInfoICM storageInfo = (DKStorageManageInfoICM)part.getExtension("DKStorageManageInfoICM");
                    storageInfo.setCollectionName(collectionName);
                    part.setCollCode((int)collCode);
                    part.setChangeSMSRequested(true);
                    partUpdated = true;
                    continue block0;
                }
            }
            if (partUpdated) {
                ddo.update();
            }
        }
    }

    private String _getCollectionName(DKRMConfigurationMgmtICM rmAdmin, int rmCode, int collCode) throws Exception {
        String collName = null;
        dkCollection smsColls = rmAdmin.listSMSCollections();
        dkIterator iter = smsColls.createIterator();
        while (iter.more()) {
            DKSMSCollectionDefICM def = (DKSMSCollectionDefICM)iter.next();
            if (def.getRMCode() != rmCode || def.getSMSCollectionCode() != collCode) continue;
            collName = def.getName();
            break;
        }
        return collName;
    }

    private DKDDO _createDDOForItem(CMItem item, boolean isChild, String rootEntityName) throws Exception {
        String entityName = item.getEntityName();
        String serverName = item.getServerName();
        String serverType = item.getServerType();
        DKDDO newDDO = null;
        if (!isChild) {
            newDDO = this.datastore.createDDO(entityName, (int)item.getItemType());
        } else {
            String rootEntityNonDisplayName = rootEntityName;
            newDDO = this.datastore.createChildDDO(rootEntityNonDisplayName, entityName);
        }
        if (newDDO.getPidObject() == null) {
            DKPid newPid = new DKPid();
            newPid.setDatastoreName(serverName);
            newPid.setDatastoreType(serverType);
            newPid.setObjectType(entityName);
            newDDO.setPidObject(newPid);
        }
        this._setDDOData(item, isChild, newDDO, rootEntityName);
        return newDDO;
    }

    private void _setDDOData(CMItem item, boolean isChild, DKDDO newDDO, String rootEntityName) throws Exception {
        if (!isChild) {
            short itemType = item.getItemType();
            short propID = newDDO.propertyId("item-type");
            if (propID == 0) {
                if (itemType == 1) {
                    newDDO.addProperty("item-type", (Object)new Short(1));
                } else if (itemType == 2) {
                    newDDO.addProperty("item-type", (Object)new Short(2));
                }
            } else if (itemType == 1) {
                newDDO.setProperty(propID, (Object)new Short(1));
            } else if (itemType == 2) {
                newDDO.setProperty(propID, (Object)new Short(2));
            }
        }
        this._setDDOAttributes(item, newDDO);
        short[] dataIds = newDDO.dataIdsByNameSpace("CHILD");
        if (dataIds != null) {
            for (int i = 0; i < dataIds.length; ++i) {
                int j;
                short dataId = dataIds[i];
                String name = newDDO.getDataName(dataId);
                if (!item.isAttr(name)) continue;
                DKSequentialCollection oldChildCompValuesCollection = (DKSequentialCollection)newDDO.getData(dataId);
                DKSequentialIterator oldChildCompValues = (DKSequentialIterator)oldChildCompValuesCollection.createIterator();
                CMItem[] newChildCompValues = item.getAttrItems(name);
                if ((newChildCompValues == null || newChildCompValues.length == 0) && (oldChildCompValuesCollection == null || oldChildCompValuesCollection.cardinality() == 0)) continue;
                if (oldChildCompValuesCollection.cardinality() == 0) {
                    for (int j2 = 0; j2 < newChildCompValues.length; ++j2) {
                        DKDDO newChildDDO = this._createDDOForItem(newChildCompValues[j2], true, rootEntityName);
                        newChildCompValues[j2].setDDO(newChildDDO, CMItem.ITEM_STATE_RETRIEVED);
                        oldChildCompValuesCollection.addElement((Object)newChildDDO);
                    }
                    continue;
                }
                HashSet<String> newChildCompHash = new HashSet<String>();
                for (j = 0; j < newChildCompValues.length; ++j) {
                    newChildCompHash.add(newChildCompValues[j].getPidString());
                }
                oldChildCompValues.reset();
                while (oldChildCompValues.setToNext()) {
                    if (newChildCompHash.contains(((DKDDO)oldChildCompValues.at()).getPidObject().pidString())) continue;
                    oldChildCompValuesCollection.removeElementAt((dkIterator)oldChildCompValues);
                    oldChildCompValues.setToPrevious();
                }
                oldChildCompValues.reset();
                for (j = 0; j < newChildCompValues.length; ++j) {
                    String newPID = null;
                    String oldPID = null;
                    if (oldChildCompValues.setToNext()) {
                        newPID = newChildCompValues[j].getPidString();
                        oldPID = ((DKDDO)oldChildCompValues.at()).getPidObject().pidString();
                    }
                    if (newPID != null && oldPID != null && newPID.equals(oldPID)) {
                        String[] attrNms = newChildCompValues[j].getAttrNames();
                        boolean shouldUpdate = false;
                        for (int k = 0; k < attrNms.length; ++k) {
                            DKDDO tempOldChild = (DKDDO)oldChildCompValues.at();
                            String nonDispName = attrNms[k];
                            if (nonDispName == null) continue;
                            if (tempOldChild != null && tempOldChild.dataId("CHILD", nonDispName) == 0) {
                                String str1 = newChildCompValues[j].getAttrValue(attrNms[k]);
                                String str2 = null;
                                if (tempOldChild != null && tempOldChild.getDataByName(nonDispName) != null) {
                                    str2 = tempOldChild.getDataByName(nonDispName).toString();
                                }
                                if (str1.equals("") && str2 == null || str1.equals(str2)) continue;
                                shouldUpdate = true;
                                continue;
                            }
                            shouldUpdate = true;
                        }
                        if (!shouldUpdate) continue;
                        this._setDDOData(newChildCompValues[j], true, (DKDDO)oldChildCompValues.at(), rootEntityName);
                        continue;
                    }
                    DKDDO newChildDDO = this._createDDOForItem(newChildCompValues[j], true, rootEntityName);
                    newChildCompValues[j].setDDO(newChildDDO, CMItem.ITEM_STATE_RETRIEVED);
                    oldChildCompValuesCollection.addElement((Object)newChildDDO);
                }
            }
        }
        if (item.getItemState() == CMItem.ITEM_STATE_NEW && !isChild) {
            CMObject obj;
            dkXDO xdo;
            Vector content;
            short itemType = item.getItemType();
            short data_id = 0;
            if (itemType == 2) {
                data_id = newDDO.dataId("DKFolder");
                if (data_id == 0) {
                    data_id = newDDO.addData("DKFolder");
                    newDDO.addDataProperty(data_id, "type", (Object)new Short(1072));
                }
                newDDO.setData(data_id, (Object)new DKFolder());
            } else if (itemType == 1) {
                Vector content2;
                DKParts parts;
                data_id = newDDO.dataId("DKParts");
                if (data_id == 0) {
                    data_id = newDDO.addData("DKParts");
                    newDDO.addDataProperty(data_id, "type", (Object)new Short(1073));
                }
                if ((parts = (DKParts)newDDO.getData(data_id)) == null) {
                    parts = new DKParts();
                }
                if ((content2 = item.getContents()) != null) {
                    for (int i = 0; i < content2.size(); ++i) {
                        CMObject obj2 = (CMObject)content2.elementAt(i);
                        dkXDO xdo2 = obj2.getXDO();
                        if (xdo2 == null) {
                            this._createXDOForObject(newDDO, obj2, 128);
                            xdo2 = obj2.getXDO();
                        }
                        parts.addElement((Object)xdo2);
                    }
                }
                newDDO.setData(data_id, (Object)parts);
            } else if (itemType == 4 && (content = item.getContents()) != null && (xdo = (obj = (CMObject)content.elementAt(0)).getXDO()) == null) {
                this._createXDOForObject(newDDO, obj, 128);
            }
        }
    }

    private void _setDDOAttributes(CMItem item, DKDDO ddo) throws Exception {
        short[] dataIds;
        if (ddo instanceof DKLobICM && item.getItemState() != CMItem.ITEM_STATE_NEW) {
            short policy;
            DKLobICM resItem = (DKLobICM)ddo;
            String entityName = item.getEntityName();
            if (entityName == null) {
                entityName = ddo.getPidObject().getObjectType();
            }
            if (!((policy = this.getEntity(entityName).getVersionControl()) != 1 && policy != 2 || resItem.isContentChanged())) {
                if (resItem.getResourceObject().isNull()) {
                    resItem.retrieve();
                }
                resItem.setContentChanged(true);
            }
        }
        if ((dataIds = ddo.dataIdsByNameSpace("ATTR")) == null || dataIds.length == 0) {
            String[] values = item.getAttrValues();
            String[] names = item.getAttrNames();
            short[] types = item.getAttrTypes();
            int attrCount = values.length;
            short dataId = 0;
            for (int i = 0; i < attrCount; ++i) {
                dataId = ddo.dataId(names[i]);
                if (dataId == 0) {
                    dataId = ddo.addData(names[i]);
                    ddo.addDataProperty(dataId, "type", (Object)new Short(types[i]));
                    ddo.addDataProperty(dataId, "nullable", (Object)new Boolean(true));
                    ddo.addDataProperty(dataId, "access-right", (Object)new Integer(6));
                }
                ddo.setData(dataId, (Object)values[i]);
            }
        } else {
            for (int i = 0; i < dataIds.length; ++i) {
                CMObject[] valueObject;
                short dataId = dataIds[i];
                String name = ddo.getDataName(dataId);
                if (ddo.getDataNameSpace(dataId).equals("LINK") || name.equals("DKResource") || name.equals("DKViews") || name.equals("DKFixedView") || name.equals("DKParts") || name.equals("DKFolder")) continue;
                short propId = ddo.dataPropertyId(dataId, "type");
                short type = 0;
                if (propId > 0) {
                    type = (Short)ddo.getDataProperty(dataId, propId);
                }
                if (!item.isAttr(name)) continue;
                boolean needSetData = true;
                Object dataObj = null;
                if (type == 48) {
                    CMItem[] valueItem = item.getAttrItems(name);
                    if (valueItem.length > 0) {
                        dataObj = valueItem[0].getDDO();
                    }
                } else if (type == 49) {
                    valueObject = item.getAttrObjects(name);
                    if (valueObject.length > 0) {
                        dataObj = valueObject[0].getXDO();
                    }
                } else if (type == 11) {
                    valueObject = null;
                    try {
                        valueObject = item.getAttrObjects(name);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (valueObject != null && valueObject.length > 0) {
                        dataObj = valueObject[0].getByteArrayData();
                    }
                } else {
                    String value = item.getAttrValue(name);
                    if (value != null && value.length() == 0) {
                        value = null;
                    }
                    if (value != null) {
                        switch (type) {
                            case 0: {
                                dataObj = value;
                                break;
                            }
                            case 1: {
                                String tempStr;
                                dataObj = value;
                                if (!this._updateItemFlag || null == (tempStr = (String)ddo.getData(dataId)) || !dataObj.equals(tempStr)) break;
                                needSetData = false;
                                break;
                            }
                            case 3: {
                                Short tempShort;
                                dataObj = Short.valueOf(value);
                                if (!this._updateItemFlag || null == (tempShort = (Short)ddo.getData(dataId)) || !value.equals(tempShort.toString())) break;
                                needSetData = false;
                                break;
                            }
                            case 4: {
                                Integer tempInt;
                                dataObj = Integer.valueOf(value);
                                if (!this._updateItemFlag || null == (tempInt = (Integer)ddo.getData(dataId)) || !value.equals(tempInt.toString())) break;
                                needSetData = false;
                                break;
                            }
                            case 5: {
                                Float tempFloat;
                                dataObj = Float.valueOf(value);
                                if (!this._updateItemFlag || null == (tempFloat = (Float)ddo.getData(dataId)) || !value.equals(tempFloat.toString())) break;
                                needSetData = false;
                                break;
                            }
                            case 6: {
                                BigDecimal tempDecimal;
                                dataObj = new BigDecimal(value);
                                if (!this._updateItemFlag || null == (tempDecimal = (BigDecimal)ddo.getData(dataId)) || !value.equals(tempDecimal.toString())) break;
                                needSetData = false;
                                break;
                            }
                            case 7: {
                                DKDate tempDate;
                                dataObj = this._getDKDateFromString(value, new SimpleDateFormat("yyyy-MM-dd"));
                                if (!this._updateItemFlag || null == (tempDate = (DKDate)ddo.getData(dataId)) || !value.equals(tempDate.toString())) break;
                                needSetData = false;
                                break;
                            }
                            case 8: {
                                DKTime tempTime;
                                dataObj = DKTime.valueOf((String)value);
                                if (!this._updateItemFlag || null == (tempTime = (DKTime)ddo.getData(dataId)) || !value.equals(tempTime.toString())) break;
                                needSetData = false;
                                break;
                            }
                            case 9: {
                                DKTimestamp tempTS;
                                dataObj = value.indexOf(58) != -1 ? new DKTimestamp(Timestamp.valueOf(value)) : DKTimestamp.valueOf((String)value);
                                if (!this._updateItemFlag || null == (tempTS = (DKTimestamp)ddo.getData(dataId)) || !value.equals(tempTS.toString())) break;
                                needSetData = false;
                                break;
                            }
                            case 10: {
                                Double tempDouble;
                                dataObj = Double.valueOf(value);
                                if (!this._updateItemFlag || null == (tempDouble = (Double)ddo.getData(dataId)) || !value.equals(tempDouble.toString())) break;
                                needSetData = false;
                                break;
                            }
                            case 11: {
                                byte[] tempBytes;
                                dataObj = value.getBytes();
                                if (!this._updateItemFlag || null == (tempBytes = (byte[])ddo.getData(dataId)) || !value.equals(tempBytes.toString())) break;
                                needSetData = false;
                                break;
                            }
                            case 50: {
                                break;
                            }
                            case 1024: {
                                break;
                            }
                            case 1072: {
                                break;
                            }
                            case 1073: {
                                break;
                            }
                            case 1071: {
                                break;
                            }
                            case 2048: {
                                break;
                            }
                            default: {
                                dataObj = value;
                            }
                        }
                    }
                }
                if (this._updateItemFlag) {
                    if (!needSetData) continue;
                    ddo.setData(dataId, dataObj);
                    continue;
                }
                ddo.setData(dataId, dataObj);
            }
        }
    }

    private Date _getDKDateFromString(String value, DateFormat userdateformat) throws ParseException {
        java.util.Date javadate = null;
        SimpleDateFormat another = (SimpleDateFormat)DateFormat.getDateInstance(3, Locale.US);
        another.applyPattern("yyyy-MM-dd");
        try {
            javadate = userdateformat.parse(value);
        }
        catch (ParseException exp) {
            try {
                javadate = another.parse(value);
            }
            catch (ParseException exp1) {
                SimpleDateFormat tryAnother = (SimpleDateFormat)DateFormat.getDateInstance(3, Locale.US);
                tryAnother.applyPattern("MM/dd/yy");
                javadate = tryAnother.parse(value);
            }
        }
        return DKDate.valueOf((String)another.format(javadate));
    }

    private void _createXDOForObject(DKDDO ddo, CMObject object, int affiliatedType) throws Exception {
        byte[] data = object.getByteArrayData();
        dkXDO xdo = null;
        if (ddo instanceof dkXDO) {
            xdo = (dkXDO)ddo;
            if (data != null) {
                xdo.setContent(data);
                xdo.setMimeType(object.getMimeType());
            }
        } else {
            String parttype = object.getPartType();
            xdo = this._createLobICM(ddo, parttype, object);
            xdo.setMimeType(object.getMimeType());
        }
        object.setXDO(xdo);
    }

    private final DKLobICM _createLobICM(DKDDO ddo, String partType, CMObject data) throws Exception {
        InputStream is;
        DKDatastoreICM dsICM = this.datastore;
        DKLobICM xdo = (DKLobICM)dsICM.createDDO(partType, 13);
        DKParts parts = this._createPartsCollectionIfNotExists(ddo);
        xdo.setPartNumber(parts.cardinality() + 1);
        if (xdo instanceof DKTextICM && data.getCCSID() != -1) {
            ((DKTextICM)xdo).setCCSID(data.getCCSID());
        }
        if ((is = data.getDataStream()) != null) {
            DKNVPair[] dknv = new DKNVPair[]{new DKNVPair("STREAM", (Object)is), new DKNVPair("LENGTH", (Object)new Long(data.getSize()))};
            xdo.setAddLocation(dknv);
            String orifile = data.getOriginalFileName();
            if (orifile != null) {
                xdo.setOrgFileName(orifile);
            }
        } else if (data.getByteArrayData() != null) {
            String orifile = data.getOriginalFileName();
            if (orifile != null) {
                xdo.setOrgFileName(orifile);
            }
            xdo.setContent(data.getByteArrayData());
        }
        if (partType.equals("ICMANNOTATION")) {
            xdo.setAffiliatedType(8);
        } else if (partType.equals("ICMNOTELOG")) {
            xdo.setAffiliatedType(64);
        } else {
            xdo.setAffiliatedType(128);
        }
        DKPid ddopid = ddo.getPidObject();
        String primaryId = ddopid.getPrimaryId();
        DKPid xdopid = xdo.getPidObject();
        xdopid.setPrimaryId(primaryId);
        xdo.setPidObject(xdopid);
        return xdo;
    }

    private DKParts _createPartsCollectionIfNotExists(DKDDO ddo) throws DKUsageError {
        DKParts partColl = null;
        short dataId = ddo.dataId("ATTR", "DKParts");
        if (dataId == 0) {
            dataId = ddo.addData("ATTR", "DKParts");
            ddo.addDataProperty(dataId, "type", (Object)new Short(1073));
            partColl = new DKParts();
            ddo.setData(dataId, (Object)partColl);
        } else {
            partColl = (DKParts)ddo.getData(dataId);
            if (partColl == null) {
                partColl = new DKParts();
                ddo.setData(dataId, (Object)partColl);
            }
        }
        return partColl;
    }

    public void updateItem(CMItem item, boolean createNewVersion, HttpServletRequest request) throws Exception {
        DKDDO ddoObj = this._getItemDDO(item);
        this._updateItemFlag = true;
        this._setDDOData(item, false, ddoObj, item.getEntityName());
        this._updateItemFlag = false;
        if (createNewVersion) {
            ddoObj.update(2);
        } else {
            this.datastore.updateObject((dkDataObject)ddoObj, 0);
        }
    }

    private DKDDO _getItemDDO(CMItem item) throws Exception {
        DKDDO pDDO = item.getDDO();
        if (pDDO == null) {
            String pidString = item.getPidString();
            if (pidString == null) {
                return null;
            }
            pDDO = this.datastore.createDDOFromPID(pidString);
            item.setDDO(pDDO, CMItem.ITEM_STATE_NEED_RETRIEVE);
        }
        return pDDO;
    }

    public void clearSchemaCache() throws Exception {
        this.datastore.datastoreDef().clearCache();
    }

    public void setLanguageCode(String languageCode) throws Exception {
        if (languageCode != null && !languageCode.equalsIgnoreCase(this.languageCode)) {
            this.languageCode = languageCode;
            this.clearSchemaCache();
        }
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void logout() throws Exception {
        this.datastore.disconnect();
    }

    public void valueBound(HttpSessionBindingEvent ev) {
        Logger.logInfo(CMConnection.class, "valueBound", ev.getSession(), "Session: " + ev.getSession() + "    maxInactiveInterval=" + ev.getSession().getMaxInactiveInterval());
    }

    public void valueUnbound(HttpSessionBindingEvent ev) {
        Logger.logInfo(CMConnection.class, "valueUnbound", ev.getSession(), "Session: " + ev.getSession() + "    maxInactiveInterval=" + ev.getSession().getMaxInactiveInterval());
        try {
            this.logout();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private dkEntityDef _findEntityDef(String entityName) throws Exception {
        dkEntityDef entity;
        dkDatastoreDef dsDef = this.datastore.datastoreDef();
        dkCollection entityList = dsDef.listEntities(2);
        dkIterator iterator = entityList.createIterator();
        boolean found = false;
        while (iterator.more()) {
            entity = (dkEntityDef)iterator.next();
            found = entity instanceof DKComponentTypeDefICM ? entity.getName().equals(entityName) : entity.getName().equals(entityName);
            if (!found) continue;
            return entity;
        }
        iterator = entityList.createIterator();
        while (iterator.more()) {
            entity = (dkEntityDef)iterator.next();
            dkEntityDef subEntity = this._findSubEntity(entityName, entity);
            if (subEntity == null) continue;
            return subEntity;
        }
        return null;
    }

    private dkEntityDef _findSubEntity(String entityName, dkEntityDef parentEntity) throws Exception {
        if (parentEntity.hasSubEntities()) {
            dkEntityDef entity;
            dkCollection collection = parentEntity.listSubEntities();
            dkIterator iterator = collection.createIterator();
            boolean found = false;
            while (iterator.more()) {
                entity = (dkEntityDef)iterator.next();
                found = entity instanceof DKComponentTypeDefICM ? entity.getName().equals(entityName) : entity.getName().equals(entityName);
                if (!found) continue;
                return entity;
            }
            iterator = collection.createIterator();
            while (iterator.more()) {
                entity = (dkEntityDef)iterator.next();
                dkEntityDef subEntity = this._findSubEntity(entityName, entity);
                if (subEntity == null) continue;
                return subEntity;
            }
        }
        return null;
    }

    public void setAllItemTypesSortNotSupported(boolean allItemTypesSortNotSupported) {
        this.allItemTypesSortNotSupported = allItemTypesSortNotSupported;
    }

    public boolean getAllItemTypesSortNotSupported() {
        return this.allItemTypesSortNotSupported;
    }
}

