/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.viewer;

import com.ibm.ecm.applets.AppletLogger;
import com.ibm.ecm.applets.MessageDialog;
import com.ibm.ecm.applets.SecurityUtil;
import com.ibm.ecm.applets.viewer.AnnotationServicesCallbacks;
import com.ibm.ecm.applets.viewer.DocLoadInfo;
import com.ibm.ecm.applets.viewer.DocServicesCallbacks;
import com.ibm.ecm.applets.viewer.JSListener;
import com.ibm.ecm.applets.viewer.JSONAnnotationEngine;
import com.ibm.ecm.applets.viewer.ProgressMonitoringStream;
import com.ibm.ecm.applets.viewer.StatusBar;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.viewer.CMBBookmark;
import com.ibm.mm.viewer.CMBBookmarksEditEvent;
import com.ibm.mm.viewer.CMBBookmarksEditListener;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocClosedEvent;
import com.ibm.mm.viewer.CMBGenericDocClosedListener;
import com.ibm.mm.viewer.CMBGenericDocOpenedEvent;
import com.ibm.mm.viewer.CMBGenericDocOpenedListener;
import com.ibm.mm.viewer.CMBGenericDocSaveEvent;
import com.ibm.mm.viewer.CMBGenericDocSaveListener;
import com.ibm.mm.viewer.CMBGenericDocSelectedEvent;
import com.ibm.mm.viewer.CMBGenericDocSelectedListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBStreamingDocServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.swing.FocusManager;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import netscape.javascript.JSObject;

public class ViewerApplet
extends JApplet {
    private static final String ERRORS = "errors";
    private static final String GLOBALS_ID = "globals_id";
    private static final String APPLET_PARAM_SHARED_INSTANCE = "sharedInstance";
    private static final String APPLET_PARAM_PROPERTIES_FILE = "propertiesFile";
    private static final String APPLET_PARAM_DOC_URL = "docUrl";
    private static final String APPLET_PARAM_DOC_NAME = "docName";
    private static final String APPLET_PARAM_CONTENT_TYPE = "contentType";
    private static final String APPLET_PARAM_SERVER_TYPE = "serverType";
    private static final String APPLET_PARAM_PRINT_DOC = "printDoc";
    private static final String APPLET_PARAM_EXPORT_DOC = "exportDoc";
    private static final String APPLET_PARAM_VIEW_ANNOTATIONS = "viewAnnotations";
    private static final String APPLET_PARAM_EDIT_ANNOTATIONS = "editAnnotations";
    private static final String APPLET_PARAM_EDIT_DOC = "editDoc";
    private static final String APPLET_PARAM_EDIT_PROPERTIES = "editProperties";
    private static final String APPLET_PARAM_LANGUAGE = "language";
    private static final String APPLET_PARAM_COUNTRY = "country";
    private static final String APPLET_PARAM_VARIANT = "variant";
    private static final String APPLET_PARAM_LOG_LEVEL = "logLevel";
    private static final String APPLET_PARAM_PROXY = "WCProxy";
    private static final String APPLET_PARAM_PAGE_NUMBER = "pageNumber";
    private static final String APPLET_PARAM_PLATFORM = "platform";
    private static final String APPLET_PARAM_EVENT_CALLACK = "jsCallback";
    private static final String APPLET_PARAM_EVENT_CALLBACK_EVENTS = "jsCallbackEvents";
    private static final String END_EDITING_BOOKMARKS_EVENT = "endEditingBookmarks";
    private static int adjustedFontSize = 0;
    private boolean checkJreVersion = false;
    private static Properties defaultProperties;
    private static Map<String, Properties> propertiesMap;
    private boolean usingSharedInstance;
    private static Hashtable sharedInstances;
    static boolean savingToServer;
    private JSListener jsListener = null;
    private Thread jsListenerThread = null;
    private String jsCallback = null;
    private Set<String> jsCallbackEvents = null;
    private static final Object openDocSynch;
    private transient GdvEventListener gdvEventListener;
    private static Hashtable docPrivilegesMap;
    private static Hashtable editableDocumentsMap;
    private static Hashtable editableAnnotationsMap;
    private static Hashtable docLoadInfoMap;
    transient ThreadGroup appletThreadGroup;
    transient InstanceInfo info;
    transient CMBDocument document;
    transient CMBAnnotationSet annoSet;
    boolean locked;
    StatusBar statusBar;
    boolean terminating;
    boolean optionallyVersioningBookmarks;
    boolean initCalled;
    private boolean docDisplayed;
    private boolean okToClose;
    private boolean docClosed;
    private boolean inJSCall = false;
    private static ResourceBundle messages;

    private void sendJsCallback(Object[] args) {
        String methodName = "sendJsCallback";
        AppletLogger.logEntry(this, methodName);
        if (args.length >= 1 && args[0] instanceof String) {
            String callbackEvent = (String)args[0];
            if (this.jsCallback != null && this.jsCallbackEvents != null && this.jsCallbackEvents.contains(callbackEvent)) {
                AppletLogger.logDebug(this, methodName, "Firing JavaScript callback event " + callbackEvent);
                JSObject window = JSObject.getWindow(this);
                if (window != null) {
                    window.call(this.jsCallback, args);
                }
            } else {
                AppletLogger.logDebug(this, methodName, "The event " + callbackEvent + " is not in the callback events list.  Skipping.");
            }
        } else {
            AppletLogger.logDebug(this, methodName, "An event name was not found.");
        }
        AppletLogger.logExit(this, methodName);
    }

    static boolean getPrintDocPrivilege(CMBDocument document) {
        if (!docPrivilegesMap.containsKey(document)) {
            return true;
        }
        DocPrivileges docPrivileges = (DocPrivileges)docPrivilegesMap.get(document);
        return docPrivileges.printDocPriv;
    }

    static boolean getExportDocPrivilege(CMBDocument document) {
        if (!docPrivilegesMap.containsKey(document)) {
            return true;
        }
        DocPrivileges docPrivileges = (DocPrivileges)docPrivilegesMap.get(document);
        return docPrivileges.exportDocPriv;
    }

    static boolean getViewAnnotationsPrivilege(CMBAnnotationSet annoSet) {
        if (!docPrivilegesMap.containsKey(annoSet)) {
            return true;
        }
        DocPrivileges docPrivileges = (DocPrivileges)docPrivilegesMap.get(annoSet);
        return docPrivileges.viewAnnotationsPriv;
    }

    static boolean getEditAnnotationsPrivilege(CMBDocument document) {
        if (!docPrivilegesMap.containsKey(document)) {
            return false;
        }
        DocPrivileges docPrivileges = (DocPrivileges)docPrivilegesMap.get(document);
        return docPrivileges.editAnnotationsPriv;
    }

    static boolean getEditDocPrivilege(CMBDocument document) {
        if (!docPrivilegesMap.containsKey(document)) {
            return false;
        }
        DocPrivileges docPrivileges = (DocPrivileges)docPrivilegesMap.get(document);
        return docPrivileges.editDocPriv;
    }

    static boolean getEditPropertiesPrivilege(CMBDocument document) {
        if (!docPrivilegesMap.containsKey(document)) {
            return false;
        }
        DocPrivileges docPrivileges = (DocPrivileges)docPrivilegesMap.get(document);
        return docPrivileges.editPropertiesPriv;
    }

    static boolean isDocumentEditable(CMBDocument document) {
        if (editableDocumentsMap.get(document) == null) {
            return false;
        }
        return (Boolean)editableDocumentsMap.get(document);
    }

    static void setDocumentEditable(CMBDocument document, boolean value) {
        editableDocumentsMap.put(document, new Boolean(value));
    }

    public static boolean areAnnotationsEditable(CMBAnnotationSet annoSet) {
        if (annoSet == null) {
            return false;
        }
        if (editableAnnotationsMap.get(annoSet) == null) {
            return true;
        }
        return (Boolean)editableAnnotationsMap.get(annoSet);
    }

    public static void setAnnotationsEditable(CMBAnnotationSet annoSet, boolean value) {
        if (annoSet != null) {
            editableAnnotationsMap.put(annoSet, new Boolean(value));
        }
    }

    public static DocLoadInfo getDocLoadInfo(CMBDocument document) {
        return (DocLoadInfo)docLoadInfoMap.get(document);
    }

    public void init() {
        String methodName = "init";
        AppletLogger.logEntry(this, "init");
        super.init();
        if (!this.initCalled) {
            this.initCalled = true;
            this.initJSListener();
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.swingInit();
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ViewerApplet.this.swingInit();
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                AppletLogger.logError((Object)this, "init", e);
            }
            catch (InvocationTargetException e) {
                AppletLogger.logError((Object)this, "init", e);
            }
        }
        AppletLogger.logExit(this, "init");
    }

    private void initJSListener() {
        if (this.jsListenerThread == null && this.jsListener == null) {
            String methodName = "initJSListener()";
            AppletLogger.logInfo(this, "initJSListener()", "Start setting up JSListener");
            this.jsListener = new JSListener();
            AppletLogger.logInfo(this, "initJSListener()", "Starting jsListenerThread.");
            this.jsListenerThread = new Thread(this.jsListener);
            this.jsListenerThread.start();
            AppletLogger.logInfo(this, "initJSListener()", "Finished setting up JSListener");
        }
    }

    private void terminateJSListener() {
        this.jsListener.terminate();
        this.jsListener = null;
        this.jsListenerThread = null;
    }

    private Properties loadProperties(String configPropertiesFile, Properties defaultProperties, Properties appletProperties) throws MalformedURLException, IOException {
        String methodName = "loadProperties";
        AppletLogger.logEntry(this, methodName);
        URL configURL = new URL(this.getCodeBase(), configPropertiesFile);
        Properties properties = propertiesMap.get(configURL.toString());
        if (properties == null) {
            AppletLogger.logInfo(this, methodName, "Loading properties from: " + configURL.toString());
            URLConnection configURLConn = configURL.openConnection();
            InputStream configInputStream = configURLConn.getInputStream();
            AppletLogger.logDebug(this, methodName, "Got InputStream from configURLConn");
            properties = defaultProperties != null ? new Properties(defaultProperties) : new Properties();
            properties.load(configInputStream);
            if (appletProperties != null) {
                this.substituteMessages(appletProperties);
            }
            propertiesMap.put(configURL.toString(), properties);
        } else {
            AppletLogger.logDebug(this, methodName, "Loading previously cached properties for: " + configURL.toString());
        }
        AppletLogger.logExit(this, methodName);
        return properties;
    }

    private void swingInit() {
        String sharedInstanceName;
        String methodName = "swingInit";
        AppletLogger.logEntry(this, "swingInit");
        this.appletThreadGroup = Thread.currentThread().getThreadGroup();
        String logLevel = this.getParameter(APPLET_PARAM_LOG_LEVEL);
        if (logLevel != null) {
            AppletLogger.setLogLevel(Integer.parseInt(logLevel));
        }
        try {
            System.setProperty("swing.useSystemFontSettings", "false");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.jsCallback = this.getParameter(APPLET_PARAM_EVENT_CALLACK);
        String jsCallbackEventList = this.getParameter(APPLET_PARAM_EVENT_CALLBACK_EVENTS);
        if (jsCallbackEventList != null) {
            this.jsCallbackEvents = new HashSet<String>();
            StringTokenizer events = new StringTokenizer(jsCallbackEventList, ",");
            while (events.hasMoreTokens()) {
                this.jsCallbackEvents.add(events.nextToken());
            }
        }
        Locale originalLocale = this.getLocale();
        AppletLogger.logInfo(this, "swingInit", "Original applet Locale = " + originalLocale);
        this.setDefaultLocale();
        AppletLogger.logInfo(this, "swingInit", "Proxy address is : " + this.getParameter(APPLET_PARAM_PROXY));
        ViewerApplet.initializeMessages();
        this.getAccessibleContext().setAccessibleName(ViewerApplet.getMessage("viewerApplet_title"));
        if (ComponentOrientation.getOrientation(this.getLocale()).equals(ComponentOrientation.RIGHT_TO_LEFT)) {
            UIManager.put("ToolTip.hideAccelerator", new Boolean(true));
        }
        if (!originalLocale.equals(this.getLocale())) {
            try {
                AppletLogger.logInfo(this, "swingInit", "Attempting to reload AWT resource bundle (may fail)");
                Field field = Toolkit.class.getDeclaredField("resources");
                field.setAccessible(true);
                field.set(null, ResourceBundle.getBundle("sun.awt.resources.awt"));
            }
            catch (NoSuchFieldException e) {
                AppletLogger.logError((Object)this, "swingInit", e);
            }
            catch (IllegalAccessException e) {
                AppletLogger.logError((Object)this, "swingInit", e);
            }
        }
        AppletLogger.logInfo(this, "swingInit", "Locale = " + this.getLocale());
        if (adjustedFontSize == 0) {
            try {
                int screenResolution = this.getToolkit().getScreenResolution();
                if (screenResolution != 96) {
                    Enumeration keys = UIManager.getDefaults().keys();
                    while (keys.hasMoreElements()) {
                        Object key = keys.nextElement();
                        Object value = UIManager.get(key);
                        if (!(value instanceof FontUIResource)) continue;
                        FontUIResource fontResource = (FontUIResource)value;
                        adjustedFontSize = fontResource.getSize() * screenResolution / 96;
                        AppletLogger.logInfo(this, "swingInit", "reset FontResource to: " + adjustedFontSize);
                        FontUIResource newFontResource = new FontUIResource(fontResource.getFontName(), fontResource.getStyle(), adjustedFontSize);
                        UIManager.put(key, newFontResource);
                    }
                }
            }
            catch (Exception e) {
                AppletLogger.logError((Object)this, "swingInit", "Could not set system default font.");
            }
        }
        if ((sharedInstanceName = this.getParameter(APPLET_PARAM_SHARED_INSTANCE)) != null && sharedInstances.get(sharedInstanceName) != null) {
            AppletLogger.logInfo(this, "swingInit", "Using existing shared gdv");
            this.usingSharedInstance = true;
            this.info = (InstanceInfo)sharedInstances.get(sharedInstanceName);
            this.info.gdv.setLocale(this.getLocale());
        } else {
            String platform;
            AppletLogger.logInfo(this, "swingInit", "Creating a new gdv");
            this.usingSharedInstance = false;
            this.info = new InstanceInfo();
            try {
                if (defaultProperties != null) {
                    AppletLogger.logInfo(this, "swingInit", "Reusing default applet properties loaded earlier.");
                } else {
                    AppletLogger.logInfo(this, "swingInit", "Loading default applet properties");
                    defaultProperties = this.loadProperties("ViewerApplet_properties.jsp", null, null);
                    this.substituteMessages(defaultProperties);
                }
                String configPropertiesFile = this.getParameter(APPLET_PARAM_PROPERTIES_FILE);
                if (configPropertiesFile == null || configPropertiesFile.length() == 0 || configPropertiesFile.equals("undefined") || configPropertiesFile.equals("null")) {
                    this.info.appletProperties = defaultProperties;
                } else {
                    AppletLogger.logInfo(this, "swingInit", "Loading applet properties from " + configPropertiesFile);
                    this.info.appletProperties = this.loadProperties(configPropertiesFile, defaultProperties, this.info.appletProperties);
                }
            }
            catch (MalformedURLException e) {
                AppletLogger.logError((Object)this, "swingInit", e);
            }
            catch (IOException e) {
                AppletLogger.logError((Object)this, "swingInit", e);
            }
            if (this.checkJreVersion) {
                AppletLogger.logInfo(this, "swingInit", "Checking JRE version.");
                String javaVersion = System.getProperty("java.version");
                if (!(javaVersion.startsWith("1.4.2") || javaVersion.startsWith("1.5.0") || javaVersion.startsWith("1.6.0"))) {
                    AppletLogger.logInfo(this, "swingInit", javaVersion);
                    MessageDialog.showErrorDialog(this, ViewerApplet.getMessage("viewerApplet_appletTitle"), ViewerApplet.getMessage("viewerApplet_wrongJavaVersion"));
                    return;
                }
            }
            if ((platform = this.getParameter(APPLET_PARAM_PLATFORM)) != null) {
                AppletLogger.logInfo(this, "swingInit", "Getting the platform from the request.");
                this.info.appletProperties.setProperty("ENGINE_platform", platform);
            }
            AppletLogger.logInfo(this, "swingInit", "Creating streaming doc services");
            this.info.docServicesCallbacks = new DocServicesCallbacks(this);
            this.info.docServices = new CMBStreamingDocServices(this.info.docServicesCallbacks, this.info.appletProperties);
            AppletLogger.logInfo(this, "swingInit", "Creating annotation services");
            if (!"od".equalsIgnoreCase(this.getParameter(APPLET_PARAM_SERVER_TYPE))) {
                this.info.annoServicesCallbacks = new AnnotationServicesCallbacks();
                this.info.annoServices = new CMBAnnotationServices(this.info.annoServicesCallbacks, this.info.appletProperties);
            }
            AppletLogger.logInfo(this, "swingInit", "Creating generic doc viewer");
            this.info.gdv = new CMBGenericDocViewer(this.info.docServices, this.info.annoServices, this.info.appletProperties);
            this.info.gdv.setViewerLayout(4);
            this.info.gdv.setLocale(this.getLocale());
            this.info.docSaveListener = new DocSaveListener(this.info);
            this.info.gdv.addDocSaveListener(this.info.docSaveListener);
        }
        if (sharedInstanceName != null && sharedInstances.get(sharedInstanceName) == null) {
            AppletLogger.logInfo(this, "swingInit", "Saving the new gdv as a shared instance");
            sharedInstances.put(sharedInstanceName, this.info);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.info.gdv, "Center");
        JComponent focuser = new JComponent(){

            public boolean isFocusable() {
                return true;
            }

            public Dimension getPreferredSize() {
                return new Dimension(0, 0);
            }
        };
        this.getContentPane().add((Component)focuser, "North");
        focuser.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent ev) {
                if (ev.getOppositeComponent() != null) {
                    if (ev.getOppositeComponent().getParent() == ((Container)ViewerApplet.this.info.gdv.getComponent(0)).getComponent(0)) {
                        JSObject.getWindow(ViewerApplet.this).call("focusOut", new Object[]{"true"});
                    } else {
                        JSObject.getWindow(ViewerApplet.this).call("focusOut", null);
                    }
                } else {
                    FocusManager.getCurrentManager().focusNextComponent();
                }
            }

            public void focusLost(FocusEvent ev) {
            }
        });
        this.statusBar = new StatusBar(this);
        this.gdvEventListener = new GdvEventListener();
        this.info.gdv.addDocOpenedListener(this.gdvEventListener);
        this.info.gdv.addDocSelectedListener(this.gdvEventListener);
        this.info.gdv.addDocStateChangedListener(this.gdvEventListener);
        this.info.gdv.addDocClosedListener(this.gdvEventListener);
        this.info.gdv.addBookmarksEditListener(this.gdvEventListener);
        if (this.getParameter(APPLET_PARAM_DOC_URL) != null) {
            String editPropertiesParam;
            String editDocParam;
            String editAnnotationsParam;
            String viewAnnotationsParam;
            String exportDocParam;
            DocPrivileges docPrivs = new DocPrivileges();
            String printDocParam = this.getParameter(APPLET_PARAM_PRINT_DOC);
            if (printDocParam != null) {
                docPrivs.printDocPriv = Boolean.valueOf(printDocParam);
            }
            if ((exportDocParam = this.getParameter(APPLET_PARAM_EXPORT_DOC)) != null) {
                docPrivs.exportDocPriv = Boolean.valueOf(exportDocParam);
            }
            if ((viewAnnotationsParam = this.getParameter(APPLET_PARAM_VIEW_ANNOTATIONS)) != null) {
                docPrivs.viewAnnotationsPriv = Boolean.valueOf(viewAnnotationsParam);
            }
            if ((editAnnotationsParam = this.getParameter(APPLET_PARAM_EDIT_ANNOTATIONS)) != null) {
                docPrivs.editAnnotationsPriv = Boolean.valueOf(editAnnotationsParam);
                if ("od".equalsIgnoreCase(this.getParameter(APPLET_PARAM_SERVER_TYPE))) {
                    docPrivs.editAnnotationsPriv = false;
                }
            }
            if ((editDocParam = this.getParameter(APPLET_PARAM_EDIT_DOC)) != null) {
                docPrivs.editDocPriv = Boolean.valueOf(editDocParam);
                if ("od".equalsIgnoreCase(this.getParameter(APPLET_PARAM_SERVER_TYPE))) {
                    docPrivs.editDocPriv = false;
                }
            }
            if ((editPropertiesParam = this.getParameter(APPLET_PARAM_EDIT_PROPERTIES)) != null) {
                docPrivs.editPropertiesPriv = Boolean.valueOf(editPropertiesParam);
                if ("od".equalsIgnoreCase(this.getParameter(APPLET_PARAM_SERVER_TYPE))) {
                    docPrivs.editPropertiesPriv = false;
                }
            }
            InitialView initialView = null;
            String pageNumberString = this.getParameter(APPLET_PARAM_PAGE_NUMBER);
            if (pageNumberString != null) {
                try {
                    int pageNumber = Integer.valueOf(pageNumberString);
                    initialView = new InitialView(pageNumber);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            this.displayDocument(this.getParameter(APPLET_PARAM_DOC_URL), this.getParameter(APPLET_PARAM_DOC_NAME), this.getParameter(APPLET_PARAM_SERVER_TYPE), docPrivs, false, false, initialView);
        }
        AppletLogger.logExit(this, "swingInit");
    }

    public void destroy() {
        String methodName = "destroy";
        AppletLogger.logEntry(this, methodName);
        if (!this.terminating) {
            this.terminating = true;
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.swingDestroy();
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ViewerApplet.this.swingDestroy();
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                AppletLogger.logError((Object)this, methodName, e);
            }
            catch (InvocationTargetException e) {
                AppletLogger.logError((Object)this, methodName, e);
            }
            super.destroy();
        }
        AppletLogger.logExit(this, methodName);
    }

    private void swingDestroy() {
        String methodName = "swingDestroy";
        AppletLogger.logEntry(this, methodName);
        if (this.info == null || this.info.gdv == null) {
            AppletLogger.logExit(this, methodName);
            return;
        }
        if (this.info.gdv.getParent() != null && this.info.gdv.getParent() == this.getContentPane()) {
            this.info.gdv.getParent().remove(this.info.gdv);
        }
        if (this.document != null) {
            AppletLogger.logInfo(this, methodName, "closing document in gdv");
            try {
                this.document.setModified(false);
                if (this.annoSet != null) {
                    this.annoSet.setDirty(false);
                }
                this.closeDocument(true, true);
            }
            catch (Exception e) {
                AppletLogger.logError((Object)this, methodName, e);
            }
        }
        this.info.gdv.removeDocOpenedListener(this.gdvEventListener);
        this.info.gdv.removeDocSelectedListener(this.gdvEventListener);
        this.info.gdv.removeDocStateChangedListener(this.gdvEventListener);
        this.info.gdv.removeDocClosedListener(this.gdvEventListener);
        this.info.gdv.removeBookmarksEditListener(this.gdvEventListener);
        AppletLogger.logDebug(this, methodName, "Terminating jsListener");
        this.terminateJSListener();
        this.terminate(false);
        AppletLogger.logExit(this, methodName);
    }

    public void terminate(boolean prompt) {
        String methodName = "terminate";
        String sharedInstanceName = this.getParameter(APPLET_PARAM_SHARED_INSTANCE);
        if (sharedInstanceName == null) {
            AppletLogger.logInfo(this, methodName, "Terminating gdv (unshared instance)");
            this.info.gdv.terminate(prompt);
        } else {
            AppletLogger.logInfo(this, methodName, "The gdv is shared, and is not being terminated.");
        }
    }

    public void activate() {
        String methodName = "activate";
        AppletLogger.logEntry(this, methodName);
        if (this.usingSharedInstance) {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.swingActivate();
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ViewerApplet.this.swingActivate();
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                AppletLogger.logError((Object)this, methodName, e);
            }
            catch (InvocationTargetException e) {
                AppletLogger.logError((Object)this, methodName, e);
            }
        }
        this.statusBar.updateStatus();
        AppletLogger.logExit(this, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swingActivate() {
        String methodName = "swingActivate";
        AppletLogger.logEntry(this, methodName);
        CMBGenericDocViewer cMBGenericDocViewer = this.info.gdv;
        synchronized (cMBGenericDocViewer) {
            this.info.gdv.activateDocument(this.document);
        }
        this.getContentPane().add((Component)this.info.gdv, "Center");
        this.validate();
        AppletLogger.logExit(this, methodName);
    }

    public boolean displayDocument(String docUrl) {
        return this.displayDocument(docUrl, docUrl, null, null, false, false);
    }

    public boolean displayDocument(String docUrl, String docName, String serverType) {
        return this.displayDocument(docUrl, docName, serverType, null, false, false);
    }

    public boolean displayDocument(String docUrl, String docName, String serverType, DocPrivileges docPrivs, boolean annotationsEditable, boolean documentEditable) {
        return this.displayDocument(docUrl, docName, serverType, docPrivs, annotationsEditable, documentEditable, null);
    }

    public boolean displayDocument(final String docUrl, final String docName, final String serverType, final DocPrivileges docPrivs, final boolean annotationsEditable, final boolean documentEditable, final InitialView initialView) {
        String methodName = "displayDocument";
        AppletLogger.logEntry(this, methodName);
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.docDisplayed = this.swingDisplayDocument(docUrl, docName, serverType, docPrivs, annotationsEditable, documentEditable, initialView);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ViewerApplet.this.docDisplayed = ViewerApplet.this.swingDisplayDocument(docUrl, docName, serverType, docPrivs, annotationsEditable, documentEditable, initialView);
                    }
                });
            }
        }
        catch (InterruptedException e) {
            AppletLogger.logError((Object)this, methodName, e);
            this.docDisplayed = false;
        }
        catch (InvocationTargetException e) {
            AppletLogger.logError((Object)this, methodName, e);
            this.docDisplayed = false;
        }
        AppletLogger.logExit(this, methodName);
        return this.docDisplayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean swingDisplayDocument(String docUrl, String docName, String serverType, DocPrivileges docPrivs, boolean annotationsEditable, boolean documentEditable, InitialView initialView) {
        boolean closed;
        String methodName = "swingDisplayDocument";
        AppletLogger.logEntry(this, methodName);
        if (this.document == null) {
            closed = true;
        } else {
            AppletLogger.logInfo(this, methodName, "Prompting prior to closing old doc");
            if (this.info.gdv.promptBeforeClosing(this.document)) {
                AppletLogger.logInfo(this, methodName, "Closing old document in gdv");
                CMBGenericDocViewer cMBGenericDocViewer = this.info.gdv;
                synchronized (cMBGenericDocViewer) {
                    this.info.gdv.closeDocument(this.document);
                }
                this.info.docToURL.remove(this.document);
                editableDocumentsMap.remove(this.document);
                if (this.annoSet != null) {
                    editableAnnotationsMap.remove(this.annoSet);
                }
                this.info.docToDocName.remove(this.document);
                this.info.docToServerType.remove(this.document);
                this.document = null;
                closed = true;
            } else {
                closed = false;
            }
        }
        if (closed) {
            Enumeration keys = this.info.docToURL.keys();
            while (keys.hasMoreElements()) {
                CMBDocument possibleDocument = (CMBDocument)keys.nextElement();
                if (this.info.docToURL.get(possibleDocument) == null || !this.info.docToURL.get(possibleDocument).equals(docUrl)) continue;
                this.document = possibleDocument;
            }
            if (this.document != null) {
                AppletLogger.logInfo(this, methodName, "CMBDocument for document found, activating document");
                this.activate();
            } else {
                AppletLogger.logInfo(this, methodName, "CMBDocument for document not found, opening document");
                OpenDocumentThread openDocumentThread = new OpenDocumentThread(docUrl, docName, serverType, docPrivs, annotationsEditable, documentEditable, initialView);
                openDocumentThread.start();
            }
        }
        AppletLogger.logExit(this, methodName);
        return closed;
    }

    public void focusViewer() {
        String methodName = "focusViewer";
        AppletLogger.logEntry(this, methodName);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (!ViewerApplet.this.docClosed) {
                        ViewerApplet.this.requestFocus();
                    }
                }
            });
        }
        catch (Exception e) {
            AppletLogger.logError((Object)this, methodName, e);
            this.docDisplayed = false;
        }
        AppletLogger.logExit(this, methodName);
    }

    public boolean promptBeforeClosing() {
        String methodName = "promptBeforeClosing";
        AppletLogger.logEntry(this, methodName);
        this.okToClose = false;
        if (this.document == null) {
            AppletLogger.logInfo(this, methodName, "document already closed");
            this.okToClose = true;
        } else {
            AppletLogger.logInfo(this, methodName, "prompting");
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        String methodName = "run";
                        try {
                            if (ViewerApplet.this.info.gdv.promptBeforeClosing(ViewerApplet.this.document)) {
                                AppletLogger.logInfo(this, methodName, "okay to continue with close");
                                ViewerApplet.this.okToClose = true;
                            }
                        }
                        catch (Exception e) {
                            AppletLogger.logInfo(this, methodName, "exception occured, likely due to document open partially completed: " + e.getClass().getName());
                            ViewerApplet.this.okToClose = true;
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                AppletLogger.logError((Object)this, methodName, e);
            }
            catch (InvocationTargetException e) {
                AppletLogger.logError((Object)this, methodName, e);
            }
        }
        AppletLogger.logExit(this, methodName);
        return this.okToClose;
    }

    public boolean closeDocument() {
        return this.closeDocument(true, true);
    }

    public void jsCloseDocumentNoPrompt() {
        String methodName = "closeAndUnlockDocumentWithNoPrompting";
        AppletLogger.logEntry(this, methodName);
        this.inJSCall = true;
        this.closeDocument(true, false);
        this.inJSCall = false;
        AppletLogger.logExit(this, methodName);
    }

    public void jsSave() {
        String methodName = "saveAnnotations";
        AppletLogger.logEntry(this, methodName);
        this.inJSCall = true;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ViewerApplet.this.info.gdv.save();
                }
            });
        }
        catch (InterruptedException e) {
            AppletLogger.logError((Object)this, methodName, e);
        }
        catch (InvocationTargetException e) {
            AppletLogger.logError((Object)this, methodName, e);
        }
        this.inJSCall = false;
        AppletLogger.logExit(this, methodName);
    }

    public boolean closeDocument(final boolean unlock, final boolean prompt) {
        String methodName = "closeDocument";
        AppletLogger.logEntry(this, methodName);
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.docClosed = this.swingCloseDocument(unlock, prompt);
            } else {
                Runnable swingCloseDocument = new Runnable(){

                    public void run() {
                        ViewerApplet.this.docClosed = ViewerApplet.this.swingCloseDocument(unlock, prompt);
                    }
                };
                if (this.inJSCall && this.jsListener != null) {
                    AppletLogger.logInfo(this, methodName, "Invoking to close the document.");
                    this.jsListener.invokeAndWait(swingCloseDocument);
                } else {
                    SwingUtilities.invokeAndWait(swingCloseDocument);
                }
            }
        }
        catch (InterruptedException e) {
            AppletLogger.logError((Object)this, methodName, e);
        }
        catch (InvocationTargetException e) {
            AppletLogger.logError((Object)this, methodName, e);
        }
        AppletLogger.logExit(this, methodName);
        return this.docClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean swingCloseDocument(boolean unlock, boolean prompt) {
        String methodName = "swingCloseDocument";
        AppletLogger.logEntry(this, methodName);
        boolean closed = false;
        if (this.docClosed || this.document == null) {
            AppletLogger.logInfo(this, methodName, "Document already closed");
            AppletLogger.logExit(this, methodName);
            return true;
        }
        CMBGenericDocViewer cMBGenericDocViewer = this.info.gdv;
        synchronized (cMBGenericDocViewer) {
            boolean okToClose = false;
            if (prompt) {
                AppletLogger.logInfo(this, methodName, "Prompting prior to closing");
                okToClose = this.info.gdv.promptBeforeClosing(this.document);
            } else {
                okToClose = true;
            }
            if (okToClose) {
                AppletLogger.logInfo(this, methodName, "Closing document in gdv");
                this.info.gdv.closeDocument(this.document, prompt);
                closed = true;
            }
        }
        if (closed && unlock) {
            this.unlockDocument(!prompt);
        }
        if (closed) {
            this.info.docToURL.remove(this.document);
            editableDocumentsMap.remove(this.document);
            if (this.annoSet != null) {
                editableAnnotationsMap.remove(this.annoSet);
                docPrivilegesMap.remove(this.annoSet);
            }
            this.info.docToDocName.remove(this.document);
            this.info.docToServerType.remove(this.document);
            docPrivilegesMap.remove(this.document);
            docLoadInfoMap.remove(this.document);
            this.document = null;
        }
        AppletLogger.logExit(this, methodName);
        return closed;
    }

    void unlockDocument(boolean cancelCheckout) {
        String methodName = "unlockDocument";
        AppletLogger.logEntry(this, methodName);
        if (this.locked) {
            this.statusBar.setStatusMessage(ViewerApplet.getMessage("viewerApplet_statusUnlocking"));
            this.info.gdv.setCursor(new Cursor(3));
            if (!ViewerApplet.isDocumentEditable(this.document)) {
                URL docURL = (URL)this.info.docToURL.get(this.document);
                String serverType = (String)this.info.docToServerType.get(this.document);
                if (serverType != null && serverType.equals("cm")) {
                    try {
                        StringBuffer sbCheckInURL = new StringBuffer("unlock.do");
                        sbCheckInURL.append("?alt_output=JSON");
                        if (AppletLogger.isDebugLogged()) {
                            sbCheckInURL.append("&debug=true");
                        }
                        sbCheckInURL.append("&").append(docURL.getQuery());
                        URL checkInURL = new URL(docURL, sbCheckInURL.toString());
                        AppletLogger.logInfo(this, methodName, "Invoking checkin for CM: " + checkInURL.toString());
                        URLConnection checkInURLConn = SecurityUtil.openConnection(checkInURL);
                        try {
                            InputStream checkInResponseStream = checkInURLConn.getInputStream();
                            ByteArrayOutputStream responseBytes = new ByteArrayOutputStream();
                            byte[] buf = new byte[1024];
                            int len = checkInResponseStream.read(buf);
                            while (len > 0) {
                                responseBytes.write(buf, 0, len);
                                len = checkInResponseStream.read(buf);
                            }
                            AppletLogger.logInfo(this, methodName, "Server returned JSON: " + responseBytes.toString("UTF-8"));
                            JSONObject jsonObject = ViewerApplet.parseJSONObject(responseBytes.toString("UTF-8"));
                            if (jsonObject.containsKey(ERRORS)) {
                                MessageDialog.showErrorDialog((Component)this.info.gdv, ViewerApplet.getMessage("viewerApplet_appletTitle"), ViewerApplet.getMessage("viewerApplet_unlockFailed"), jsonObject);
                            } else {
                                AppletLogger.logInfo(this, methodName, "Appears that document was checked in successfully");
                                this.locked = false;
                            }
                        }
                        catch (Exception e) {
                            AppletLogger.logInfo(this, methodName, "Couldn't open or parse JSON response from server: " + e);
                            AppletLogger.logError((Object)this, methodName, e);
                        }
                    }
                    catch (Exception e) {
                        AppletLogger.logError((Object)this, methodName, e);
                    }
                } else if (serverType != null && serverType.equals("ci")) {
                    try {
                        URL checkInURL = new URL(docURL, "unlock.do?alt_output=JSON&" + docURL.getQuery());
                        AppletLogger.logInfo(this, methodName, "Invoking checkin for CM: " + checkInURL.toString());
                        URLConnection checkInURLConn = SecurityUtil.openConnection(checkInURL);
                        try {
                            InputStream checkInResponseStream = checkInURLConn.getInputStream();
                            ByteArrayOutputStream responseBytes = new ByteArrayOutputStream();
                            byte[] buf = new byte[1024];
                            int len = checkInResponseStream.read(buf);
                            while (len > 0) {
                                responseBytes.write(buf, 0, len);
                                len = checkInResponseStream.read(buf);
                            }
                            AppletLogger.logInfo(this, methodName, "Server returned JSON: " + responseBytes.toString("UTF-8"));
                            JSONObject jsonObject = ViewerApplet.parseJSONObject(responseBytes.toString("UTF-8"));
                            if (jsonObject.containsKey(ERRORS)) {
                                MessageDialog.showErrorDialog((Component)this.info.gdv, ViewerApplet.getMessage("viewerApplet_appletTitle"), ViewerApplet.getMessage("viewerApplet_lockFailed"), jsonObject);
                            } else {
                                AppletLogger.logInfo(this, methodName, "Appears that document was checked in successfully");
                                this.locked = false;
                            }
                        }
                        catch (Exception e) {
                            AppletLogger.logInfo(this, methodName, "Couldn't open or parse JSON response from server: " + e);
                        }
                    }
                    catch (Exception e) {
                        AppletLogger.logError((Object)this, methodName, e);
                    }
                } else {
                    this.locked = false;
                }
                this.info.gdv.setCursor(new Cursor(0));
                this.statusBar.clearStatusMessage();
            }
        }
        AppletLogger.logExit(this, methodName);
    }

    CMBBookmark[] retrieveBookmarks() {
        String methodName = "retrieveBookmarks";
        AppletLogger.logEntry(this, methodName);
        CMBBookmark[] bookmarks = null;
        String serverType = (String)this.info.docToServerType.get(this.document);
        if (serverType != null && serverType.equals("cm")) {
            this.statusBar.setStatusMessage(ViewerApplet.getMessage("viewerApplet_statusRetrievingBookmarks"));
            this.info.gdv.setCursor(new Cursor(3));
            URL docURL = (URL)this.info.docToURL.get(this.document);
            try {
                HttpURLConnection httpUrlConnection;
                URL retrieveBookmarksURL = new URL(docURL, "getBookmarks.do?" + docURL.getQuery());
                AppletLogger.logInfo(this, methodName, "Invoking retrieve bookmarks for CM: " + retrieveBookmarksURL.toString());
                URLConnection urlConnection = SecurityUtil.openConnection(retrieveBookmarksURL);
                InputStream responseStream = urlConnection instanceof HttpURLConnection ? ((httpUrlConnection = (HttpURLConnection)urlConnection).getResponseCode() != 200 ? httpUrlConnection.getErrorStream() : urlConnection.getInputStream()) : urlConnection.getInputStream();
                ByteArrayOutputStream responseBytes = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                int len = responseStream.read(buf);
                while (len > 0) {
                    responseBytes.write(buf, 0, len);
                    len = responseStream.read(buf);
                }
                AppletLogger.logInfo(this, methodName, "Server returned JSON: " + responseBytes.toString("UTF-8"));
                JSONObject jsonResponseObject = ViewerApplet.parseJSONObject(responseBytes.toString("UTF-8"));
                if (jsonResponseObject.containsKey(ERRORS)) {
                    AppletLogger.logError((Object)this, methodName, "Retrieve bookmarks request returned errors");
                    MessageDialog.showErrorDialog((Component)this.info.gdv, ViewerApplet.getMessage("viewerApplet_appletTitle"), ViewerApplet.getMessage("viewerApplet_retrieveBookmarksFailed"), jsonResponseObject);
                } else if (jsonResponseObject.containsKey("bookmarks")) {
                    AppletLogger.logInfo(this, methodName, "Retrieve bookmarks request was successful");
                    JSONArray jsonBookmarksArray = (JSONArray)jsonResponseObject.get("bookmarks");
                    bookmarks = new CMBBookmark[jsonBookmarksArray.size()];
                    for (int i = 0; i < bookmarks.length; ++i) {
                        JSONObject jsonBookmarkObject = (JSONObject)jsonBookmarksArray.get(i);
                        CMBBookmark bookmark = new CMBBookmark();
                        bookmark.setPageNumber(new Integer(jsonBookmarkObject.get("page").toString()));
                        bookmark.setName(jsonBookmarkObject.get("name").toString());
                        bookmark.setTimestamp(new Long(jsonBookmarkObject.get("timestamp").toString()));
                        bookmarks[i] = bookmark;
                    }
                    if (jsonResponseObject.containsKey("versioningPolicy")) {
                        String versioningPolicy = jsonResponseObject.get("versioningPolicy").toString();
                        this.optionallyVersioningBookmarks = versioningPolicy.equals("prompt");
                    }
                }
            }
            catch (Exception e) {
                AppletLogger.logError((Object)this, methodName, e);
                MessageDialog.showErrorDialog(this.info.gdv, ViewerApplet.getMessage("viewerApplet_appletTitle"), ViewerApplet.getMessage("viewerApplet_retrieveBookmarksFailed") + "\n\n" + e.getClass().getName() + " " + e.getMessage());
            }
            this.info.gdv.setCursor(new Cursor(0));
            this.statusBar.clearStatusMessage();
        }
        AppletLogger.logExit(this, methodName);
        return bookmarks;
    }

    boolean saveBookmarks(final CMBBookmark[] bookmarks) {
        String methodName = "updateBookmarks";
        AppletLogger.logEntry(this, methodName);
        boolean saved = false;
        URL docURL = (URL)this.info.docToURL.get(this.document);
        String serverType = (String)this.info.docToServerType.get(this.document);
        try {
            HttpURLConnection httpUrlConnection;
            JSONObject jsonRequestObject = new JSONObject();
            JSONArray jsonBookmarksArray = new JSONArray();
            for (int i = 0; i < bookmarks.length; ++i) {
                CMBBookmark bookmark = bookmarks[i];
                JSONObject jsonBookmarkObject = new JSONObject();
                JSONUtils.put(jsonBookmarkObject, "page", bookmark.getPageNumber());
                jsonBookmarkObject.put("name", bookmark.getName());
                JSONUtils.put(jsonBookmarkObject, "timestamp", bookmark.getTimestamp());
                jsonBookmarksArray.add(jsonBookmarkObject);
            }
            jsonRequestObject.put("bookmarks", jsonBookmarksArray);
            boolean newVersion = false;
            if (this.optionallyVersioningBookmarks) {
                AppletLogger.logInfo(this, methodName, "Prompting for new version");
                int reply = JOptionPane.showConfirmDialog(null, ViewerApplet.getMessage("viewerApplet_newVersionPrompt"), ViewerApplet.getMessage("viewerApplet_appletTitle"), 0);
                if (reply == 0) {
                    newVersion = true;
                } else if (reply == 1) {
                    newVersion = false;
                } else {
                    AppletLogger.logExit(this, methodName);
                    return false;
                }
            }
            JSONUtils.put(jsonRequestObject, "newVersion", newVersion);
            byte[] jsonRequestBytes = jsonRequestObject.toString().getBytes("UTF-8");
            this.statusBar.setStatusMessage(ViewerApplet.getMessage("viewerApplet_statusSavingBookmarks"));
            this.info.gdv.setCursor(new Cursor(3));
            URL updateBookmarksURL = new URL(docURL, "updateBookmarks.do?" + docURL.getQuery());
            AppletLogger.logInfo(this, methodName, "Invoking update bookmarks for CM: " + updateBookmarksURL.toString());
            URLConnection urlConnection = updateBookmarksURL.openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            if (urlConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)urlConnection).setRequestMethod("POST");
            }
            urlConnection.setRequestProperty("Content-Type", "text/json");
            urlConnection.setRequestProperty("Content-Length", String.valueOf(jsonRequestBytes.length));
            OutputStream requestStream = urlConnection.getOutputStream();
            requestStream.write(jsonRequestBytes);
            requestStream.flush();
            InputStream responseStream = urlConnection instanceof HttpURLConnection ? ((httpUrlConnection = (HttpURLConnection)urlConnection).getResponseCode() != 200 ? httpUrlConnection.getErrorStream() : urlConnection.getInputStream()) : urlConnection.getInputStream();
            ByteArrayOutputStream responseBytes = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int len = responseStream.read(buf);
            while (len > 0) {
                responseBytes.write(buf, 0, len);
                len = responseStream.read(buf);
            }
            AppletLogger.logInfo(this, methodName, "Server returned JSON: " + responseBytes.toString("UTF-8"));
            this.info.gdv.setCursor(new Cursor(0));
            this.statusBar.clearStatusMessage();
            JSONObject jsonResponseObject = ViewerApplet.parseJSONObject(responseBytes.toString("UTF-8"));
            if (jsonResponseObject.containsKey(ERRORS)) {
                MessageDialog.showErrorDialog((Component)this.info.gdv, ViewerApplet.getMessage("viewerApplet_appletTitle"), ViewerApplet.getMessage("viewerApplet_saveBookmarksFailed"), jsonResponseObject);
            } else {
                AppletLogger.logInfo(this, methodName, "Save bookmarks completed successfully");
                saved = true;
            }
        }
        catch (Exception e) {
            AppletLogger.logError((Object)this, methodName, e);
            this.info.gdv.setCursor(new Cursor(0));
            this.statusBar.clearStatusMessage();
            MessageDialog.showErrorDialog(this.info.gdv, ViewerApplet.getMessage("viewerApplet_appletTitle"), ViewerApplet.getMessage("viewerApplet_saveBookmarksFailed") + "\n\n" + e.getClass().getName() + " " + e.getMessage());
        }
        if (saved) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Class<JSObject> clazz = JSObject.class;
                        synchronized (JSObject.class) {
                            JSObject jsObject = JSObject.getWindow(ViewerApplet.this);
                            jsObject.call("bookmarksUpdated", new String[]{String.valueOf(bookmarks.length)});
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    {
                        return;
                    }
                }
            });
        }
        AppletLogger.logExit(this, methodName);
        return saved;
    }

    public CMBGenericDocViewer getGenericDocViewer() {
        return this.info.gdv;
    }

    public CMBDocument getDocument() {
        return this.document;
    }

    private static String getFileNameWithPath(String filename) {
        int extIndex = filename.lastIndexOf(46);
        String partName = extIndex != -1 ? filename.substring(0, extIndex) : filename;
        return partName;
    }

    private String getContentType(String docURLString, URLConnection docUrlConnection) {
        String methodName = "getContentType";
        AppletLogger.logEntry(this, methodName);
        String contentType = this.getParameter(APPLET_PARAM_CONTENT_TYPE);
        AppletLogger.logInfo(this, methodName, "Content type parameter: " + contentType);
        if (contentType == null) {
            contentType = docUrlConnection.getContentType();
            AppletLogger.logInfo(this, methodName, "Content type from response header: " + contentType);
            if (contentType != null && contentType.indexOf(59) > 0) {
                contentType = contentType.substring(0, contentType.indexOf(59)).trim();
            }
            if (contentType != null && (contentType.equals("application/binary") || contentType.equals("text/plain") || contentType.equals("content/unknown"))) {
                contentType = null;
            }
        }
        if (contentType == null) {
            contentType = docURLString.substring(docURLString.lastIndexOf(46) + 1);
            AppletLogger.logInfo(this, methodName, "Content type parsed from URL: " + contentType);
        }
        if (contentType != null && contentType.length() <= 4) {
            contentType = this.guessMimeType(contentType);
            AppletLogger.logInfo(this, methodName, "Content type after guessing from extension: " + contentType);
        }
        AppletLogger.logInfo(this, methodName, "Content type: " + contentType);
        AppletLogger.logExit(this, methodName);
        return contentType;
    }

    private String getContentEncoding(URLConnection docUrlConnection) {
        String methodName = "getContentEncoding";
        AppletLogger.logEntry(this, methodName);
        String contentEncoding = docUrlConnection.getContentEncoding();
        if (contentEncoding == null) {
            String contentType = docUrlConnection.getContentType();
            if (contentType != null && contentType.indexOf("charset=") > 0) {
                contentEncoding = contentType.substring(contentType.indexOf("charset=") + 8).trim();
            }
            if (contentEncoding == null) {
                contentEncoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
            }
        }
        AppletLogger.logExit(this, methodName);
        return contentEncoding;
    }

    private String guessMimeType(String extension) {
        if ((extension = extension.toLowerCase()).equals("gif")) {
            return "image/gif";
        }
        if (extension.equals("jpg") || extension.equals("jpeg")) {
            return "image/jpeg";
        }
        if (extension.equals("tif") || extension.equals("tiff")) {
            return "image/tiff";
        }
        if (extension.equals("pdf")) {
            return "application/pdf";
        }
        if (extension.equals("mda")) {
            return "application/vnd.ibm.modcap";
        }
        if (extension.equals("afp")) {
            return "application/afp";
        }
        if (extension.equals("lin")) {
            return "application/line";
        }
        if (extension.equals("txt")) {
            return "text/plain";
        }
        if (extension.equals("htm") || extension.equals("html")) {
            return "text/html";
        }
        if (extension.equals("rtf")) {
            return "text/richtext";
        }
        if (extension.equals("doc")) {
            return "application/msword";
        }
        if (extension.equals("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (extension.equals("lwp")) {
            return "application/vnd.lotus-wordpro";
        }
        if (extension.equals("123")) {
            return "application/vnd.lotus-1-2-3";
        }
        if (extension.equals("prz")) {
            return "application/vnd.lotus-freelance";
        }
        if (extension.equals("xls")) {
            return "application/vnd.ms-excel";
        }
        if (extension.equals("wp")) {
            return "application/wordperfect5.1";
        }
        if (extension.equals("bmp")) {
            return "image/bmp";
        }
        if (extension.equals("pcx")) {
            return "image/pcx";
        }
        if (extension.equals("dcx")) {
            return "image/dcx";
        }
        if (extension.equals("xml")) {
            return "text/xml";
        }
        return "application/binary";
    }

    public int getPageNumber() {
        return this.info.gdv.getCurrentPageNumber();
    }

    public boolean isDirty() {
        String methodName = "isDirty";
        AppletLogger.logEntry(this, methodName);
        boolean isDirty = false;
        if (this.document != null && this.document.isModified()) {
            AppletLogger.logInfo(this, methodName, "Document is modified");
            isDirty = true;
        }
        if (this.annoSet != null && this.annoSet.isDirty()) {
            AppletLogger.logInfo(this, methodName, "Annotation set is dirty");
            isDirty = true;
        }
        AppletLogger.logExit(this, methodName);
        return isDirty;
    }

    public boolean isPrinting() {
        String methodName = "isPrinting";
        AppletLogger.logEntry(this, methodName);
        boolean isPrinting = false;
        if (this.document != null && this.info.gdv.isDocumentPrinting(this.document)) {
            AppletLogger.logInfo(this, methodName, "Document is printing");
            isPrinting = true;
        }
        AppletLogger.logExit(this, methodName);
        return isPrinting;
    }

    void editDocument() {
        if (!this.locked) {
            this.lockDocument();
        }
        if (this.locked) {
            this.refreshDocument(true, false);
        }
    }

    void lockDocument() {
        block12: {
            String methodName = "lockDocument";
            AppletLogger.logEntry(this, methodName);
            this.statusBar.setStatusMessage(ViewerApplet.getMessage("viewerApplet_statusLocking"));
            String serverType = (String)this.info.docToServerType.get(this.document);
            if (serverType != null && serverType.equals("cm")) {
                try {
                    URL docURL = (URL)this.info.docToURL.get(this.document);
                    String checkOutFromParam = "checkout_from=viewer_applet";
                    URL checkOutURL = new URL(docURL, "lock.do?alt_output=JSON&" + checkOutFromParam + "&" + docURL.getQuery());
                    AppletLogger.logInfo(this, methodName, "Invoking checkout for CM: " + checkOutURL.toString());
                    URLConnection checkOutURLConn = SecurityUtil.openConnection(checkOutURL);
                    InputStream checkOutResponseStream = checkOutURLConn.getInputStream();
                    ByteArrayOutputStream responseBytes = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    int len = checkOutResponseStream.read(buf);
                    while (len > 0) {
                        responseBytes.write(buf, 0, len);
                        len = checkOutResponseStream.read(buf);
                    }
                    AppletLogger.logInfo(this, methodName, "Server returned JSON: " + responseBytes.toString("UTF-8"));
                    JSONObject jsonResponseObject = ViewerApplet.parseJSONObject(responseBytes.toString("UTF-8"));
                    if (jsonResponseObject.containsKey(ERRORS)) {
                        AppletLogger.logError((Object)this, methodName, "Checkout request returned errors");
                        MessageDialog.showErrorDialog((Component)this.info.gdv, ViewerApplet.getMessage("viewerApplet_appletTitle"), ViewerApplet.getMessage("viewerApplet_lockFailed"), jsonResponseObject);
                        break block12;
                    }
                    AppletLogger.logInfo(this, methodName, "Appears that document was checked out successfully");
                    this.locked = true;
                }
                catch (Exception e) {
                    AppletLogger.logError((Object)this, methodName, e);
                }
            } else if (serverType != null && serverType.equals("ci")) {
                try {
                    URL docURL = (URL)this.info.docToURL.get(this.document);
                    String checkOutFromParam = "checkout_from=viewer_applet";
                    URL checkOutURL = new URL(docURL, "lock.do?alt_output=JSON&" + checkOutFromParam + "&" + docURL.getQuery());
                    AppletLogger.logInfo(this, methodName, "Invoking checkout for CE: " + checkOutURL.toString());
                    URLConnection checkOutURLConn = SecurityUtil.openConnection(checkOutURL);
                    InputStream checkOutResponseStream = checkOutURLConn.getInputStream();
                    ByteArrayOutputStream responseBytes = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    int len = checkOutResponseStream.read(buf);
                    while (len > 0) {
                        responseBytes.write(buf, 0, len);
                        len = checkOutResponseStream.read(buf);
                    }
                    AppletLogger.logInfo(this, methodName, "Server returned JSON: " + responseBytes.toString("UTF-8"));
                    JSONObject jsonResponseObject = ViewerApplet.parseJSONObject(responseBytes.toString("UTF-8"));
                    if (jsonResponseObject.containsKey(ERRORS)) {
                        AppletLogger.logError((Object)this, methodName, "Checkout request returned errors");
                        MessageDialog.showErrorDialog((Component)this.info.gdv, ViewerApplet.getMessage("viewerApplet_appletTitle"), ViewerApplet.getMessage("viewerApplet_lockFailed"), jsonResponseObject);
                        break block12;
                    }
                    AppletLogger.logInfo(this, methodName, "Appears that document was checked out successfully");
                    this.locked = true;
                }
                catch (Exception e) {
                    AppletLogger.logError((Object)this, methodName, e);
                    MessageDialog.showErrorDialog(this.info.gdv, ViewerApplet.getMessage("viewerApplet_appletTitle"), ViewerApplet.getMessage("viewerApplet_lockFailed"));
                }
            } else {
                this.locked = true;
            }
        }
        this.statusBar.clearStatusMessage();
    }

    void refreshDocument(boolean editableAnnotations, boolean editableDocument) {
        String methodName = "refreshDocument";
        AppletLogger.logEntry(this, methodName);
        String docUrlString = this.info.docToURL.get(this.document).toString();
        String docName = (String)this.info.docToDocName.get(this.document);
        String serverType = (String)this.info.docToServerType.get(this.document);
        DocPrivileges docPrivs = (DocPrivileges)docPrivilegesMap.get(this.document);
        int pageNo = this.info.gdv.getCurrentPageNumber();
        double scale = this.info.gdv.getScale();
        Rectangle viewRect = this.info.gdv.getCurrentViewRectangle();
        InitialView initialView = new InitialView(pageNo, scale, viewRect);
        this.closeDocument(false, true);
        this.docClosed = false;
        this.displayDocument(docUrlString, docName, serverType, docPrivs, editableAnnotations, editableDocument, initialView);
        AppletLogger.logExit(this, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeMessages() {
        Class<ViewerApplet> clazz = ViewerApplet.class;
        synchronized (ViewerApplet.class) {
            if (messages == null) {
                messages = PropertyResourceBundle.getBundle("com.ibm.ecm.applets.AppletMessages");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static String getMessage(String key) {
        try {
            return messages.getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    static String getMessage(String key, String[] inserts) {
        try {
            String pattern = messages.getString(key);
            if (pattern == null) {
                return key;
            }
            return MessageFormat.format(pattern, inserts);
        }
        catch (Exception e) {
            return key;
        }
    }

    void setDefaultLocale() {
        block9: {
            String methodName = "setDefaultLocale";
            String language = this.getParameter(APPLET_PARAM_LANGUAGE);
            AppletLogger.logInfo(this, methodName, "language:" + language);
            String country = this.getParameter(APPLET_PARAM_COUNTRY);
            AppletLogger.logInfo(this, methodName, "country :" + country);
            String variant = this.getParameter(APPLET_PARAM_VARIANT);
            AppletLogger.logInfo(this, methodName, "variant:" + variant);
            try {
                Locale appletLocale = Locale.getDefault();
                if (variant != null && variant.length() > 0 && !variant.equals(appletLocale.getVariant())) {
                    appletLocale = new Locale(language, country, variant);
                } else if (country != null && country.length() > 0 && !country.equals(appletLocale.getCountry())) {
                    appletLocale = new Locale(language, country);
                } else if (language != null && language.length() > 0 && !language.equals(appletLocale.getLanguage())) {
                    appletLocale = new Locale(language);
                }
                if (appletLocale == null) break block9;
                try {
                    Locale.setDefault(appletLocale);
                }
                catch (SecurityException e) {
                    AppletLogger.logError((Object)this, methodName, e.getLocalizedMessage());
                }
                this.setLocale(appletLocale);
                AppletLogger.logInfo(this, methodName, "applet locale set to :" + appletLocale);
            }
            catch (Exception e) {
                AppletLogger.logInfo(this, methodName, "failed to set applet locale");
            }
        }
    }

    void substituteMessages(Properties properties) {
        Enumeration<Object> keysEnum = properties.keys();
        while (keysEnum.hasMoreElements()) {
            String key = (String)keysEnum.nextElement();
            String value = (String)properties.get(key);
            if (value == null || !value.startsWith("%")) continue;
            String messageKey = value.substring(1);
            value = ViewerApplet.getMessage(messageKey);
            properties.put(key, value);
        }
    }

    static JSONObject parseJSONObject(String jsonString) throws IOException {
        return SecurityUtil.parseJSON(jsonString);
    }

    static {
        propertiesMap = new HashMap<String, Properties>();
        sharedInstances = new Hashtable();
        savingToServer = false;
        openDocSynch = new Object();
        docPrivilegesMap = new Hashtable();
        editableDocumentsMap = new Hashtable();
        editableAnnotationsMap = new Hashtable();
        docLoadInfoMap = new Hashtable();
    }

    private static class DocSaveListener
    implements CMBGenericDocSaveListener {
        InstanceInfo info;
        HttpServletRequest request = null;

        public DocSaveListener(InstanceInfo info) {
            this.info = info;
        }

        public DocSaveListener(HttpServletRequest request, InstanceInfo info) {
            this.info = info;
            this.request = request;
        }

        public void genericDocSave(CMBGenericDocSaveEvent evt) {
            String methodName = "genericDocSave";
            AppletLogger.logEntry(this, methodName);
            if (evt.getSaveAsNew()) {
                throw new RuntimeException("Save as New not supported");
            }
            if (evt.getDocument().isModified()) {
                throw new RuntimeException("Document save not supported");
            }
            CMBAnnotationSet annoSet = evt.getAnnotationSet();
            CMBDocument document = evt.getDocument();
            try {
                URL annoURL;
                this.info.gdv.setCursor(new Cursor(3));
                String serverType = (String)this.info.docToServerType.get(document);
                URL docURL = (URL)this.info.docToURL.get(document);
                URLConnection annoURLConn = null;
                if (serverType != null && serverType.equals("cm")) {
                    annoURL = new URL(docURL, "updateAnnotations.do?alt_input=JSON&" + docURL.getQuery() + "&annotation_position=" + document.getAnnotationPosition());
                    AppletLogger.logInfo(this, methodName, "Updating annotations to CM: " + annoURL.toString());
                    annoURLConn = annoURL.openConnection();
                    annoURLConn.setDoOutput(true);
                    annoURLConn.setUseCaches(false);
                    if (annoURLConn instanceof HttpURLConnection) {
                        ((HttpURLConnection)annoURLConn).setRequestMethod("POST");
                    }
                } else if (serverType != null && serverType.equals("p8")) {
                    annoURL = new URL(docURL, "updateAnnotations.do?alt_input=JSON&" + docURL.getQuery() + "&annotation_position=" + document.getAnnotationPosition());
                    AppletLogger.logInfo(this, methodName, "Updating annotations to P8: " + annoURL.toString());
                    annoURLConn = annoURL.openConnection();
                    annoURLConn.setDoOutput(true);
                    annoURLConn.setUseCaches(false);
                    if (annoURLConn instanceof HttpURLConnection) {
                        ((HttpURLConnection)annoURLConn).setRequestMethod("POST");
                    }
                } else if (serverType != null && serverType.equals("ci")) {
                    annoURL = new URL(docURL, "updateAnnotations.do?alt_input=JSON&" + docURL.getQuery());
                    AppletLogger.logInfo(this, methodName, "Updating annotations to CE: " + annoURL.toString());
                    annoURLConn = annoURL.openConnection();
                    annoURLConn.setDoOutput(true);
                    annoURLConn.setUseCaches(false);
                    if (annoURLConn instanceof HttpURLConnection) {
                        ((HttpURLConnection)annoURLConn).setRequestMethod("POST");
                    }
                } else {
                    String docPath = docURL.getPath();
                    String baseName = docPath.substring(0, docPath.lastIndexOf(46));
                    URL annoURL2 = new URL(docURL, baseName + ".ann_json");
                    AppletLogger.logInfo(this, methodName, "Writing to annotation file " + annoURL2.toString());
                    annoURLConn = annoURL2.openConnection();
                    annoURLConn.setDoOutput(true);
                    if (annoURLConn instanceof HttpURLConnection) {
                        ((HttpURLConnection)annoURLConn).setRequestMethod("POST");
                    }
                }
                AppletLogger.logInfo(this, methodName, "Getting annotations as JSON");
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                savingToServer = true;
                annoSet.write(byteStream);
                savingToServer = false;
                byte[] annoBytes = byteStream.toByteArray();
                AppletLogger.logInfo(this, methodName, "Annotations written to byte array, length: " + annoBytes.length);
                if (annoBytes.length == 0) {
                    this.info.gdv.setCursor(new Cursor(0));
                    AppletLogger.logExit(this, methodName);
                    return;
                }
                AppletLogger.logInfo(this, methodName, "Invoking annotationSet.write");
                annoURLConn.setRequestProperty("Content-Type", "text/json");
                annoURLConn.setRequestProperty("Content-Length", String.valueOf(annoBytes.length));
                OutputStream annoOutputStream = annoURLConn.getOutputStream();
                annoOutputStream.write(annoBytes);
                annoOutputStream.flush();
                Object jsonErrors = null;
                try {
                    HttpURLConnection httpUrlConnection;
                    InputStream annoUpdateResponseStream = annoURLConn instanceof HttpURLConnection ? ((httpUrlConnection = (HttpURLConnection)annoURLConn).getResponseCode() != 200 ? httpUrlConnection.getErrorStream() : annoURLConn.getInputStream()) : annoURLConn.getInputStream();
                    ByteArrayOutputStream annotationBytes = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    int len = annoUpdateResponseStream.read(buf);
                    while (len > 0) {
                        annotationBytes.write(buf, 0, len);
                        len = annoUpdateResponseStream.read(buf);
                    }
                    AppletLogger.logInfo(this, methodName, "Server returned JSON: " + annotationBytes.toString("UTF-8"));
                    JSONObject jsonResponseObject = ViewerApplet.parseJSONObject(annotationBytes.toString("UTF-8"));
                    if (annoURLConn instanceof HttpURLConnection) {
                        HttpURLConnection httpAnnoURLConn = (HttpURLConnection)annoURLConn;
                        int responseCode = httpAnnoURLConn.getResponseCode();
                        AppletLogger.logInfo(this, methodName, "Http response code: " + responseCode);
                        if (responseCode >= 400 || jsonErrors != null) {
                            MessageDialog.showErrorDialog((Component)this.info.gdv, ViewerApplet.getMessage("viewerApplet_appletTitle"), ViewerApplet.getMessage("viewerApplet_annotationSaveFailed"), jsonResponseObject);
                        } else {
                            annoSet.setDirty(false);
                        }
                    } else {
                        annoSet.setDirty(false);
                    }
                }
                catch (Exception e) {
                    AppletLogger.logInfo(this, methodName, "Couldn't open or parse JSON response from server: " + e);
                }
                this.info.gdv.setCursor(new Cursor(0));
            }
            catch (Exception e) {
                savingToServer = false;
                AppletLogger.logError((Object)this, methodName, e);
            }
            AppletLogger.logExit(this, methodName);
        }
    }

    private class OpenDocumentThread
    extends Thread {
        private String docUrlString;
        private String docName;
        private String serverType;
        private DocPrivileges docPrivs;
        private boolean annotationsEditable;
        private boolean documentEditable;
        private InitialView initialView;
        private InputStream docInputStream;

        public OpenDocumentThread(String docUrlString, String docName, String serverType, DocPrivileges docPrivs, boolean annotationsEditable, boolean documentEditable, InitialView initialView) {
            super(ViewerApplet.this.appletThreadGroup, "ViewerApplet.OpenDocumentThread");
            this.docUrlString = docUrlString;
            this.docName = docName;
            this.serverType = serverType;
            this.docPrivs = docPrivs;
            this.annotationsEditable = annotationsEditable;
            this.documentEditable = documentEditable;
            this.initialView = initialView;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object = openDocSynch;
            synchronized (object) {
                String methodName = "run";
                AppletLogger.logEntry(this, methodName);
                AppletLogger.logInfo(this, methodName, "docUrl=" + this.docUrlString);
                AppletLogger.logInfo(this, methodName, "serverType=" + this.serverType);
                AppletLogger.logInfo(this, methodName, "docPrivs=" + this.docPrivs);
                if (ViewerApplet.this.terminating) {
                    AppletLogger.logInfo(this, methodName, "Viewer closed, terminating open early");
                    return;
                }
                String updatedDocUrlString = this.docUrlString;
                if (this.serverType != null) {
                    if (this.serverType.equals("od")) {
                        AppletLogger.logInfo(this, methodName, "Adding transform=native to Url for OD");
                        AppletLogger.logInfo(this, methodName, "Adding include_segment_info to Url for OD");
                        updatedDocUrlString = this.docUrlString + "&transform=native&include_segment_info=true";
                    } else if (this.serverType.equals("cm")) {
                        AppletLogger.logInfo(this, methodName, "Adding transform=native to Url for CM");
                        updatedDocUrlString = this.docUrlString + "&transform=native";
                    }
                }
                try {
                    CMBBookmark[] tbookmarks;
                    void var15_28;
                    Object annoURL;
                    String charset;
                    String strMime;
                    URL docURL = new URL(ViewerApplet.this.getCodeBase(), updatedDocUrlString);
                    ViewerApplet.this.info.gdv.setCursor(Cursor.getPredefinedCursor(3));
                    ViewerApplet.this.statusBar.setStatusMessage(ViewerApplet.getMessage("viewerApplet_statusRequestingDocument"));
                    int contentLength = 0;
                    int partCount = 1;
                    int partPageCount = 0;
                    int lastPartPageCount = 0;
                    int annotationPartCount = 0;
                    boolean retryRetrieve = false;
                    do {
                        HttpURLConnection httpDocURLConn;
                        HttpURLConnection httpDocUrlConnection;
                        URLConnection docURLConn = SecurityUtil.openConnection(docURL, !retryRetrieve);
                        retryRetrieve = false;
                        if (ViewerApplet.this.terminating) {
                            AppletLogger.logInfo(this, methodName, "Viewer closed, terminating open early");
                            ViewerApplet.this.statusBar.clearStatusMessage();
                            return;
                        }
                        if (docURLConn instanceof HttpURLConnection && (httpDocUrlConnection = (HttpURLConnection)docURLConn).getResponseCode() != 200) {
                            throw new HttpException(httpDocUrlConnection.getResponseCode(), httpDocUrlConnection.getResponseMessage());
                        }
                        strMime = ViewerApplet.this.getContentType(this.docUrlString, docURLConn);
                        if (ViewerApplet.this.terminating) {
                            AppletLogger.logInfo(this, methodName, "Viewer closed, terminating open early");
                            ViewerApplet.this.statusBar.clearStatusMessage();
                            this.closeDocInputStream();
                            return;
                        }
                        charset = ViewerApplet.this.getContentEncoding(docURLConn);
                        AppletLogger.logInfo(this, methodName, "Content encoding: " + charset);
                        if (this.serverType != null && this.serverType.equals("od")) {
                            AppletLogger.logInfo(this, methodName, "Getting od segment info headers");
                            if (docURLConn instanceof HttpURLConnection) {
                                httpDocURLConn = (HttpURLConnection)docURLConn;
                                partCount = httpDocURLConn.getHeaderFieldInt("Segment-Count", partCount);
                                partPageCount = httpDocURLConn.getHeaderFieldInt("Segment-Page-Count", partPageCount);
                                lastPartPageCount = httpDocURLConn.getHeaderFieldInt("Segment-Last-Page-Count", lastPartPageCount);
                                if (partCount < 1) {
                                    partCount = 1;
                                }
                            }
                            AppletLogger.logInfo(this, methodName, "Simply opening the docInputStream");
                            contentLength = docURLConn.getContentLength();
                            this.docInputStream = docURLConn.getInputStream();
                        } else {
                            if (docURLConn instanceof HttpURLConnection) {
                                httpDocURLConn = (HttpURLConnection)docURLConn;
                                AppletLogger.logDebug(this, methodName, "Getting Part-Count");
                                String string = httpDocURLConn.getHeaderField("Part-Count");
                                if (string != null) {
                                    try {
                                        partCount = Integer.parseInt(string);
                                    }
                                    catch (NumberFormatException e) {
                                        // empty catch block
                                    }
                                }
                                AppletLogger.logDebug(this, methodName, "Getting Annotation-Part-Count");
                                String annotationPartCountString = httpDocURLConn.getHeaderField("Annotation-Part-Count");
                                if (annotationPartCountString != null) {
                                    try {
                                        annotationPartCount = Integer.parseInt(annotationPartCountString);
                                    }
                                    catch (NumberFormatException e) {
                                        // empty catch block
                                    }
                                }
                                AppletLogger.logDebug(this, methodName, "Getting direct-retrieve-url");
                                String directRetrieveUrlString = httpDocURLConn.getHeaderField("direct-retrieve-url");
                                if (directRetrieveUrlString != null) {
                                    URL directDocURL = new URL(ViewerApplet.this.getCodeBase(), directRetrieveUrlString);
                                    try {
                                        docURLConn = directDocURL.openConnection();
                                        docURLConn.connect();
                                    }
                                    catch (Exception e) {
                                        retryRetrieve = true;
                                        docURLConn = null;
                                    }
                                }
                            }
                            if (docURLConn != null) {
                                AppletLogger.logDebug(this, methodName, "Getting just the InputStream");
                                contentLength = 0;
                                this.docInputStream = docURLConn.getInputStream();
                            }
                        }
                        if (!ViewerApplet.this.terminating) continue;
                        AppletLogger.logInfo(this, methodName, "Viewer closed, terminating open early");
                        ViewerApplet.this.statusBar.clearStatusMessage();
                        this.closeDocInputStream();
                        return;
                    } while (retryRetrieve);
                    AppletLogger.logInfo(this, methodName, "Invoking loadDocument");
                    ProgressMonitoringStream progressMonitoringStream = new ProgressMonitoringStream(this.docInputStream, ViewerApplet.this.statusBar, contentLength);
                    ViewerApplet.this.statusBar.setStatusMessage(ViewerApplet.getMessage("viewerApplet_statusRetrievingDocument"));
                    ViewerApplet.this.document = ViewerApplet.this.info.docServices.loadDocument(progressMonitoringStream, contentLength, partCount, strMime, strMime, null, null, charset);
                    if (ViewerApplet.this.terminating) {
                        AppletLogger.logInfo(this, methodName, "Viewer closed, terminating open early");
                        ViewerApplet.this.statusBar.clearStatusMessage();
                        this.closeDocInputStream();
                        return;
                    }
                    DocLoadInfo docLoadInfo = new DocLoadInfo(null, null, this.docUrlString, strMime, charset, this.serverType, partCount, partPageCount, lastPartPageCount);
                    docLoadInfoMap.put(ViewerApplet.this.document, docLoadInfo);
                    ViewerApplet.this.info.docToURL.put(ViewerApplet.this.document, docURL);
                    if (this.docName != null) {
                        ViewerApplet.this.info.docToDocName.put(ViewerApplet.this.document, this.docName);
                    }
                    if (this.serverType != null) {
                        ViewerApplet.this.info.docToServerType.put(ViewerApplet.this.document, this.serverType);
                    }
                    editableDocumentsMap.put(ViewerApplet.this.document, new Boolean(this.documentEditable));
                    if (this.docPrivs != null) {
                        docPrivilegesMap.put(ViewerApplet.this.document, this.docPrivs);
                    }
                    Object var15_23 = null;
                    if (this.docPrivs != null && this.docPrivs.viewAnnotationsPriv) {
                        URLConnection annoURLConn;
                        URL annoURL2;
                        if (this.serverType != null && this.serverType.equals("cm")) {
                            if (this.annotationsEditable || annotationPartCount >= 1) {
                                annoURL2 = new URL(docURL, "getAnnotations.do?alt_output=JSON&" + docURL.getQuery() + "&annotation_position=" + ViewerApplet.this.document.getAnnotationPosition());
                                AppletLogger.logInfo(this, methodName, "Requesting annotations from CM: " + annoURL2.toString());
                                annoURLConn = SecurityUtil.openConnection(annoURL2);
                                InputStream inputStream = annoURLConn.getInputStream();
                            }
                        } else if (this.serverType != null && this.serverType.equals("p8")) {
                            annoURL2 = new URL(docURL, "getAnnotations.do?alt_output=JSON&" + docURL.getQuery() + "&annotation_position=" + ViewerApplet.this.document.getAnnotationPosition());
                            AppletLogger.logInfo(this, methodName, "Requesting annotations from P8: " + annoURL2.toString());
                            annoURLConn = SecurityUtil.openConnection(annoURL2);
                            InputStream inputStream = annoURLConn.getInputStream();
                        } else if (this.serverType != null && this.serverType.equals("ci")) {
                            annoURL2 = new URL(docURL, "getAnnotations.do?alt_output=JSON&" + docURL.getQuery());
                            AppletLogger.logInfo(this, methodName, "Requesting annotations from CE: " + annoURL2.toString());
                            annoURLConn = SecurityUtil.openConnection(annoURL2);
                            InputStream inputStream = annoURLConn.getInputStream();
                        } else if (this.serverType == null || !this.serverType.equals("od")) {
                            String docPath = docURL.getPath();
                            String baseName = docPath.lastIndexOf(46) > 0 ? docPath.substring(0, docPath.lastIndexOf(46)) : docPath;
                            annoURL = new URL(docURL, baseName + ".ann_json");
                            URLConnection annoURLConn2 = SecurityUtil.openConnection((URL)annoURL);
                            try {
                                InputStream inputStream = annoURLConn2.getInputStream();
                                AppletLogger.logInfo(this, methodName, "Using annotation file " + ((URL)annoURL).toString());
                            }
                            catch (FileNotFoundException e) {
                                AppletLogger.logInfo(this, methodName, "No annotation file found named " + ((URL)annoURL).toString());
                            }
                        }
                    }
                    if (var15_28 == null) {
                        AppletLogger.logInfo(this, methodName, "No annotations or server type doesn't support annotations.");
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("{}".getBytes());
                    }
                    if (ViewerApplet.this.terminating) {
                        AppletLogger.logInfo(this, methodName, "Viewer closed, terminating open early");
                        ViewerApplet.this.statusBar.clearStatusMessage();
                        this.closeDocInputStream();
                        return;
                    }
                    if (ViewerApplet.this.info.annoServices != null) {
                        try {
                            void var15_30;
                            AppletLogger.logInfo(this, methodName, "Invoking loadAnnotations");
                            AppletLogger.logInfo(this, methodName, "annotationPosition = " + ViewerApplet.this.document.getAnnotationPosition());
                            ViewerApplet.this.annoSet = ViewerApplet.this.info.annoServices.loadAnnotationSet((InputStream)var15_30, "text/json", ViewerApplet.this.document.getAnnotationPosition(), 1, 0);
                        }
                        catch (Exception e) {
                            if (ViewerApplet.this.terminating) return;
                            AppletLogger.logError((Object)this, methodName, e);
                            return;
                        }
                    }
                    if (ViewerApplet.this.terminating) {
                        AppletLogger.logInfo(this, methodName, "Viewer closed, terminating open early");
                        ViewerApplet.this.statusBar.clearStatusMessage();
                        this.closeDocInputStream();
                        return;
                    }
                    if (ViewerApplet.this.annoSet != null) {
                        editableAnnotationsMap.put(ViewerApplet.this.annoSet, new Boolean(this.annotationsEditable));
                        if (this.docPrivs != null) {
                            docPrivilegesMap.put(ViewerApplet.this.annoSet, this.docPrivs);
                        }
                    }
                    if (annotationPartCount >= 2 && this.docPrivs != null && this.docPrivs.viewAnnotationsPriv) {
                        AppletLogger.logInfo(this, methodName, "Retrieving bookmarks");
                        tbookmarks = ViewerApplet.this.retrieveBookmarks();
                    } else {
                        AppletLogger.logInfo(this, methodName, "Not retrieving bookmarks");
                        tbookmarks = new CMBBookmark[]{};
                    }
                    final CMBBookmark[] bookmarks = tbookmarks;
                    if (ViewerApplet.this.document != null) {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                String methodName = "run";
                                ViewerApplet.this.info.gdv.setCursor(Cursor.getPredefinedCursor(3));
                                CMBGenericDocViewer cMBGenericDocViewer = ViewerApplet.this.info.gdv;
                                synchronized (cMBGenericDocViewer) {
                                    AppletLogger.logInfo(this, methodName, "Invoking showDocument");
                                    ViewerApplet.this.info.gdv.showDocument(ViewerApplet.this.document, ViewerApplet.this.annoSet, OpenDocumentThread.this.docName);
                                    ViewerApplet.this.info.gdv.setCursor(Cursor.getDefaultCursor());
                                    if (!((OpenDocumentThread)OpenDocumentThread.this).docPrivs.exportDocPriv && ViewerApplet.this.info.gdv.canExport()) {
                                        ViewerApplet.this.info.gdv.setPrivilege(ViewerApplet.this.document, 7, false);
                                    }
                                    if (ViewerApplet.this.info.gdv.canBookmark()) {
                                        if (bookmarks != null) {
                                            ViewerApplet.this.info.gdv.setBookmarks(bookmarks);
                                        }
                                        ViewerApplet.this.info.gdv.setPrivilege(ViewerApplet.this.document, 9, ((OpenDocumentThread)OpenDocumentThread.this).docPrivs.editAnnotationsPriv);
                                    }
                                    if (OpenDocumentThread.this.initialView != null) {
                                        try {
                                            if (((OpenDocumentThread)OpenDocumentThread.this).initialView.setScale) {
                                                ViewerApplet.this.info.gdv.setScale(((OpenDocumentThread)OpenDocumentThread.this).initialView.scale);
                                            }
                                            if (((OpenDocumentThread)OpenDocumentThread.this).initialView.viewRect != null || !((OpenDocumentThread)OpenDocumentThread.this).initialView.setViewRect) {
                                                SwingUtilities.invokeLater(new Runnable(){

                                                    public void run() {
                                                        try {
                                                            ViewerApplet.this.info.gdv.setCurrentPageNumber(((OpenDocumentThread)OpenDocumentThread.this).initialView.pageNo);
                                                            if (((OpenDocumentThread)OpenDocumentThread.this).initialView.setViewRect) {
                                                                ViewerApplet.this.info.gdv.moveCurrentViewRectangle(((OpenDocumentThread)OpenDocumentThread.this).initialView.viewRect.x, ((OpenDocumentThread)OpenDocumentThread.this).initialView.viewRect.y);
                                                            }
                                                        }
                                                        catch (Exception exception) {
                                                            // empty catch block
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                                ViewerApplet.this.info.gdv.setCursor(Cursor.getPredefinedCursor(0));
                            }
                        });
                        if (ViewerApplet.this.terminating) {
                            AppletLogger.logInfo(this, methodName, "Viewer closed, terminating open early");
                            ViewerApplet.this.statusBar.clearStatusMessage();
                            this.closeDocInputStream();
                            return;
                        }
                        try {
                            annoURL = JSObject.class;
                            synchronized (JSObject.class) {
                                JSObject jsObject = JSObject.getWindow(ViewerApplet.this);
                                jsObject.call("appletInitialized", new String[0]);
                                // ** MonitorExit[annoURL] (shouldn't be in output)
                            }
                        }
                        catch (Exception e) {}
                    } else {
                        AppletLogger.logError((Object)this, methodName, "Document is null, skipped showing document.");
                        ViewerApplet.this.statusBar.clearStatusMessage();
                        ViewerApplet.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (OutOfMemoryError e) {
                    AppletLogger.logError((Object)this, methodName, e);
                    this.closeDocInputStream();
                    ViewerApplet.this.statusBar.clearStatusMessage();
                    ViewerApplet.this.setCursor(Cursor.getPredefinedCursor(0));
                    String openErrorMessage = ViewerApplet.getMessage("viewerApplet_openFailed");
                    String openErrorDetails = ViewerApplet.getMessage("viewerApplet_openFailed_details", new String[]{e.getClass().getName(), e.getMessage()});
                    MessageDialog.showErrorDialog((Component)ViewerApplet.this.info.gdv, ViewerApplet.getMessage("viewerApplet_appletTitle"), openErrorMessage, openErrorDetails);
                }
                catch (Exception e) {
                    String openErrorMessage;
                    AppletLogger.logError((Object)this, methodName, e);
                    this.closeDocInputStream();
                    ViewerApplet.this.statusBar.clearStatusMessage();
                    ViewerApplet.this.setCursor(Cursor.getPredefinedCursor(0));
                    String openErrorDetails = "";
                    if (e instanceof HttpException) {
                        HttpException httpException = (HttpException)e;
                        if (httpException.getStatusCode() == 408) {
                            openErrorMessage = ViewerApplet.getMessage("viewerApplet_session_expired");
                        } else {
                            openErrorMessage = ViewerApplet.getMessage("viewerApplet_openFailedHttp");
                            openErrorDetails = ViewerApplet.getMessage("viewerApplet_openFailedHttp_details", new String[]{String.valueOf(httpException.getStatusCode()), e.getMessage()});
                        }
                    } else {
                        openErrorMessage = ViewerApplet.getMessage("viewerApplet_openFailed");
                        openErrorDetails = ViewerApplet.getMessage("viewerApplet_openFailed_details", new String[]{e.getClass().getName(), e.getMessage()});
                    }
                    MessageDialog.showErrorDialog((Component)ViewerApplet.this.info.gdv, ViewerApplet.getMessage("viewerApplet_appletTitle"), openErrorMessage, openErrorDetails);
                }
                {
                    AppletLogger.logExit(this, methodName);
                    return;
                }
            }
        }

        private void closeDocInputStream() {
            if (this.docInputStream != null) {
                try {
                    this.docInputStream.close();
                }
                catch (IOException e) {
                    AppletLogger.logInfo(this, "closeDocInputStream", e.toString());
                }
            }
        }
    }

    private class GdvEventListener
    implements CMBGenericDocStateChangedListener,
    CMBGenericDocOpenedListener,
    CMBGenericDocClosedListener,
    CMBGenericDocSelectedListener,
    CMBBookmarksEditListener {
        private GdvEventListener() {
        }

        public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
            this.updateStatusArea();
        }

        public void genericDocOpened(CMBGenericDocOpenedEvent evt) {
            this.updateStatusArea();
        }

        public void genericDocClosed(CMBGenericDocClosedEvent evt) {
            this.updateStatusArea();
        }

        public void genericDocSelected(CMBGenericDocSelectedEvent evt) {
            this.updateStatusArea();
        }

        private void updateStatusArea() {
            if (ViewerApplet.this.info == null || ViewerApplet.this.info.gdv == null || ViewerApplet.this.info.gdv.getSelectedDocument() == null) {
                ViewerApplet.this.statusBar.setPageCount(0);
                ViewerApplet.this.statusBar.setCurrentPage(0);
                ViewerApplet.this.statusBar.setScale(0.0);
            } else {
                ViewerApplet.this.statusBar.setCurrentPage(ViewerApplet.this.info.gdv.getCurrentPageNumber());
                if (ViewerApplet.this.info.gdv.isPageCountDetermined()) {
                    ViewerApplet.this.statusBar.setPageCount(ViewerApplet.this.info.gdv.getPageCount());
                } else {
                    ViewerApplet.this.statusBar.setPageCount(0);
                }
                ViewerApplet.this.statusBar.setScale(ViewerApplet.this.info.gdv.getScale());
            }
        }

        public void beginEditing(CMBBookmarksEditEvent editEvent) {
            CMBBookmark[] bookmarks;
            if (!ViewerApplet.this.locked) {
                ViewerApplet.this.lockDocument();
                if (!ViewerApplet.this.locked) {
                    editEvent.setEventFailed(true);
                    return;
                }
            }
            if ((bookmarks = ViewerApplet.this.retrieveBookmarks()) == null) {
                editEvent.setEventFailed(true);
                return;
            }
            ViewerApplet.this.info.gdv.setBookmarks(bookmarks);
        }

        public void endEditing(CMBBookmarksEditEvent editEvent) {
            CMBBookmark[] cmBookmarks = editEvent.getNewBookmarks();
            boolean saved = ViewerApplet.this.saveBookmarks(cmBookmarks);
            if (saved) {
                ViewerApplet.this.sendJsCallback(new Object[]{ViewerApplet.END_EDITING_BOOKMARKS_EVENT, new Integer(cmBookmarks != null ? cmBookmarks.length : 0)});
            } else {
                editEvent.setEventFailed(true);
            }
        }
    }

    private class HttpException
    extends Exception {
        int statusCode;

        HttpException(int statusCode, String message) {
            super(message);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }

    private class InitialView {
        int pageNo;
        boolean setScale;
        double scale;
        boolean setViewRect;
        Rectangle viewRect;

        public InitialView(int pageNo, double scale, Rectangle viewRect) {
            this.pageNo = pageNo;
            this.setScale = true;
            this.scale = scale;
            this.setViewRect = true;
            this.viewRect = viewRect;
        }

        public InitialView(int pageNo) {
            this.pageNo = pageNo;
            this.setScale = false;
            this.setViewRect = false;
        }
    }

    private class DocPrivileges {
        boolean printDocPriv = true;
        boolean exportDocPriv = true;
        boolean viewAnnotationsPriv = true;
        boolean editAnnotationsPriv = false;
        boolean editDocPriv = false;
        boolean editPropertiesPriv = false;

        private DocPrivileges() {
        }

        public String toString() {
            return "printDoc: " + this.printDocPriv + " exportDoc: " + this.exportDocPriv + " viewAnnotations: " + this.viewAnnotationsPriv + " editAnnotations: " + this.editAnnotationsPriv + " editDoc: " + this.editDocPriv + " editProperties: " + this.editPropertiesPriv;
        }
    }

    static class InstanceInfo {
        CMBGenericDocViewer gdv;
        CMBStreamingDocServices docServices;
        DocServicesCallbacks docServicesCallbacks;
        CMBAnnotationServices annoServices;
        AnnotationServicesCallbacks annoServicesCallbacks;
        JSONAnnotationEngine annotationEngine;
        Properties appletProperties;
        Hashtable docToURL = new Hashtable();
        Hashtable docToDocName = new Hashtable();
        Hashtable docToServerType = new Hashtable();
        CMBGenericDocSaveListener docSaveListener;

        InstanceInfo() {
        }

        public ViewerApplet getViewerApplet() {
            Container c;
            for (c = this.gdv.getParent(); c != null && !(c instanceof ViewerApplet); c = c.getParent()) {
            }
            return (ViewerApplet)c;
        }
    }
}

