/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.viewer;

import com.ibm.ecm.applets.viewer.ViewerApplet;

public class StatusBar {
    String message;
    int pageNumber;
    int pageCount;
    double scale;
    boolean inProgress;
    boolean progressIndeterminant;
    int progressPercentage;
    ViewerApplet applet;

    public StatusBar(ViewerApplet applet) {
        this.applet = applet;
    }

    public void setStatusMessage(String message) {
        this.message = message;
        this.updateStatus();
    }

    public void clearStatusMessage() {
        this.message = null;
        this.updateStatus();
    }

    public void setProgress(double amount) {
        this.progressPercentage = (int)(amount * 100.0);
        this.inProgress = true;
        this.progressIndeterminant = false;
        this.updateStatus();
    }

    public void setProgressComplete() {
        this.inProgress = false;
        this.updateStatus();
    }

    public void setProgressIndeterminate() {
        this.progressIndeterminant = false;
        this.updateStatus();
    }

    public void setCurrentPage(int pageNumber) {
        this.pageNumber = pageNumber;
        this.updateStatus();
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
        this.updateStatus();
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.updateStatus();
    }

    public void updateStatus() {
        String status = "";
        if (this.message != null) {
            status = this.message + "  ";
            if (this.inProgress) {
                // empty if block
            }
        }
        if (this.applet.getAppletContext() != null) {
            this.applet.getAppletContext().showStatus(status);
        }
    }
}

