/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.viewer;

import com.ibm.ecm.applets.viewer.StatusBar;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.SwingUtilities;

public class ProgressMonitoringStream
extends InputStream {
    private InputStream inputStream;
    private StatusBar statusBar;
    long contentCount;
    long currentLocation;
    long totalRead;
    boolean isClosed;

    public ProgressMonitoringStream(InputStream inputStream, StatusBar statusBar, long contentCount) {
        this.inputStream = inputStream;
        this.statusBar = statusBar;
        this.contentCount = contentCount;
    }

    public int read() throws IOException {
        int byteRead = this.inputStream.read();
        if (byteRead > -1) {
            ++this.currentLocation;
            this.updateStatus();
        }
        return byteRead;
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public void close() throws IOException {
        this.isClosed = true;
        this.updateStatus();
        this.inputStream.close();
    }

    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.inputStream.read(b, off, len);
        if (bytesRead > 0) {
            this.currentLocation += (long)bytesRead;
            this.updateStatus();
        }
        return bytesRead;
    }

    public int read(byte[] b) throws IOException {
        int bytesRead = this.inputStream.read(b);
        if (bytesRead > 0) {
            this.currentLocation += (long)bytesRead;
            this.updateStatus();
        }
        return bytesRead;
    }

    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    private void updateStatus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressMonitoringStream.this.swingUpdateStatus();
            }
        });
    }

    private void swingUpdateStatus() {
        this.totalRead = Math.max(this.totalRead, this.currentLocation);
        if (this.isClosed || this.totalRead == this.contentCount) {
            this.statusBar.setProgressComplete();
            this.statusBar.clearStatusMessage();
        } else if (this.contentCount <= 0L) {
            this.statusBar.setProgressIndeterminate();
        } else {
            this.statusBar.setProgress((double)this.totalRead / (double)this.contentCount);
        }
    }
}

