/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.viewer;

import com.ibm.ecm.applets.AppletLogger;
import com.ibm.ecm.applets.SecurityUtil;
import com.ibm.ecm.applets.viewer.ViewerApplet;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngine;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineCallbacks;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBArrowAnnotation;
import com.ibm.mm.viewer.annotation.CMBCircleAnnotation;
import com.ibm.mm.viewer.annotation.CMBHighlightAnnotation;
import com.ibm.mm.viewer.annotation.CMBLineAnnotation;
import com.ibm.mm.viewer.annotation.CMBNoteAnnotation;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPenAnnotation;
import com.ibm.mm.viewer.annotation.CMBPenStroke;
import com.ibm.mm.viewer.annotation.CMBRectAnnotation;
import com.ibm.mm.viewer.annotation.CMBStampAnnotation;
import com.ibm.mm.viewer.annotation.CMBTextAnnotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.commons.codec.binary.Base64;

public class JSONAnnotationEngine
extends CMBAnnotationEngine {
    CMBAnnotationEngineCallbacks callbacks;
    Properties properties;

    public void initialize(CMBAnnotationEngineCallbacks callbacks, Properties properties) {
        this.callbacks = callbacks;
        this.properties = properties;
    }

    public void terminate() {
    }

    public boolean canLoadAnnotationFormat(String format) {
        if (format.equals("text/json")) {
            return true;
        }
        return format.equals("application/vnd.ibm.modcap");
    }

    public boolean canSaveAnnotationFormat(String srcFormat, String destFormat) {
        if (destFormat.equals("text/json")) {
            return true;
        }
        return destFormat.equals("application/vnd.ibm.modcap");
    }

    public Class[] getSupportedAnnotations() {
        return new Class[]{CMBArrowAnnotation.class, CMBCircleAnnotation.class, CMBHighlightAnnotation.class, CMBLineAnnotation.class, CMBNoteAnnotation.class, CMBPenAnnotation.class, CMBRectAnnotation.class, CMBStampAnnotation.class, CMBTextAnnotation.class};
    }

    public Object loadAnnotationSet(InputStream annotationStream, String format, int annotationPosition, int numOfParts, int partNumber) throws CMBAnnotationEngineException {
        String methodName = "loadAnnotationSet";
        AppletLogger.logEntry(this, methodName);
        if (annotationStream == null) {
            JSONObject newJsonObject = new JSONObject();
            try {
                newJsonObject.put("annotations", new JSONArray());
            }
            catch (Exception e) {
                throw new CMBAnnotationEngineException("Error converting to JSON", (Object)e);
            }
            AppletLogger.logExit(this, methodName);
            return newJsonObject;
        }
        ByteArrayOutputStream annotationBytes = new ByteArrayOutputStream();
        try {
            byte[] buf = new byte[1024];
            int len = annotationStream.read(buf);
            while (len > 0) {
                annotationBytes.write(buf, 0, len);
                len = annotationStream.read(buf);
            }
            AppletLogger.logInfo(this, methodName, annotationBytes.toString());
            JSONObject jsonObject = SecurityUtil.parseJSON(annotationBytes.toString("UTF-8"));
            AppletLogger.logExit(this, methodName);
            return jsonObject;
        }
        catch (Exception e) {
            throw new CMBAnnotationEngineException("Error loading annotations", (Object)e);
        }
    }

    public void saveAnnotationSet(Object hAnnotationSet, CMBPageAnnotation[] pageAnnotations) throws CMBAnnotationEngineException {
        byte[] annotationData;
        boolean newVersion;
        JSONObject oldJsonObject;
        String methodName;
        block11: {
            methodName = "saveAnnotationSet";
            AppletLogger.logEntry(this, methodName);
            oldJsonObject = (JSONObject)hAnnotationSet;
            newVersion = false;
            try {
                if (!ViewerApplet.savingToServer || !oldJsonObject.get("versioningPolicy").equals("prompt")) break block11;
                AppletLogger.logInfo(this, methodName, "Prompting for new version");
                int reply = JOptionPane.showConfirmDialog(null, ViewerApplet.getMessage("viewerApplet_newVersionPrompt"), ViewerApplet.getMessage("viewerApplet_appletTitle"), 0);
                if (reply == 0) {
                    newVersion = true;
                    break block11;
                }
                if (reply == 1) {
                    newVersion = false;
                    break block11;
                }
                AppletLogger.logExit(this, methodName);
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        AppletLogger.logInfo(this, methodName, "Converting " + pageAnnotations.length + " annotations to JSON");
        JSONObject newJsonObject = new JSONObject();
        try {
            newJsonObject.put("newVersion", new Boolean(newVersion));
            newJsonObject.put("annotations", new JSONArray());
            for (int i = 0; i < pageAnnotations.length; ++i) {
                JSONObject jsonAnnotation = this.toJSON(pageAnnotations[i]);
                JSONUtils.accumulate(newJsonObject, "annotations", jsonAnnotation);
            }
        }
        catch (IOException e) {
            throw new CMBAnnotationEngineException("Error converting to JSON", (Object)e);
        }
        String newJsonAnnotations = newJsonObject.toString();
        AppletLogger.logInfo(this, methodName, "Annotations in JSON: " + newJsonAnnotations);
        try {
            annotationData = newJsonAnnotations.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            annotationData = newJsonAnnotations.getBytes();
        }
        if (oldJsonObject.containsKey("annotations")) {
            AppletLogger.logInfo(this, methodName, "Invoking updateAnnotationPart callback");
            this.callbacks.updateAnnotationPart(oldJsonObject, annotationData, 0);
        } else {
            AppletLogger.logInfo(this, methodName, "Invoking addAnnotationPart callback");
            this.callbacks.addAnnotationPart(oldJsonObject, annotationData);
        }
        AppletLogger.logExit(this, methodName);
    }

    public void removeAnnotationSet(Object hAnnotationSet) throws CMBAnnotationEngineException {
    }

    public void dropAnnotationSet(Object hAnnotationSet) {
    }

    public CMBPageAnnotation[] getAnnotations(Object hAnnotationSet) throws CMBAnnotationEngineException {
        String methodName = "getAnnotations";
        AppletLogger.logEntry(this, methodName);
        try {
            CMBPageAnnotation[] annotations;
            JSONObject jsonObject = (JSONObject)hAnnotationSet;
            if (!jsonObject.containsKey("annotations")) {
                AppletLogger.logInfo(this, methodName, "No annotations.");
                annotations = new CMBPageAnnotation[]{};
            } else {
                JSONArray jsonAnnotations = (JSONArray)jsonObject.get("annotations");
                AppletLogger.logInfo(this, methodName, "Number of annotations: " + jsonAnnotations.size());
                annotations = new CMBPageAnnotation[jsonAnnotations.size()];
                for (int i = 0; i < jsonAnnotations.size(); ++i) {
                    annotations[i] = this.getAnnotation((JSONObject)jsonAnnotations.get(i));
                }
                AppletLogger.logExit(this, methodName);
            }
            return annotations;
        }
        catch (IOException e) {
            throw new CMBAnnotationEngineException("Error parsing JSON annotations", (Object)e);
        }
    }

    private CMBPageAnnotation getAnnotation(JSONObject jsonAnnotation) throws IOException, CMBAnnotationEngineException {
        String text;
        String methodName = "getAnnotation";
        AppletLogger.logEntry(this, methodName);
        CMBPageAnnotation annotation = null;
        String type = jsonAnnotation.get("type").toString();
        AppletLogger.logInfo(this, methodName, "Annotation type: " + type);
        int pageNumber = new Integer(jsonAnnotation.get("pageNumber").toString());
        int x = new Integer(jsonAnnotation.get("x").toString());
        int y = new Integer(jsonAnnotation.get("y").toString());
        int width = new Integer(jsonAnnotation.get("width").toString());
        int height = new Integer(jsonAnnotation.get("height").toString());
        Rectangle position = new Rectangle(x, y, width, height);
        if (type.equals("arrow")) {
            CMBArrowAnnotation arrowAnnotation = new CMBArrowAnnotation(position, pageNumber);
            arrowAnnotation.setWingAngle(new Integer(jsonAnnotation.get("wingAngle").toString()));
            arrowAnnotation.setWingLength(new Integer(jsonAnnotation.get("wingLength").toString()));
            annotation = arrowAnnotation;
        } else if (type.equals("circle")) {
            annotation = new CMBCircleAnnotation(position, pageNumber);
        } else if (type.equals("highlight")) {
            annotation = new CMBHighlightAnnotation(position, pageNumber);
        } else if (type.equals("line")) {
            annotation = new CMBLineAnnotation(position, pageNumber);
        } else if (type.equals("note")) {
            text = jsonAnnotation.get("text").toString();
            CMBNoteAnnotation noteAnnotation = new CMBNoteAnnotation(position, text, pageNumber);
            noteAnnotation.setWordWrap(new Boolean(jsonAnnotation.get("wordWrap").toString()));
            annotation = noteAnnotation;
        } else if (type.equals("pen")) {
            Vector<CMBPenStroke> strokes = new Vector<CMBPenStroke>();
            if (jsonAnnotation.containsKey("strokes")) {
                JSONArray jsonStrokes = (JSONArray)jsonAnnotation.get("strokes");
                for (int i = 0; i < jsonStrokes.size(); ++i) {
                    JSONObject jsonStroke = (JSONObject)jsonStrokes.get(i);
                    int fromX = new Integer(jsonStroke.get("fromX").toString());
                    int fromY = new Integer(jsonStroke.get("fromY").toString());
                    int toX = new Integer(jsonStroke.get("toX").toString());
                    int toY = new Integer(jsonStroke.get("toY").toString());
                    CMBPenStroke stroke = new CMBPenStroke(new Point(fromX, fromY), new Point(toX, toY));
                    strokes.addElement(stroke);
                }
            }
            annotation = new CMBPenAnnotation(strokes, pageNumber);
        } else if (type.equals("rect")) {
            annotation = new CMBRectAnnotation(position, pageNumber);
        } else if (type.equals("stamp")) {
            CMBStampAnnotation stampAnnotation = new CMBStampAnnotation(position, pageNumber);
            stampAnnotation.setStampAngle(new Integer(jsonAnnotation.get("angle").toString()));
            stampAnnotation.setStampText(jsonAnnotation.get("text").toString());
            stampAnnotation.setImageStamp(new Boolean(jsonAnnotation.get("isImage").toString()));
            if (stampAnnotation.isImageStamp()) {
                stampAnnotation.setImageSize(new Dimension(new Integer(jsonAnnotation.get("imageWidth").toString()), new Integer(jsonAnnotation.get("imageHeight").toString())));
                stampAnnotation.setImageData(Base64.decodeBase64((String)jsonAnnotation.get("imageData").toString()));
            }
            annotation = stampAnnotation;
        } else if (type.equals("text")) {
            text = jsonAnnotation.get("text").toString();
            text = this.convertLineSeparators(text, "\n", System.getProperty("line.separator"));
            annotation = new CMBTextAnnotation(position, text, pageNumber);
        } else {
            throw new CMBAnnotationEngineException("Invalid annotation type found in JSON format annotations");
        }
        annotation.setTransparent(new Boolean(jsonAnnotation.get("transparent").toString()));
        if (jsonAnnotation.containsKey("borderColor")) {
            annotation.setBorderColor(new Color(new Integer(jsonAnnotation.get("borderColor").toString())));
        }
        annotation.setBorderWidth(new Integer(jsonAnnotation.get("borderWidth").toString()));
        if (jsonAnnotation.containsKey("fillColor")) {
            annotation.setFillColor(new Color(new Integer(jsonAnnotation.get("fillColor").toString())));
        }
        Object font = null;
        if (jsonAnnotation.containsKey("fontName")) {
            String fontName = jsonAnnotation.get("fontName").toString();
            int fontStyle = new Integer(jsonAnnotation.get("fontStyle").toString());
            int fontSize = new Integer(jsonAnnotation.get("fontSize").toString());
            annotation.setFont(new Font(fontName, fontStyle, fontSize));
        }
        annotation.setRotateWithImage(new Boolean(jsonAnnotation.get("rotateWithImage").toString()));
        annotation.setRotation(new Integer(jsonAnnotation.get("rotation").toString()));
        annotation.setInvertHorizontal(new Boolean(jsonAnnotation.get("invertHorizontal").toString()));
        annotation.setInvertVertical(new Boolean(jsonAnnotation.get("invertVertical").toString()));
        annotation.setCanDelete(new Boolean(jsonAnnotation.get("canDelete").toString()));
        annotation.setCanUpdate(new Boolean(jsonAnnotation.get("canUpdate").toString()));
        annotation.setCanShow(new Boolean(jsonAnnotation.get("canShow").toString()));
        annotation.setCanHide(new Boolean(jsonAnnotation.get("canHide").toString()));
        AppletLogger.logExit(this, methodName);
        return annotation;
    }

    private JSONObject toJSON(CMBPageAnnotation annotation) throws IOException {
        Font font;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", this.annotationTypeAsString(annotation.getType()));
        jsonObject.put("pageNumber", new Integer(annotation.getPageNumber()));
        jsonObject.put("x", new Integer(annotation.getDrawRect().x));
        jsonObject.put("y", new Integer(annotation.getDrawRect().y));
        jsonObject.put("width", new Integer(annotation.getDrawRect().width));
        jsonObject.put("height", new Integer(annotation.getDrawRect().height));
        jsonObject.put("canDelete", new Boolean(annotation.canDelete()));
        jsonObject.put("canUpdate", new Boolean(annotation.canUpdate()));
        jsonObject.put("canShow", new Boolean(annotation.canShow()));
        jsonObject.put("canHide", new Boolean(annotation.canHide()));
        jsonObject.put("transparent", new Boolean(annotation.getTransparent()));
        Color borderColor = annotation.getBorderColor();
        if (borderColor != null) {
            jsonObject.put("borderColor", new Integer(borderColor.getRGB()));
        }
        jsonObject.put("borderWidth", new Integer(annotation.getBorderWidth()));
        Color fillColor = annotation.getFillColor();
        if (fillColor != null) {
            jsonObject.put("fillColor", new Integer(fillColor.getRGB()));
        }
        if ((font = annotation.getFont()) != null) {
            jsonObject.put("fontName", font.getName());
            jsonObject.put("fontStyle", new Integer(font.getStyle()));
            jsonObject.put("fontSize", new Integer(font.getSize()));
        }
        jsonObject.put("rotateWithImage", new Boolean(annotation.getRotateWithImage()));
        jsonObject.put("rotation", new Integer(annotation.getRotation()));
        jsonObject.put("invertHorizontal", new Boolean(annotation.getInvertHorizontal()));
        jsonObject.put("invertVertical", new Boolean(annotation.getInvertVertical()));
        if (annotation.getType() == 5) {
            CMBNoteAnnotation noteAnnotation = (CMBNoteAnnotation)annotation;
            jsonObject.put("wordWrap", new Boolean(noteAnnotation.getWordWrap()));
            jsonObject.put("text", noteAnnotation.getText());
        } else if (annotation.getType() == 9) {
            CMBTextAnnotation textAnnotation = (CMBTextAnnotation)annotation;
            String text = textAnnotation.getTextLine();
            text = this.convertLineSeparators(text, System.getProperty("line.separator"), "\n");
            jsonObject.put("text", text);
        } else if (annotation.getType() == 8) {
            CMBStampAnnotation stampAnnotation = (CMBStampAnnotation)annotation;
            jsonObject.put("angle", new Integer(stampAnnotation.getStampAngle()));
            jsonObject.put("text", stampAnnotation.getStampText());
            jsonObject.put("isImage", new Boolean(stampAnnotation.isImageStamp()));
            if (stampAnnotation.isImageStamp()) {
                jsonObject.put("imageWidth", new Integer(stampAnnotation.getImageSize().width));
                jsonObject.put("imageHeight", new Integer(stampAnnotation.getImageSize().height));
                jsonObject.put("imageData", Base64.encodeBase64String((byte[])stampAnnotation.getImageData()));
            }
        } else if (annotation.getType() == 6) {
            CMBPenAnnotation penAnnotation = (CMBPenAnnotation)annotation;
            Vector penStrokes = penAnnotation.getPenStrokes();
            jsonObject.put("strokes", new JSONArray());
            for (int i = 0; i < penStrokes.size(); ++i) {
                JSONObject penStrokeJsonObject = new JSONObject();
                CMBPenStroke penStroke = (CMBPenStroke)penStrokes.get(i);
                penStrokeJsonObject.put("fromX", new Integer(penStroke.from.x));
                penStrokeJsonObject.put("fromY", new Integer(penStroke.from.y));
                penStrokeJsonObject.put("toX", new Integer(penStroke.to.x));
                penStrokeJsonObject.put("toY", new Integer(penStroke.to.y));
                JSONUtils.accumulate(jsonObject, "strokes", penStrokeJsonObject);
            }
        } else if (annotation.getType() == 1) {
            CMBArrowAnnotation arrowAnnotation = (CMBArrowAnnotation)annotation;
            jsonObject.put("wingAngle", new Integer(arrowAnnotation.getWingAngle()));
            jsonObject.put("wingLength", new Integer(arrowAnnotation.getWingLength()));
        }
        return jsonObject;
    }

    private String annotationTypeAsString(int type) {
        if (type == 0) {
            return "unknown";
        }
        if (type == 1) {
            return "arrow";
        }
        if (type == 2) {
            return "circle";
        }
        if (type == 3) {
            return "highlight";
        }
        if (type == 4) {
            return "line";
        }
        if (type == 5) {
            return "note";
        }
        if (type == 6) {
            return "pen";
        }
        if (type == 7) {
            return "rect";
        }
        if (type == 8) {
            return "stamp";
        }
        if (type == 9) {
            return "text";
        }
        if (type == 10) {
            return "mask";
        }
        return "custom" + Integer.toString(type);
    }

    public boolean getPrivilege(Object hAnnotationSet, int privilegeID) throws CMBAnnotationEngineException {
        return true;
    }

    public void addAnnotation(Object hAnnotationSet, CMBPageAnnotation newPageAnnotation, int page) throws CMBAnnotationEngineException {
    }

    public void removeAnnotation(Object hAnnotationSet, CMBPageAnnotation newPageAnnotation) throws CMBAnnotationEngineException {
    }

    public void reorderAnnotation(Object hAnnotationSet, CMBPageAnnotation pageAnnotation, int location) throws CMBAnnotationEngineException {
    }

    public void updateAnnotation(Object hAnnotationSet, CMBPageAnnotation pageAnnotation, int index) throws CMBAnnotationEngineException {
    }

    private String convertLineSeparators(String text, String oldSeparator, String newSeparator) {
        StringBuffer oldString = new StringBuffer(text);
        StringBuffer newString = new StringBuffer();
        while (oldString.length() > 0) {
            if (oldString.indexOf(oldSeparator) == 0) {
                newString.append(newSeparator);
                oldString.delete(0, oldSeparator.length());
                continue;
            }
            newString.append(oldString.charAt(0));
            oldString.deleteCharAt(0);
        }
        return newString.toString();
    }
}

