/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.viewer;

import com.ibm.ecm.applets.AppletLogger;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

class JSListener
implements Runnable {
    private JSQueue requestQueue = null;
    private JSQueue responseQueue = null;
    private Runnable runnable = null;

    JSListener() {
    }

    public void run() {
        String methodName = "JSListener.run";
        AppletLogger.logEntry(this, methodName);
        try {
            this.requestQueue = new JSQueue();
            this.responseQueue = new JSQueue();
            AppletLogger.logDebug(this, methodName, "Waiting for first request");
            int command = this.requestQueue.receive();
            while (command != -1) {
                AppletLogger.logDebug(this, methodName, "Received request");
                if (this.runnable != null) {
                    this.runnable.run();
                }
                AppletLogger.logDebug(this, methodName, "Completed request");
                this.responseQueue.send(0);
                AppletLogger.logDebug(this, methodName, "Waiting for next request");
                command = this.requestQueue.receive();
            }
        }
        catch (IOException ioe) {
            AppletLogger.logError((Object)this, methodName, ioe);
        }
        AppletLogger.logExit(this, methodName);
    }

    private boolean waitForReady() throws InterruptedException {
        int sleepTime = 500;
        for (int retries = 0; retries < 10 && (this.requestQueue == null || this.responseQueue == null); ++retries) {
            AppletLogger.logInfo(this, "waitForReady", "Listener not ready wait/retry: " + retries);
            Thread.sleep(sleepTime);
        }
        return this.requestQueue != null && this.responseQueue != null;
    }

    public int invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        String methodName = "sendRunnableRequest";
        AppletLogger.logEntry(this, methodName);
        int result = 0;
        if (this.waitForReady()) {
            try {
                result = this.sendRequest(0, runnable);
            }
            catch (IOException ioe) {
                AppletLogger.logError((Object)this, methodName, ioe);
            }
        } else {
            AppletLogger.logInfo(this, methodName, "Listener is not ready, falling back to SwingUtilities");
            SwingUtilities.invokeAndWait(runnable);
        }
        AppletLogger.logExit(this, methodName);
        return result;
    }

    public void terminate() {
        try {
            this.requestQueue.close();
        }
        catch (IOException ioe) {
            AppletLogger.logError((Object)this, "terminate", ioe);
        }
        try {
            this.responseQueue.close();
        }
        catch (IOException ioe) {
            AppletLogger.logError((Object)this, "terminate", ioe);
        }
    }

    private synchronized int sendRequest(int command, Runnable runnable) throws IOException {
        String methodName = "sendRequest";
        AppletLogger.logEntry(this, methodName);
        this.runnable = runnable;
        this.requestQueue.send(command);
        AppletLogger.logDebug(this, methodName, "Waiting for response from request: " + command);
        int result = this.responseQueue.receive();
        AppletLogger.logExit(this, methodName);
        return result;
    }

    private static class JSQueue {
        PipedInputStream is = new PipedInputStream();
        PipedOutputStream os = new PipedOutputStream(this.is);

        private JSQueue() throws IOException {
        }

        private void send(int message) {
            block2: {
                try {
                    this.os.write(message);
                }
                catch (IOException ioe) {
                    AppletLogger.logInfo(this, "send", "Write pipe closed, or write did not complete.");
                    if (!AppletLogger.isDebugLogged()) break block2;
                    AppletLogger.logError((Object)this, "send", ioe);
                }
            }
        }

        private int receive() {
            int result;
            block2: {
                result = -1;
                try {
                    result = this.is.read();
                }
                catch (IOException ioe) {
                    result = -1;
                    AppletLogger.logInfo(this, "read", "Read pipe closed, or read did not complete");
                    if (!AppletLogger.isDebugLogged()) break block2;
                    AppletLogger.logError((Object)this, "send", ioe);
                }
            }
            return result;
        }

        private void close() throws IOException {
            this.os.close();
        }
    }
}

