/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.viewer;

import com.ibm.ecm.applets.AppletLogger;
import com.ibm.ecm.applets.viewer.ViewerApplet;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocClosedEvent;
import com.ibm.mm.viewer.CMBGenericDocClosedListener;
import com.ibm.mm.viewer.CMBGenericDocOpenedEvent;
import com.ibm.mm.viewer.CMBGenericDocOpenedListener;
import com.ibm.mm.viewer.CMBGenericDocSelectedEvent;
import com.ibm.mm.viewer.CMBGenericDocSelectedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBViewerAction;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import java.awt.Cursor;
import java.awt.event.ActionEvent;

public class EditAction
extends CMBViewerAction
implements CMBGenericDocClosedListener,
CMBGenericDocOpenedListener,
CMBGenericDocSelectedListener {
    CMBGenericDocViewer gdv;

    public EditAction(CMBGenericDocViewer gdv, String name) {
        super(gdv, name);
        this.gdv = gdv;
        gdv.addDocSelectedListener(this);
        gdv.addDocClosedListener(this);
        gdv.addDocOpenedListener(this);
        this.updateToolState();
    }

    public void actionPerformed(ActionEvent event) {
        String methodName = "actionPerformed";
        AppletLogger.logEntry(this, methodName);
        this.gdv.setCursor(new Cursor(3));
        CMBDocument document = this.gdv.getSelectedDocument();
        CMBAnnotationSet annoSet = this.gdv.getSelectedAnnotationSet();
        if (!ViewerApplet.isDocumentEditable(document)) {
            ViewerApplet applet = (ViewerApplet)this.gdv.getParent().getParent().getParent().getParent();
            applet.editDocument();
            this.gdv.setCursor(new Cursor(0));
        }
        AppletLogger.logExit(this, methodName);
    }

    public void genericDocClosed(CMBGenericDocClosedEvent evt) {
        AppletLogger.logEntry(this, "genericDocClosed");
        this.updateToolState();
        AppletLogger.logExit(this, "genericDocClosed");
    }

    public void genericDocOpened(CMBGenericDocOpenedEvent evt) {
        AppletLogger.logEntry(this, "genericDocOpened");
        this.updateToolState();
        AppletLogger.logExit(this, "genericDocOpened");
    }

    public void genericDocSelected(CMBGenericDocSelectedEvent evt) {
        AppletLogger.logEntry(this, "genericDocSelected");
        this.updateToolState();
        AppletLogger.logExit(this, "genericDocSelected");
    }

    private void updateToolState() {
        if (this.gdv.getSelectedDocument() == null) {
            this.setEnabled(false);
            return;
        }
        if (ViewerApplet.isDocumentEditable(this.gdv.getSelectedDocument())) {
            this.setEnabled(false);
            return;
        }
        if (ViewerApplet.areAnnotationsEditable(this.gdv.getSelectedAnnotationSet())) {
            this.setEnabled(false);
            return;
        }
        if (ViewerApplet.getEditAnnotationsPrivilege(this.gdv.getSelectedDocument())) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

