/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.viewer;

import com.ibm.ecm.applets.AppletLogger;
import com.ibm.ecm.applets.NativeLibraryDeployer;
import com.ibm.ecm.applets.viewer.DocLoadInfo;
import com.ibm.ecm.applets.viewer.ProgressMonitoringStream;
import com.ibm.ecm.applets.viewer.ViewerApplet;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBStreamingDocServicesCallbacks;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

class DocServicesCallbacks
extends CMBStreamingDocServicesCallbacks {
    URL codebase;
    ViewerApplet applet;

    public DocServicesCallbacks(ViewerApplet applet) {
        this.applet = applet;
        this.codebase = applet.getCodeBase();
    }

    public InputStream getForm(CMBDocument document, String formName) {
        try {
            URL formURL = new URL(null, formName);
            try {
                URLConnection urlConn = formURL.openConnection();
                InputStream formStream = urlConn == null ? new ByteArrayInputStream(new byte[0]) : urlConn.getInputStream();
                return formStream;
            }
            catch (IOException e) {
                return null;
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public boolean getPrintPrivilege(CMBDocument document) {
        return ViewerApplet.getPrintDocPrivilege(document);
    }

    public int getPartPageCount(CMBDocument document, int partNumber) {
        String methodName = "getPartPageCount";
        DocLoadInfo docLoadInfo = ViewerApplet.getDocLoadInfo(document);
        if (docLoadInfo == null) {
            return 0;
        }
        int partPageCount = partNumber == docLoadInfo.getPartCount() - 1 ? docLoadInfo.getLastPartPageCount() : docLoadInfo.getPartPageCount();
        return partPageCount;
    }

    public InputStream getPart(CMBDocument document, int partNumber, StringBuffer outMimeType) {
        URL docURL;
        String methodName = "getPart";
        AppletLogger.logEntry(this, methodName);
        DocLoadInfo docLoadInfo = ViewerApplet.getDocLoadInfo(document);
        String serverType = docLoadInfo.getServerType();
        URL contextURL = docLoadInfo.getContextURL();
        String docURLString = docLoadInfo.getDocURLString();
        String cookieProperty = docLoadInfo.getCookieProperty();
        AppletLogger.logDebug(this, methodName, "Part number " + partNumber);
        this.applet.statusBar.setStatusMessage(ViewerApplet.getMessage("viewerApplet_statusRequestingDocumentPart", new String[]{Integer.toString(partNumber)}));
        try {
            if (serverType != null) {
                if (serverType.equals("od")) {
                    AppletLogger.logDebug(this, methodName, "Adding transform=native and segment_num to Url for OD");
                    docURL = new URL(this.codebase, docURLString + "&transform=native&segment_num=" + partNumber);
                } else if (serverType.equals("cm")) {
                    AppletLogger.logDebug(this, methodName, "Adding transform=native and part_number to Url for CM");
                    docURL = new URL(this.codebase, docURLString + "&transform=native&part_number=" + partNumber);
                } else {
                    docURL = new URL(this.codebase, docURLString + "&transform=native&part_number=" + partNumber);
                }
            } else {
                docURL = new URL(this.codebase, docURLString + "&transform=native&part_number=" + partNumber);
            }
        }
        catch (MalformedURLException e) {
            AppletLogger.logDebug(this, methodName, "MalformedURLException -- assuming local resource");
            docURL = this.getClass().getResource("/" + docURLString);
        }
        if (docURL == null) {
            AppletLogger.logDebug(this, methodName, "The docURL could not be formed.  Throwing illegal argument exception");
            throw new IllegalArgumentException(ViewerApplet.getMessage("viewerApplet_notAbleToRetrieve", new String[]{docURLString}));
        }
        AppletLogger.logDebug(this, methodName, "Attempting to open the connection to the docURL.");
        try {
            URLConnection docUrlConnection = docURL.openConnection();
            if (cookieProperty != null) {
                AppletLogger.logDebug(this, methodName, "Setting COOKIE property: " + cookieProperty);
                docUrlConnection.setRequestProperty("COOKIE", cookieProperty);
            }
            AppletLogger.logDebug(this, methodName, "Getting an input stream.");
            InputStream instream = docUrlConnection.getInputStream();
            int contentLength = docUrlConnection.getContentLength();
            AppletLogger.logDebug(this, methodName, "Content length is " + contentLength);
            String mimeType = docUrlConnection.getContentType();
            AppletLogger.logDebug(this, methodName, "Mimetype is " + mimeType);
            outMimeType.append(mimeType);
            ProgressMonitoringStream progressMonitoringStream = new ProgressMonitoringStream(instream, this.applet.statusBar, contentLength);
            this.applet.statusBar.setStatusMessage(ViewerApplet.getMessage("viewerApplet_statusRetrievingDocumentPart", new String[]{Integer.toString(partNumber)}));
            AppletLogger.logExit(this, methodName);
            return progressMonitoringStream;
        }
        catch (IOException e) {
            this.applet.statusBar.clearStatusMessage();
            throw new IllegalArgumentException(ViewerApplet.getMessage("viewerApplet_notAbleToRetrieve", new String[]{docURLString}));
        }
    }

    public InputStream getAnnotation(CMBDocument document, int annotationNumber) {
        return null;
    }

    public InputStream getResources(CMBDocument document) {
        ByteArrayInputStream resourceStream = null;
        if (resourceStream == null) {
            resourceStream = new ByteArrayInputStream(new byte[0]);
        }
        return resourceStream;
    }

    public boolean traceEnabled() {
        return AppletLogger.getLogLevel() > 4;
    }

    public String deployNativeLibrary(String nativeLibName) {
        NativeLibraryDeployer deployer = new NativeLibraryDeployer(this.applet.getCodeBase());
        try {
            deployer.setPlatform(this.applet.getParameter("platform"));
            deployer.deployNativeLibrary(nativeLibName);
            String dllPath = deployer.getDllPath();
            return dllPath;
        }
        catch (Exception e) {
            throw new CMBDocumentEngineException(e.getMessage(), (Object)e);
        }
    }

    public String getPartEncoding(CMBDocument document, int partNumber) {
        String methodName = "getPartEncoding";
        DocLoadInfo docLoadInfo = ViewerApplet.getDocLoadInfo(document);
        String encoding = docLoadInfo.getCharset();
        AppletLogger.logDebug(this, methodName, encoding);
        return encoding;
    }
}

