/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.versioning;

import com.ibm.ecm.applets.versioning.BaseApplet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class ProgressDialog
extends JDialog {
    private Timer taskTimer = null;
    private JProgressBar progressBar = null;
    private JLabel fileLabel = null;
    private BaseApplet _applet = null;

    public ProgressDialog(Frame parent, int delay, BaseApplet applet, String title) {
        super(parent, false);
        this._applet = applet;
        applet.getAppletUtils().setLocale(applet);
        this.initComponents(title);
        this.pack();
        this.taskTimer = new Timer(delay, new ActionListener(){
            long taskStartTime = System.currentTimeMillis();

            public void actionPerformed(ActionEvent event) {
                int oldValue = ProgressDialog.this.progressBar.getValue();
                int percentValue = oldValue + 2;
                if (percentValue > 100) {
                    percentValue = 0;
                }
                ProgressDialog.this.progressBar.setValue(percentValue);
            }
        });
        this.taskTimer.setInitialDelay(0);
        this.taskTimer.start();
    }

    public void update(String message, int percentValue, String fileName) {
        this.stopTimer();
        int oldValue = this.progressBar.getValue();
        if (percentValue != oldValue) {
            this.progressBar.setValue(percentValue);
        }
        this.fileLabel.setText(this.getApplet().getMessage(message, new String[]{fileName}));
    }

    public void update(String message, String fileName) {
        this.fileLabel.setText(this.getApplet().getMessage(message, new String[]{fileName}));
    }

    public BaseApplet getApplet() {
        return this._applet;
    }

    public void setApplet(BaseApplet applet) {
        this._applet = applet;
    }

    public void startTimer() {
        if (this.taskTimer != null) {
            this.taskTimer.start();
        }
    }

    public void stopTimer() {
        if (this.taskTimer != null) {
            this.taskTimer.stop();
        }
    }

    public void init(String message) {
        this.fileLabel.setText(this.getApplet().getMessage(message));
        this.progressBar.setValue(0);
    }

    private void initComponents(String title) {
        this.setTitle(this.getApplet().getMessage(title));
        this.getContentPane().setLayout(new BorderLayout());
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setValue(this.progressBar.getMinimum());
        this.progressBar.setPreferredSize(new Dimension(220, 20));
        this.getApplet().getAppletUtils().setLocale(this.progressBar);
        this.getContentPane().add((Component)this.progressBar, "South");
        this.fileLabel = new JLabel();
        this.fileLabel.setText(this.getApplet().getMessage(title));
        this.getApplet().getAppletUtils().setLocale(this.fileLabel);
        this.getContentPane().add((Component)this.fileLabel, "North");
    }
}

