/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.versioning;

import com.ibm.ecm.applets.AppletLogger;
import com.ibm.ecm.applets.versioning.AppletUtils;
import com.ibm.ecm.applets.versioning.BaseApplet;
import com.ibm.ecm.applets.versioning.ProgressDialog;
import com.ibm.ecm.util.MimeTypeUtil;
import com.ibm.json.java.JSONObject;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class ImportApplet
extends BaseApplet {
    protected Thread thread;
    protected byte threadState = 1;
    private boolean bImportDocuments;
    private boolean bCreateNewPart;
    private boolean bImportSuccess;
    private boolean bPause;
    private String partFileName;
    private String queryString;
    private String updateBasePartURL;
    private String partMimeType;
    protected ProgressDialog progressDialog = null;
    private Hashtable importFailureMessages = null;
    private String jsCheckinSuccess = "checkinSuccess";
    private String jsCheckinFailed = "checkinFailed";
    private String jsImportNewSuccess = "addDocumentSuccess";
    private String jsImportNewFailed = "addDocumentFailed";
    private String jsImportSessionExpired = "importSessionExpired";

    public void doInit() {
        String methodName = "doInit";
        this.setThreadState((byte)1);
        this.getThread().start();
        String createNew = this.getParameter("applet_create_new_part");
        this.bCreateNewPart = createNew.equals("true");
        AppletLogger.logInfo(this, "doInit", "Creating new parts set to " + this.bCreateNewPart);
    }

    public void doRun() {
        String methodName = " doRun";
        int iPauseSleep = 100;
        while (this.isAppletAlive()) {
            switch (this.getThreadState()) {
                case 1: {
                    try {
                        Thread.sleep(iPauseSleep);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (!this.bImportDocuments) break;
                    this.setThreadState((byte)3);
                    break;
                }
                case 3: {
                    if (this.bImportDocuments) {
                        this.importDocuments(this.bCreateNewPart);
                        this.bImportDocuments = false;
                        AppletLogger.logInfo(this, " doRun", "import docs after -" + this.bImportDocuments);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        AppletLogger.logError((Object)this, " doRun", ie);
                    }
                    this.setThreadState((byte)1);
                    AppletLogger.logInfo(this, " doRun", "thread state set to pause");
                }
            }
        }
    }

    public boolean testImpApp() {
        String methodName = "testImpApp";
        AppletLogger.logInfo(this, methodName, "Import Applet detected");
        return true;
    }

    public void cancel() {
        this.bPause = true;
        this.bImportSuccess = false;
        this.bImportDocuments = false;
        this.setThreadState((byte)1);
    }

    public String getSelectedFile(String currFile) {
        String methodName = "getSelectedFile";
        AppletLogger.logEntry(this, "getSelectedFile");
        Frame f = new Frame();
        FileDialog fd = new FileDialog(f, "Please select the file to check in", 0);
        fd.setFile(currFile);
        fd.setVisible(true);
        String selectedFile = "";
        if (fd.getDirectory() != null && fd.getFile() != null) {
            selectedFile = fd.getDirectory() + fd.getFile();
        }
        AppletLogger.logInfo(this, "getSelectedFile", "Selected file is =" + selectedFile);
        AppletLogger.logExit(this, "getSelectedFile");
        return selectedFile;
    }

    public String getPartMimeType() {
        return this.partMimeType;
    }

    public void setPartMimeType(String partMimeType) {
        this.partMimeType = partMimeType;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getUpdateBasePartURL() {
        return this.updateBasePartURL;
    }

    public void setUpdateBasePartURL(String updateBasePartURL) {
        this.updateBasePartURL = updateBasePartURL;
    }

    public void appendQueryString(String param) {
        this.queryString = this.queryString + "&" + param;
    }

    public String getPartFileName() {
        return this.partFileName;
    }

    public void setPartFileName(String partFileName) {
        this.partFileName = partFileName;
    }

    private void showErrorMessageDialog(String message) {
        if (this.progressDialog != null) {
            this.progressDialog.stopTimer();
        }
        JOptionPane.showMessageDialog(this.progressDialog, message, this.getMessage("importApplet_title"), 0);
        if (this.progressDialog != null) {
            this.progressDialog.startTimer();
        }
    }

    private void showMessageDialog(String message) {
        if (this.progressDialog != null) {
            this.progressDialog.stopTimer();
        }
        JOptionPane.showMessageDialog(this.progressDialog, message);
        if (this.progressDialog != null) {
            this.progressDialog.startTimer();
        }
    }

    public void startImportDocuments() {
        String methodName = "startImportDocuments";
        this.bImportDocuments = true;
        AppletLogger.logInfo(this, methodName, "import applet thread is starting");
    }

    private void createExportFailureMessageHolder() {
        if (this.importFailureMessages == null) {
            this.importFailureMessages = new Hashtable();
        }
    }

    private void addFileToFailureList(String filename, String message) {
        this.createExportFailureMessageHolder();
        this.importFailureMessages.put(filename, message);
    }

    private String getAllErrorMessages() {
        String errorMessage = "";
        if (this.importFailureMessages != null) {
            Enumeration errMesgs = this.importFailureMessages.elements();
            while (errMesgs.hasMoreElements()) {
                errorMessage = errorMessage + errMesgs.nextElement().toString() + "\n\n";
            }
        }
        return errorMessage;
    }

    private void importDocuments(boolean createNew) {
        if (createNew) {
            this.importNewDocuments();
        } else {
            this.importDocuments();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importDocuments() {
        block37: {
            JSONObject resultJSON;
            boolean bImportSessionExpired;
            block35: {
                String methodName = "importDocuments";
                AppletLogger.logEntry(this, "importDocuments");
                this.bPause = false;
                this.bImportSuccess = true;
                int numItems = 1;
                String baseFileName = "";
                bImportSessionExpired = false;
                resultJSON = new JSONObject();
                try {
                    try {
                        for (int i = 0; this.bImportDocuments && !this.bPause && i < numItems; ++i) {
                            HttpURLConnection httpDocUrlConnection;
                            baseFileName = this.getPartFileName();
                            AppletLogger.logInfo(this, "importDocuments", "FileName = " + baseFileName);
                            int delay = 200;
                            if (this.progressDialog == null) {
                                this.progressDialog = new ProgressDialog(this.getFrame(), delay, this, "importApplet_title");
                                this.progressDialog.setResizable(true);
                                Dimension d1 = this.progressDialog.getSize();
                                this.progressDialog.setBounds(500, 400, d1.width, d1.height);
                            }
                            AppletLogger.logInfo(this, "importDocuments", "Setting title = " + this.getMessage("importApplet_title"));
                            this.progressDialog.setTitle(this.getMessage("importApplet_title"));
                            this.progressDialog.setVisible(true);
                            this.progressDialog.init("importApplet_preparing_for_checkin");
                            this.progressDialog.startTimer();
                            AppletLogger.logInfo(this, "importDocuments", "update base part url =" + this.getUpdateBasePartURL());
                            int extIndex = baseFileName.lastIndexOf(46);
                            String ext = "dat";
                            if (extIndex != -1) {
                                ext = baseFileName.substring(extIndex + 1);
                                AppletLogger.logInfo(this, "importDocuments", "File extension is " + ext);
                            }
                            String newMimeType = MimeTypeUtil.getMimeType(ext);
                            AppletLogger.logInfo(this, "importDocuments", "New mime type from ext = " + newMimeType);
                            String originalMimeType = this.getPartMimeType();
                            AppletLogger.logInfo(this, "importDocuments", "Original mime type of the part = " + originalMimeType);
                            if (newMimeType.equalsIgnoreCase("application/binary") && !newMimeType.equals(originalMimeType)) {
                                newMimeType = originalMimeType;
                            }
                            if (ext.equals("mpeg") || ext.equals("mpg") || ext.equals("m1s") || ext.equals("m1a") || ext.equals("mp2")) {
                                newMimeType = originalMimeType;
                                AppletLogger.logInfo(this, "importDocuments", "Using original mime type for these type of formats...");
                            }
                            AppletLogger.logInfo(this, "importDocuments", "New mimetype set for first base part = " + newMimeType);
                            String mimeTypeParam = "mimetype=" + newMimeType;
                            this.appendQueryString(mimeTypeParam);
                            AppletLogger.logInfo(this, "importDocuments", "query String = " + this.getQueryString());
                            URLConnection connection = this.getConnection(this.getUpdateBasePartURL() + "?" + this.getQueryString());
                            AppletLogger.logInfo(this, "importDocuments", connection.getURL().toString());
                            this.progressDialog.update("importApplet_progress_checkin", baseFileName);
                            this.streamFile(connection, baseFileName);
                            if (connection instanceof HttpURLConnection && (httpDocUrlConnection = (HttpURLConnection)connection).getResponseCode() != 200) {
                                throw new HttpException(httpDocUrlConnection.getResponseCode(), httpDocUrlConnection.getResponseMessage());
                            }
                            boolean jsonErrorsFound = false;
                            InputStream is = connection.getInputStream();
                            ByteArrayOutputStream resBytes = new ByteArrayOutputStream();
                            byte[] buf = new byte[1024];
                            int len = is.read(buf);
                            while (len > 0) {
                                resBytes.write(buf, 0, len);
                                len = is.read(buf);
                            }
                            resultJSON = JSONObject.parse(resBytes.toString("UTF-8"));
                            AppletLogger.logInfo(this, "importDocuments", "JSON object=" + resultJSON.toString());
                            if (resultJSON.containsKey("errors")) {
                                AppletLogger.logError((Object)this, "importDocuments", "Errors found");
                                jsonErrorsFound = true;
                            }
                            if (!(connection instanceof HttpURLConnection)) continue;
                            HttpURLConnection httpAnnoURLConn = (HttpURLConnection)connection;
                            int responseCode = httpAnnoURLConn.getResponseCode();
                            AppletLogger.logInfo(this, "importDocuments", "Http response code: " + responseCode);
                            String errorMessage = "";
                            if (responseCode < 400 && !jsonErrorsFound) continue;
                            String errors = resultJSON.get("errors").toString();
                            AppletLogger.logError((Object)this, "importDocuments", "errors=" + errors.toString());
                            JSONObject errObject = JSONObject.parse(errors);
                            errorMessage = errObject.get("globals").toString();
                            AppletLogger.logError((Object)this, "importDocuments", "globals=" + errorMessage);
                            this.bImportSuccess = false;
                            this.addFileToFailureList(baseFileName, errorMessage);
                        }
                        Object var25_30 = null;
                        if (this.progressDialog == null) break block35;
                    }
                    catch (FileNotFoundException fnfe) {
                        AppletLogger.logError((Object)this, "importDocuments", fnfe);
                        this.bImportSuccess = false;
                        String message = this.getMessage("exportApplet_filenotfound_error", new String[]{baseFileName});
                        this.addFileToFailureList(baseFileName, message);
                        Object var25_31 = null;
                        if (this.progressDialog != null) {
                            this.progressDialog.setVisible(false);
                            this.progressDialog.stopTimer();
                        }
                        if (!this.bImportDocuments) break block37;
                        if (this.bImportSuccess) {
                            AppletUtils.execJavaScript(this, this.jsCheckinSuccess, new String[]{resultJSON.toString()});
                            AppletLogger.logInfo(this, "importDocuments", "checkin failed with error:  import success !!!");
                            break block37;
                        }
                        String errorMessage = this.getAllErrorMessages();
                        AppletLogger.logError((Object)this, "importDocuments", "checkin failed with error: " + errorMessage);
                        if (errorMessage != null && errorMessage.length() > 0) {
                            AppletUtils.execJavaScript(this, this.jsCheckinFailed, new String[]{errorMessage});
                        }
                        this.importFailureMessages = null;
                        if (bImportSessionExpired) {
                            AppletUtils.execJavaScript(this, this.jsImportSessionExpired, null);
                        }
                        break block37;
                    }
                    catch (HttpException he) {
                        AppletLogger.logError((Object)this, "importDocuments", he);
                        this.bImportSuccess = false;
                        this.addFileToFailureList(baseFileName, he.getMessage());
                        if (he.getStatusCode() == 408) {
                            bImportSessionExpired = true;
                        }
                        Object var25_32 = null;
                        if (this.progressDialog != null) {
                            this.progressDialog.setVisible(false);
                            this.progressDialog.stopTimer();
                        }
                        if (!this.bImportDocuments) break block37;
                        if (this.bImportSuccess) {
                            AppletUtils.execJavaScript(this, this.jsCheckinSuccess, new String[]{resultJSON.toString()});
                            AppletLogger.logInfo(this, "importDocuments", "checkin failed with error:  import success !!!");
                            break block37;
                        }
                        String errorMessage = this.getAllErrorMessages();
                        AppletLogger.logError((Object)this, "importDocuments", "checkin failed with error: " + errorMessage);
                        if (errorMessage != null && errorMessage.length() > 0) {
                            AppletUtils.execJavaScript(this, this.jsCheckinFailed, new String[]{errorMessage});
                        }
                        this.importFailureMessages = null;
                        if (bImportSessionExpired) {
                            AppletUtils.execJavaScript(this, this.jsImportSessionExpired, null);
                        }
                        break block37;
                    }
                    catch (Exception e) {
                        AppletLogger.logError((Object)this, "importDocuments", e);
                        this.bImportSuccess = false;
                        this.addFileToFailureList(baseFileName, this.getMessage("importApplet_checkinFailed"));
                        Object var25_33 = null;
                        if (this.progressDialog != null) {
                            this.progressDialog.setVisible(false);
                            this.progressDialog.stopTimer();
                        }
                        if (!this.bImportDocuments) break block37;
                        if (this.bImportSuccess) {
                            AppletUtils.execJavaScript(this, this.jsCheckinSuccess, new String[]{resultJSON.toString()});
                            AppletLogger.logInfo(this, "importDocuments", "checkin failed with error:  import success !!!");
                            break block37;
                        }
                        String errorMessage = this.getAllErrorMessages();
                        AppletLogger.logError((Object)this, "importDocuments", "checkin failed with error: " + errorMessage);
                        if (errorMessage != null && errorMessage.length() > 0) {
                            AppletUtils.execJavaScript(this, this.jsCheckinFailed, new String[]{errorMessage});
                        }
                        this.importFailureMessages = null;
                        if (bImportSessionExpired) {
                            AppletUtils.execJavaScript(this, this.jsImportSessionExpired, null);
                        }
                        break block37;
                    }
                }
                catch (Throwable throwable) {
                    Object var25_34 = null;
                    if (this.progressDialog != null) {
                        this.progressDialog.setVisible(false);
                        this.progressDialog.stopTimer();
                    }
                    if (!this.bImportDocuments) throw throwable;
                    if (this.bImportSuccess) {
                        AppletUtils.execJavaScript(this, this.jsCheckinSuccess, new String[]{resultJSON.toString()});
                        AppletLogger.logInfo(this, "importDocuments", "checkin failed with error:  import success !!!");
                        throw throwable;
                    }
                    String errorMessage = this.getAllErrorMessages();
                    AppletLogger.logError((Object)this, "importDocuments", "checkin failed with error: " + errorMessage);
                    if (errorMessage != null && errorMessage.length() > 0) {
                        AppletUtils.execJavaScript(this, this.jsCheckinFailed, new String[]{errorMessage});
                    }
                    this.importFailureMessages = null;
                    if (!bImportSessionExpired) throw throwable;
                    AppletUtils.execJavaScript(this, this.jsImportSessionExpired, null);
                    throw throwable;
                }
                this.progressDialog.setVisible(false);
                this.progressDialog.stopTimer();
            }
            if (this.bImportDocuments) {
                if (this.bImportSuccess) {
                    AppletUtils.execJavaScript(this, this.jsCheckinSuccess, new String[]{resultJSON.toString()});
                    AppletLogger.logInfo(this, "importDocuments", "checkin failed with error:  import success !!!");
                } else {
                    String errorMessage = this.getAllErrorMessages();
                    AppletLogger.logError((Object)this, "importDocuments", "checkin failed with error: " + errorMessage);
                    if (errorMessage != null && errorMessage.length() > 0) {
                        AppletUtils.execJavaScript(this, this.jsCheckinFailed, new String[]{errorMessage});
                    }
                    this.importFailureMessages = null;
                    if (bImportSessionExpired) {
                        AppletUtils.execJavaScript(this, this.jsImportSessionExpired, null);
                    }
                }
            }
        }
        AppletLogger.logExit(this, "importDocuments");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void importNewDocuments() {
        block35: {
            JSONObject resultJSON;
            boolean bImportSessionExpired;
            block33: {
                String methodName = "importNewDocuments";
                AppletLogger.logEntry(this, "importNewDocuments");
                this.bPause = false;
                this.bImportSuccess = true;
                int numItems = 1;
                String baseFileName = "";
                bImportSessionExpired = false;
                resultJSON = new JSONObject();
                try {
                    try {
                        for (int i = 0; this.bImportDocuments && !this.bPause && i < numItems; ++i) {
                            HttpURLConnection httpDocUrlConnection;
                            baseFileName = this.getPartFileName();
                            AppletLogger.logInfo(this, "importNewDocuments", "FileName = " + baseFileName);
                            int delay = 200;
                            if (this.progressDialog == null) {
                                this.progressDialog = new ProgressDialog(this.getFrame(), delay, this, "importApplet_import_title");
                                this.progressDialog.setResizable(true);
                                Dimension d1 = this.progressDialog.getSize();
                                this.progressDialog.setBounds(500, 400, d1.width, d1.height);
                            }
                            AppletLogger.logInfo(this, "importNewDocuments", "Setting title = " + this.getMessage("importApplet_import_title"));
                            this.progressDialog.setTitle(this.getMessage("importApplet_import_title"));
                            this.progressDialog.setVisible(true);
                            this.progressDialog.init("importApplet_preparing_for_import");
                            this.progressDialog.startTimer();
                            AppletLogger.logInfo(this, "importNewDocuments", "update base part url =" + this.getUpdateBasePartURL());
                            int extIndex = baseFileName.lastIndexOf(46);
                            String ext = "dat";
                            if (extIndex != -1) {
                                ext = baseFileName.substring(extIndex + 1);
                                AppletLogger.logInfo(this, "importNewDocuments", "File extension is " + ext);
                            }
                            String newMimeType = MimeTypeUtil.getMimeType(ext);
                            AppletLogger.logInfo(this, "importNewDocuments", "New mime type from ext = " + newMimeType);
                            String mimeTypeParam = "mimetype=" + newMimeType;
                            this.appendQueryString(mimeTypeParam);
                            AppletLogger.logInfo(this, "importNewDocuments", "query String = " + this.getQueryString());
                            URLConnection connection = this.getConnection(this.getUpdateBasePartURL() + "?" + this.getQueryString());
                            AppletLogger.logInfo(this, "importNewDocuments", connection.getURL().toString());
                            this.progressDialog.update("importApplet_progress_import", baseFileName);
                            this.streamFile(connection, baseFileName);
                            if (connection instanceof HttpURLConnection && (httpDocUrlConnection = (HttpURLConnection)connection).getResponseCode() != 200) {
                                throw new HttpException(httpDocUrlConnection.getResponseCode(), httpDocUrlConnection.getResponseMessage());
                            }
                            boolean jsonErrorsFound = false;
                            InputStream is = connection.getInputStream();
                            ByteArrayOutputStream resBytes = new ByteArrayOutputStream();
                            byte[] buf = new byte[1024];
                            int len = is.read(buf);
                            while (len > 0) {
                                resBytes.write(buf, 0, len);
                                len = is.read(buf);
                            }
                            resultJSON = JSONObject.parse(resBytes.toString("UTF-8"));
                            AppletLogger.logInfo(this, "importNewDocuments", "JSON object=" + resultJSON.toString());
                            if (resultJSON != null && resultJSON.containsKey("errors")) {
                                AppletLogger.logError((Object)this, "importNewDocuments", "errors found");
                                jsonErrorsFound = true;
                            }
                            if (!(connection instanceof HttpURLConnection)) continue;
                            HttpURLConnection httpAnnoURLConn = (HttpURLConnection)connection;
                            int responseCode = httpAnnoURLConn.getResponseCode();
                            AppletLogger.logInfo(this, "importNewDocuments", "Http response code: " + responseCode);
                            String errorMessage = "";
                            if (responseCode < 400 && !jsonErrorsFound) continue;
                            String errors = resultJSON.get("errors").toString();
                            AppletLogger.logError((Object)this, "importNewDocuments", "errors=" + errors.toString());
                            JSONObject errObject = JSONObject.parse(errors);
                            errorMessage = errObject.get("globals").toString();
                            AppletLogger.logError((Object)this, "importNewDocuments", "globals=" + errorMessage);
                            this.bImportSuccess = false;
                            this.addFileToFailureList(baseFileName, errorMessage);
                        }
                        Object var24_29 = null;
                        if (this.progressDialog == null) break block33;
                    }
                    catch (FileNotFoundException fnfe) {
                        AppletLogger.logError((Object)this, "importNewDocuments", fnfe);
                        this.bImportSuccess = false;
                        String message = this.getMessage("exportApplet_filenotfound_error", new String[]{baseFileName});
                        this.addFileToFailureList(baseFileName, message);
                        Object var24_30 = null;
                        if (this.progressDialog != null) {
                            this.progressDialog.setVisible(false);
                            this.progressDialog.stopTimer();
                        }
                        if (!this.bImportDocuments) break block35;
                        if (this.bImportSuccess) {
                            AppletUtils.execJavaScript(this, this.jsImportNewSuccess, new String[]{resultJSON.toString()});
                            AppletLogger.logInfo(this, "importNewDocuments", " add document succeeded !!");
                            break block35;
                        }
                        String errorMessage = this.getAllErrorMessages();
                        AppletLogger.logInfo(this, "importNewDocuments", "add document failed with error: " + errorMessage);
                        if (errorMessage != null && errorMessage.length() > 0) {
                            AppletUtils.execJavaScript(this, this.jsImportNewFailed, new String[]{errorMessage});
                        }
                        this.importFailureMessages = null;
                        if (bImportSessionExpired) {
                            AppletUtils.execJavaScript(this, this.jsImportSessionExpired, null);
                        }
                        break block35;
                    }
                    catch (HttpException he) {
                        AppletLogger.logError((Object)this, "importNewDocuments", he);
                        this.bImportSuccess = false;
                        this.addFileToFailureList(baseFileName, he.getMessage());
                        if (he.getStatusCode() == 408) {
                            bImportSessionExpired = true;
                        }
                        Object var24_31 = null;
                        if (this.progressDialog != null) {
                            this.progressDialog.setVisible(false);
                            this.progressDialog.stopTimer();
                        }
                        if (!this.bImportDocuments) break block35;
                        if (this.bImportSuccess) {
                            AppletUtils.execJavaScript(this, this.jsImportNewSuccess, new String[]{resultJSON.toString()});
                            AppletLogger.logInfo(this, "importNewDocuments", " add document succeeded !!");
                            break block35;
                        }
                        String errorMessage = this.getAllErrorMessages();
                        AppletLogger.logInfo(this, "importNewDocuments", "add document failed with error: " + errorMessage);
                        if (errorMessage != null && errorMessage.length() > 0) {
                            AppletUtils.execJavaScript(this, this.jsImportNewFailed, new String[]{errorMessage});
                        }
                        this.importFailureMessages = null;
                        if (bImportSessionExpired) {
                            AppletUtils.execJavaScript(this, this.jsImportSessionExpired, null);
                        }
                        break block35;
                    }
                    catch (Exception e) {
                        AppletLogger.logError((Object)this, "importNewDocuments", e);
                        this.bImportSuccess = false;
                        this.addFileToFailureList(baseFileName, this.getMessage("importApplet_importFailed"));
                        Object var24_32 = null;
                        if (this.progressDialog != null) {
                            this.progressDialog.setVisible(false);
                            this.progressDialog.stopTimer();
                        }
                        if (!this.bImportDocuments) break block35;
                        if (this.bImportSuccess) {
                            AppletUtils.execJavaScript(this, this.jsImportNewSuccess, new String[]{resultJSON.toString()});
                            AppletLogger.logInfo(this, "importNewDocuments", " add document succeeded !!");
                            break block35;
                        }
                        String errorMessage = this.getAllErrorMessages();
                        AppletLogger.logInfo(this, "importNewDocuments", "add document failed with error: " + errorMessage);
                        if (errorMessage != null && errorMessage.length() > 0) {
                            AppletUtils.execJavaScript(this, this.jsImportNewFailed, new String[]{errorMessage});
                        }
                        this.importFailureMessages = null;
                        if (bImportSessionExpired) {
                            AppletUtils.execJavaScript(this, this.jsImportSessionExpired, null);
                        }
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    Object var24_33 = null;
                    if (this.progressDialog != null) {
                        this.progressDialog.setVisible(false);
                        this.progressDialog.stopTimer();
                    }
                    if (!this.bImportDocuments) throw throwable;
                    if (this.bImportSuccess) {
                        AppletUtils.execJavaScript(this, this.jsImportNewSuccess, new String[]{resultJSON.toString()});
                        AppletLogger.logInfo(this, "importNewDocuments", " add document succeeded !!");
                        throw throwable;
                    }
                    String errorMessage = this.getAllErrorMessages();
                    AppletLogger.logInfo(this, "importNewDocuments", "add document failed with error: " + errorMessage);
                    if (errorMessage != null && errorMessage.length() > 0) {
                        AppletUtils.execJavaScript(this, this.jsImportNewFailed, new String[]{errorMessage});
                    }
                    this.importFailureMessages = null;
                    if (!bImportSessionExpired) throw throwable;
                    AppletUtils.execJavaScript(this, this.jsImportSessionExpired, null);
                    throw throwable;
                }
                this.progressDialog.setVisible(false);
                this.progressDialog.stopTimer();
            }
            if (this.bImportDocuments) {
                if (this.bImportSuccess) {
                    AppletUtils.execJavaScript(this, this.jsImportNewSuccess, new String[]{resultJSON.toString()});
                    AppletLogger.logInfo(this, "importNewDocuments", " add document succeeded !!");
                } else {
                    String errorMessage = this.getAllErrorMessages();
                    AppletLogger.logInfo(this, "importNewDocuments", "add document failed with error: " + errorMessage);
                    if (errorMessage != null && errorMessage.length() > 0) {
                        AppletUtils.execJavaScript(this, this.jsImportNewFailed, new String[]{errorMessage});
                    }
                    this.importFailureMessages = null;
                    if (bImportSessionExpired) {
                        AppletUtils.execJavaScript(this, this.jsImportSessionExpired, null);
                    }
                }
            }
        }
        AppletLogger.logExit(this, "importNewDocuments");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void streamFile(URLConnection connection, String baseFileName) throws Exception {
        String methodName = "streamFile";
        File fileToUpload = new File(baseFileName);
        connection.setDoOutput(true);
        if (!(connection instanceof HttpURLConnection)) throw new Exception("Connection is not of type HttpURLConnection");
        AppletLogger.logInfo(this, "streamFile", "This is HttpURLConnection");
        ((HttpURLConnection)connection).setRequestMethod("POST");
        if (fileToUpload.length() >= Integer.MAX_VALUE) throw new Exception("File size is larger than 2147483647 bytes.");
        try {
            Class<?> httpURLConnectionClass = connection.getClass();
            httpURLConnectionClass.getMethod("setFixedLengthStreamingMode", Integer.TYPE).invoke((Object)connection, new Integer((int)fileToUpload.length()));
        }
        catch (NoSuchMethodException nsme) {
            AppletLogger.logInfo(this, "streamFile", "HttpURLConnection does not support method setFixedLengthStreamingMode(). JVM must be version < 1.5.0.");
        }
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestProperty("Content-Length", String.valueOf(fileToUpload.length()));
        String language = this.getLocale().getLanguage();
        String country = this.getLocale().getCountry();
        if (country != null && country.length() > 0) {
            language = language + "-" + country;
        }
        connection.setRequestProperty("Accept-Language", language);
        int totalBytesRead = 0;
        int bytesReadIn = 0;
        BufferedInputStream bufferedIS = new BufferedInputStream(new FileInputStream(fileToUpload));
        OutputStream os = connection.getOutputStream();
        byte[] fileBuffer = new byte[4096];
        while ((bytesReadIn = bufferedIS.read(fileBuffer)) != -1) {
            totalBytesRead += bytesReadIn;
            os.write(fileBuffer, 0, bytesReadIn);
        }
        AppletLogger.logInfo(this, "streamFile", "Total bytes read = " + totalBytesRead);
        bufferedIS.close();
    }

    public void doDestroy() {
    }

    protected String doGetAppletInfo() {
        return "Licensed Materials - Property of IBM\n(C) Copyright IBM Corp. 1994, 2005. All Rights Reserved.\n\nUS Government Users Restricted Rights\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corp.\n\nDISCLAIMER OF WARRANTIES :\n\nPermission is granted to copy and modify this Sample code, and to\ndistribute modified versions provided that both the copyright\nnotice and this permission notice and warranty disclaimer\nappear in all copies and modified versions.\n\nTHIS SAMPLE CODE IS LICENSED TO YOU AS-IS.\nIBM AND ITS SUPPLIERS AND LICENSORS DISCLAIM\nALL WARRANTIES, EITHER EXPRESS OR IMPLIED, IN SUCH SAMPLE CODE,\nINCLUDING THE WARRANTY OF NON-INFRINGEMENT AND THE IMPLIED WARRANTIES\nOF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT\nWILL IBM OR ITS LICENSORS OR SUPPLIERS BE LIABLE FOR ANY DAMAGES\nARISING OUT OF THE USE OF OR INABILITY TO USE THE SAMPLE CODE,\nDISTRIBUTION OF THE SAMPLE CODE, OR COMBINATION OF THE SAMPLE CODE\nWITH ANY OTHER CODE. IN NO EVENT SHALL IBM OR ITS LICENSORS AND\nSUPPLIERS BE LIABLE FOR ANY LOST REVENUE, LOST PROFITS OR DATA, OR\nFOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE\nDAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY,\nEVEN IF IBM OR ITS LICENSORS OR SUPPLIERS HAVE BEEN ADVISED OF THE\nPOSSIBILITY OF SUCH DAMAGES.";
    }

    protected String[][] doGetParameterInfo() {
        return null;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    public void pauseImportDocument() {
        this.bImportDocuments = false;
    }

    public boolean isCreateNewParts() {
        return this.bCreateNewPart;
    }

    public void setCreateNewParts(boolean createNewParts) {
        String methodName = "setCreateNewParts";
        AppletLogger.logInfo(this, "setCreateNewParts", "create new part = " + this.bCreateNewPart);
        this.bCreateNewPart = createNewParts;
    }

    private class HttpException
    extends Exception {
        int statusCode;

        HttpException(int statusCode, String message) {
            super(message);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

