/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.versioning;

import com.ibm.ecm.applets.AppletLogger;
import com.ibm.ecm.applets.versioning.AppletUtils;
import com.ibm.ecm.applets.versioning.BaseApplet;
import com.ibm.ecm.applets.versioning.ExportItemsModel;
import com.ibm.ecm.applets.versioning.ProgressDialog;
import com.ibm.ecm.util.MimeTypeUtil;
import com.ibm.json.java.JSONObject;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ExportApplet
extends BaseApplet {
    protected Thread thread;
    protected byte threadState = 1;
    private boolean bExportDocuments;
    private boolean bExportSuccess;
    private boolean bCheckOutSuccess;
    private boolean bExportSessionExpired;
    private boolean bEditDocument;
    private boolean bPause;
    private boolean bDiskFull;
    protected ProgressDialog progressDialog = null;
    private ExportItemsModel exportItemsModel = null;
    private String docURL;
    private String annotationsURL;
    private String notelogsURL;
    private String metaDataURL;
    private String checkOutURL;
    private String unlockURL;
    private String unlockQuery;
    private String persistentKey;
    private FailedItemsTable failedItemsTable = null;
    private String jsExportSuccess = "exportSuccess";
    private String jsExportFailed = "exportFailed";
    private String jsExportSessionExpired = "exportSessionExpired";
    private String jsCheckOutSuccess = "lockSuccess";
    private String jsCheckOutFailed = "lockFailed";
    public static final String annotationExtension = ".t_l";

    public void doInit() {
        String methodName = "doInit";
        AppletLogger.logEntry(this, "doInit");
        this.setThreadState((byte)1);
        this.getThread().start();
        this.exportItemsModel = new ExportItemsModel(this.request, this);
        String editDoc = this.getParameter("applet_edit_document");
        this.bEditDocument = editDoc.equals("true");
        AppletLogger.logInfo(this, "doInit", " Edit Document set to " + this.bEditDocument);
        AppletLogger.logInfo(this, "doInit", "initializing export applet...");
        AppletLogger.logExit(this, "doInit");
    }

    public void doRun() {
        String methodName = "doRun";
        AppletLogger.logEntry(this, "doRun");
        int iPauseSleep = 100;
        while (this.isAppletAlive()) {
            switch (this.getThreadState()) {
                case 1: {
                    try {
                        Thread.sleep(iPauseSleep);
                    }
                    catch (InterruptedException ie) {
                        AppletLogger.logError((Object)this, "doRun", ie);
                    }
                    if (!this.bExportDocuments) break;
                    this.setThreadState((byte)3);
                    break;
                }
                case 3: {
                    if (this.bExportDocuments) {
                        this.exportDocuments();
                        this.bExportDocuments = false;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        AppletLogger.logError((Object)this, "doRun", ie);
                    }
                    this.setThreadState((byte)1);
                }
            }
        }
        AppletLogger.logExit(this, "doRun");
    }

    public void cancel() {
        String methodName = "cancel";
        AppletLogger.logEntry(this, "cancel");
        this.bPause = true;
        this.bExportSuccess = false;
        this.bExportDocuments = false;
        if (this.progressDialog != null) {
            this.progressDialog.setVisible(false);
            this.progressDialog.stopTimer();
        }
        this.setThreadState((byte)1);
        AppletLogger.logExit(this, "cancel");
    }

    public boolean testExpApp() {
        String methodName = "testExpApp";
        AppletLogger.logInfo(this, methodName, "Export Applet detected");
        return true;
    }

    public String getAnnotationsURL() {
        return this.annotationsURL;
    }

    public void setAnnotationsURL(String annotationsURL) {
        this.annotationsURL = annotationsURL;
    }

    public String getDocURL() {
        return this.docURL;
    }

    public void setDocURL(String docURL) {
        this.docURL = docURL;
    }

    public String getNotelogsURL() {
        return this.notelogsURL;
    }

    public void setNotelogsURL(String notelogsURL) {
        this.notelogsURL = notelogsURL;
    }

    public String getMetaDataURL() {
        return this.metaDataURL;
    }

    public void setMetaDataURL(String propertiesURL) {
        this.metaDataURL = propertiesURL;
    }

    public String getCheckOutURL() {
        return this.checkOutURL;
    }

    public void setCheckOutURL(String checkOutURL) {
        this.checkOutURL = checkOutURL;
    }

    public void setPersistentKey(String key) {
        this.persistentKey = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkoutDocument(String pid, String documentName, String extension) {
        String methodName = "checkoutDocument";
        AppletLogger.logEntry(this, "checkoutDocument");
        try {
            AppletLogger.logInfo(this, "checkoutDocument", this.getCheckOutURL() + "&docid=" + URLEncoder.encode(pid, "UTF-8"));
            URLConnection urlConnect = this.getConnection(this.getCheckOutURL() + "&docid=" + URLEncoder.encode(pid, "UTF-8"));
            if (null != urlConnect) {
                if (urlConnect instanceof HttpURLConnection) {
                    HttpURLConnection httpAnnoURLConn = (HttpURLConnection)urlConnect;
                    int responseCode = httpAnnoURLConn.getResponseCode();
                    AppletLogger.logInfo(this, "checkoutDocument", "Http response code: " + responseCode);
                    if (responseCode >= 400) {
                        this.bCheckOutSuccess = false;
                        AppletLogger.logInfo(this, "checkoutDocument", "adding " + documentName + " to failed list");
                        this.addFileToFailureList(new ExportItem(pid, documentName, MimeTypeUtil.getMimeType(extension), "checkout failed"), true);
                        boolean bl = this.bCheckOutSuccess;
                        return bl;
                    }
                }
                this.bCheckOutSuccess = true;
                AppletLogger.logInfo(this, "checkoutDocument", "checkout was a success");
                boolean bl = this.bCheckOutSuccess;
                return bl;
            }
        }
        catch (Exception e) {
            AppletLogger.logError((Object)this, "checkoutDocument", e);
            this.addFileToFailureList(new ExportItem(pid, documentName, MimeTypeUtil.getMimeType(extension), e.getMessage()), true);
            this.bCheckOutSuccess = false;
        }
        finally {
            if (this.bCheckOutSuccess) {
                AppletUtils.execJavaScript(this, this.jsCheckOutSuccess, new String[0]);
                AppletLogger.logInfo(this, "checkoutDocument", "checkout succeeded for doc:" + documentName);
            } else {
                AppletUtils.execJavaScript(this, this.jsCheckOutFailed, new String[0]);
                AppletLogger.logInfo(this, "checkoutDocument", "checkout failed for doc:" + documentName);
            }
            this.bCheckOutSuccess = false;
        }
        AppletLogger.logExit(this, "checkoutDocument");
        return false;
    }

    private boolean unlockDocument(String fileName, String docId) throws IOException, HttpException {
        HttpURLConnection httpDocUrlConnection;
        String methodName = "unlockDocument";
        AppletLogger.logEntry(this, "unlockDocument");
        URLConnection connection = this.getConnection(this.unlockURL + this.unlockQuery + "&docid=" + URLEncoder.encode(docId, "UTF-8"));
        AppletLogger.logInfo(this, "unlockDocument", connection.getURL().toString());
        if (connection instanceof HttpURLConnection && (httpDocUrlConnection = (HttpURLConnection)connection).getResponseCode() != 200) {
            throw new HttpException(httpDocUrlConnection.getResponseCode(), httpDocUrlConnection.getResponseMessage());
        }
        JSONObject resultJSON = new JSONObject();
        resultJSON = JSONObject.parse(this.readJSONCallback(connection.getInputStream()));
        AppletLogger.logInfo(this, "unlockDocument", "JSON object=" + resultJSON.toString());
        if (resultJSON.containsKey("errors")) {
            AppletLogger.logError((Object)this, "unlockDocument", "Errors found: " + resultJSON.containsKey("errors"));
        }
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpAnnoURLConn = (HttpURLConnection)connection;
            if (httpAnnoURLConn.getResponseCode() >= 400 || resultJSON.containsKey("errors")) {
                JSONObject errObject = JSONObject.parse(resultJSON.get("errors").toString());
                AppletLogger.logError((Object)this, "unlockDocument", "errors=" + resultJSON.get("errors"));
                AppletLogger.logError((Object)this, "unlockDocument", "globals=" + errObject.get("globals"));
                return false;
            }
            return true;
        }
        AppletLogger.logExit(this, "unlockDocument");
        return false;
    }

    private String readJSONCallback(InputStream is) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream resultingBytes = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int len = is.read(buf);
        while (len > 0) {
            resultingBytes.write(buf, 0, len);
            len = is.read(buf);
        }
        return resultingBytes.toString("UTF-8");
    }

    public boolean editDocument() {
        return this.bEditDocument;
    }

    public void setEditDocument(boolean editDocument) {
        String methodName = "setEditDocument";
        AppletLogger.logInfo(this, "setEditDocument", "Edit Document set to " + this.bEditDocument);
        this.bEditDocument = editDocument;
    }

    private File initLocalFile(String destPath, String fileName, String fileExt) throws IOException {
        String methodName = "verifyLocalUserDirectory";
        if (destPath == null || destPath.equals("")) {
            try {
                destPath = System.getProperty("user.dir");
            }
            catch (Exception e) {
                AppletLogger.logError((Object)this, "verifyLocalUserDirectory", e);
                destPath = null;
            }
            if (destPath == null || destPath.equals("")) {
                return File.createTempFile(fileName, fileExt);
            }
            return new File(destPath + File.separator + fileName + fileExt);
        }
        return new File(destPath + File.separator + fileName + fileExt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFileFromStream(String destPath, String fileName, String fileExt, String pid, String url) {
        block22: {
            String methodName = "writeFileFromStream";
            AppletLogger.logEntry(this, "writeFileFromStream");
            String exportFilePath = null;
            String mimeType = MimeTypeUtil.getMimeType(fileExt);
            try {
                int numRead;
                FileOutputStream fos;
                if (!this.bExportDocuments) {
                    return false;
                }
                URLConnection urlConnect = this.getConnection(url + "&docid=" + URLEncoder.encode(pid, "UTF-8"));
                if (null == urlConnect) break block22;
                String contentType = urlConnect.getContentType();
                AppletLogger.logDebug(this, "writeFileFromStream", "contentType=" + contentType);
                if (contentType != null && !contentType.equals("") && fileExt != annotationExtension) {
                    fileExt = MimeTypeUtil.getExtFromMimeType(contentType);
                }
                boolean canWrite = true;
                File fileToDownload = this.initLocalFile(destPath, fileName, fileExt);
                exportFilePath = fileToDownload.getCanonicalPath();
                canWrite = this.promptForOverwrite(canWrite, fileToDownload, new ExportItem(pid, fileToDownload.getCanonicalPath(), MimeTypeUtil.getMimeType(fileExt), null));
                AppletLogger.logDebug(this, "writeFileFromStream", "canWrite=" + canWrite);
                if (!canWrite) break block22;
                if (urlConnect instanceof HttpURLConnection) {
                    HttpURLConnection httpAnnoURLConn = (HttpURLConnection)urlConnect;
                    int responseCode = httpAnnoURLConn.getResponseCode();
                    AppletLogger.logDebug(this, "writeFileFromStream", "responseCode=" + responseCode);
                    if (responseCode >= 400) {
                        this.bExportSuccess = false;
                        fileToDownload.delete();
                        this.addFileToFailureList(new ExportItem(pid, fileToDownload.getCanonicalPath(), mimeType, this.getMessage("exportApplet_downloadFailed_details")), true);
                        return false;
                    }
                }
                int bufsize = 4096;
                byte[] buf = new byte[bufsize];
                try {
                    fos = new FileOutputStream(fileToDownload);
                }
                catch (IOException ioe) {
                    AppletLogger.logError((Object)this, "writeFileFromStream", ioe);
                    this.bDiskFull = false;
                    this.bExportSuccess = false;
                    this.addFileToFailureList(new ExportItem(pid, fileToDownload.getCanonicalPath(), mimeType, this.getMessage("exportApplet_filecreate_error", new String[]{fileToDownload.getCanonicalPath()})), true);
                    return false;
                }
                InputStream urlStream = urlConnect.getInputStream();
                int fsize = 0;
                this.progressDialog.update("exportApplet_download_file", fileToDownload.getCanonicalPath());
                while ((numRead = urlStream.read(buf, 0, bufsize)) != -1) {
                    fsize += numRead;
                    try {
                        fos.write(buf, 0, numRead);
                    }
                    catch (IOException ioe) {
                        AppletLogger.logError((Object)this, "writeFileFromStream", ioe);
                        this.bDiskFull = true;
                        this.bExportSuccess = false;
                        this.addFileToFailureList(new ExportItem(pid, fileToDownload.getCanonicalPath(), mimeType, this.getMessage("exportApplet_filecreate_error", new String[]{fileToDownload.getCanonicalPath()})), true);
                        fos.flush();
                        fos.close();
                        urlStream.close();
                        fileToDownload.delete();
                        return false;
                    }
                }
                fos.flush();
                fos.close();
                urlStream.close();
                if (!this.bExportDocuments) {
                    fileToDownload.delete();
                }
                if (this.bExportSuccess && this.bEditDocument) {
                    try {
                        Class<?> dClass = Class.forName("java.awt.Desktop");
                        Object currentDesktop = dClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                        dClass.getMethod("open", File.class).invoke(currentDesktop, fileToDownload);
                    }
                    catch (InvocationTargetException ite) {
                        AppletLogger.logError((Object)this, "writeFileFromStream", ite);
                        this.showErrorMessageDialog(this.getMessage("exportApplet_editorNotFound", new String[]{fileToDownload.getCanonicalPath()}));
                    }
                    catch (Exception e) {
                        AppletLogger.logError((Object)this, "writeFileFromStream", e);
                        this.showErrorMessageDialog(this.getMessage("exportApplet_launchNotSupported", new String[]{fileToDownload.getCanonicalPath()}) + "\n\n" + this.getMessage("exportApplet_launchNotSupported_details", new String[]{fileToDownload.getCanonicalPath()}));
                    }
                    finally {
                        this.bEditDocument = false;
                    }
                }
                return true;
            }
            catch (FileNotFoundException fnfe) {
                this.handleWriteException(new ExportItem(pid, exportFilePath, mimeType, this.getMessage("exportApplet_filenotfound_error", new String[]{exportFilePath})), fnfe);
            }
            catch (IOException ioe) {
                this.handleWriteException(new ExportItem(pid, exportFilePath, mimeType, this.getMessage("exportApplet_downloadFailed")), ioe);
            }
            catch (Exception e) {
                this.handleWriteException(new ExportItem(pid, exportFilePath, mimeType, e.getMessage()), e);
            }
        }
        AppletLogger.logExit(this, "writeFileFromStream");
        return false;
    }

    private void handleWriteException(ExportItem exportItem, Exception e) {
        exportItem.errorMessage = this.getMessage("exportApplet_filenotfound_error");
        this.addFileToFailureList(exportItem, true);
        this.bExportSuccess = false;
        AppletLogger.logError((Object)this, "writeFileFromStream", e);
    }

    private boolean promptForOverwrite(boolean canWrite, File fileToDownload, ExportItem exportItem) throws IOException {
        if (fileToDownload.exists()) {
            this.progressDialog.stopTimer();
            int result = JOptionPane.showConfirmDialog(this.progressDialog, this.getMessage("exportApplet_file_exists", new String[]{fileToDownload.getName()}), this.getMessage("exportApplet_title"), 0);
            boolean bl = canWrite = result == 0;
            if (result == 1) {
                this.bExportSuccess = false;
                this.addFileToFailureList(exportItem, false);
            }
            this.progressDialog.startTimer();
        }
        return canWrite;
    }

    private void showErrorMessageDialog(String message) {
        if (this.progressDialog != null) {
            this.progressDialog.stopTimer();
        }
        JOptionPane.showMessageDialog(this.progressDialog, message, this.getMessage("exportApplet_title"), 0);
        if (this.progressDialog != null) {
            this.progressDialog.startTimer();
        }
    }

    private void showMessageDialog(String message) {
        if (this.progressDialog != null) {
            this.progressDialog.stopTimer();
        }
        JOptionPane.showMessageDialog(this.progressDialog, message);
        if (this.progressDialog != null) {
            this.progressDialog.startTimer();
        }
    }

    public void exportDocument(String strPid, boolean bExportNotelog, boolean bExportAnnotation, boolean bBasePartOnly, boolean bCheckOut, boolean bOldCheckOutState, boolean bExportMetaData, boolean pdfConvert, String baseFileName, String baseFileExt, int partCount, int annopartCount, int notelogCount, String destPath) {
        String methodName = "exportDocument";
        AppletLogger.logEntry(this, "exportDocument");
        try {
            this.processDocumentItem(strPid, bExportNotelog, bExportAnnotation, bBasePartOnly, bCheckOut, bOldCheckOutState, bExportMetaData, pdfConvert, baseFileName, baseFileExt, partCount, annopartCount, notelogCount, destPath);
        }
        catch (Exception e) {
            AppletLogger.logError((Object)this, "exportDocument", e);
            this.bExportSuccess = false;
        }
        AppletLogger.logExit(this, "exportDocument");
    }

    private void processDocumentItem(String strPid, boolean bExportNotelog, boolean bExportAnnotation, boolean bBasePartOnly, boolean bCheckOut, boolean bOldCheckOutState, boolean bExportMetaData, boolean pdfConvert, String baseFilename, String fileExt, int partCount, int annoPartCount, int notelogCount, String destPath) throws Exception {
        String methodName = "processDocumentItem";
        AppletLogger.logEntry(this, "processDocumentItem");
        if (bCheckOut) {
            boolean checkOutStatus = this.checkoutDocument(strPid, baseFilename, fileExt);
            AppletLogger.logInfo(this, "processDocumentItem", "checkoutstatus = " + checkOutStatus);
        }
        if (pdfConvert) {
            this.exportPDFConvertedDocument(destPath, baseFilename, strPid, "pdf", bOldCheckOutState);
        } else {
            if (bBasePartOnly) {
                partCount = 1;
            }
            this.exportDocumentParts(destPath, baseFilename, partCount, strPid, fileExt, bOldCheckOutState);
        }
        if (!this.bExportSessionExpired && bExportNotelog && notelogCount > 0) {
            this.exportNotelogs(destPath, strPid, baseFilename);
        }
        if (!this.bExportSessionExpired && bExportAnnotation && annoPartCount > 0) {
            this.exportAnnotations(destPath, strPid, baseFilename);
        }
        if (!this.bExportSessionExpired && bExportMetaData) {
            this.exportMetaData(destPath, strPid, baseFilename);
        }
        AppletLogger.logExit(this, "processDocumentItem");
    }

    public void setPid(String index, String pid) {
        this.exportItemsModel.setPid("parm_export_key" + index, pid);
    }

    public void setPartCount(String index, int partCount) {
        this.exportItemsModel.setPartCount("parm_export_key" + index, new Integer(partCount));
    }

    public void setAnnoPartCount(String index, int partCount) {
        String methodName = "setAnnoPartCount";
        AppletLogger.logEntry(this, "setAnnoPartCount");
        AppletLogger.logInfo(this, "setAnnoPartCount", "anno part count=" + partCount);
        AppletLogger.logInfo(this, "setAnnoPartCount", "parm_export_key" + index);
        this.exportItemsModel.setAnnoPartCount("parm_export_key" + index, new Integer(partCount));
        AppletLogger.logExit(this, "setAnnoPartCount");
    }

    public void setNotelogCount(String index, int partCount) {
        this.exportItemsModel.setNotelogCount("parm_export_key" + index, new Integer(partCount));
    }

    public void setFileName(String index, String fileName) {
        this.exportItemsModel.setFileName("parm_export_key" + index, fileName.trim());
    }

    public void setIsCheckedOut(String key, String isCheckedOut) {
        this.exportItemsModel.setIsCheckedOut("parm_export_key" + key, new Boolean(isCheckedOut));
    }

    public void setIsCheckedOut(String key, boolean isCheckedOut) {
        this.exportItemsModel.setIsCheckedOut("parm_export_key" + key, new Boolean(isCheckedOut));
    }

    public String getUnlockURL() {
        return this.unlockURL;
    }

    public void setUnlockURL(String unlockURL) {
        this.unlockURL = unlockURL;
    }

    public String getUnlockQuery() {
        return this.unlockQuery;
    }

    public void setUnlockQuery(String unlockQuery) {
        this.unlockQuery = unlockQuery;
    }

    public void setMimeType(String index, String mimeType) {
        this.exportItemsModel.setMimeType("parm_export_key" + index, mimeType);
    }

    public void setCount(String countOfItems) {
        int count = Integer.parseInt(countOfItems);
        this.exportItemsModel.setItemCount(count);
    }

    public void setDestinationPath(final String destPath, final String currentPath) {
        String methodName = "setDestinationPath";
        AppletLogger.logEntry(this, "setDestinationPath");
        try {
            AppletLogger.logInfo(this, "setDestinationPath", "destPath= " + destPath);
            if (SwingUtilities.isEventDispatchThread()) {
                this.swingSetDestinationPath(destPath, currentPath);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        PrivilegedAction<Integer> pa = new PrivilegedAction<Integer>(){

                            @Override
                            public Integer run() {
                                AppletLogger.logInfo(this, "setDestinationPath", "destPath: " + destPath);
                                AppletLogger.logInfo(this, "setDestinationPath", "currentPath: " + currentPath);
                                ExportApplet.this.swingSetDestinationPath(destPath, currentPath);
                                return new Integer(0);
                            }
                        };
                        int status = AccessController.doPrivileged(pa);
                        AppletLogger.logInfo(this, "setDestinationPath", "status: " + status);
                    }
                });
            }
        }
        catch (Throwable e) {
            AppletLogger.logError((Object)this, "setDestinationPath", e);
        }
        AppletLogger.logExit(this, "setDestinationPath");
    }

    public void swingSetDestinationPath(String destPath, String currentPath) {
        String methodName = "swingSetDestinationPath";
        AppletLogger.logEntry(this, "swingSetDestinationPath");
        if (destPath != null && !destPath.equals("")) {
            boolean isValidDir = true;
            try {
                File testDir = new File(destPath);
                isValidDir = testDir.isDirectory();
            }
            catch (Exception fe) {
                // empty catch block
            }
            if (!isValidDir) {
                this.showMessageDialog(this.getMessage("exportApplet_filenotfound_error", new String[]{destPath}));
                this.exportItemsModel.setDestinationPath(null);
                return;
            }
        }
        this.exportItemsModel.setDestinationPath(destPath);
        AppletLogger.logExit(this, "swingSetDestinationPath");
    }

    public String getDestinationPath() {
        String p = this.exportItemsModel.getDestinationPath();
        return p;
    }

    public void setCheckOut(boolean checkOut) {
        this.exportItemsModel.setCheckOut(checkOut);
    }

    public void setExportNotelog(boolean exportNoteLog) {
        this.exportItemsModel.setExportNotelog(exportNoteLog);
    }

    public void setExportAnnotation(boolean exportAnnotation) {
        this.exportItemsModel.setExportAnnotation(exportAnnotation);
    }

    public void setExportBasePartOnly(boolean exportBasePartOnly) {
        this.exportItemsModel.setExportBasePartOnly(exportBasePartOnly);
    }

    public void setExportMetaData(boolean exportMetaData) {
        this.exportItemsModel.setExportMetaData(exportMetaData);
    }

    public void setPDFConvert(String key, boolean pdfConvert) {
        this.exportItemsModel.setPDFConvert("parm_export_key" + key, new Boolean(pdfConvert));
    }

    public void setPDFConvert(String key, String pdfConvert) {
        this.exportItemsModel.setPDFConvert("parm_export_key" + key, new Boolean(pdfConvert));
    }

    public void startExportDocuments() {
        this.bExportDocuments = true;
    }

    public void clearItems() {
        this.exportItemsModel.clearItems();
    }

    private void addFileToFailureList(ExportItem exportItem, boolean errors) throws IllegalArgumentException {
        String methodName = "addFileToFailureList";
        AppletLogger.logDebug(this, methodName, "docId=" + exportItem.docId);
        AppletLogger.logDebug(this, methodName, "fileName=" + exportItem.fileName);
        AppletLogger.logDebug(this, methodName, "errorMessage=" + exportItem.errorMessage);
        if (this.failedItemsTable == null) {
            this.failedItemsTable = new FailedItemsTable();
        }
        if (exportItem.docId == null) {
            throw new IllegalArgumentException("Null document id, cannot download file.");
        }
        if (!this.failedItemsTable.containsKey(exportItem.docId)) {
            this.failedItemsTable.put(exportItem.docId, exportItem);
        } else {
            AppletLogger.logDebug(this, methodName, this.composeExportItemDebugMessage(exportItem));
        }
        this.failedItemsTable.errors = this.failedItemsTable.errors || errors;
    }

    private String composeExportItemDebugMessage(ExportItem exportItem) {
        StringBuilder s = new StringBuilder();
        s.append("***Duplicate failed item ***\n");
        s.append("fileName = " + exportItem.fileName + "\ndocId = " + exportItem.docId + "\nmimeType = " + exportItem.mimeType + "\n");
        ExportItem ei = (ExportItem)this.failedItemsTable.get(exportItem.docId);
        if (!exportItem.fileName.equals(ei.fileName)) {
            s.append("Inconsistent filenames:\n" + exportItem.fileName + "\n" + ei.fileName + "\n");
        }
        if (!exportItem.docId.equals(ei.docId)) {
            s.append("Inconsistent docId:\n" + exportItem.docId + "\n" + ei.docId + "\n");
        }
        if (!exportItem.mimeType.equals(ei.mimeType)) {
            s.append("Inconsistent mimeType:\n" + exportItem.mimeType + "\n" + ei.mimeType + "\n");
        }
        return s.toString();
    }

    private String getAllErrorMessages() {
        String errorMessage = "";
        if (this.bDiskFull) {
            this.bDiskFull = false;
            errorMessage = this.getMessage("exportApplet_filecreate_error");
        } else if (this.failedItemsTable != null && this.failedItemsTable.errors) {
            Enumeration errorMessages = this.failedItemsTable.elements();
            while (errorMessages.hasMoreElements()) {
                ExportItem next = (ExportItem)errorMessages.nextElement();
                AppletLogger.logDebug(this, "getAllErrorMessages", "next.errorMessages=" + next.errorMessage);
                errorMessage = errorMessage + next.errorMessage + "\n\n";
            }
        }
        AppletLogger.logDebug(this, "getAllErrorMessages", "errorMessage=" + errorMessage);
        return errorMessage;
    }

    private String constructFilesQuery() {
        StringBuilder query = new StringBuilder();
        if (null == this.failedItemsTable) {
            return null;
        }
        ListIterator errorList = this.failedItemsTable.listIterator();
        while (errorList.hasNext()) {
            String docId = (String)errorList.next();
            query.append("&docId=" + docId);
        }
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportDocuments() {
        block23: {
            String methodName = "exportDocuments";
            AppletLogger.logEntry(this, "exportDocuments");
            this.bPause = false;
            this.bExportSuccess = true;
            this.exportItemsModel.setItemCount();
            int numItems = this.exportItemsModel.getItemCount();
            String destinationPath = this.exportItemsModel.getDestinationPath();
            if (destinationPath == null) {
                return;
            }
            int delay = 200;
            if (this.progressDialog == null) {
                this.progressDialog = new ProgressDialog(this.getFrame(), delay, this, "exportApplet_title");
                this.progressDialog.setResizable(true);
                Dimension d1 = this.progressDialog.getSize();
                this.progressDialog.setBounds(500, 400, d1.width, d1.height);
            }
            this.progressDialog.setVisible(true);
            this.progressDialog.init("exportApplet_preparing_for_download");
            try {
                try {
                    for (int i = 0; this.bExportDocuments && !this.bPause && i < numItems; ++i) {
                        String strPid = this.exportItemsModel.getPid("parm_export_key" + i);
                        if (strPid == null || strPid.length() < 0) continue;
                        boolean pdfConvert = this.exportItemsModel.isPDFConvert("parm_export_key" + i);
                        String baseFileName = this.exportItemsModel.getFileName("parm_export_key" + i);
                        baseFileName = baseFileName.replaceAll("[\\/:*?\"<>|]", "-");
                        String baseMimeType = this.exportItemsModel.getMimeType("parm_export_key" + i);
                        boolean bOldCheckOutState = this.exportItemsModel.getIsCheckedOut("parm_export_key" + i);
                        int partCount = 1;
                        int annopartCount = 0;
                        int notelogCount = 0;
                        try {
                            partCount = this.exportItemsModel.getPartCount("parm_export_key" + i);
                        }
                        catch (Exception e) {
                            AppletLogger.logError((Object)this, "exportDocuments", e);
                        }
                        try {
                            annopartCount = this.exportItemsModel.getAnnoPartCount("parm_export_key" + i);
                        }
                        catch (Exception ae) {
                            AppletLogger.logError((Object)this, "exportDocuments", ae);
                        }
                        try {
                            notelogCount = this.exportItemsModel.getNotelogCount("parm_export_key" + i);
                        }
                        catch (Exception ne) {
                            AppletLogger.logError((Object)this, "exportDocuments", ne);
                        }
                        String baseFileExt = MimeTypeUtil.getExtFromMimeType(baseMimeType);
                        this.exportDocument(strPid, this.exportItemsModel.getExportNotelog(), this.exportItemsModel.getExportAnnotation(), this.exportItemsModel.getExportBasePartOnly(), this.exportItemsModel.getCheckOut(), bOldCheckOutState, this.exportItemsModel.getExportMetaData(), pdfConvert, baseFileName, baseFileExt, partCount, annopartCount, notelogCount, destinationPath);
                    }
                    Object var16_20 = null;
                    if (this.progressDialog == null) break block23;
                }
                catch (Exception e) {
                    AppletLogger.logError((Object)this, "exportDocuments", e);
                    this.bExportSuccess = false;
                    Object var16_21 = null;
                    if (this.progressDialog == null) break block23;
                    this.progressDialog.setVisible(false);
                    this.progressDialog.stopTimer();
                    if (!this.bExportDocuments) break block23;
                    if (this.bExportSuccess) {
                        AppletUtils.execJavaScript(this, this.jsExportSuccess, null);
                        break block23;
                    }
                    String errorMessages = this.getAllErrorMessages();
                    if (this.failedItemsTable != null) {
                        String filesQuery = this.constructFilesQuery();
                        this.clearItems();
                        AppletUtils.execJavaScript(this, this.jsExportFailed, new String[]{errorMessages + "||" + "||" + filesQuery});
                    }
                    this.failedItemsTable = null;
                    if (this.bExportSessionExpired) {
                        AppletUtils.execJavaScript(this, this.jsExportSessionExpired, null);
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                Object var16_22 = null;
                if (this.progressDialog == null) throw throwable;
                this.progressDialog.setVisible(false);
                this.progressDialog.stopTimer();
                if (!this.bExportDocuments) throw throwable;
                if (this.bExportSuccess) {
                    AppletUtils.execJavaScript(this, this.jsExportSuccess, null);
                    throw throwable;
                }
                String errorMessages = this.getAllErrorMessages();
                if (this.failedItemsTable != null) {
                    String filesQuery = this.constructFilesQuery();
                    this.clearItems();
                    AppletUtils.execJavaScript(this, this.jsExportFailed, new String[]{errorMessages + "||" + "||" + filesQuery});
                }
                this.failedItemsTable = null;
                if (!this.bExportSessionExpired) throw throwable;
                AppletUtils.execJavaScript(this, this.jsExportSessionExpired, null);
                throw throwable;
            }
            this.progressDialog.setVisible(false);
            this.progressDialog.stopTimer();
            if (this.bExportDocuments) {
                if (this.bExportSuccess) {
                    AppletUtils.execJavaScript(this, this.jsExportSuccess, null);
                } else {
                    String errorMessages = this.getAllErrorMessages();
                    if (this.failedItemsTable != null) {
                        String filesQuery = this.constructFilesQuery();
                        this.clearItems();
                        AppletUtils.execJavaScript(this, this.jsExportFailed, new String[]{errorMessages + "||" + "||" + filesQuery});
                    }
                    this.failedItemsTable = null;
                    if (this.bExportSessionExpired) {
                        AppletUtils.execJavaScript(this, this.jsExportSessionExpired, null);
                    }
                }
            }
        }
        AppletLogger.logExit(this, "exportDocuments");
    }

    public void getSelectedDir(final String currDirectory) {
        String methodName = "getSelectedDir";
        AppletLogger.logEntry(this, "getSelectedDir");
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.swingGetSelectedDir(currDirectory);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        PrivilegedAction<Integer> pa = new PrivilegedAction<Integer>(){

                            @Override
                            public Integer run() {
                                AppletLogger.logInfo(this, "getSelectedDir", "currentDir: " + currDirectory);
                                ExportApplet.this.swingGetSelectedDir(currDirectory);
                                return new Integer(0);
                            }
                        };
                        int status = AccessController.doPrivileged(pa);
                        AppletLogger.logInfo(this, "getSelectedDir", "status: " + status);
                    }
                });
            }
        }
        catch (Throwable e) {
            AppletLogger.logError((Object)this, "getSelectedDir", e);
        }
        AppletLogger.logExit(this, "getSelectedDir");
    }

    public void swingGetSelectedDir(String currentDirectory) {
        String methodName = "getSelectedDir";
        AppletLogger.logEntry(this, "getSelectedDir");
        Frame frame = new Frame();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        File f = new File(currentDirectory);
        if (f != null && f.exists()) {
            chooser.setCurrentDirectory(f);
        } else {
            chooser.setCurrentDirectory(null);
        }
        int returnValue = chooser.showOpenDialog(frame);
        String newDirectory = chooser.getCurrentDirectory().getAbsolutePath();
        if (returnValue == 0) {
            newDirectory = chooser.getSelectedFile().getAbsolutePath();
            AppletLogger.logInfo(this, "getSelectedDir", "You chose to save files in this directory: " + newDirectory);
        } else {
            newDirectory = currentDirectory;
            AppletLogger.logInfo(this, "getSelectedDir", "Previous chosen directory: " + newDirectory);
        }
        this.setDestinationPath(newDirectory, currentDirectory);
    }

    public void doDestroy() {
    }

    protected String doGetAppletInfo() {
        return "Licensed Materials - Property of IBM\n(C) Copyright IBM Corp. 1994, 2005. All Rights Reserved.\n\nUS Government Users Restricted Rights\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corp.\n\nDISCLAIMER OF WARRANTIES :\n\nPermission is granted to copy and modify this Sample code, and to\ndistribute modified versions provided that both the copyright\nnotice and this permission notice and warranty disclaimer\nappear in all copies and modified versions.\n\nTHIS SAMPLE CODE IS LICENSED TO YOU AS-IS.\nIBM AND ITS SUPPLIERS AND LICENSORS DISCLAIM\nALL WARRANTIES, EITHER EXPRESS OR IMPLIED, IN SUCH SAMPLE CODE,\nINCLUDING THE WARRANTY OF NON-INFRINGEMENT AND THE IMPLIED WARRANTIES\nOF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT\nWILL IBM OR ITS LICENSORS OR SUPPLIERS BE LIABLE FOR ANY DAMAGES\nARISING OUT OF THE USE OF OR INABILITY TO USE THE SAMPLE CODE,\nDISTRIBUTION OF THE SAMPLE CODE, OR COMBINATION OF THE SAMPLE CODE\nWITH ANY OTHER CODE. IN NO EVENT SHALL IBM OR ITS LICENSORS AND\nSUPPLIERS BE LIABLE FOR ANY LOST REVENUE, LOST PROFITS OR DATA, OR\nFOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE\nDAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY,\nEVEN IF IBM OR ITS LICENSORS OR SUPPLIERS HAVE BEEN ADVISED OF THE\nPOSSIBILITY OF SUCH DAMAGES.";
    }

    protected String[][] doGetParameterInfo() {
        return null;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    private boolean exportDocumentParts(String destPath, String exportBaseFilename, int partCount, String strPid, String fileExt, boolean bOldCheckOutState) throws IOException, HttpException {
        String methodName = "exportDocumentParts";
        AppletLogger.logEntry(this, "exportDocumentParts");
        DecimalFormat threeDigits = new DecimalFormat("000");
        boolean bDocumentExportSuccess = true;
        if (partCount > 1) {
            for (int part = 0; !this.bPause && part < partCount && bDocumentExportSuccess; ++part) {
                String exportFilename = exportBaseFilename;
                if (part != 0) {
                    exportFilename = exportBaseFilename + "-" + threeDigits.format(part + 1);
                }
                String currentURL = this.getDocURL() + "&transform=native&part_number=" + part;
                AppletLogger.logInfo(this, "exportDocumentParts", "part number = " + part);
                if (this.writeFileFromStream(destPath, exportFilename, fileExt, strPid, currentURL)) continue;
                bDocumentExportSuccess = false;
                if (part != 0 || bOldCheckOutState) continue;
                this.unlockDocument(exportBaseFilename, strPid);
            }
        } else if (!this.bPause && partCount == 1) {
            this.progressDialog.update("exportApplet_download_file", destPath + File.separator + exportBaseFilename + fileExt);
            String currentURL = this.getDocURL() + "&transform=native";
            if (!this.writeFileFromStream(destPath, exportBaseFilename, fileExt, strPid, currentURL)) {
                bDocumentExportSuccess = false;
                if (!bOldCheckOutState) {
                    this.unlockDocument(exportBaseFilename, strPid);
                }
            }
        }
        AppletLogger.logExit(this, "exportDocumentParts");
        return bDocumentExportSuccess;
    }

    private boolean exportPDFConvertedDocument(String destPath, String exportBaseFilename, String strPid, String fileExt, boolean bOldCheckOutState) throws IOException, HttpException {
        String methodName = "exportPDFConvertedDocument";
        AppletLogger.logEntry(this, "exportPDFConvertedDocument");
        boolean bDocumentExportSuccess = true;
        String currentURL = this.getDocURL();
        if (!this.bPause) {
            this.progressDialog.update("exportApplet_download_file", destPath + File.separator + exportBaseFilename + fileExt);
            if (!this.writeFileFromStream(destPath, exportBaseFilename, fileExt, strPid, currentURL + "&transform=PDF")) {
                bDocumentExportSuccess = false;
                if (!bOldCheckOutState) {
                    this.unlockDocument(exportBaseFilename, strPid);
                }
            }
        }
        AppletLogger.logExit(this, "exportPDFConvertedDocument");
        return bDocumentExportSuccess;
    }

    private boolean exportNotelogs(String destPath, String strPid, String exportBaseFilename) {
        int notelogCount = 1;
        if (!this.bPause && notelogCount > 0) {
            String exportFilename = exportBaseFilename + "_notelog";
            String ext = ".txt";
            this.progressDialog.update("exportApplet_download_file", destPath + File.separator + exportFilename + ext);
            this.writeFileFromStream(destPath, exportFilename, ext, strPid, this.getNotelogsURL());
        }
        return true;
    }

    private boolean exportAnnotations(String destPath, String strPid, String exportBaseFilename) {
        this.progressDialog.update("exportApplet_download_file", exportBaseFilename + annotationExtension);
        this.writeFileFromStream(destPath, exportBaseFilename, annotationExtension, strPid, this.getAnnotationsURL());
        return true;
    }

    private boolean exportMetaData(String destPath, String strPid, String exportBaseFilename) {
        String exportFilename = exportBaseFilename + "_properties";
        String ext = ".xml";
        this.progressDialog.update("exportApplet_download_file", destPath + File.separator + exportFilename + ext);
        this.writeFileFromStream(destPath, exportFilename, ext, strPid, this.getMetaDataURL());
        return true;
    }

    private class HttpException
    extends Exception {
        int statusCode;

        HttpException(int statusCode, String message) {
            super(message);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }

    private class ExportItem {
        public String docId;
        public String fileName;
        public String mimeType;
        public String errorMessage;

        public ExportItem() {
            this.docId = new String();
            this.fileName = new String();
            this.mimeType = new String();
            this.errorMessage = new String();
        }

        public ExportItem(String docId, String fileName, String mimeType, String errorMessage) {
            this.docId = docId;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.errorMessage = errorMessage;
        }
    }

    private class FailedItemsTable
    extends Hashtable {
        private LinkedList _order = new LinkedList();
        public boolean errors = false;

        FailedItemsTable() {
        }

        public Object put(String key, ExportItem value) {
            this._order.add(key);
            return super.put(key, value);
        }

        public ListIterator listIterator() {
            return this._order.listIterator();
        }
    }
}

