/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.versioning;

import com.ibm.ecm.applets.AppletLogger;
import com.ibm.ecm.applets.versioning.AppletUtils;
import java.awt.Container;
import java.awt.Frame;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.http.HttpServletRequest;
import javax.swing.JApplet;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public abstract class BaseApplet
extends JApplet
implements Runnable {
    protected Thread thread;
    private AppletUtils appletUtils;
    protected String className = "WCBaseApplet";
    protected byte threadState = 1;
    protected HttpServletRequest request = null;

    public void init() {
        this.getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
        this.getAppletUtils().setAppletLocale(this);
        String logLevel = this.getParameter("logLevel");
        AppletLogger.setLogLevel(Integer.parseInt(logLevel));
        try {
            System.setProperty("swing.useSystemFontSettings", "false");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        this.thread = new Thread(this);
        this.doInit();
    }

    protected abstract void doInit();

    public void run() {
        this.doRun();
    }

    protected abstract void doRun();

    protected AppletUtils getAppletUtils() {
        if (this.appletUtils == null) {
            this.appletUtils = new AppletUtils();
        }
        return this.appletUtils;
    }

    String getMessage(String key) {
        String methodName = "getMessage";
        String message = "";
        try {
            message = AppletUtils.getResourceBundle(this.getLocale()).getString(key);
        }
        catch (Exception e) {
            AppletLogger.logError(BaseApplet.class, methodName, e);
            return key;
        }
        return message;
    }

    String getMessage(String key, String[] inserts) {
        String methodName = "getMessageReplaceTokens";
        String message = "";
        try {
            message = AppletUtils.getResourceBundle(this.getLocale()).getString(key);
            if (message == null) {
                message = key;
            } else {
                for (int i = 0; i < inserts.length; ++i) {
                    String token = "{" + i + "}";
                    int index = message.indexOf(token);
                    StringBuffer buffer = new StringBuffer(message);
                    if (index < 0) continue;
                    message = buffer.replace(index, index + token.length(), inserts[i]).toString();
                }
            }
        }
        catch (Exception e) {
            AppletLogger.logError(BaseApplet.class, methodName, e);
            message = key;
        }
        return message;
    }

    protected URLConnection getConnection(String docURL) {
        String methodName = "getConnection";
        AppletLogger.logEntry(this, "getConnection");
        URLConnection urlConnect = null;
        URL urlServlet = null;
        try {
            urlServlet = new URL(this.getCodeBase(), docURL);
            AppletLogger.logDebug(this, "getConnection", " doc url in get Connection = " + urlServlet);
            urlConnect = urlServlet.openConnection();
        }
        catch (MalformedURLException mue) {
            AppletLogger.logError((Object)this, "getConnection", mue);
        }
        catch (IOException ioe) {
            AppletLogger.logError((Object)this, "getConnection", ioe);
            urlConnect = null;
        }
        AppletLogger.logExit(this, "getConnection");
        return urlConnect;
    }

    public void destroy() {
        String methodName = "destroy";
        this.setThreadState((byte)0);
        while (this.thread.isAlive()) {
            try {
                this.thread.join(50L);
            }
            catch (InterruptedException ie) {
                AppletLogger.logError((Object)this, "destroy", ie);
            }
        }
        this.doDestroy();
    }

    protected abstract void doDestroy();

    public byte getThreadState() {
        return this.threadState;
    }

    protected void setThreadState(byte tState) {
        if (0 != this.threadState) {
            this.threadState = tState;
        }
    }

    protected Thread getThread() {
        return this.thread;
    }

    protected void setThread(Thread threadData) {
        this.thread = threadData;
    }

    protected boolean isAppletAlive() {
        return 0 != this.threadState;
    }

    public void showStatus(String strStatus) {
        super.showStatus(strStatus);
    }

    public Frame getFrame() {
        Frame result = null;
        for (Container c = this; result == null && c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            result = (Frame)c;
        }
        return result;
    }

    public String getAppletInfo() {
        return this.doGetAppletInfo();
    }

    protected abstract String doGetAppletInfo();

    public String[][] getParameterInfo() {
        return this.doGetParameterInfo();
    }

    protected abstract String[][] doGetParameterInfo();

    public void start() {
        this.doStart();
    }

    protected abstract void doStart();

    public void stop() {
        this.doStop();
    }

    protected abstract void doStop();
}

