/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.versioning;

import com.ibm.ecm.applets.AppletLogger;
import com.ibm.ecm.applets.versioning.AppletConstants;
import java.applet.Applet;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import netscape.javascript.JSObject;
import sun.awt.AppContext;

public class AppletUtils
implements AppletConstants {
    public static boolean isBIDI = false;
    public Locale locale = Locale.getDefault();
    public static String APPLET_MESSAGES = "com.ibm.ecm.applets.AppletMessages";

    public static ResourceBundle getResourceBundle(Locale locale) {
        ClassLoader loader = AppletUtils.class.getClassLoader();
        return ResourceBundle.getBundle(APPLET_MESSAGES, locale, loader);
    }

    public void setAppletLocale(Applet applet) {
        String methodName = "setAppletLocale";
        String language = applet.getParameter("applet_language");
        String country = applet.getParameter("applet_country");
        this.locale = Locale.getDefault();
        if (language != null && country != null) {
            this.locale = new Locale(language, country);
            AppletLogger.logInfo(this, methodName, "Applet locale set to " + this.locale);
        } else {
            try {
                Locale.setDefault(this.locale);
                AppletLogger.logInfo(this, methodName, "Default locale set to =" + this.locale);
            }
            catch (SecurityException e) {
                AppletLogger.logError((Object)this, methodName, e);
            }
        }
        applet.setLocale(this.locale);
        AppContext.getAppContext().put("JComponent.defaultLocale", this.locale);
        String thisLocale = this.locale.toString();
        if (thisLocale != null && (thisLocale.equals("ar") || thisLocale.equals("he") || thisLocale.equals("iw") || thisLocale.equals("iw_IL"))) {
            isBIDI = true;
        }
    }

    public void setLocale(Component comp) {
        comp.setLocale(this.locale);
        if (isBIDI) {
            comp.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            comp.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        }
    }

    public static void getHelp(Applet applet) {
        String strHelp = applet.getParameter("applet_helpPage");
        AppletUtils.openJSWindow(applet, strHelp, "'width=400,height=400,resizable=yes,scrollbars=yes'");
    }

    public static Object openJSWindow(Applet applet, String urlToOpen, String windowFeatures) {
        String strOpenWinFn = applet.getParameter("openWin");
        if (strOpenWinFn == null || "".equals(strOpenWinFn)) {
            strOpenWinFn = "window.open";
        }
        strOpenWinFn = strOpenWinFn.concat("('" + urlToOpen + "','helpWindow', '" + windowFeatures + "');");
        return AppletUtils.execJavaScript(applet, strOpenWinFn, null);
    }

    public static Object execJSToken(Applet parentApplet, String strToken) {
        String strTemp = parentApplet.getParameter(strToken);
        strTemp = AppletUtils.parseToken(strTemp);
        return AppletUtils.execJavaScript(parentApplet, strTemp, null);
    }

    public static String parseToken(String strJSAlias) {
        String methodName = "parseToken";
        String strJavaScriptFunction = null;
        try {
            int iLeft = strJSAlias.indexOf(40);
            int iRight = strJSAlias.indexOf(41);
            if (iLeft > 0 && iRight > iLeft) {
                strJavaScriptFunction = strJSAlias;
            } else {
                StringTokenizer st = new StringTokenizer(strJSAlias, "&");
                strJavaScriptFunction = new String(st.nextToken());
                strJavaScriptFunction = strJavaScriptFunction.concat("(");
                while (st.hasMoreTokens()) {
                    strJavaScriptFunction = strJavaScriptFunction.concat("\"");
                    strJavaScriptFunction = strJavaScriptFunction.concat(st.nextToken());
                    strJavaScriptFunction = strJavaScriptFunction.concat(st.hasMoreTokens() ? "\"," : "\"");
                }
                strJavaScriptFunction = strJavaScriptFunction.concat(");");
            }
        }
        catch (Exception e) {
            strJavaScriptFunction = null;
            AppletLogger.logError(AppletUtils.class, methodName, e);
        }
        return strJavaScriptFunction;
    }

    public static Object execJavaScript(Applet parentApplet, String strJavaScriptFunction, String[] arguments) {
        String methodName = "executeJavaScript";
        try {
            JSObject jsObject;
            if (arguments == null) {
                arguments = new String[]{};
            }
            if ((jsObject = JSObject.getWindow(parentApplet)) != null) {
                jsObject.call(strJavaScriptFunction, arguments);
            }
        }
        catch (Exception e) {
            AppletLogger.logError(AppletUtils.class, methodName, e.getLocalizedMessage());
        }
        return null;
    }
}

