/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.print;

import com.ibm.ecm.applets.AppletLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintableLineDoc
implements Pageable {
    private static final int BLOCK_SIZE = 33000;
    private final File dataFile;
    private final PrintRequestAttributeSet aset;
    private final PageFormat pageFormat;
    private final PrintService printSvc;
    private Vector<LineDataPage> pages;
    private LineDataPage cachedPage;
    private Font font;
    private int maxPageLines;
    private String widestLine;
    private double docScaleYFactor;
    private double docScaleXFactor;
    private LinePrintable renderer;
    private final DocFlavor flavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;

    public PrintableLineDoc(File file, PrintService printSvc, PrintRequestAttributeSet aset, PageFormat pageFormat) {
        String methodName = "PrintableLineDoc";
        AppletLogger.logEntry(this, methodName);
        this.dataFile = file;
        this.printSvc = printSvc;
        this.aset = aset;
        this.pageFormat = pageFormat;
        this.font = new Font("Monospaced", 1, 14);
        this.maxPageLines = 0;
        this.widestLine = " ";
        this.pages = new Vector();
        this.cachedPage = null;
        this.docScaleYFactor = 0.0;
        this.docScaleXFactor = 0.0;
        this.renderer = new LinePrintable();
        AppletLogger.logExit(this, methodName);
    }

    public void buildPages(Graphics2D g2d) {
        int numread = 0;
        int lineCount = 0;
        int byteCount = 0;
        int pageOffset = 0;
        int total = 0;
        int pageNum = 0;
        byte[] b = new byte[33000];
        byte[] bLine = new byte[33000];
        TextLayout widestLineLayout = new TextLayout(this.widestLine, this.font, g2d.getFontRenderContext());
        FileInputStream fis = null;
        String methodName = "buildPages";
        AppletLogger.logEntry(this, methodName);
        try {
            fis = this.getProtectedFileInputStream();
        }
        catch (PrivilegedActionException e) {
            AppletLogger.logError((Object)this, methodName, AppletLogger.getStackTraceAsString(e));
            return;
        }
        try {
            while ((numread = fis.read(b, 0, 33000)) != -1) {
                for (int i = 0; i < numread; ++i) {
                    if (b[i] == 10) {
                        String line = new String(bLine, "UTF-8");
                        line = line.trim();
                        ++lineCount;
                        byteCount = 0;
                        bLine = new byte[33000];
                        if (g2d != null && line.length() > 0) {
                            TextLayout layout = new TextLayout(line, this.font, g2d.getFontRenderContext());
                            if (!(layout.getVisibleAdvance() > widestLineLayout.getVisibleAdvance())) continue;
                            widestLineLayout = layout;
                            this.widestLine = line;
                            AppletLogger.logDebug(this, methodName, "Widest line [" + this.widestLine + "]");
                            continue;
                        }
                        if (line.length() <= this.widestLine.length()) continue;
                        this.widestLine = line;
                        AppletLogger.logDebug(this, methodName, "Widest line [" + this.widestLine + "]");
                        continue;
                    }
                    if (b[i] == 12) {
                        LineDataPage p = new LineDataPage(pageOffset, total + i - 1, pageNum++);
                        this.pages.addElement(p);
                        this.maxPageLines = Math.max(lineCount, this.maxPageLines);
                        pageOffset = total + i + 1;
                        lineCount = 0;
                        byteCount = 0;
                        continue;
                    }
                    bLine[byteCount++] = b[i];
                }
                total += numread;
            }
            if (pageOffset < total) {
                LineDataPage p = new LineDataPage(pageOffset, total - 1, pageNum);
                this.pages.addElement(p);
                this.maxPageLines = Math.max(lineCount, this.maxPageLines);
            }
            fis.close();
            AppletLogger.logDebug(this, methodName, "Document completed with " + this.pages.size() + " pages");
            AppletLogger.logDebug(this, methodName, "Document completed with " + this.maxPageLines + " max lines on a page");
        }
        catch (IOException e) {
            AppletLogger.logError((Object)this, methodName, AppletLogger.getStackTraceAsString(e));
            return;
        }
        AppletLogger.logExit(this, methodName);
    }

    public Vector<String> getPageLines(int pageNum) throws Exception {
        FileInputStream fis = null;
        LineDataPage page = this.pages.elementAt(pageNum);
        Vector<String> vectLines = new Vector();
        String methodName = "getPageLines";
        if (page == this.cachedPage) {
            vectLines = this.cachedPage.getLines();
        } else {
            int num_read = 0;
            try {
                fis = this.getProtectedFileInputStream();
            }
            catch (PrivilegedActionException e) {
                AppletLogger.logError((Object)this, methodName, AppletLogger.getStackTraceAsString(e));
                return null;
            }
            int num_to_skip = 0;
            while ((long)num_to_skip != page.getStartOffset()) {
                num_to_skip = (int)((long)num_to_skip + fis.skip(page.getStartOffset() - (long)num_to_skip));
            }
            int num_to_read = (int)(page.getEndOffset() - page.getStartOffset() + 1L);
            byte[] b = new byte[num_to_read];
            while (num_read != num_to_read) {
                num_read += fis.read(b, num_read, num_to_read - num_read);
            }
            fis.close();
            String tryThis = new String(b, "UTF-8");
            String[] lines = tryThis.split("\\n");
            for (int i = 0; i < lines.length; ++i) {
                vectLines.addElement(lines[i]);
            }
            this.cachedPage = page;
            this.cachedPage.setLines(vectLines);
        }
        return vectLines;
    }

    private FileInputStream getProtectedFileInputStream() throws PrivilegedActionException {
        String methodName = "getProtectedFileInputStream";
        FileInputStream fis = null;
        try {
            fis = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws FileNotFoundException {
                    return new FileInputStream(PrintableLineDoc.this.dataFile);
                }
            });
        }
        catch (PrivilegedActionException e) {
            AppletLogger.logError((Object)this, methodName, "Unable to open file stream " + this.dataFile.getAbsolutePath() + " for writing data");
            throw e;
        }
        return fis;
    }

    public boolean printLineDoc(String docName) {
        String methodName = "printLineDoc";
        AppletLogger.logEntry(this, "printLineDoc");
        final SimpleDoc doc = new SimpleDoc(this, this.flavor, null);
        try {
            this.aset.add(new JobName(docName, null));
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws PrintException {
                    DocPrintJob pj = null;
                    pj = PrintableLineDoc.this.printSvc.createPrintJob();
                    pj.addPrintJobListener(new LinePrintListener());
                    AppletLogger.logDebug(this, "printLineDoc", "Printing line document");
                    pj.print(doc, PrintableLineDoc.this.aset);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            AppletLogger.logError((Object)this, "printLineDoc", AppletLogger.getStackTraceAsString(e));
            return false;
        }
        return true;
    }

    @Override
    public int getNumberOfPages() {
        return this.pages.size();
    }

    @Override
    public PageFormat getPageFormat(int arg0) throws IndexOutOfBoundsException {
        return this.pageFormat;
    }

    @Override
    public Printable getPrintable(int arg0) throws IndexOutOfBoundsException {
        return this.renderer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LineDataPage {
        private long startOffset;
        private long endOffset;
        private int pageNumber;
        private Vector<String> lines;

        public LineDataPage(long start, long end, int page) {
            this.startOffset = start;
            this.endOffset = end;
            this.pageNumber = page;
        }

        public long getStartOffset() {
            return this.startOffset;
        }

        public void setStartOffset(long startOffset) {
            this.startOffset = startOffset;
        }

        public long getEndOffset() {
            return this.endOffset;
        }

        public void setEndOffset(long endOffset) {
            this.endOffset = endOffset;
        }

        public int getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(int pageNumber) {
            this.pageNumber = pageNumber;
        }

        public void setLines(Vector<String> lines) {
            this.lines = lines;
        }

        public Vector<String> getLines() {
            return this.lines;
        }
    }

    private class LinePrintListener
    implements PrintJobListener {
        public void printDataTransferCompleted(PrintJobEvent pje) {
            AppletLogger.logDebug(this, "printDataTransferCompleted", "Data Transfer complete");
        }

        public void printJobCanceled(PrintJobEvent pje) {
            AppletLogger.logDebug(this, "printJobCanceled", "Job Canceled");
        }

        public void printJobCompleted(PrintJobEvent pje) {
            AppletLogger.logDebug(this, "printJobCompleted", "Job Complete");
        }

        public void printJobFailed(PrintJobEvent pje) {
            AppletLogger.logDebug(this, "printJobFailed", "Job FAIL");
        }

        public void printJobNoMoreEvents(PrintJobEvent pje) {
            AppletLogger.logDebug(this, "printJobNoMoreEvents", "No More Events");
        }

        public void printJobRequiresAttention(PrintJobEvent pje) {
            AppletLogger.logDebug(this, "printJobRequiresAttention", "Job needs ATTENTION");
        }
    }

    private class LinePrintable
    implements Printable {
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            Vector<String> pageLines;
            Graphics2D g2d = (Graphics2D)graphics;
            FontRenderContext frc = g2d.getFontRenderContext();
            double scale = 0.0;
            String methodName = "print";
            try {
                pageLines = PrintableLineDoc.this.getPageLines(pageIndex);
            }
            catch (Exception ex) {
                AppletLogger.logError((Object)this, methodName, AppletLogger.getStackTraceAsString(ex));
                return 1;
            }
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2d.setColor(Color.black);
            g2d.setFont(PrintableLineDoc.this.font);
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            Rectangle2D maxCharBounds = g2d.getFontMetrics(PrintableLineDoc.this.font).getMaxCharBounds(g2d);
            float lineHeight = (float)maxCharBounds.getHeight();
            float verticalOffset = (float)Math.abs(maxCharBounds.getY());
            if (PrintableLineDoc.this.docScaleXFactor == 0.0 && PrintableLineDoc.this.docScaleYFactor == 0.0) {
                TextLayout wideLayout = new TextLayout(PrintableLineDoc.this.widestLine, PrintableLineDoc.this.font, frc);
                PrintableLineDoc.this.docScaleYFactor = pageFormat.getImageableHeight() / (maxCharBounds.getHeight() * (double)PrintableLineDoc.this.maxPageLines);
                PrintableLineDoc.this.docScaleXFactor = pageFormat.getImageableWidth() / (double)wideLayout.getVisibleAdvance();
            }
            scale = Math.min(PrintableLineDoc.this.docScaleXFactor, PrintableLineDoc.this.docScaleYFactor);
            g2d.scale(scale, scale);
            int i = 0;
            while (i < pageLines.size()) {
                String pText = pageLines.elementAt(i);
                g2d.drawString(pText, 0.0f, verticalOffset);
                ++i;
                verticalOffset += lineHeight;
            }
            return 0;
        }
    }
}

