/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.print;

import com.ibm.ecm.applets.AppletLogger;
import com.ibm.ecm.applets.NativeLibraryDeployer;
import com.ibm.ecm.applets.SecurityUtil;
import com.ibm.ecm.applets.print.PrintableLineDoc;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBStreamingDocServices;
import com.ibm.mm.viewer.CMBStreamingDocServicesCallbacks;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JApplet;

public class PrintApplet
extends JApplet {
    private static final String filePrefix = "NXPRT";
    private final double MILLIS_PER_INCH = 25.4;
    private boolean isMetric;
    private PrintService printSvc;
    private PrintRequestAttributeSet prAttrSet;
    private PageFormat pageFormat;
    private String platform = null;

    public void init() {
        String methodName = "init";
        AppletLogger.logEntry(this, methodName);
        this.prAttrSet = new HashPrintRequestAttributeSet();
        String locale = this.getParameter("clientLocale");
        AppletLogger.logDebug(this, methodName, "clientLocale:" + locale);
        this.isMetric = locale == null || !locale.equalsIgnoreCase("en-us");
        this.platform = this.getParameter("platform");
        AppletLogger.logDebug(this, methodName, "isMetric: " + this.isMetric);
    }

    public String getLocalPrinterNames() {
        String methodName = "getLocalPrinterNames";
        AppletLogger.logEntry(this, "getLocalPrinterNames");
        String json = "";
        PrintService[] printers = this.getPrivilegedPrintServices();
        Object[] names = new String[printers.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = printers[i].getName();
        }
        Arrays.sort(names);
        JSONArray jsonArr = new JSONArray(printers.length);
        for (int i = 0; i < names.length; ++i) {
            jsonArr.add(names[i]);
        }
        PrintService defaultPrinter = (PrintService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                PrintService printer = PrintServiceLookup.lookupDefaultPrintService();
                AppletLogger.logDebug(this, "getLocalPrinterNames", "Default printer is " + printer);
                return printer;
            }
        });
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("defaultPrinter", defaultPrinter.getName());
        jsonObj.put("printers", jsonArr);
        try {
            json = jsonObj.serialize();
            AppletLogger.logDebug(this, "getLocalPrinterNames", "JSON : " + json);
        }
        catch (IOException e) {
            AppletLogger.logError((Object)this, "getLocalPrinterNames", AppletLogger.getStackTraceAsString(e));
        }
        AppletLogger.logExit(this, "getLocalPrinterNames");
        return json;
    }

    public String getDefaultsForPrinter(String printerName) {
        String methodName = "getDefaultsForPrinter";
        AppletLogger.logEntry(this, "getDefaultsForPrinter");
        String json = "";
        JSONObject jsonObj = new JSONObject();
        int numCopies = 1;
        String orientation = "portrait";
        PrintService currentPrintSvc = this.getPrivilegedPrintService(printerName);
        Class<Copies> copies = Copies.class;
        Copies copy = (Copies)currentPrintSvc.getDefaultAttributeValue(copies);
        if (copy != null) {
            numCopies = copy.getValue();
        }
        jsonObj.put("numCopies", (Object)numCopies);
        Object o = currentPrintSvc.getDefaultAttributeValue(OrientationRequested.class);
        if (o != null && o instanceof OrientationRequested) {
            OrientationRequested or = (OrientationRequested)o;
            orientation = or == OrientationRequested.PORTRAIT ? "portrait" : "landscape";
        }
        jsonObj.put("orientation", orientation);
        double dDPI = 72.0;
        if (this.isMetric) {
            dDPI /= 25.4;
        }
        double width = 612.0;
        double height = 792.0;
        Media media = (Media)currentPrintSvc.getDefaultAttributeValue(Media.class);
        float[] dims = new float[2];
        if (media != null && media instanceof MediaSizeName) {
            MediaSize size = MediaSize.getMediaSizeForName((MediaSizeName)media);
            dims = this.isMetric ? size.getSize(1000) : size.getSize(25400);
            width = orientation.equalsIgnoreCase("portrait") ? (double)dims[0] * dDPI : (double)dims[1] * dDPI;
            height = orientation.equalsIgnoreCase("portrait") ? (double)dims[1] * dDPI : (double)dims[0] * dDPI;
            AppletLogger.logDebug(this, "getDefaultsForPrinter", "MEDIASIZE width: " + width + " height:" + height);
        } else {
            if (this.pageFormat == null) {
                this.pageFormat = (PageFormat)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return PrinterJob.getPrinterJob().defaultPage();
                    }
                });
            }
            Paper odPaper = this.pageFormat.getPaper();
            width = orientation.equalsIgnoreCase("portrait") ? odPaper.getWidth() : odPaper.getHeight();
            height = orientation.equalsIgnoreCase("portrait") ? odPaper.getHeight() : odPaper.getWidth();
            AppletLogger.logDebug(this, "getDefaultsForPrinter", "PAGEFORMAT width: " + width + " height:" + height);
        }
        double minMargin = this.isMetric ? 6.3 : 0.25;
        double defaultMargin = this.isMetric ? 25.4 : 1.0;
        double maxHorizMargin = Math.round(width / 3.0 / dDPI);
        double maxVertMargin = Math.round(height / 3.0 / dDPI);
        AppletLogger.logDebug(this, "getDefaultsForPrinter", "maxHorizMargin:" + maxHorizMargin + " maxVertMargin:" + maxVertMargin);
        JSONArray margins = new JSONArray(4);
        JSONObject margDefault = new JSONObject();
        margDefault.put("defaultMargin", (Object)defaultMargin);
        margins.add(margDefault);
        JSONObject margMinimum = new JSONObject();
        margMinimum.put("minimumMargin", (Object)minMargin);
        margins.add(margMinimum);
        JSONObject maxHorizontal = new JSONObject();
        maxHorizontal.put("maxHorizontal", (Object)maxHorizMargin);
        margins.add(maxHorizontal);
        JSONObject maxVertical = new JSONObject();
        maxVertical.put("maxVertical", (Object)maxVertMargin);
        margins.add(maxVertical);
        jsonObj.put("margins", margins);
        try {
            json = jsonObj.serialize();
            AppletLogger.logDebug(this, "getDefaultsForPrinter", "JSON : " + json);
        }
        catch (IOException e) {
            AppletLogger.logError((Object)this, "getDefaultsForPrinter", AppletLogger.getStackTraceAsString(e));
        }
        AppletLogger.logExit(this, "getDefaultsForPrinter");
        return json;
    }

    public void setPrinterValues(String json) {
        String methodName = "setPrinterValues";
        AppletLogger.logEntry(this, methodName);
        JSONObject jsonObj = null;
        try {
            jsonObj = SecurityUtil.parseJSON(json);
            AppletLogger.logDebug(this, methodName, "Parsed JSON : " + json);
        }
        catch (IOException e) {
            AppletLogger.logError((Object)this, methodName, AppletLogger.getStackTraceAsString(e));
            return;
        }
        String printerName = (String)jsonObj.get("printerName");
        AppletLogger.logDebug(this, methodName, "printerName : " + printerName);
        this.printSvc = this.getPrivilegedPrintService(printerName);
        this.pageFormat = (PageFormat)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                PrinterJob pj = PrinterJob.getPrinterJob();
                PageFormat pf = null;
                try {
                    pj.setPrintService(PrintApplet.this.printSvc);
                    pf = pj.validatePage(pj.defaultPage());
                }
                catch (PrinterException e) {
                    pf = PrinterJob.getPrinterJob().defaultPage();
                }
                return pf;
            }
        });
        String orientation = (String)jsonObj.get("orientation");
        if (orientation.equalsIgnoreCase("portrait")) {
            this.prAttrSet.add(OrientationRequested.PORTRAIT);
            this.pageFormat.setOrientation(1);
        } else if (orientation.equalsIgnoreCase("landscape")) {
            this.prAttrSet.add(OrientationRequested.LANDSCAPE);
            this.pageFormat.setOrientation(0);
        } else {
            this.prAttrSet.add(OrientationRequested.PORTRAIT);
            this.pageFormat.setOrientation(1);
        }
        AppletLogger.logDebug(this, methodName, "orientation : " + this.pageFormat.getOrientation());
        int numCopies = (int)((Long)jsonObj.get("numCopies")).longValue();
        AppletLogger.logDebug(this, methodName, "numCopies " + numCopies);
        this.prAttrSet.add(new Copies(numCopies));
        JSONArray jsonMargins = (JSONArray)jsonObj.get("margins");
        double[] margins = new double[4];
        for (int i = 0; i < margins.length; ++i) {
            Object obj = jsonMargins.get(i);
            if (obj instanceof String) {
                String sval = (String)obj;
                margins[i] = Double.parseDouble(sval);
                continue;
            }
            if (obj instanceof Double) {
                Double dval = (Double)obj;
                margins[i] = dval;
                continue;
            }
            if (!(obj instanceof Long)) continue;
            Long lval = (Long)obj;
            margins[i] = lval.doubleValue();
        }
        this.setPageFormatMargins(margins, this.prAttrSet);
        AppletLogger.logExit(this, methodName);
    }

    private PrintService getPrivilegedPrintService(String printerName) {
        PrintService service = null;
        String methodName = "getPrivilegedPrintService";
        AppletLogger.logEntry(this, "getPrivilegedPrintService");
        PrintService[] printers = this.getPrivilegedPrintServices();
        for (int i = 0; i < printers.length; ++i) {
            if (!printerName.equals(printers[i].getName())) continue;
            service = printers[i];
            AppletLogger.logDebug(this, "getPrivilegedPrintService", "Found " + service.getName() + " printer");
            break;
        }
        AppletLogger.logExit(this, "getPrivilegedPrintService");
        return service;
    }

    private PrintService[] getPrivilegedPrintServices() {
        String methodName = "getPrivilegedPrintServices";
        AppletLogger.logEntry(this, "getPrivilegedPrintServices");
        PrintService[] printers = (PrintService[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object[] run() {
                Object[] printers = PrinterJob.lookupPrintServices();
                AppletLogger.logDebug(this, "getPrivilegedPrintServices", "Found " + printers.length + " printers");
                return printers;
            }
        });
        AppletLogger.logExit(this, "getPrivilegedPrintServices");
        return printers;
    }

    public boolean printDocument(String json) {
        JSONObject jsonObj = null;
        final Graphics2D g2d = (Graphics2D)this.getGraphics();
        String methodName = "printDocument";
        final PageFormat pFormat = this.pageFormat;
        final PrintRequestAttributeSet attributeSet = this.prAttrSet;
        final PrintService pService = this.printSvc;
        AppletLogger.logEntry(this, "printDocument");
        try {
            jsonObj = SecurityUtil.parseJSON(json);
            AppletLogger.logDebug(this, "printDocument", "Parsed JSON : " + json);
        }
        catch (IOException e) {
            AppletLogger.logError((Object)this, "printDocument", AppletLogger.getStackTraceAsString(e));
            return false;
        }
        final String docURL = (String)jsonObj.get("docURL");
        final String docid = (String)jsonObj.get("docId");
        final String mimeType = (String)jsonObj.get("contentType");
        final String repositoryType = (String)jsonObj.get("repositoryType");
        final String docName = (String)jsonObj.get("docName");
        AppletLogger.logDebug(this, "printDocument", "docURL: " + docURL);
        AppletLogger.logDebug(this, "printDocument", "docid: " + docid);
        AppletLogger.logDebug(this, "printDocument", "contentType: " + mimeType);
        AppletLogger.logDebug(this, "printDocument", "repository: " + repositoryType);
        AppletLogger.logDebug(this, "printDocument", "docName: " + docName);
        if (repositoryType.equals("od") && mimeType.equalsIgnoreCase("application/line")) {
            Thread t = new Thread(){

                public void run() {
                    try {
                        File dataFile = (File)PrintApplet.this.getDocData(docURL, docid, mimeType, repositoryType);
                        AppletLogger.logDebug(this, "printDocument", "retrieved line data to file: " + dataFile.getAbsolutePath());
                        PrintableLineDoc lineDoc = new PrintableLineDoc(dataFile, pService, attributeSet, pFormat);
                        lineDoc.buildPages(g2d);
                        AppletLogger.logDebug(this, "printDocument", "sending line data to print");
                        lineDoc.printLineDoc(docName);
                    }
                    catch (Exception e) {
                        AppletLogger.logError((Object)this, "printDocument", AppletLogger.getStackTraceAsString(e));
                    }
                }
            };
            t.start();
        } else {
            try {
                final CMBDocument cmbDoc = (CMBDocument)this.getDocData(docURL, docid, mimeType, repositoryType);
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        int status = 0;
                        final PrinterJob pj = PrinterJob.getPrinterJob();
                        Copies cp = (Copies)attributeSet.get(Copies.class);
                        pj.setCopies(cp.getValue());
                        pj.setJobName(docName);
                        pj.setPrintService(pService);
                        PrivilegedAction<Integer> pa = new PrivilegedAction<Integer>(){

                            @Override
                            public Integer run() {
                                AppletLogger.logDebug(this, "printDocument", "sending cmb data to print");
                                Integer rc = new Integer(0);
                                try {
                                    cmbDoc.print(pj, pFormat, false, null);
                                    AppletLogger.logDebug(this, "printDocument", "sent cmb data to print");
                                }
                                catch (CMBDocumentEngineException e) {
                                    AppletLogger.logError((Object)this, "printDocument", e);
                                    rc = 1;
                                }
                                catch (IllegalArgumentException e) {
                                    AppletLogger.logError((Object)this, "printDocument", e);
                                    rc = 2;
                                }
                                catch (IOException e) {
                                    AppletLogger.logError((Object)this, "printDocument", e);
                                    rc = 3;
                                }
                                catch (PrinterException e) {
                                    AppletLogger.logError((Object)this, "printDocument", e);
                                    rc = 4;
                                }
                                return rc;
                            }
                        };
                        status = AccessController.doPrivileged(pa);
                        if (status == 0) {
                            AppletLogger.logDebug(this, "printDocument", "AccessController privilegedAction status: " + status);
                        } else {
                            AppletLogger.logError((Object)this, "printDocument", "AccessController privilegedAction status: " + status);
                        }
                        return new Integer(status);
                    }
                });
            }
            catch (Exception e) {
                AppletLogger.logError((Object)this, "printDocument", AppletLogger.getStackTraceAsString(e));
            }
        }
        AppletLogger.logExit(this, "printDocument", "document print was submitted");
        return true;
    }

    private Object getDocData(final String docUrlString, String encodedDocId, final String mimeType, final String repositoryType) throws Exception {
        URL theURL;
        final URL codebase = this.getCodeBase();
        Object objData = null;
        String methodName = "getDocData";
        AppletLogger.logEntry(this, "getDocData");
        String updatedDocUrlString = docUrlString;
        if (repositoryType != null && repositoryType.equals("od")) {
            String view = "native";
            if (mimeType.equalsIgnoreCase("application/line")) {
                view = "ascii";
            } else if (mimeType.equalsIgnoreCase("application/afp")) {
                view = "pdf";
            }
            AppletLogger.logInfo(this, "getDocData", "Adding transform=" + view + " to Url for OD");
            AppletLogger.logInfo(this, "getDocData", "Adding include_segment_info to Url for OD");
            updatedDocUrlString = docUrlString + "&transform=" + view + "&include_segment_info=false";
        }
        try {
            theURL = new URL(this.getCodeBase(), updatedDocUrlString);
        }
        catch (MalformedURLException e) {
            AppletLogger.logError((Object)this, "getDocData", "Bad URL: " + this.getCodeBase() + updatedDocUrlString);
            AppletLogger.logError((Object)this, "getDocData", "MalformedURLException: " + e);
            throw e;
        }
        if (theURL != null) {
            try {
                objData = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        HttpURLConnection httpDocUrlConnection;
                        String methodName = "run";
                        AppletLogger.logEntry(this, methodName);
                        Serializable data = null;
                        InputStream docInputStream = null;
                        int partCount = 1;
                        URLConnection docURLConn = SecurityUtil.openConnection(theURL);
                        docURLConn.connect();
                        AppletLogger.logInfo(this, methodName, "URL Connected");
                        if (docURLConn instanceof HttpURLConnection && (httpDocUrlConnection = (HttpURLConnection)docURLConn).getResponseCode() != 200) {
                            throw new Exception(httpDocUrlConnection.getResponseMessage());
                        }
                        docInputStream = docURLConn.getInputStream();
                        int contentLength = docURLConn.getContentLength();
                        AppletLogger.logInfo(this, methodName, "contentLength = " + contentLength);
                        if (mimeType.equalsIgnoreCase("application/line")) {
                            File path = null;
                            String home = System.getProperty("user.home");
                            path = home != null && home.length() > 0 ? new File(System.getProperty("user.home")) : new File(System.getProperty("user.dir"));
                            File tempFile = File.createTempFile(PrintApplet.filePrefix, "_lin", path);
                            tempFile.deleteOnExit();
                            FileOutputStream fos = new FileOutputStream(tempFile);
                            if (fos != null && docInputStream != null) {
                                try {
                                    AppletLogger.logDebug(this, methodName, "reading from input stream, writing to file " + tempFile.getAbsolutePath());
                                    int b = 0;
                                    while ((b = docInputStream.read()) != -1) {
                                        fos.write(b);
                                    }
                                    docInputStream.close();
                                    fos.close();
                                    data = tempFile;
                                }
                                catch (IOException e) {
                                    AppletLogger.logError((Object)this, methodName, "Unable to read data from mid-tier");
                                    throw e;
                                }
                            }
                        } else {
                            Properties engineProperties = null;
                            if (PrintApplet.this.platform != null) {
                                engineProperties = new Properties();
                                engineProperties.put("ENGINE_platform", PrintApplet.this.platform);
                            }
                            AppletLogger.logDebug(this, methodName, "Creating callbacks( repo:" + repositoryType + ", url: " + docUrlString + ", codebase: " + codebase + ")");
                            SimpleDocServiceCallbacks callbacks = new SimpleDocServiceCallbacks(repositoryType, docUrlString, codebase);
                            AppletLogger.logDebug(this, methodName, "Setting up streaming services");
                            CMBStreamingDocServices docServices = new CMBStreamingDocServices(callbacks, engineProperties);
                            AppletLogger.logDebug(this, methodName, "Invoking loadDocument(inputstream, content len: " + contentLength + ", mimetype: " + mimeType + ", annotationStream: null, resources: null)");
                            CMBDocument doc = docServices.loadDocument(docInputStream, contentLength, partCount, mimeType, mimeType, null, null);
                            data = doc;
                        }
                        AppletLogger.logExit(this, methodName);
                        return data;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                AppletLogger.logError((Object)this, "getDocData", "Error creating Document: " + e.getMessage());
                throw e;
            }
        }
        AppletLogger.logExit(this, "getDocData");
        return objData;
    }

    private void setPageFormatMargins(double[] margins, PrintRequestAttributeSet aset) {
        Media media = null;
        MediaSize size = null;
        Paper odPaper = null;
        float[] dims = new float[2];
        String methodName = "setPageFormatMargins";
        AppletLogger.logEntry(this, methodName);
        AppletLogger.logDebug(this, methodName, "Margins:\n\t Left:" + margins[0] + "\n\t Right:" + margins[1] + "\n\t Top:" + margins[2] + "\n\t Bottom:" + margins[3]);
        if (this.pageFormat != null) {
            double dDPI = 72.0;
            if (this.isMetric) {
                dDPI /= 25.4;
            }
            int i = 0;
            while (i < margins.length) {
                int n = i++;
                margins[n] = margins[n] * dDPI;
            }
            media = (Media)aset.get(Media.class);
            if (media != null && media instanceof MediaSizeName) {
                size = MediaSize.getMediaSizeForName((MediaSizeName)media);
                odPaper = new Paper();
                dims = this.isMetric ? size.getSize(1000) : size.getSize(25400);
                odPaper.setSize((double)dims[0] * dDPI, (double)dims[1] * dDPI);
            } else {
                odPaper = this.pageFormat.getPaper();
            }
            if (0 == this.pageFormat.getOrientation()) {
                odPaper.setImageableArea(margins[2], margins[1], odPaper.getWidth() - margins[2] - margins[3], odPaper.getHeight() - margins[0] - margins[1]);
            } else {
                odPaper.setImageableArea(margins[0], margins[2], odPaper.getWidth() - margins[0] - margins[1], odPaper.getHeight() - margins[2] - margins[3]);
            }
            AppletLogger.logDebug(this, methodName, "Margins: L:" + margins[0] + " R:" + margins[1] + " T:" + margins[2] + " B:" + margins[3]);
            AppletLogger.logDebug(this, methodName, "Paper size: X:" + odPaper.getImageableX() + " Y:" + odPaper.getImageableY() + " W:" + odPaper.getImageableWidth() + " H:" + odPaper.getImageableHeight());
            this.pageFormat.setPaper(odPaper);
        }
    }

    private class SimpleDocServiceCallbacks
    extends CMBStreamingDocServicesCallbacks {
        private String serverType;
        private String docURLString;
        private URL codebase;

        public SimpleDocServiceCallbacks(String serverType, String docURLString, URL codebase) {
            this.serverType = serverType;
            this.docURLString = docURLString;
            this.codebase = codebase;
        }

        public InputStream getPart(CMBDocument document, int partNumber, StringBuffer outMimeType) {
            URL docURL = null;
            String methodName = "getPart";
            AppletLogger.logEntry(this, methodName);
            AppletLogger.logDebug(this, methodName, "Part number " + partNumber);
            try {
                if (this.serverType != null && this.serverType.equals("od")) {
                    AppletLogger.logDebug(this, methodName, "Adding transform=native and segment_num to Url for OD");
                    docURL = new URL(this.codebase, this.docURLString + "&transform=native&segment_num=" + partNumber);
                }
            }
            catch (MalformedURLException e) {
                AppletLogger.logDebug(this, methodName, "MalformedURLException -- assuming local resource");
            }
            if (docURL == null) {
                AppletLogger.logDebug(this, methodName, "The docURL could not be formed.");
                throw new IllegalArgumentException("printApplet_notAbleToRetrieve: " + this.docURLString);
            }
            try {
                URLConnection docUrlConnection = SecurityUtil.openConnection(docURL);
                AppletLogger.logDebug(this, methodName, "Getting an input stream.");
                InputStream instream = docUrlConnection.getInputStream();
                int contentLength = docUrlConnection.getContentLength();
                AppletLogger.logDebug(this, methodName, "Content length is " + contentLength);
                String mimeType = docUrlConnection.getContentType();
                AppletLogger.logDebug(this, methodName, "Mimetype is " + mimeType);
                outMimeType.append(mimeType);
                AppletLogger.logExit(this, methodName);
                return instream;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("printApplet_notAbleToRetrieve: " + this.docURLString);
            }
        }

        public String deployNativeLibrary(String nativeLibName) {
            NativeLibraryDeployer deployer = new NativeLibraryDeployer(this.codebase);
            try {
                deployer.setPlatform(PrintApplet.this.platform);
                deployer.deployNativeLibrary(nativeLibName);
                String dllPath = deployer.getDllPath();
                return dllPath;
            }
            catch (Exception e) {
                throw new CMBDocumentEngineException(e.getMessage(), (Object)e);
            }
        }

        public boolean getPrintPrivilege(CMBDocument document) {
            return true;
        }

        public InputStream getAnnotation(CMBDocument document, int annotationNumber) {
            return null;
        }

        public InputStream getResources(CMBDocument document) {
            return null;
        }

        public InputStream getForm(CMBDocument document, String formName) {
            return null;
        }

        public boolean traceEnabled() {
            return AppletLogger.getLogLevel() > 4;
        }

        public void trace(String message) {
            try {
                AppletLogger.logDebug(this, "trace", message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

