/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets.email;

import com.ibm.ecm.applets.AppletLogger;
import com.ibm.ecm.applets.SecurityUtil;
import com.ibm.ecm.util.MimeTypeUtil;
import com.ibm.mm.wc.applets.email.WCEmailAppletJNI;
import java.awt.Graphics;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;

public class EmailApplet
extends JApplet {
    private static final long serialVersionUID = 1L;
    public static final char SAFE_CHAR = '-';
    private static final boolean deleteFiles = true;
    public static final int RECIPIENT_TYPE_TO = 1;
    public static final int RECIPIENT_TYPE_CC = 2;
    public static final int RECIPIENT_TYPE_BCC = 3;
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_JNI_LOAD_FAILED = 1;
    public static final int STATUS_TEMP_FILE_NOT_CREATED = 2;
    public static final int STATUS_TEMP_FILE_WRITE_FAILED = 3;
    public static final int STATUS_TEMP_FILE_NOT_DELETED = 4;
    public static final int STATUS_MALFORMED_ATTACHMENT_URL = 5;
    public static final int STATUS_ATTACHMENT_URL_CANNOT_OPEN = 6;
    public static final int STATUS_ATTACHMENT_URL_READ_FAILED = 7;
    public static final int STATUS_SESSION_EXPIRED = 8;
    public static final int STATUS_RETRIEVE_DOC_FAILED = 9;
    public static final int STATUS_MAPI_USER_ABORT = 101;
    public static final int STATUS_MAPI_FAILURE = 102;
    public static final int STATUS_MAPI_LOGON_FAILURE = 103;
    public static final int STATUS_MAPI_DISK_FULL = 104;
    public static final int STATUS_MAPI_INSUFFICIENT_MEMORY = 105;
    public static final int STATUS_MAPI_ACCESS_DENIED = 106;
    public static final int STATUS_MAPI_TOO_MANY_SESSIONS = 108;
    public static final int STATUS_MAPI_TOO_MANY_FILES = 109;
    public static final int STATUS_MAPI_TOO_MANY_RECIPIENTS = 110;
    public static final int STATUS_MAPI_ATTACHMENT_NOT_FOUND = 111;
    public static final int STATUS_MAPI_ATTACHMENT_OPEN_FAILURE = 112;
    public static final int STATUS_MAPI_ATTACHMENT_WRITE_FAILURE = 113;
    public static final int STATUS_MAPI_UNKNOWN_RECIPIENT = 114;
    public static final int STATUS_MAPI_BAD_RECIPTYPE = 115;
    public static final int STATUS_MAPI_NO_MESSAGES = 116;
    public static final int STATUS_MAPI_INVALID_MESSAGE = 117;
    public static final int STATUS_MAPI_TEXT_TOO_LARGE = 118;
    public static final int STATUS_MAPI_INVALID_SESSION = 119;
    public static final int STATUS_MAPI_TYPE_NOT_SUPPORTED = 120;
    public static final int STATUS_MAPI_AMBIGUOUS_RECIPIENT = 121;
    public static final int STATUS_MAPI_MESSAGE_IN_USE = 122;
    public static final int STATUS_MAPI_NETWORK_FAILURE = 123;
    public static final int STATUS_MAPI_INVALID_EDITFIELDS = 124;
    public static final int STATUS_MAPI_INVALID_RECIPS = 125;
    public static final int STATUS_MAPI_NOT_SUPPORTED = 126;
    private WCEmailAppletJNI jni;
    private String subject;
    private String noteText;
    private String userAgent = "";
    private String platform = "Win32";
    private boolean initCalled = false;
    private ArrayList filesNotDeleted = new ArrayList();
    private ArrayList recipients = new ArrayList();
    private ArrayList attachments = new ArrayList();
    private int status;

    public EmailApplet() {
    }

    public EmailApplet(Object request) {
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setNoteText(String noteText) {
        this.noteText = noteText;
    }

    public String getTempFilesNotDeletedJSONArray() {
        StringBuilder tempFilesNotDeleted = new StringBuilder("[ ");
        boolean deletedFileAdded = false;
        for (int i = 0; i < this.filesNotDeleted.size(); ++i) {
            String fileName = (String)this.filesNotDeleted.get(i);
            fileName = fileName.replace("\\", "\\\\");
            if (deletedFileAdded) {
                tempFilesNotDeleted.append(", ");
            } else {
                deletedFileAdded = true;
            }
            tempFilesNotDeleted.append("\"").append(fileName).append("\"");
        }
        tempFilesNotDeleted.append(" ]");
        return tempFilesNotDeleted.toString();
    }

    public String getAttachmentPathName(int i) {
        String methodName = "getAttachmentPathName";
        AppletLogger.logEntry(this, "getAttachmentPathName");
        Attachment attachment = (Attachment)this.attachments.get(i);
        try {
            File f = new File(attachment.fileName);
            String val = attachment.fileName + ", canonicalPath=" + f.getCanonicalPath() + ",  canonicalFile=" + f.getCanonicalFile() + ", toSTring= " + f + ", f.name=" + f.getName() + ",f.absoluteFile=" + f.getAbsoluteFile();
            AppletLogger.logInfo(this, "getAttachmentPathName", "val=" + val);
            AppletLogger.logExit(this, "getAttachmentPathName");
            return attachment.fileName == null ? "" : new File(attachment.fileName).getCanonicalPath();
        }
        catch (IOException e) {
            AppletLogger.logError((Object)this, "getAttachmentPathName", e);
            return null;
        }
    }

    public void setNoteTextFromAttachmentNames() {
        String text = "\n\n";
        for (int i = 0; i < this.attachments.size(); ++i) {
            Attachment attachment = (Attachment)this.attachments.get(i);
            text = text + '\n' + attachment.name + "  (" + new File(attachment.fileName).getName() + ")\n";
        }
        this.noteText = text;
    }

    public String getNoteText() {
        return this.noteText;
    }

    public int addRecipient(int recipientType, String recipientName) {
        Recipient recipient = new Recipient();
        recipient.type = recipientType;
        recipient.name = recipientName;
        recipient.address = "";
        this.recipients.add(recipient);
        return 0;
    }

    public int addAttachmentData(final String attachmentName, final String attachmentData) {
        String methodName = "addAttachmentData";
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.status = this.swingAddAttachmentData(attachmentName, attachmentData);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        EmailApplet.this.status = 0;
                        PrivilegedAction<Integer> pa = new PrivilegedAction<Integer>(){

                            @Override
                            public Integer run() {
                                String libExt = System.getProperty("java.io.tmpdir");
                                AppletLogger.logInfo(this, "addAttachmentData", "addAttachmentData:libExt: " + libExt);
                                int pstatus = EmailApplet.this.swingAddAttachmentData(attachmentName, attachmentData);
                                AppletLogger.logInfo(this, "addAttachmentData", "addAttachmentData:status: " + pstatus);
                                return new Integer(pstatus);
                            }
                        };
                        EmailApplet.this.status = AccessController.doPrivileged(pa);
                        AppletLogger.logInfo(this, "addAttachmentData", "addAttachmentData:AccessController: " + EmailApplet.this.status);
                    }
                });
            }
        }
        catch (Exception e) {
            AppletLogger.logError((Object)this, "addAttachmentData", e);
        }
        return this.status;
    }

    private int swingAddAttachmentData(String attachmentName, String attachmentData) {
        String methodName = "swingAddAttachmentData";
        File tempFile = null;
        try {
            tempFile = File.createTempFile("wcEmail", ".html");
        }
        catch (Throwable e) {
            AppletLogger.logError((Object)this, methodName, e);
        }
        if (tempFile == null) {
            return 2;
        }
        try {
            FileOutputStream tempFileStream = new FileOutputStream(tempFile);
            tempFileStream.write(attachmentData.getBytes("UTF-8"));
            tempFileStream.close();
            this.addAttachmentFile(attachmentName, tempFile.getCanonicalPath(), true);
        }
        catch (Exception e) {
            AppletLogger.logError((Object)this, methodName, e);
            return 3;
        }
        return 0;
    }

    public int addAttachmentURL(final String docName, final String defaultMimeType, final String attachmentURLString, final boolean useSafeAttachmentFileName) {
        String methodName = "addAttachmentURL";
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.status = this.swingAddAttachmentURL(docName, defaultMimeType, attachmentURLString, useSafeAttachmentFileName);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        EmailApplet.this.status = 0;
                        PrivilegedAction<Integer> pa = new PrivilegedAction<Integer>(){

                            @Override
                            public Integer run() {
                                String libExt = System.getProperty("java.io.tmpdir");
                                AppletLogger.logInfo(this, "addAttachmentURL", "addAttachmentURL:libExt: " + libExt);
                                int pstatus = EmailApplet.this.swingAddAttachmentURL(docName, defaultMimeType, attachmentURLString, useSafeAttachmentFileName);
                                AppletLogger.logInfo(this, "addAttachmentURL", "addAttachmentURL:status: " + pstatus);
                                return new Integer(pstatus);
                            }
                        };
                        EmailApplet.this.status = AccessController.doPrivileged(pa);
                        AppletLogger.logInfo(this, "addAttachmentURL", "addAttachmentURL:AccessController: " + EmailApplet.this.status);
                    }
                });
            }
        }
        catch (Exception e) {
            AppletLogger.logError((Object)this, "addAttachmentURL", e);
        }
        return this.status;
    }

    private int swingAddAttachmentURL(String docName, String defaultMimeType, String attachmentURLString, boolean useSafeAttachmentFileName) {
        String methodName = "swingAddAttachmentURL";
        int status = 0;
        URL attachmentURL = null;
        try {
            attachmentURL = new URL(this.getCodeBase(), attachmentURLString + "&userAgent=" + this.userAgent);
        }
        catch (MalformedURLException e) {
            AppletLogger.logInfo(this, methodName, "getCodeBase() = " + this.getCodeBase() + " attachmentURLString = " + attachmentURLString);
            AppletLogger.logError((Object)this, methodName, e);
            return 5;
        }
        URLConnection attachmentURLConnection = null;
        try {
            HttpURLConnection httpUrlConnection;
            int responseCode;
            attachmentURLConnection = SecurityUtil.openConnection(attachmentURL);
            if (attachmentURLConnection instanceof HttpURLConnection && (responseCode = (httpUrlConnection = (HttpURLConnection)attachmentURLConnection).getResponseCode()) != 200) {
                if (responseCode == 408) {
                    AppletLogger.logInfo(this, methodName, "session with server expired");
                    return 8;
                }
                AppletLogger.logInfo(this, methodName, "doc retrieve failed, http response code = " + responseCode);
                return 9;
            }
        }
        catch (IOException e) {
            AppletLogger.logError((Object)this, methodName, e);
            return 6;
        }
        String contentType = attachmentURLConnection.getContentType();
        AppletLogger.logDebug(this, methodName, "HTTP response contentType = " + contentType);
        if (contentType == null || contentType.length() == 0) {
            contentType = defaultMimeType;
            AppletLogger.logDebug(this, methodName, "defaultMimeType = " + contentType);
        }
        String extension = MimeTypeUtil.getExtFromMimeType(contentType);
        InputStream attachmentInputStream = null;
        try {
            attachmentInputStream = attachmentURLConnection.getInputStream();
        }
        catch (IOException e) {
            AppletLogger.logError((Object)this, methodName, e);
            return 7;
        }
        String fileName = this.createFilename(docName, extension);
        File tempFile = this.createTempFileForAttachment(fileName, useSafeAttachmentFileName);
        if (tempFile == null) {
            return 2;
        }
        FileOutputStream tempFileOutputStream = null;
        try {
            tempFileOutputStream = new FileOutputStream(tempFile);
        }
        catch (Throwable t) {
            AppletLogger.logError((Object)this, methodName, t);
            return 2;
        }
        try {
            int len = 0;
            do {
                byte[] buff = null;
                buff = new byte[Math.max(65536, attachmentInputStream.available())];
                try {
                    len = attachmentInputStream.read(buff);
                }
                catch (IOException e) {
                    AppletLogger.logError((Object)this, methodName, e);
                    return 7;
                }
                if (len <= 0) continue;
                try {
                    tempFileOutputStream.write(buff, 0, len);
                }
                catch (IOException e) {
                    AppletLogger.logError((Object)this, methodName, e);
                    return 3;
                }
            } while (len != -1);
            attachmentInputStream.close();
            tempFileOutputStream.close();
            this.addAttachmentFile(this.createFilename(docName, extension), tempFile.getCanonicalPath(), true);
        }
        catch (Exception e) {
            AppletLogger.logError((Object)this, methodName, e);
            return 3;
        }
        return status;
    }

    private String createFilename(String docName, String extension) {
        String methodName = "createFilename";
        AppletLogger.logEntry(this, methodName);
        String fileName = docName;
        if (!extension.startsWith(".")) {
            AppletLogger.logDebug(this, methodName, "Extension " + extension + " does not start with a '.', adding one.");
            extension = "." + extension;
        }
        if (!fileName.endsWith(extension)) {
            AppletLogger.logDebug(this, methodName, "Adding the extension to the document name.");
            fileName = fileName + extension;
        } else {
            AppletLogger.logDebug(this, methodName, "It looks like the document name already has the extension in it, so appending the extension will be skipped.");
        }
        AppletLogger.logExit(this, methodName, "Filename: " + fileName);
        return fileName;
    }

    public String convertUTF8toUnicode(byte[] utf8) {
        String methodName = "convertUTF8toUnicode";
        try {
            return new String(utf8, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            AppletLogger.logError((Object)this, methodName, e);
            return null;
        }
    }

    public byte[] convertUnicodetoUTF8(String string) {
        String methodName = "convertUnicodetoUTF8";
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            AppletLogger.logError((Object)this, methodName, e);
            return null;
        }
    }

    public static String replaceSpecialUnicodeCharacters(Object request, String s) {
        String methodName = "replaceSpecialUnicodeCharacters";
        String news = s;
        try {
            byte[] utf8 = s.getBytes("UTF-8");
            String string = new String(utf8, "UTF-8");
            String[] msg = new String[]{"vert bar 1", "vert bar 2", "tilda 1", "tilda2", "dash1", "dash2 8212", "dash3", "dash4", "Yen", "Yen-like-not-in-chart", "curr"};
            char[] ch1 = new char[]{'\u2016', '\u2225', '\u301c', '\uff5e', '\u2015', '\u2014', '\u2212', '\uff0d', '\u00a5', '\uffe5', '\uffe5'};
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
            }
            for (int j = 0; j < ch1.length; ++j) {
                news = news.replace(ch1[j], '-');
            }
        }
        catch (UnsupportedEncodingException e) {
            AppletLogger.logError(EmailApplet.class, methodName, e);
        }
        return news;
    }

    public String convertToLocale(String str) {
        String methodName = "convertToLocale";
        String newStr = "";
        String encoding = System.getProperty("file.encoding");
        try {
            newStr = new String(str.getBytes(), System.getProperty("file.encoding"));
        }
        catch (UnsupportedEncodingException e) {
            AppletLogger.logError((Object)this, methodName, e);
        }
        return newStr;
    }

    private File createTempFileForAttachment(String fileName, boolean useSafeAttachmentFileName) {
        String prefix;
        String methodName = "createTempFileForAttachment";
        AppletLogger.logEntry(this, "createTempFileForAttachment");
        String SAFE_CHAR_AS_STRING = "-";
        String SAFE_PREFIX = "wcEmail";
        String SAFE_SUFFIX = ".tmpfile";
        String suffix = "";
        String docName = fileName;
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex > 0) {
            docName = fileName.substring(0, extensionIndex - 1);
            suffix = fileName.substring(extensionIndex);
        }
        if (useSafeAttachmentFileName) {
            prefix = SAFE_PREFIX;
        } else {
            prefix = docName;
            if (prefix.length() < 3) {
                for (int padlen = 0; padlen < 3 - prefix.length(); ++padlen) {
                    prefix = prefix + "_";
                }
            }
            prefix = prefix.replaceAll("[\\/:*?\"<>|]", SAFE_CHAR_AS_STRING);
            prefix = this.convertToLocale(prefix);
        }
        AppletLogger.logInfo(this, "createTempFileForAttachment", "attempting to create temp file:  prefix='" + prefix + "';  suffix='" + suffix + "'");
        File tempFile = null;
        try {
            tempFile = File.createTempFile(prefix + "_", suffix);
        }
        catch (IOException e1) {
            AppletLogger.logError((Object)this, "createTempFileForAttachment", e1);
            prefix = SAFE_PREFIX;
            AppletLogger.logInfo(this, "createTempFileForAttachment", "Attempt to create temp file failed.  Trying again with prefix='" + prefix + "';  suffix='" + suffix + "'");
            try {
                tempFile = File.createTempFile(prefix, suffix);
            }
            catch (IOException e) {
                AppletLogger.logError((Object)this, "createTempFileForAttachment", e);
                try {
                    suffix = SAFE_SUFFIX;
                    AppletLogger.logInfo(this, "createTempFileForAttachment", "Attempt to create temp file failed.  Trying agin with prefix='" + prefix + "';  suffix='" + suffix + "'");
                    tempFile = File.createTempFile(prefix, suffix);
                }
                catch (IOException e2) {
                    AppletLogger.logError((Object)this, "createTempFileForAttachment", e2);
                }
            }
        }
        catch (Throwable t) {
            AppletLogger.logError((Object)this, "createTempFileForAttachment", t);
        }
        AppletLogger.logExit(this, "createTempFileForAttachment");
        return tempFile;
    }

    private void addAttachmentFile(String attachmentName, String attachmentFileName, boolean isTemporaryFile) {
        String cleansedAttachmentName;
        Attachment attachment = new Attachment();
        attachment.name = cleansedAttachmentName = attachmentName.replace('/', '-');
        attachment.fileName = attachmentFileName;
        attachment.isTemporary = isTemporaryFile;
        this.attachments.add(attachment);
    }

    public int sendMail() {
        String methodName = "sendMail";
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.status = this.swingSendMail();
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        EmailApplet.this.status = 0;
                        PrivilegedAction<Integer> pa = new PrivilegedAction<Integer>(){

                            @Override
                            public Integer run() {
                                String libExt = System.getProperty("java.io.tmpdir");
                                AppletLogger.logInfo(this, "sendMail", "sendMail:libExt: " + libExt);
                                int pstatus = EmailApplet.this.swingSendMail();
                                AppletLogger.logInfo(this, "sendMail", "sendMail:status: " + pstatus);
                                return new Integer(pstatus);
                            }
                        };
                        EmailApplet.this.status = AccessController.doPrivileged(pa);
                        AppletLogger.logInfo(this, "sendMail", "sendMail:AccessController: " + EmailApplet.this.status);
                    }
                });
            }
        }
        catch (Exception e) {
            AppletLogger.logError((Object)this, "sendMail", e);
        }
        return this.status;
    }

    private int swingSendMail() {
        boolean deleteStatus;
        String methodName = "swingSendMail";
        AppletLogger.logEntry(this, "swingSendMail");
        AppletLogger.logInfo(this, "swingSendMail", "-- EmailApplet.sendMail invoked --");
        int status = 0;
        if (this.jni == null && (status = this.initializeJNI()) != 0) {
            return status;
        }
        if (status == 0) {
            int i;
            int[] recipientTypes = new int[this.recipients.size()];
            String[] recipientNames = new String[this.recipients.size()];
            String[] recipientAddresses = new String[this.recipients.size()];
            for (int i2 = 0; i2 < this.recipients.size(); ++i2) {
                Recipient recipient = (Recipient)this.recipients.get(i2);
                recipientTypes[i2] = recipient.type;
                recipientNames[i2] = recipient.name;
                if (recipientNames[i2] == null) {
                    recipientNames[i2] = "";
                }
                recipientAddresses[i2] = recipient.address;
                if (recipientAddresses[i2] != null) continue;
                recipientAddresses[i2] = "";
            }
            String[] attachmentNames = new String[this.attachments.size()];
            String[] attachmentFileNames = new String[this.attachments.size()];
            for (i = 0; i < this.attachments.size(); ++i) {
                Attachment attachment = (Attachment)this.attachments.get(i);
                attachmentNames[i] = attachment.name == null ? "" : attachment.name;
                attachmentFileNames[i] = attachment.fileName == null ? "" : attachment.fileName;
                try {
                    attachmentFileNames[i] = attachment.fileName == null ? "" : new File(attachment.fileName).getCanonicalPath();
                    continue;
                }
                catch (IOException e) {
                    AppletLogger.logError((Object)this, "swingSendMail", e);
                    attachmentFileNames[i] = "";
                }
            }
            AppletLogger.logInfo(this, "swingSendMail", "subject: " + this.subject);
            AppletLogger.logInfo(this, "swingSendMail", "recipients: " + recipientTypes.length);
            for (i = 0; i < recipientTypes.length; ++i) {
                AppletLogger.logInfo(this, "swingSendMail", "  recipient name: " + recipientNames[i]);
                AppletLogger.logInfo(this, "swingSendMail", "  recipient address: " + recipientAddresses[i]);
            }
            AppletLogger.logInfo(this, "swingSendMail", "attachments: " + attachmentNames.length);
            for (i = 0; i < attachmentNames.length; ++i) {
                AppletLogger.logInfo(this, "swingSendMail", "  attachment name: " + attachmentNames[i]);
                AppletLogger.logInfo(this, "swingSendMail", "  attachment file: " + attachmentFileNames[i]);
            }
            if (this.subject == null) {
                this.subject = "";
            }
            if (this.noteText == null) {
                this.noteText = "";
            }
            AppletLogger.logInfo(this, "swingSendMail", "calling sendMail");
            status = this.jni.sendMail(this.subject, this.noteText, recipientTypes, recipientNames, recipientAddresses, attachmentNames, attachmentFileNames);
            AppletLogger.logInfo(this, "swingSendMail", "back from calling sendMail, status=" + status);
        }
        if (!(deleteStatus = this.deleteTemporaryFiles()) && status == 0) {
            status = 4;
        }
        this.recipients.clear();
        this.attachments.clear();
        AppletLogger.logInfo(this, "swingSendMail", "-- EmailApplet.sendMail completed.  Status: " + status + " --");
        AppletLogger.logExit(this, "swingSendMail");
        return status;
    }

    private int initializeJNI() {
        this.jni = new WCEmailAppletJNI();
        int status = this.jni.initialize(this.getCodeBase(), this.platform);
        return status;
    }

    private boolean deleteTemporaryFiles() {
        boolean status = true;
        this.filesNotDeleted = new ArrayList();
        for (int i = 0; i < this.attachments.size(); ++i) {
            Attachment attachment = (Attachment)this.attachments.get(i);
            if (!attachment.isTemporary) continue;
            File file = new File(attachment.fileName);
            boolean fileDeleted = file.delete();
            status &= fileDeleted;
            if (fileDeleted) continue;
            this.filesNotDeleted.add(attachment.fileName);
        }
        return status;
    }

    private File createZipFile(String attachmentName, File attachmentFile, boolean isTemporary) {
        String methodName = "createZipFile";
        AppletLogger.logEntry(this, "createZipFile");
        File tempFile = null;
        FileOutputStream tempFileOutputStream = null;
        try {
            tempFile = File.createTempFile("wcEmail", ".zip");
            tempFileOutputStream = new FileOutputStream(tempFile);
        }
        catch (Throwable e) {
            AppletLogger.logError((Object)this, "createZipFile", e);
        }
        if (tempFile == null) {
            return null;
        }
        try {
            FileInputStream attachmentInputStream = new FileInputStream(attachmentFile);
            byte[] attachmentByteArray = new byte[(int)attachmentFile.length()];
            try {
                attachmentInputStream.read(attachmentByteArray);
            }
            catch (IOException e) {
                AppletLogger.logError((Object)this, "createZipFile", e);
                return null;
            }
            CRC32 crc32 = new CRC32();
            crc32.update(attachmentByteArray, 0, attachmentByteArray.length);
            ZipOutputStream zipOutputStream = new ZipOutputStream(tempFileOutputStream);
            ZipEntry zipEntry = new ZipEntry(attachmentName);
            zipEntry.setMethod(0);
            zipEntry.setSize(attachmentFile.length());
            zipEntry.setCrc(crc32.getValue());
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(attachmentByteArray);
            attachmentInputStream.close();
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            if (isTemporary) {
                attachmentFile.delete();
            }
            AppletLogger.logExit(this, "createZipFile");
            return tempFile;
        }
        catch (Exception e) {
            AppletLogger.logError((Object)this, "createZipFile", e);
            return null;
        }
    }

    public void update(Graphics g) {
    }

    public void destroy() {
        String methodName = "destroy";
        AppletLogger.logInfo(this, "destroy", "-- EmailApplet destroyed --");
        super.destroy();
    }

    public synchronized void init() {
        String methodName = "init";
        if (this.initCalled) {
            AppletLogger.logInfo(this, "init", "init, init is returning since already called");
            return;
        }
        this.initCalled = true;
        String userAgent = this.getParameter("userAgent");
        AppletLogger.logInfo(this, "init", "User agent specified: " + userAgent);
        if (this.platform != null && this.platform.length() > 0) {
            this.userAgent = userAgent;
        }
        String platform = this.getParameter("platform");
        AppletLogger.logInfo(this, "init", "Platform specified: " + platform);
        if (platform != null && platform.length() > 0) {
            this.platform = platform;
        }
        String logLevel = this.getParameter("logLevel");
        AppletLogger.setLogLevel(Integer.parseInt(logLevel));
        AppletLogger.logInfo(this, "init", "-- EmailApplet initialized --");
        super.init();
    }

    private class Attachment {
        public String name;
        public String fileName;
        public boolean isTemporary;

        private Attachment() {
        }
    }

    private class Recipient {
        public int type;
        public String name;
        public String address;

        private Recipient() {
        }
    }
}

