/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets;

import com.ibm.ecm.applets.AppletLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public class NativeLibraryDeployer {
    private static final Object GET_LOCK_SYNCH = new Object();
    URL codebase;
    String platform = null;

    public NativeLibraryDeployer(URL codebase) {
        this.codebase = codebase;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    private FileLock getLock(String destPath) throws FileNotFoundException, IOException {
        String methodName = "getLock";
        AppletLogger.logEntry(this, methodName);
        FileLock fileLock = null;
        String lockPath = destPath + (destPath.endsWith(File.separator) ? "" : File.separator) + "NativeLibraryDeployer.lock";
        File lockFile = new File(lockPath);
        FileChannel lockChannel = new RandomAccessFile(lockFile, "rw").getChannel();
        fileLock = lockChannel.lock();
        AppletLogger.logExit(this, methodName);
        return fileLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployNativeLibrary(String nativeLibName) throws Exception {
        String methodName = "deployNativeLibrary";
        AppletLogger.logEntry(this, methodName);
        Object object = GET_LOCK_SYNCH;
        synchronized (object) {
            AppletLogger.logDebug(this, methodName, "ENTER THREAD SYNCHRONIZED BLOCK");
            String destPath = this.getLibExt();
            FileLock lock = this.getLock(destPath);
            AppletLogger.logDebug(this, methodName, "ENTER FILESYSTEM SYNCHRONIZED BLOCK");
            if (this.isDifferentVersion(nativeLibName)) {
                AppletLogger.logWarning(this, methodName, "Deploying native library: " + nativeLibName);
                String metaInfPath = destPath + (destPath.endsWith(File.separator) ? "" : File.separator) + "META-INF";
                File miFile = new File(metaInfPath);
                if (!miFile.exists()) {
                    miFile.mkdirs();
                }
                URL jarURL = new URL("jar:" + this.codebase.toString() + nativeLibName + "!/");
                JarURLConnection jarLib = (JarURLConnection)jarURL.openConnection();
                JarFile jarLibFile = jarLib.getJarFile();
                Enumeration<JarEntry> enuJarEntries = jarLibFile.entries();
                while (enuJarEntries.hasMoreElements()) {
                    JarEntry jeOneFile = enuJarEntries.nextElement();
                    File flOneFile = new File(destPath + (destPath.endsWith(File.separator) ? "" : File.separator) + jeOneFile.toString());
                    if (jeOneFile.isDirectory()) {
                        if (flOneFile.exists()) continue;
                        flOneFile.mkdir();
                        continue;
                    }
                    CheckedInputStream cisOneFile = new CheckedInputStream(jarLibFile.getInputStream(jeOneFile), new CRC32());
                    try {
                        int numRead;
                        FileOutputStream fos = new FileOutputStream(flOneFile);
                        int bufsize = 4096;
                        byte[] buf = new byte[bufsize];
                        for (int fsize = (int)jeOneFile.getSize(); fsize > 0; fsize -= numRead) {
                            numRead = fsize > bufsize ? cisOneFile.read(buf, 0, bufsize) : cisOneFile.read(buf, 0, fsize);
                            fos.write(buf, 0, numRead);
                        }
                        fos.flush();
                        fos.close();
                    }
                    catch (FileNotFoundException e) {
                        AppletLogger.logError(NativeLibraryDeployer.class, methodName, e);
                    }
                    cisOneFile.close();
                }
                String path = destPath + (destPath.endsWith(File.separator) ? "" : File.separator) + nativeLibName + ".manifest";
                AppletLogger.logWarning(this, methodName, "Updating manifest file in " + path);
                FileOutputStream wManifestFile = new FileOutputStream(path);
                Manifest cManifest = jarLibFile.getManifest();
                if (cManifest != null) {
                    cManifest.write(wManifestFile);
                }
                wManifestFile.close();
                AppletLogger.logWarning(this, methodName, "Deploy finished: " + nativeLibName);
            }
            AppletLogger.logDebug(this, methodName, "EXIT FILESYSTEM SYNCHRONIZED BLOCK");
            lock.release();
            AppletLogger.logDebug(this, methodName, "EXIT THREAD SYNCHRONIZED BLOCK");
        }
        AppletLogger.logExit(this, methodName);
    }

    private boolean isDifferentVersion(String nativeLibName) throws IOException {
        String methodName = "isDifferentVersion";
        String destPath = this.getLibExt();
        AppletLogger.logWarning(this, methodName, "Determining if native library is different: " + nativeLibName);
        URL jarURL = new URL("jar:" + this.codebase.toString() + nativeLibName + "!/");
        AppletLogger.logWarning(this, methodName, "JAR URL is jar:" + this.codebase.toString() + nativeLibName + "!/");
        JarURLConnection jarLib = (JarURLConnection)jarURL.openConnection();
        JarFile jarLibFile = jarLib.getJarFile();
        boolean differentVersion = true;
        Manifest cManifest = jarLibFile.getManifest();
        Attributes cAttr = cManifest.getMainAttributes();
        String cVersion = cAttr.getValue("Implementation-Version");
        AppletLogger.logWarning(this, methodName, "Jar's implementation version is " + cVersion);
        FileInputStream oManifestFile = null;
        String pathOfOldManifest = destPath + System.getProperty("file.separator") + nativeLibName + ".manifest";
        try {
            oManifestFile = new FileInputStream(pathOfOldManifest);
        }
        catch (FileNotFoundException e) {
            AppletLogger.logWarning(this, methodName, "Manifest file not found.  Assuming different version.");
            differentVersion = true;
        }
        if (oManifestFile != null) {
            Manifest oManifest = new Manifest(oManifestFile);
            Attributes oAttr = oManifest.getMainAttributes();
            String oVersion = oAttr.getValue("Implementation-Version");
            AppletLogger.logWarning(this, methodName, "Deployed implementation version is " + oVersion);
            if (oVersion != null && oVersion.compareToIgnoreCase(cVersion) == 0) {
                differentVersion = false;
            }
            oManifestFile.close();
        }
        return differentVersion;
    }

    private final String getLibExt() {
        File libExtDir;
        String methodName = "getLibExt";
        AppletLogger.logEntry(this, methodName);
        String libExt = System.getProperty("java.io.tmpdir");
        if (this.platform != null && this.platform.length() > 0) {
            AppletLogger.logDebug(this, methodName, "Adding platform " + this.platform + " to java.io.tmpdir path.");
            libExt = libExt + this.platform + File.separator;
        }
        if (!(libExtDir = new File(libExt)).exists()) {
            libExtDir.mkdir();
        }
        AppletLogger.logExit(this, methodName, libExt);
        return libExt;
    }

    public final String getDllPath() {
        return this.getLibExt();
    }
}

