/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets;

import com.ibm.ecm.applets.AppletLogger;
import com.ibm.ecm.util.JSONUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class MessageDialog
extends JDialog {
    private static final String ERRORS = "errors";
    private static final String GLOBALS = "globals";
    private static final String GLOBALS_ID = "globals_id";
    private static final String[] NEXUS_ERROR_FIELDS = new String[]{"number", "explanation", "userResponse"};
    private JOptionPane optionPane;

    public static void showErrorDialog(Component parentComponent, String title, String message) {
        Window window = SwingUtilities.windowForComponent(parentComponent);
        MessageDialog messageDialog = window instanceof Frame ? new MessageDialog((Frame)window, title) : new MessageDialog((Dialog)window, title);
        messageDialog.setMessage(0, message);
        messageDialog.pack();
        messageDialog.setLocationRelativeTo(parentComponent);
        messageDialog.show();
    }

    public static void showErrorDialog(Component parentComponent, String title, String message, String detailedMessage) {
        Window window = SwingUtilities.windowForComponent(parentComponent);
        MessageDialog messageDialog = window instanceof Frame ? new MessageDialog((Frame)window, title) : new MessageDialog((Dialog)window, title);
        messageDialog.setMessage(0, message + "\n\n" + detailedMessage);
        messageDialog.pack();
        messageDialog.setLocationRelativeTo(parentComponent);
        messageDialog.show();
    }

    public static void showErrorDialog(Component parentComponent, String title, String message, JSONObject jsonResponseObject) {
        String methodName = "showErrorDialog";
        if (jsonResponseObject.containsKey(ERRORS)) {
            JSONArray jsonErrors = JSONUtil.getArray(jsonResponseObject, ERRORS);
            if (jsonErrors != null) {
                String errorStrings = "";
                if (jsonErrors != null) {
                    for (int i = 0; i < jsonErrors.size(); ++i) {
                        try {
                            Object jsonError = jsonErrors.get(i);
                            if (jsonError instanceof String) {
                                try {
                                    JSONObject jsonErrorAsJSONObject = JSONObject.parse(jsonError.toString());
                                    jsonError = jsonErrorAsJSONObject;
                                }
                                catch (Exception e) {
                                    AppletLogger.logError(MessageDialog.class, methodName, e);
                                }
                            }
                            if (jsonError instanceof JSONObject && ((JSONObject)jsonError).containsKey(GLOBALS)) {
                                JSONArray globalJsonErrors = JSONUtil.getArray((JSONObject)jsonError, GLOBALS);
                                for (int j = 0; j < globalJsonErrors.size(); ++j) {
                                    errorStrings = errorStrings + "\n" + globalJsonErrors.get(i).toString();
                                }
                                continue;
                            }
                            if (jsonError instanceof JSONObject && ((JSONObject)jsonError).containsKey(GLOBALS_ID)) {
                                JSONArray globalJsonErrorIds = JSONUtil.getArray((JSONObject)jsonError, GLOBALS_ID);
                                for (int j = 0; j < globalJsonErrorIds.size(); ++j) {
                                    errorStrings = errorStrings + "\n" + globalJsonErrorIds.get(i).toString();
                                }
                                continue;
                            }
                            if (jsonError instanceof JSONObject && ((JSONObject)jsonError).containsKey(NEXUS_ERROR_FIELDS[0])) {
                                JSONObject jsonErrorObject = (JSONObject)jsonError;
                                StringBuffer sBuf = new StringBuffer();
                                for (int n = 0; n < NEXUS_ERROR_FIELDS.length; ++n) {
                                    Object value = jsonErrorObject.get(NEXUS_ERROR_FIELDS[n]);
                                    if (value == null) continue;
                                    sBuf.append(value).append("\n");
                                }
                                errorStrings = errorStrings + "\n" + sBuf.toString();
                                continue;
                            }
                            errorStrings = errorStrings + "\n" + jsonError.toString();
                            continue;
                        }
                        catch (Exception e) {
                            AppletLogger.logError(MessageDialog.class, methodName, e);
                        }
                    }
                }
                MessageDialog.showErrorDialog(parentComponent, title, message, errorStrings);
            } else {
                MessageDialog.showErrorDialog(parentComponent, title, message);
            }
        }
    }

    public MessageDialog(Frame parent, String title) {
        super(parent, title, true);
        this.init();
    }

    public MessageDialog(Dialog parent, String title) {
        super(parent, title, true);
        this.init();
    }

    private void init() {
        this.optionPane = new JOptionPane(){

            public int getMaxCharactersPerLineCount() {
                return 80;
            }
        };
        this.getContentPane().add(this.optionPane);
        this.optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (MessageDialog.this.isVisible() && event.getSource() == MessageDialog.this.optionPane && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    MessageDialog.this.setVisible(false);
                }
            }
        });
    }

    public void setMessage(int messageType, String message) {
        this.optionPane.setMessage(message);
        this.optionPane.setMessageType(messageType);
    }
}

