/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.applets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;

public class ContentVerifyApplet
extends JApplet {
    public static boolean trace = false;
    StringBuffer sb = new StringBuffer();
    private JSListener jsListener = null;
    private Thread jsListenerThread = null;

    public void init() {
        this.initJSListener();
        this.println("ContentVerifyApplet X has started.");
    }

    public static void setTrace(boolean trace) {
        ContentVerifyApplet.trace = trace;
    }

    public static void trace(String value) {
        if (trace) {
            System.out.println(value);
        }
    }

    public String getHttp(String url, boolean forwardCookies) {
        this.sb.setLength(0);
        try {
            final String rUrl = url;
            final boolean rForwardCookies = forwardCookies;
            this.jsListener.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        ContentVerifyApplet.this.println("\nGET: " + rUrl + "; forwardCookies == " + rForwardCookies);
                        URL oUrl = new URL(rUrl);
                        ContentVerifyApplet.trace("URL Assigned.");
                        String protocol = oUrl.getProtocol();
                        ContentVerifyApplet.trace("Protocol: " + protocol);
                        String host = oUrl.getHost();
                        ContentVerifyApplet.trace("Host: " + host);
                        int port = oUrl.getPort();
                        ContentVerifyApplet.trace("Port: " + port);
                        String path = oUrl.getPath();
                        ContentVerifyApplet.trace("Path: " + path);
                        String query = oUrl.getQuery();
                        ContentVerifyApplet.trace("Query: " + query);
                        if (port < 0) {
                            port = protocol.equalsIgnoreCase("https") ? 443 : 80;
                        }
                        ContentVerifyApplet.trace("Port fixed to: " + port);
                        String string = path = path == null || path == "" ? "/" : path;
                        if (query != null) {
                            path = path + "?" + query;
                        }
                        ContentVerifyApplet.trace("Path and query: " + path);
                        ContentVerifyApplet.trace("Callling InetAddress.getByName()");
                        InetAddress ia = InetAddress.getByName(host);
                        ContentVerifyApplet.trace("Returned from InetAddress.getByName()");
                        ContentVerifyApplet.this.println("Opening IP:  " + ia.getHostAddress() + ", port: " + port);
                        Socket socket = new Socket(ia, port);
                        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
                        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        ContentVerifyApplet.this.println("REQUEST HEADERS:");
                        ContentVerifyApplet.this.sendHeader(out, "GET " + path + " HTTP/1.1");
                        ContentVerifyApplet.this.sendHeader(out, "Host: " + host + ":" + port);
                        if (rForwardCookies) {
                            ContentVerifyApplet.this.sendHeader(out, "Cookie: " + ContentVerifyApplet.this.getCookie());
                        }
                        ContentVerifyApplet.this.sendHeader(out, "Connection: close");
                        out.println();
                        ContentVerifyApplet.this.println("== End of request headers ==");
                        boolean loop = true;
                        int timeout = 15000;
                        int interval = 500;
                        for (int totalTime = 0; !in.ready() && totalTime < timeout; totalTime += interval) {
                            ContentVerifyApplet.this.println("Waiting for response...");
                            Thread.sleep(interval);
                        }
                        ContentVerifyApplet.this.println("RESPONSE HEADERS:");
                        if (in.ready()) {
                            String line = in.readLine();
                            while (line != null && line.length() > 0) {
                                ContentVerifyApplet.this.println(line);
                                line = in.readLine();
                            }
                            ContentVerifyApplet.this.println("== End of response headers ==\n");
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return this.sb.toString();
    }

    private void sendHeader(PrintWriter out, String header) {
        this.println(header);
        out.println(header);
    }

    private String getCookie() {
        JSObject window = JSObject.getWindow(this);
        JSObject document = (JSObject)window.getMember("document");
        return (String)document.getMember("cookie");
    }

    private void println(String value) {
        this.sb.append(value).append("\n");
        System.out.println(value);
    }

    private void initJSListener() {
        if (this.jsListenerThread == null && this.jsListener == null) {
            String methodName = "initJSListener()";
            ContentVerifyApplet.trace("Start setting up JSListener");
            this.jsListener = new JSListener();
            ContentVerifyApplet.trace("Starting jsListenerThread.");
            this.jsListenerThread = new Thread(this.jsListener);
            this.jsListenerThread.start();
            ContentVerifyApplet.trace("Finished setting up JSListener");
        }
    }

    private void terminateJSListener() {
        this.jsListener.terminate();
        this.jsListener = null;
        this.jsListenerThread = null;
    }

    private static class JSQueue {
        PipedInputStream is = new PipedInputStream();
        PipedOutputStream os = new PipedOutputStream(this.is);

        private JSQueue() throws IOException {
        }

        private void send(int message) {
            try {
                this.os.write(message);
            }
            catch (IOException ioe) {
                ContentVerifyApplet.trace("Write pipe closed, or write did not complete.");
                ioe.printStackTrace();
            }
        }

        private int receive() {
            int result = -1;
            try {
                result = this.is.read();
            }
            catch (IOException ioe) {
                result = -1;
                ContentVerifyApplet.trace("Read pipe closed, or read did not complete");
                ioe.printStackTrace();
            }
            return result;
        }

        private void close() throws IOException {
            this.os.close();
        }
    }

    private static class JSListener
    implements Runnable {
        private JSQueue requestQueue = null;
        private JSQueue responseQueue = null;
        private Runnable runnable = null;

        private JSListener() {
        }

        public void run() {
            String methodName = "JSListener.run";
            ContentVerifyApplet.trace("Entry: " + methodName);
            try {
                this.requestQueue = new JSQueue();
                this.responseQueue = new JSQueue();
                ContentVerifyApplet.trace("Waiting for first request");
                int command = this.requestQueue.receive();
                while (command != -1) {
                    ContentVerifyApplet.trace("Received request");
                    if (this.runnable != null) {
                        this.runnable.run();
                    }
                    ContentVerifyApplet.trace("Completed request");
                    this.responseQueue.send(0);
                    ContentVerifyApplet.trace("Waiting for next request");
                    command = this.requestQueue.receive();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            ContentVerifyApplet.trace("Exit: " + methodName);
        }

        private boolean waitForReady() throws InterruptedException {
            int sleepTime = 500;
            for (int retries = 0; retries < 10 && (this.requestQueue == null || this.responseQueue == null); ++retries) {
                ContentVerifyApplet.trace("Listener not ready wait/retry: " + retries);
                Thread.sleep(sleepTime);
            }
            return this.requestQueue != null && this.responseQueue != null;
        }

        public int invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
            String methodName = "sendRunnableRequest";
            ContentVerifyApplet.trace("Entry: " + methodName);
            int result = 0;
            if (this.waitForReady()) {
                try {
                    result = this.sendRequest(0, runnable);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            } else {
                ContentVerifyApplet.trace("Listener is not ready, falling back to SwingUtilities");
                SwingUtilities.invokeAndWait(runnable);
            }
            ContentVerifyApplet.trace("Exit: " + methodName);
            return result;
        }

        public void terminate() {
            try {
                this.requestQueue.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            try {
                this.responseQueue.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private synchronized int sendRequest(int command, Runnable runnable) throws IOException {
            String methodName = "sendRequest";
            ContentVerifyApplet.trace("Entry: " + methodName);
            this.runnable = runnable;
            this.requestQueue.send(command);
            ContentVerifyApplet.trace("Waiting for response from request: " + command);
            int result = this.responseQueue.receive();
            ContentVerifyApplet.trace("Exit: " + methodName);
            return result;
        }
    }
}

