/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sls.powercapture;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Utilities {
    public static Document parseXMLFile(String string) throws Exception {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(fileInputStream);
            return document;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static PrintWriter getWriterForArg(File file, String string) throws IOException {
        PrintWriter printWriter = string.equals("-") ? new PrintWriter(System.out){

            @Override
            public void close() {
                this.flush();
            }
        } : (file == null ? new PrintWriter(new File(string)) : new PrintWriter(new File(file, string)));
        return printWriter;
    }

    protected static void writeXMLFile(Node node, File file, String string) throws Exception {
        PrintWriter printWriter = null;
        try {
            printWriter = Utilities.getWriterForArg(file, string);
            StreamResult streamResult = new StreamResult(printWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource dOMSource = new DOMSource(node);
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (printWriter != null) {
                try {
                    ((Writer)printWriter).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeXMLFile(Document document, String string) throws Exception {
        Utilities.writeXMLFile(document, null, string);
    }

    public static String extract(String string, String string2) {
        Matcher matcher = Pattern.compile(string2 + "=([^=]+)(,|$)").matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "$" + string2;
    }
}

