/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sls.powercapture;

import com.ibm.sls.powercapture.ColumnPanel;
import com.ibm.sls.powercapture.Main;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class PromptWindow {
    private JFrame frame;
    private JTextField hmcNameField;
    private JTextField hmcUserIdField;
    private JPasswordField hmcPasswordField;
    private JTextField outputFilenameField;
    private JTextField managedSystemListField;
    private JTextField partitionListField;
    boolean running = true;
    private JCheckBox extendedCheckbox;
    private JCheckBox strictCheckbox;
    Object lock;
    private String[] args = null;
    private Main main;
    private JButton fileChooseButton;

    public PromptWindow(Main main) {
        this.main = main;
        this.lock = main.lock;
        this.initialize();
        this.frame.setVisible(true);
    }

    private void initialize() {
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(3);
        this.frame.setTitle("Power Capture " + this.main.build);
        this.frame.getContentPane().setLayout(new BorderLayout());
        ColumnPanel columnPanel = new ColumnPanel();
        this.frame.getContentPane().add((Component)columnPanel, "Center");
        this.hmcNameField = new JTextField(20);
        columnPanel.addRow("HMC Name:", this.hmcNameField);
        this.hmcUserIdField = new JTextField(20);
        columnPanel.addRow("HMC User Id:", this.hmcUserIdField);
        this.hmcPasswordField = new JPasswordField(20);
        this.hmcPasswordField.setEchoChar('*');
        columnPanel.addRow("HMC Password:", this.hmcPasswordField);
        this.outputFilenameField = new JTextField(50);
        this.fileChooseButton = new JButton(UIManager.getIcon("FileView.directoryIcon"));
        this.fileChooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JFileChooser jFileChooser = new JFileChooser(".");
                    int n = jFileChooser.showSaveDialog(PromptWindow.this.outputFilenameField.getParent());
                    if (n == 0) {
                        PromptWindow.this.outputFilenameField.setText(jFileChooser.getSelectedFile().getCanonicalPath());
                    }
                }
                catch (HeadlessException headlessException) {
                    headlessException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
        columnPanel.addRow("Output Filename:", this.outputFilenameField, this.fileChooseButton);
        this.managedSystemListField = new JTextField(50);
        columnPanel.addRow("Managed System List (optional):", this.managedSystemListField);
        this.partitionListField = new JTextField(50);
        columnPanel.addRow("Partition List (optional):", this.partitionListField);
        this.extendedCheckbox = new JCheckBox();
        this.extendedCheckbox.setSelected(true);
        columnPanel.addRow("Bypass Extended Capture:", this.extendedCheckbox);
        this.strictCheckbox = new JCheckBox();
        this.strictCheckbox.setSelected(false);
        columnPanel.addRow("Strict SSL Checking:", this.strictCheckbox);
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PromptWindow.this.createArguments();
                PromptWindow.this.frame.dispose();
                PromptWindow.this.running = false;
                Object object = PromptWindow.this.lock;
                synchronized (object) {
                    PromptWindow.this.lock.notifyAll();
                }
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("Cancel pressed");
                PromptWindow.this.frame.dispose();
                PromptWindow.this.running = false;
                Object object = PromptWindow.this.lock;
                synchronized (object) {
                    PromptWindow.this.lock.notifyAll();
                }
            }
        });
        jPanel.add(jButton2);
        this.frame.getContentPane().add((Component)jPanel, "South");
        Dimension dimension = this.frame.getPreferredSize();
        dimension.height += 50;
        this.frame.setSize(dimension);
        this.hmcNameField.setColumns(50);
        this.hmcUserIdField.setColumns(50);
        this.hmcPasswordField.setColumns(50);
        this.outputFilenameField.setColumns(50);
        this.managedSystemListField.setColumns(256);
        this.partitionListField.setColumns(256);
    }

    public boolean isRunning() {
        return this.running;
    }

    private void createArguments() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.hmcNameField.getText();
        String string2 = this.hmcUserIdField.getText();
        char[] cArray = this.hmcPasswordField.getPassword();
        String string3 = this.outputFilenameField.getText();
        String string4 = this.managedSystemListField.getText();
        String string5 = this.partitionListField.getText();
        if (!string.isEmpty()) {
            arrayList.add("-h");
            arrayList.add(string);
        }
        if (!string2.isEmpty()) {
            arrayList.add("-u");
            arrayList.add(string2);
        }
        if (cArray.length > 0) {
            arrayList.add("-p");
            arrayList.add(new String(cArray));
        }
        if (!string3.isEmpty()) {
            arrayList.add("-o");
            arrayList.add(string3);
        }
        if (!string4.isEmpty()) {
            arrayList.add("-m");
            arrayList.add(string4);
        }
        if (!string5.isEmpty()) {
            arrayList.add("-l");
            arrayList.add(string5);
        }
        if (this.extendedCheckbox.isSelected()) {
            arrayList.add("-e");
        }
        if (this.strictCheckbox.isSelected()) {
            arrayList.add("-s");
        }
        this.args = arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getArgs() {
        return this.args;
    }
}

