/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sls.powercapture;

import com.ibm.sls.install.IBMiLabsInstaller;
import com.ibm.sls.powercapture.HMCRESTConnection;
import com.ibm.sls.powercapture.PromptWindow;
import com.ibm.sls.powercapture.Utilities;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main
implements Runnable {
    private static Pattern listpattern = Pattern.compile(",?([^,]+)");
    private static Pattern csvpattern = Pattern.compile("(?:,|\n|^)(\"(?:(?:\"\")*[^\"]*)*\"|[^\",\n]*|(?:\n|$))");
    String build = "default";
    private String hmc = null;
    private String userid = "hscroot";
    private String password = null;
    private boolean extended = true;
    private File draw_captures;
    private File capture;
    private List<String> sysList = new LinkedList<String>();
    private List<String> lparList = new LinkedList<String>();
    private File record = null;
    Object lock = new Object();
    private boolean strict = false;

    public static void main(String[] stringArray) {
        Main main = new Main(stringArray);
        main.run();
    }

    private Main(String[] stringArray) {
        String string;
        Object object;
        Object object2;
        String string2 = this.getClass().getCanonicalName();
        String string3 = "java " + string2 + " -h hmcName [-u hmcUserid] [-p hmcpassword] [-o outputFileName] [-m managedSystemList] [-l partitionList] {-e] [-s]\r\n";
        boolean bl = false;
        String string4 = null;
        if (stringArray.length == 0) {
            object2 = new IBMiLabsInstaller();
            ((IBMiLabsInstaller)object2).run();
            if (((IBMiLabsInstaller)object2).isInstalled()) {
                System.err.print(((IBMiLabsInstaller)object2).getLog());
                System.err.println("\nInstall Completed");
                System.exit(0);
            }
        }
        object2 = this.getClass().getResourceAsStream("/installer.properties");
        Properties properties = new Properties();
        try {
            properties.load((InputStream)object2);
            this.build = properties.getProperty("build.version", "notfound");
        }
        catch (IOException iOException) {
            this.build = "exception";
        }
        if (stringArray.length == 0) {
            try {
                final PromptWindow promptWindow = new PromptWindow(this);
                object = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = Main.this.lock;
                        synchronized (object) {
                            while (promptWindow.isRunning()) {
                                try {
                                    Main.this.lock.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            }
                        }
                    }
                };
                object.start();
                object.join();
                String[] stringArray2 = promptWindow.getArgs();
                if (stringArray2 != null) {
                    stringArray = stringArray2;
                }
            }
            catch (HeadlessException headlessException) {
                System.err.println("No GUI available - use command line options\n");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            block29: for (int i = 0; i < stringArray.length; ++i) {
                switch (object = stringArray[i]) {
                    case "-h": {
                        this.hmc = stringArray[++i];
                        continue block29;
                    }
                    case "-u": {
                        this.userid = stringArray[++i];
                        continue block29;
                    }
                    case "-p": {
                        this.password = stringArray[++i];
                        continue block29;
                    }
                    case "-o": {
                        string4 = stringArray[++i];
                        continue block29;
                    }
                    case "-m": {
                        object = stringArray[++i];
                        Matcher matcher = listpattern.matcher((CharSequence)object);
                        while (matcher.find()) {
                            this.sysList.add(matcher.group(1));
                        }
                        continue block29;
                    }
                    case "-l": {
                        object = stringArray[++i];
                        Matcher matcher = listpattern.matcher((CharSequence)object);
                        while (matcher.find()) {
                            this.lparList.add(matcher.group(1));
                        }
                        continue block29;
                    }
                    case "-r": {
                        object = stringArray[++i];
                        this.record = this.mkdir((String)object);
                        continue block29;
                    }
                    case "-e": {
                        this.extended = false;
                        continue block29;
                    }
                    case "-s": {
                        this.strict = true;
                        continue block29;
                    }
                    default: {
                        System.err.println("Unrecognized parameter: " + (String)object);
                        bl = true;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Missing argument");
            bl = true;
        }
        if (this.record == null && (string = System.getenv("POWERCAPTURE_RECORD_PATH")) != null) {
            this.record = this.mkdir(string);
        }
        if (this.hmc == null) {
            System.err.println("missing -h hmc name");
            bl = true;
        }
        if (string4 == null) {
            System.err.println("missing -o capture file name");
            bl = true;
        }
        if (this.record != null && this.hmc != null && this.hmc.startsWith("files:")) {
            System.err.println("-r record not valid with file input");
            bl = true;
        }
        if (bl) {
            System.err.println(string3);
            System.err.println("Java version: " + System.getProperty("java.version", "unknown"));
            System.err.println("Tool version:" + this.build);
            System.exit(0);
        }
        this.capture = new File(string4);
        if (this.capture.getParent() == null) {
            this.draw_captures = this.mkdir("draw_captures");
            this.capture = new File(this.draw_captures, string4);
        }
    }

    private File mkdir(String string) {
        File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            try {
                System.err.println("Could not make directories: " + file.getCanonicalPath());
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
        return file;
    }

    @Override
    public void run() {
        this.captureFromHMC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void captureFromHMC() {
        System.err.println("Java version: " + System.getProperty("java.version", "unknown"));
        System.err.println("Tool version:" + this.build);
        HMCRESTConnection hMCRESTConnection = null;
        try (PrintWriter printWriter = new PrintWriter(this.capture);){
            String string;
            String string2;
            String string322;
            Object object;
            printWriter.println("CREATIONDATE:" + new Date());
            printWriter.print("CAPTUREVERSION:");
            printWriter.print(this.build);
            printWriter.print(" on java version ");
            printWriter.println(System.getProperty("java.version", "unknown"));
            if (this.password == null && System.console() != null && !this.hmc.startsWith("files:")) {
                object = System.console().readPassword("Password for user %s@%s: ", this.userid, this.hmc);
                if (object == null) {
                    return;
                }
                this.password = new String((char[])object);
            }
            hMCRESTConnection = new HMCRESTConnection(this.strict);
            if (this.hmc.startsWith("files:")) {
                object = this.hmc.substring(6);
                try {
                    hMCRESTConnection.readSystemsXMLFromFile((String)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    hMCRESTConnection.systemXML = null;
                }
            } else {
                if (this.record != null) {
                    hMCRESTConnection.debugPath = this.record;
                }
                if (!hMCRESTConnection.logon(this.hmc, this.userid, this.password)) {
                    System.err.println("Logon failed!");
                    System.exit(-2);
                }
                System.err.println("Login succeeded...");
            }
            hMCRESTConnection.getHMCXml();
            object = hMCRESTConnection.cliRunner("lssyscfg -r sys");
            String string4 = hMCRESTConnection.getJobResults((String)object);
            string4 = string4.replace("\"", "");
            string4 = string4.replace("\r", "");
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            for (String string322 : Arrays.asList(string4.split("\n"))) {
                string2 = this.extract(string322, "name");
                string = this.extract(string322, "state");
                if (string != null && string.equalsIgnoreCase("Operating")) {
                    treeMap.put(string2, string322);
                    continue;
                }
                System.out.println("Bypassing system " + string2 + " in state " + string);
            }
            Object object2 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lshmc -v"));
            object2 = ((String)object2).replace("\"", "");
            string322 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lshmc -n"));
            string322 = string322.replace("\"", "");
            string2 = this.extract(string322, "name");
            string = this.extractGroup("(?m)^\\*RM\\s+(.*)$", (String)object2, 1);
            String string5 = this.extractGroup("(?m)^\\*TM\\s+(.*)$", (String)object2, 1);
            printWriter.println("HMC," + string2 + ":version=" + string + ",type_model=" + string5 + "," + string322);
            for (String string6 : treeMap.keySet()) {
                int n;
                void var21_56;
                void var20_44;
                void var20_42;
                TreeSet<String> treeSet;
                Object object3;
                void i;
                if (this.sysList != null && !this.sysList.isEmpty() && !this.sysList.contains(string6)) continue;
                printWriter.println("MANAGEDSYSTEM," + string6 + ":" + (String)treeMap.get(string6));
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                messageDigest.update(((String)treeMap.get(string6)).getBytes("UTF-8"));
                String string8 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lssyscfg -r sys -m " + string6 + " -F capabilities"));
                string8 = string8.replace("\"", "");
                printWriter.println("CAPABILITIES," + string6 + ":" + String.join((CharSequence)",", string8));
                String string9 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lshwres -r io --rsubtype slot -m " + string6));
                string9 = string9.replace("\"", "");
                for (String string3 : string9.split("\n")) {
                    printWriter.println("PHYSICALIO," + string6 + ":" + string3);
                }
                Object object6 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lshwres -r io --rsubtype slotchildren -m " + string6));
                object6 = ((String)object6).replace("\"", "");
                Object object4 = ((String)object6).split("\n");
                int n2 = ((String[])object4).length;
                boolean entry = false;
                while (i < n2) {
                    String string7 = object4[i];
                    printWriter.println("SLOTCHILDREN," + string6 + ":" + string7);
                    messageDigest.update(string7.getBytes("UTF-8"));
                    ++i;
                }
                object6 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lshwres -r virtualio --rsubtype vnetwork -m " + string6 + " -F vswitch,is_tagged,vlan_id "));
                if (!((String)object6).isEmpty()) {
                    if (!((String)object6).contains("invalid value are --rsubtype")) {
                        void var21_51;
                        object6 = ((String)object6).replace("\"", "");
                        object4 = new TreeMap();
                        String[] stringArray = ((String)object6).split("\n");
                        int n3 = stringArray.length;
                        boolean bl = false;
                        while (var21_51 < n3) {
                            String string12 = stringArray[var21_51];
                            string12 = string12.replace("\n", "");
                            string12 = string12.replace("\r", "");
                            object3 = string12.split(",");
                            treeSet = (TreeSet<String>)object4.get(object3[0]);
                            if (treeSet == null) {
                                treeSet = new TreeSet<String>();
                                object4.put(object3[0], treeSet);
                            }
                            treeSet.add("tagged:" + object3[1] + " vlan:" + object3[2]);
                            ++var21_51;
                        }
                        for (Map.Entry entry2 : object4.entrySet()) {
                            printWriter.print("VSWITCH," + string6 + "," + (String)entry2.getKey() + ":vswitch=" + (String)entry2.getKey());
                            for (String string13 : (Set)entry2.getValue()) {
                                printWriter.print("," + string13);
                            }
                            printWriter.println();
                        }
                    } else {
                        printWriter.println("WARNING," + string6 + ": lshwres --rsubtype vnetwork Unsupported - virtual networks may be incomplete");
                        System.err.println("WARNING," + string6 + ": lshwres --rsubtype vnetwork Unsupported - virtual networks may be incomplete");
                    }
                }
                this.createVirtualIO(hMCRESTConnection, printWriter, string6, "eth");
                this.createVirtualIO(hMCRESTConnection, printWriter, string6, "fc");
                this.createVirtualIO(hMCRESTConnection, printWriter, string6, "scsi");
                this.createVirtualIO(hMCRESTConnection, printWriter, string6, "vnic");
                this.createVirtualIO(hMCRESTConnection, printWriter, string6, "vnicbkdev");
                object6 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lshwres -r sriov --rsubtype adapter -m " + string6));
                object6 = ((String)object6).replace("\"", "");
                object4 = ((String)object6).split("\n");
                int n4 = ((Object)object4).length;
                boolean bl = false;
                while (var20_42 < n4) {
                    Object object5 = object4[var20_42];
                    printWriter.println("SRIOVADAPTER," + string6 + ":DeviceType=SRIOVADAPTER," + (String)object5);
                    ++var20_42;
                }
                object4 = "eth,roce,ethc".split(",");
                n4 = ((Object)object4).length;
                boolean bl2 = false;
                while (var20_44 < n4) {
                    Object object7 = object4[var20_44];
                    object6 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lshwres -r sriov --rsubtype physport --level " + (String)object7 + " -m " + string6));
                    object6 = ((String)object6).replace("\"", "");
                    for (String string14 : ((String)object6).split("\n")) {
                        printWriter.println("SRIOVPHYSPORT," + string6 + ":DeviceType=SRIOVPHYSPORT," + string14);
                    }
                    ++var20_44;
                }
                Object object8 = object4 = new String[]{"", " --level eth"};
                int n5 = ((Object)object8).length;
                boolean bl3 = false;
                while (var21_56 < n5) {
                    Object object9 = object8[var21_56];
                    object6 = this.extended ? ((object6 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lshwres -r sriov --rsubtype logport" + (String)object9 + " -m " + string6 + " -F --header"))) != null && !((String)object6).contains("HSCL8016") ? this.convertCSVToNameValue((String)object6) : hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lshwres -r sriov --rsubtype logport" + (String)object9 + " -m " + string6))) : hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lshwres -r sriov --rsubtype logport" + (String)object9 + " -m " + string6));
                    object6 = ((String)object6).replace("\"", "");
                    for (String string15 : ((String)object6).split("\n")) {
                        printWriter.println("SRIOVLOGPORT," + string6 + ":DeviceType=SRIOVLOGPORT," + string15);
                    }
                    ++var21_56;
                }
                object8 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lssyscfg -r prof -m " + string6));
                String string72 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lssyscfg -r lpar -m " + string6));
                string72 = string72.replace("\"", "");
                object8 = ((String)object8).replace("\"", "");
                String[] stringArray = string72.split("\n");
                int n6 = stringArray.length;
                for (n = 0; n < n6; ++n) {
                    String string17 = stringArray[n];
                    String string18 = this.extract(string17, "lpar_env");
                    if (string18.equals("vioserver")) continue;
                    this.doLparCommon(printWriter, string6, string9, (String)object8, string17, "CLIENTLPAR");
                }
                String[] stringArray2 = string72.split("\n");
                int n7 = stringArray2.length;
                for (n = 0; n < n7; ++n) {
                    String string15;
                    String string19 = stringArray2[n];
                    String string20 = this.extract(string19, "lpar_env");
                    if (!string20.equals("vioserver") || !this.doLparCommon(printWriter, string6, string9, (String)object8, string19, "VIOLPAR")) continue;
                    string15 = this.extract(string19, "name");
                    String string21 = this.extract(string19, "state");
                    if (string20.equals("vioserver") && string21.equalsIgnoreCase("running")) {
                        void var34_103;
                        void var33_102;
                        void var32_95;
                        Object object10;
                        if (!this.extract(string19, "rmc_state").equalsIgnoreCase("active")) {
                            printWriter.println("WARNING," + string6 + ":VIOS RMC was not active at capture time for : " + string15);
                        }
                        String string22 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("viosvrcmd -m " + string6 + " -p " + string15 + " -c &quot;lsdev -field name physLoc description -fmt ':'&quot;"));
                        for (String string23 : string22.split("\n")) {
                            String[] stringArray3;
                            Object object11;
                            String[] stringArray4 = string23.split(":");
                            if (!stringArray4[0].startsWith("en") && !stringArray4[0].startsWith("fcs") && !stringArray4[0].startsWith("fscsi") && !stringArray4[0].startsWith("iscsi")) continue;
                            String string24 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("viosvrcmd -m " + string6 + " -p " + string15 + " -c &quot;lsdev -dev " + stringArray4[0] + " -attr&quot;"));
                            object10 = new StringBuffer();
                            for (String string25 : string24.split("\n")) {
                                if (string25.contains("attribute") || string25.isEmpty()) continue;
                                String[] stringArray5 = string25.split("\\s+");
                                object10.append(",");
                                object10.append(stringArray5[0]);
                                object10.append("=");
                                object10.append(stringArray5[1]);
                            }
                            if (stringArray4[0].startsWith("ent")) {
                                printWriter.println("DEVICE_ENT," + string6 + "," + string15 + ":DeviceName=" + stringArray4[0] + ",DeviceType=" + stringArray4[2] + ",PhysLoc=" + stringArray4[1] + object10);
                                continue;
                            }
                            if (stringArray4[0].startsWith("en")) {
                                printWriter.println("DEVICE_EN," + string6 + "," + string15 + ":DeviceName=" + stringArray4[0] + ",DeviceType=" + stringArray4[2] + ",PhysLoc=" + stringArray4[1] + object10);
                                continue;
                            }
                            if (stringArray4[0].startsWith("fcs")) {
                                printWriter.println("DEVICE_FCS," + string6 + "," + string15 + ":DeviceName=" + stringArray4[0] + ",DeviceType=" + stringArray4[2] + ",PhysLoc=" + stringArray4[1] + object10);
                                continue;
                            }
                            if (stringArray4[0].startsWith("fscsi")) {
                                printWriter.println("DEVICE_FSCSI," + string6 + "," + string15 + ":DeviceName=" + stringArray4[0] + ",DeviceType=" + stringArray4[2] + ",PhysLoc=" + stringArray4[1] + object10);
                                object11 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("viosvrcmd -m " + string6 + " -p " + string15 + " -c &quot;lsdev -dev " + stringArray4[0] + " -child&quot;"));
                                printWriter.print("DEVICE_FSCSICHILD," + string6 + "," + string15 + ":DeviceName=" + stringArray4[0] + ",DeviceType=FSCSICHILD,PhysLoc=" + stringArray4[1]);
                                for (String string26 : ((String)object11).split("\n")) {
                                    if (string26.startsWith("name ") || string26.isEmpty()) continue;
                                    stringArray3 = string26.split("\\s+");
                                    printWriter.print(",");
                                    printWriter.print(stringArray3[0]);
                                    printWriter.print(":");
                                    printWriter.print(stringArray3[1]);
                                }
                                printWriter.println();
                                continue;
                            }
                            if (!stringArray4[0].startsWith("iscsi")) continue;
                            printWriter.println("DEVICE_ISCSI," + string6 + "," + string15 + ":DeviceName=" + stringArray4[0] + ",DeviceType=" + stringArray4[2] + ",PhysLoc=" + stringArray4[1] + object10);
                            object11 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("viosvrcmd -m " + string6 + " -p " + string15 + " -c &quot;lsiscsi -F name,port,address,target_name&quot; --admin"));
                            if (((String)object11).contains("HSCL350B")) continue;
                            for (String string27 : ((String)object11).split("\n")) {
                                stringArray3 = string27.split(",");
                                if (stringArray3.length == 4) {
                                    printWriter.println("ELEMENT_ISCSI," + string6 + "," + string15 + ":name=" + stringArray3[0] + ",port=" + stringArray3[1] + ",address=" + stringArray3[2] + ",target_name=" + stringArray3[3]);
                                    continue;
                                }
                                System.err.println("Could not parse lsiscsi: " + string27);
                            }
                        }
                        String string28 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("viosvrcmd -m " + string6 + " -p " + string15 + " -c &quot;lspath -field name parent status connection -fmt =&quot;"));
                        Object object12 = string28.split("\n");
                        int n8 = ((String[])object12).length;
                        boolean bl4 = false;
                        while (var32_95 < n8) {
                            String string29 = object12[var32_95];
                            String[] stringArray6 = string29.split("=");
                            if (stringArray6.length == 4) {
                                printWriter.println("LSPATH," + string6 + "," + string15 + ":name=" + stringArray6[0] + ",parent=" + stringArray6[1] + ",status=" + stringArray6[2] + ",connection=" + stringArray6[3]);
                            } else {
                                System.err.println("Could not parse lspath: " + string29);
                                printWriter.println("WARNING," + string6 + ":Could not parse lspath: " + string29);
                            }
                            ++var32_95;
                        }
                        object12 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("viosvrcmd -m " + string6 + " -p " + string15 + " -c &quot;lsmap -all -npiv -field name physloc clntid fc fcphysloc vfcclient vfcclientdrc -fmt ,&quot;"));
                        Object object13 = ((String)object12).split("\n");
                        int n9 = ((String[])object13).length;
                        boolean bl5 = false;
                        while (var33_102 < n9) {
                            String string30 = object13[var33_102];
                            object10 = string30.split(",");
                            if (((String[])object10).length == 6) {
                                object10 = (string30 + " ").split(",");
                            }
                            if (((String[])object10).length == 7) {
                                printWriter.println("LSMAP_NPIV," + string6 + "," + string15 + ":name=" + object10[0] + ",physloc=" + object10[1] + ",clntid=" + object10[2] + ",fc=" + object10[3] + ",fcphysloc=" + object10[4] + ",vfcclient=" + object10[5] + ",vfcclientdrc=" + object10[6]);
                            } else {
                                System.err.println("Could not parse lsmap: " + string30);
                                printWriter.println("WARNING," + string6 + ":Could not parse lsmap: " + string30);
                            }
                            ++var33_102;
                        }
                        object13 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("viosvrcmd -m " + string6 + " -p " + string15 + " -c &quot;lsmap -all -field svsa physloc clientid vtd status lun backing bdphysloc mirrored -fmt ,&quot;"));
                        String[] stringArray7 = ((String)object13).split("\n");
                        int n10 = stringArray7.length;
                        boolean bl6 = false;
                        while (var34_103 < n10) {
                            object10 = stringArray7[var34_103];
                            printWriter.println("LSMAP_SCSI," + string6 + "," + string15 + ":" + (String)object10);
                            ++var34_103;
                        }
                        continue;
                    }
                    printWriter.println("WARNING," + string6 + ":VIOS was not active at capture time: " + string15);
                }
                Random random = new Random();
                int n11 = 1000 + random.nextInt(8999);
                object3 = "" + n11;
                messageDigest.update(((String)object3).getBytes("UTF-8"));
                treeSet = (TreeSet<String>)messageDigest.digest();
                printWriter.println("SIGNATURE," + string6 + ":" + (String)object3 + Base64.getEncoder().encodeToString((byte[])treeSet));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace(System.err);
            System.exit(-1);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(-1);
        }
        finally {
            if (hMCRESTConnection != null && hMCRESTConnection.loggedOn()) {
                try {
                    hMCRESTConnection.logoff();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private boolean doLparCommon(PrintWriter printWriter, String string, String string2, String string3, String string4, String string5) {
        Pattern pattern;
        Matcher matcher;
        String string6 = this.extract(string4, "name");
        if (this.lparList != null && !this.lparList.isEmpty() && !this.lparList.contains(string6)) {
            return false;
        }
        String string7 = this.extract(string4, "curr_profile");
        String string8 = this.extract(string4, "default_profile");
        printWriter.println(string5 + "," + string + "," + string6 + ":" + string4);
        if (string7.isEmpty() || string7.equals("$curr_profile")) {
            string7 = string8;
        }
        if ((matcher = (pattern = Pattern.compile("(?m)^name=" + string7 + ",lpar_name=" + string6 + ",.+$")).matcher(string3)).find()) {
            String string9 = matcher.group();
            printWriter.println("PROFILE," + string + "," + string6 + ":" + string9);
        } else {
            System.err.println("WARNING: Profile " + string7 + " Not found for Lpar " + string6);
            printWriter.println("WARNING," + string + ":Profile " + string7 + " Not found for Lpar " + string6);
        }
        int n = 0;
        Pattern pattern2 = Pattern.compile("(?m)^.*,lpar_name=" + string6 + ",.+$");
        matcher = pattern2.matcher(string2);
        while (matcher.find()) {
            String string10 = matcher.group();
            String string11 = this.extract(string10, "drc_name");
            String string12 = this.extract(string10, "description");
            if (n == 0) {
                printWriter.print("IOSLOTS," + string + "," + string6 + ":io_adapter" + n + "=" + string11 + "," + string12.replace(" ", "_"));
            } else {
                printWriter.print(",io_adapter" + n + "=" + string11 + "," + string12.replace(" ", "_"));
            }
            ++n;
        }
        if (n > 0) {
            printWriter.println();
        }
        return true;
    }

    public void createVirtualIO(HMCRESTConnection hMCRESTConnection, PrintWriter printWriter, String string, String string2) throws Exception {
        String string3;
        String string4;
        String string5 = " --level lpar";
        switch (string2) {
            case "fc": {
                string4 = "VIRTUALFC";
                break;
            }
            case "scsi": {
                string4 = "VIRTUALSCSI";
                break;
            }
            case "vnic": {
                string4 = "VIRTUALVNIC";
                break;
            }
            case "vnicbkdev": {
                string4 = "VIRTUALVNICBKDEV";
                string5 = "";
                break;
            }
            default: {
                string4 = "VIRTUALIO";
            }
        }
        boolean bl = false;
        do {
            if (this.extended && !bl) {
                string3 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lshwres -r virtualio --rsubtype " + string2 + string5 + " -F --header -m " + string));
                string3 = this.convertCSVToNameValue(string3);
            } else {
                string3 = hMCRESTConnection.getJobResults(hMCRESTConnection.cliRunner("lshwres -r virtualio --rsubtype " + string2 + string5 + " -m " + string));
            }
            if (!string3.isEmpty() && !string3.equalsIgnoreCase("No results were found.")) continue;
            System.out.println(string3);
            if (bl) {
                return;
            }
            bl = true;
        } while (bl);
        for (String string6 : string3.split("\n")) {
            String string7 = this.extract(string6, "lpar_name");
            printWriter.println(string4 + "," + string + "," + string7 + ":DeviceType=" + string2.toUpperCase() + "," + string6.replace("\"", ""));
        }
    }

    private String extractGroup(String string, String string2, int n) {
        Matcher matcher = Pattern.compile(string).matcher(string2);
        if (matcher.find()) {
            return matcher.group(n);
        }
        return null;
    }

    public String extract(String string, String string2) {
        return Utilities.extract(string, string2);
    }

    public String convertCSVToNameValue(String string) {
        if (string.matches("No results were found.")) {
            return "";
        }
        String[] stringArray = string.split("\n");
        String[] stringArray2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : stringArray) {
            int n;
            if (stringArray2 == null) {
                stringArray2 = string2.split(",");
                for (int i = 0; i < stringArray2.length; ++i) {
                }
                continue;
            }
            String[] stringArray3 = new String[stringArray2.length];
            Matcher matcher = csvpattern.matcher(string2);
            for (n = 0; n < stringArray2.length; ++n) {
                if (matcher.find()) {
                    stringArray3[n] = matcher.group(1);
                    continue;
                }
                System.err.println("WARNING: problem parsing field #" + n + "(" + stringArray2[n] + ") for input: " + string2);
                stringArray3[n] = "";
            }
            n = 0;
            for (int i = 0; i < stringArray3.length; ++i) {
                if (n != 0) {
                    stringBuffer.append(",");
                }
                n = 1;
                stringBuffer.append(stringArray2[i]);
                stringBuffer.append("=");
                stringBuffer.append(stringArray3[i]);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

