/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sls.powercapture;

import com.ibm.sls.powercapture.Utilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class HMCRESTConnection {
    protected Document systemXML = null;
    protected String APIkey = null;
    protected String hmc = null;
    protected String filepath = null;
    protected boolean recordXml = false;
    NodeList systems = null;
    boolean multiple = false;
    private Document HMCXml;
    private String HMCUid = null;
    public File debugPath = null;
    private boolean strict = false;

    public HMCRESTConnection(boolean bl) {
        this.strict = bl;
        TrustManager[] trustManagerArray = new TrustManager[]{new X509ExtendedTrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
            }
        }};
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){
            HostnameVerifier orighv = HttpsURLConnection.getDefaultHostnameVerifier();

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                if (this.orighv != null && this.orighv.verify(string, sSLSession)) {
                    return true;
                }
                System.err.println("Security Warning: URL Host: " + string + " vs. " + sSLSession.getPeerHost());
                return true;
            }
        };
        if (!bl) {
            try {
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(null, trustManagerArray, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            }
            catch (GeneralSecurityException generalSecurityException) {
                generalSecurityException.printStackTrace();
            }
        }
    }

    public int getSystemsCount() {
        if (this.systems != null) {
            return this.systems.getLength();
        }
        return 0;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    protected void downloadSystemsXML(String string) throws Exception {
        if (!this.loggedOn()) {
            throw new RuntimeException("Not logged on");
        }
        if (string != null) {
            this.systemXML = this.parseXMLDocument("https://" + this.hmc + ":12443/rest/api/uom/ManagedSystem/search/(SystemName==" + string + ")");
        } else {
            this.systemXML = this.parseXMLDocument("https://" + this.hmc + ":12443/rest/api/uom/ManagedSystem");
            this.multiple = true;
        }
        if (this.debugPath != null) {
            Utilities.writeXMLFile(this.systemXML, this.debugPath, "system.xml");
        }
        this.initializeSystemsNodeList();
    }

    protected Document getHMCXml() throws Exception {
        if (this.HMCXml != null) {
            return this.HMCXml;
        }
        if (this.filepath != null) {
            this.HMCXml = Utilities.parseXMLFile(this.filepath + "hmc.xml");
        } else {
            if (!this.loggedOn()) {
                throw new RuntimeException("Not logged on");
            }
            this.HMCXml = this.parseXMLDocument("https://" + this.hmc + ":12443/rest/api/uom/ManagementConsole");
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        this.HMCUid = (String)xPath.compile("/feed/entry/id").evaluate(this.HMCXml, XPathConstants.STRING);
        if (this.debugPath != null) {
            Utilities.writeXMLFile(this.HMCXml, this.debugPath, "hmc.xml");
        }
        return this.HMCXml;
    }

    private void initializeSystemsNodeList() throws XPathExpressionException {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            this.systems = (NodeList)xPath.compile("//*[local-name()='ManagedSystem']").evaluate(this.systemXML, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw xPathExpressionException;
        }
        catch (DOMException dOMException) {
            throw dOMException;
        }
    }

    protected void readSystemsXMLFromFile(String string) throws Exception {
        this.filepath = string;
        this.systemXML = Utilities.parseXMLFile(string + "system.xml");
        this.initializeSystemsNodeList();
    }

    protected boolean loggedOn() {
        return this.APIkey != null || this.filepath != null;
    }

    protected int logoff() throws IOException {
        if (!this.loggedOn()) {
            return 0;
        }
        if (this.filepath != null) {
            return 0;
        }
        System.out.println("Logging off");
        URL uRL = new URL("https://" + this.hmc + ":12443/rest/api/web/Logon");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestProperty("X-API-Session", this.APIkey);
        httpURLConnection.setRequestMethod("DELETE");
        httpURLConnection.setConnectTimeout(20000);
        httpURLConnection.setReadTimeout(20000);
        return httpURLConnection.getResponseCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean logon(String string, String string2, String string3) throws Exception {
        boolean bl;
        this.hmc = string;
        if (this.filepath != null) {
            return true;
        }
        String string4 = String.join((CharSequence)System.getProperty("line.separator"), "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "<LogonRequest xmlns=\"http://www.ibm.com/xmlns/systems/power/firmware/web/mc/2012_10/\" schemaVersion=\"V1_0\">", "<UserID>" + string2 + "</UserID>", "<Password>" + string3 + "</Password>", "</LogonRequest>");
        InputStream inputStream = null;
        try {
            Object object;
            URL uRL = new URL("https://" + string + ":12443/rest/api/web/Logon");
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setConnectTimeout(20000);
            httpsURLConnection.setReadTimeout(20000);
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setUseCaches(false);
            httpsURLConnection.setRequestMethod("PUT");
            httpsURLConnection.setRequestProperty("Accept", "application/vnd.ibm.powervm.web+xml; type=LogonResponse");
            httpsURLConnection.setRequestProperty("Content-Type", "application/vnd.ibm.powervm.web+xml; type=LogonRequest");
            OutputStream outputStream = null;
            try {
                outputStream = httpsURLConnection.getOutputStream();
                object = string4.getBytes("UTF-8");
                outputStream.write((byte[])object);
                outputStream.flush();
            }
            catch (SSLHandshakeException sSLHandshakeException) {
                if (this.strict) {
                    System.err.println("Hint: try without strict mode");
                    throw sSLHandshakeException;
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (httpsURLConnection.getResponseCode() == 401) {
                boolean bl2 = false;
                return bl2;
            }
            inputStream = httpsURLConnection.getInputStream();
            object = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            XPath xPath = XPathFactory.newInstance().newXPath();
            this.APIkey = (String)xPath.compile("/LogonResponse/X-API-Session").evaluate(document, XPathConstants.STRING);
            bl = true;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String cliRunner(String string) throws Exception {
        if (!this.loggedOn()) {
            throw new RuntimeException("Not logged on");
        }
        if (this.HMCUid == null) {
            this.getHMCXml();
        }
        System.out.println("Command: " + string);
        String string2 = URLEncoder.encode(string.replace("&quot;", "\""), "UTF-8");
        if (this.filepath != null) {
            return "CMD:" + string2;
        }
        if (this.debugPath != null && new File(this.debugPath, string2).exists()) {
            return "CMD:" + string2;
        }
        String string3 = String.join((CharSequence)System.getProperty("line.separator"), "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "<JobRequest:JobRequest", " xmlns:JobRequest=\"http://www.ibm.com/xmlns/systems/power/firmware/web/mc/2012_10/\"", " xmlns=\"http://www.ibm.com/xmlns/systems/power/firmware/web/mc/2012_10/\"", " xmlns:ns2=\"http://www.w3.org/XML/1998/namespace/k2\" schemaVersion=\"V1_0\">", "    <Metadata>", "        <Atom/>", "    </Metadata>", "    <RequestedOperation kxe=\"false\" kb=\"CUR\" schemaVersion=\"V1_0\">", "        <Metadata>", "            <Atom/>", "        </Metadata>", "        <OperationName kxe=\"false\" kb=\"ROR\">CLIRunner</OperationName>", "        <GroupName kxe=\"false\" kb=\"ROR\">ManagementConsole</GroupName>", "    </RequestedOperation>", "    <JobParameters kxe=\"false\" kb=\"CUR\" schemaVersion=\"V1_0\">", "        <Metadata>", "            <Atom/>", "        </Metadata>", "      <JobParameter schemaVersion=\"V1_0\">", "            <Metadata>", "                <Atom/>", "            </Metadata>", "            <ParameterName kxe=\"false\" kb=\"ROR\">cmd</ParameterName>", "            <ParameterValue kxe=\"false\" kb=\"CUR\">" + string + "</ParameterValue>", "        </JobParameter>", "      <JobParameter schemaVersion=\"V1_0\">", "            <Metadata>", "                <Atom/>", "            </Metadata>", "            <ParameterName kxe=\"false\" kb=\"ROR\">acknowledgeThisAPIMayGoAwayInTheFuture</ParameterName>", "            <ParameterValue kxe=\"false\" kb=\"CUR\">true</ParameterValue>", "        </JobParameter>", "    </JobParameters>", "</JobRequest:JobRequest>");
        InputStream inputStream = null;
        try {
            String string4;
            Object object;
            URL uRL = new URL("https://" + this.hmc + ":12443/rest/api/uom/ManagementConsole/" + this.HMCUid + "/do/CLIRunner");
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setConnectTimeout(20000);
            httpsURLConnection.setReadTimeout(20000);
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setUseCaches(false);
            httpsURLConnection.setRequestMethod("PUT");
            httpsURLConnection.setRequestProperty("X-API-Session", this.APIkey);
            httpsURLConnection.setRequestProperty("Accept", "*/*");
            httpsURLConnection.setRequestProperty("Content-Type", "application/vnd.ibm.powervm.web+xml; type=JobRequest");
            OutputStream outputStream = null;
            try {
                outputStream = httpsURLConnection.getOutputStream();
                object = string3.getBytes("UTF-8");
                outputStream.write((byte[])object);
                outputStream.flush();
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (httpsURLConnection.getResponseCode() != 200) {
                throw new RuntimeException("Bad Response code for CLIRunner = " + httpsURLConnection.getResponseCode());
            }
            inputStream = httpsURLConnection.getInputStream();
            object = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String string5 = string4 = (String)xPath.compile("//JobResponse/JobID/text()").evaluate(document, XPathConstants.STRING);
            return string5;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getJobResults(String string) throws Exception {
        long l;
        if (!this.loggedOn()) {
            throw new RuntimeException("Not logged on");
        }
        if (string.startsWith("CMD:")) {
            String string2 = null;
            if (this.filepath != null) {
                string2 = this.filepath;
            } else if (this.debugPath != null) {
                string2 = this.debugPath.getCanonicalPath() + File.separator;
            }
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            StringBuffer stringBuffer = new StringBuffer();
            try {
                inputStreamReader = new FileReader(string2 + string.substring(4));
                bufferedReader = new BufferedReader(inputStreamReader);
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    stringBuffer.append(string3);
                    string3 = bufferedReader.readLine();
                    if (string3 == null) continue;
                    stringBuffer.append("\n");
                }
                String string4 = stringBuffer.toString();
                return string4;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        Document document = null;
        String string5 = "NOTFOUND";
        XPath xPath = XPathFactory.newInstance().newXPath();
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        int n = 100;
        do {
            Thread.sleep(n);
            n = 1000;
            l = System.currentTimeMillis();
            if (l - l2 > 5000L) {
                n = 5000;
            }
            document = this.parseXMLDocument("https://" + this.hmc + ":12443/rest/api/uom/jobs/" + string);
            string5 = (String)xPath.compile("//JobResponse/Status/text()").evaluate(document, XPathConstants.STRING);
            if (string5.equals("RUNNING")) {
                if (l3 == 0L) {
                    System.out.print("\nRUNNING");
                }
                if (l <= l3 + 5000L) continue;
                System.out.print(".");
                l3 = l;
                continue;
            }
            System.out.print("\nStatus is: " + string5);
        } while (!string5.startsWith("COMPLETED") && !string5.startsWith("FAILED") && !string5.startsWith("CANCELED"));
        l = System.currentTimeMillis();
        System.out.println("(" + (l - l2) / 1000L + ")");
        String string6 = (String)xPath.compile("//JobResponse/Results/JobParameter/ParameterName[text()=\"result\"]/../ParameterValue/text()").evaluate(document, XPathConstants.STRING);
        String string7 = (String)xPath.compile("//JobResponse/JobRequestInstance/JobParameters/JobParameter/ParameterName[text()=\"cmd\"]/../ParameterValue/text()").evaluate(document, XPathConstants.STRING);
        this.parseXMLDocument("https://" + this.hmc + ":12443/rest/api/uom/jobs/" + string, "DELETE");
        if (!string5.equals("COMPLETED_OK")) {
            System.out.println("--- Detail results for status " + string5);
            System.out.println(string6);
            System.out.println("--- End");
        }
        if (this.debugPath != null && !string.startsWith("CMD:")) {
            String string8 = URLEncoder.encode(string7, "UTF-8");
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new FileWriter(new File(this.debugPath, string8));
                outputStreamWriter.write(string6);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return string6;
    }

    protected Document parseXMLDocument(String string) throws Exception {
        return this.parseXMLDocument(string, "GET");
    }

    protected Document parseXMLDocument(String string, String string2) throws Exception {
        Document document;
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("X-API-Session", this.APIkey);
            if (!string2.equals("DELETE")) {
                httpURLConnection.setRequestProperty("Accept", "application/atom+xml; charset=UTF-8");
            }
            httpURLConnection.setConnectTimeout(60000);
            httpURLConnection.setReadTimeout(60000);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod(string2);
            if (httpURLConnection.getResponseCode() == 204 && string2.equals("DELETE")) {
                Document document2 = null;
                return document2;
            }
            if (httpURLConnection.getResponseCode() == 204) {
                throw new IllegalArgumentException("Nothing found for " + string);
            }
            inputStream = httpURLConnection.getInputStream();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return document;
    }
}

