/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sls.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class IBMiLabsInstaller
implements Runnable {
    private boolean installed = false;
    private boolean debugmode = false;
    private PrintWriter installlog = null;
    private StringWriter logsw = null;

    private void log(Object object) {
        if (this.installlog == null) {
            this.logsw = new StringWriter();
            this.installlog = new PrintWriter(this.logsw);
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            throwable.printStackTrace(this.installlog);
            if (this.debugmode) {
                throwable.printStackTrace();
            }
        }
        this.installlog.println("" + object);
        if (this.debugmode) {
            System.err.println("" + object);
        }
    }

    private void debug(Object object) {
        if (this.debugmode) {
            this.log(object);
        }
    }

    public String getLog() {
        return this.logsw == null ? "" : this.logsw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        boolean bl = false;
        InputStream inputStream = this.getClass().getResourceAsStream("/installer.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.debug(properties);
        String string = System.getProperty("java.class.path", "");
        String string2 = System.getProperty("os.name");
        this.debug("Classpath is:" + string);
        URL uRL = null;
        CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            uRL = codeSource.getLocation();
        }
        if (uRL != null && "rsrc".equals(uRL.getProtocol())) {
            object = new File(string);
            try {
                if (!((File)object).isFile() || !((File)object).exists()) {
                    this.log("classpath is not a single jar file:" + string);
                    return;
                }
                uRL = ((File)object).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                this.debug(malformedURLException);
                this.log("Cannot determine jar file location from classpath:" + string);
                return;
            }
        } else if (uRL == null || !"file".equals(uRL.getProtocol()) || !uRL.getFile().endsWith(".jar")) {
            this.debug("Installer bypassed.  Not loaded from jar file");
            return;
        }
        this.debug("os.name is " + string2);
        if (string2.equalsIgnoreCase("OS/400")) {
            Object object2;
            Object object3;
            Object object4;
            File file;
            File file2;
            object = properties.getProperty("target.library");
            String string3 = properties.getProperty("target.savf.obj");
            String string4 = properties.getProperty("target.directory");
            String string5 = properties.getProperty("source.savf");
            String string6 = properties.getProperty("build.version");
            String string7 = properties.getProperty("target.properties", "installer.properties");
            this.debug(object);
            this.debug(string4);
            this.debug(string5);
            this.debug(string6);
            File file3 = new File("/QSYS.LIB/" + (String)object + ".LIB");
            if (!file3.exists()) {
                this.log("Creating library");
                this.systemCommand("CRTLIB LIB(" + (String)object + ") TEXT('IBM Powerdraw')");
                bl = true;
            }
            if (!(file2 = new File(string4)).exists()) {
                this.log("Creating directory");
                file2.mkdir();
                bl = true;
            }
            if (!bl) {
                this.log("Looking up existing version");
                file = new File(file2, string7);
                if (!file.exists()) {
                    this.log("No current properties installed");
                    bl = true;
                } else {
                    object4 = null;
                    try {
                        object4 = new FileInputStream(file);
                        object3 = new Properties();
                        ((Properties)object3).load((InputStream)object4);
                        object2 = ((Properties)object3).getProperty("build.version", "NONE");
                        this.log("Found current install version: " + (String)object2);
                        if (!((String)object2).equals(string6)) {
                            this.log("Found version " + (String)object2 + "...  Installing.");
                            bl = true;
                        }
                    }
                    catch (IOException iOException) {
                        bl = true;
                    }
                    finally {
                        if (object4 != null) {
                            try {
                                ((FileInputStream)object4).close();
                            }
                            catch (IOException iOException) {
                                this.debug(iOException);
                            }
                        }
                    }
                }
            }
            if (!string.matches(".*\\.jar$")) {
                this.log("Installer bypassed for development execution");
                bl = false;
                return;
            }
            if (bl) {
                this.log("Installing new version");
                this.log("Creating Save file");
                this.systemCommand("CRTSAVF FILE(" + (String)object + "/" + string3 + ") TEXT('PowerCapture')");
                try {
                    this.extractFileFromJar(string5, new File(file3, string3 + ".FILE"));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.log(fileNotFoundException);
                }
                this.systemCommand("RSTLIB SAVLIB(" + (String)object + ") DEV(*SAVF) SAVF(" + (String)object + "/" + string3 + ") MBROPT(*ALL) ALWOBJDIF(*ALL) RSTLIB(" + (String)object + ")");
                this.systemCommand("DLTF FILE(" + (String)object + "/" + string3 + ")");
                try {
                    this.extractFileFromJar("/installer.properties", new File(file2, string7));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.log(fileNotFoundException);
                }
                file = new File(file2, string3 + ".jar");
                object4 = uRL;
                try {
                    object4 = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    this.debug(malformedURLException);
                }
                if (uRL == null || ((URL)object4).equals(uRL)) {
                    this.log("Skipping jar copy because source==target or source is null");
                } else {
                    object3 = null;
                    object2 = null;
                    try {
                        object3 = uRL.openStream();
                        object2 = new FileOutputStream(file);
                        int n = this.copy((InputStream)object3, (OutputStream)object2);
                        this.log(n + " bytes copied to " + string3 + ".jar");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.log(fileNotFoundException);
                    }
                    catch (IOException iOException) {
                        this.log(iOException);
                    }
                    finally {
                        if (object3 != null) {
                            try {
                                ((InputStream)object3).close();
                            }
                            catch (IOException iOException) {
                                this.debug(iOException);
                            }
                        }
                        if (object2 != null) {
                            try {
                                ((OutputStream)object2).close();
                            }
                            catch (IOException iOException) {
                                this.debug(iOException);
                            }
                        }
                    }
                }
            }
        }
        if (bl) {
            this.installed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFileFromJar(String string, File file) throws FileNotFoundException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException("source stream file: " + string + " not found");
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            int n = this.copy(inputStream, fileOutputStream);
            this.log(n + " bytes copied to " + file.getName());
        }
        catch (IOException iOException) {
            this.log(iOException);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                this.debug(iOException);
            }
        }
    }

    private void systemCommand(String string) {
        this.log(string);
        ProcessBuilder processBuilder = new ProcessBuilder("system", string);
        processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        processBuilder.redirectErrorStream(true);
        try {
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "Cp1047");
            HashMap<Character, Character> hashMap = new HashMap<Character, Character>();
            hashMap.put(Character.valueOf('\u0085'), Character.valueOf('\n'));
            this.copy(inputStreamReader, this.installlog, hashMap);
            this.installlog.flush();
            process.waitFor();
            this.installlog.println();
        }
        catch (IOException iOException) {
            this.log(iOException);
        }
        catch (InterruptedException interruptedException) {
            this.log(interruptedException);
        }
    }

    public int copy(Reader reader, Writer writer, Map<Character, Character> map) throws IOException {
        char[] cArray = new char[1024];
        int n = 0;
        int n2 = 0;
        while (-1 != (n2 = reader.read(cArray))) {
            if (map != null) {
                for (int i = 0; i < n2; ++i) {
                    Character c = map.get(Character.valueOf(cArray[i]));
                    if (c == null) continue;
                    cArray[i] = c.charValue();
                }
            }
            writer.write(cArray, 0, n2);
            n += n2;
        }
        return n;
    }

    public int copy(Reader reader, Writer writer) throws IOException {
        return this.copy(reader, writer, null);
    }

    public int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        int n2 = 0;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            n += n2;
        }
        return n;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public boolean isDebugmode() {
        return this.debugmode;
    }

    public void setDebugmode(boolean bl) {
        this.debugmode = bl;
    }
}

