#!/bin/bash

set -e

python -m pip install twine

if [[ -d 'dist' ]]; then
    rm dist/*
fi

python setup.py sdist --format=gztar

# upload to srom artifactory
twine upload --repository-url https://na.artifactory.swg-devops.com/artifactory/api/pypi/res-srom-pypi-local -u $USERNAME -p $PASSWORD dist/*

# upload to predict's artifactory
twine upload --repository-url https://na.artifactory.swg-devops.com/artifactory/api/pypi/wiotp-pypi-local -u $PRED_USERNAME -p $PRED_PASSWORD dist/*

