# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
import pmlib
from pmlib.time_to_failure import TimeToFailureAssetGroupPipeline


def test():
    asset_group_id='4527'
    newAssetPrefix='NNN'

    assetNum=newAssetPrefix
    device_type= 'VEHICLEINTG'+newAssetPrefix
    
    desired_features = ['var_1', 'var_2', 'var_3', 'var_4', 'var_5']
    device_type_qualified_features = [device_type+':'+col for col in desired_features]

    group = TimeToFailureAssetGroupPipeline(
            asset_group_id=asset_group_id, 
            model_pipeline={
                "features":device_type_qualified_features,
                
                'predictions': ['predicted_time_to_failure', 'predicted_failure_date'],
            })
    df = group.execute()

    print(pmlib.log_df_info(df, head=0))

    # Once all are ready, register the function and create a KPI
    #group.register()
    #group.register(url='git+https://74ed0460a34403877c1893b70476a78a128c0f0a@github.ibm.com/asset-performance/APM-PM-LIB.git@q1-2020')
    # group.unregister()


if __name__ == '__main__':
    test()

