# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
import pmlib


def test():
    asset_group_id='4184'
    device_type = 'LOBControllerSensor20191119'
    desired_features = ['maxsecondarycurrent', 'minsecondarycurrent']
    device_type_qualified_features = [ device_type + ':' + col for col in desired_features]
    group = pmlib.TimeToFailureAssetGroupPipeline(
                asset_group_id=asset_group_id, 
                model_pipeline={
                    'features': device_type_qualified_features,
                    'features_for_training': [':installdate', ':faildate'],
                    'predictions': ['predicted_time_to_failure_loose','prediction_interval_loose'],
                    'failure_mode': 'loose',
                    'failure_code' : 'problemcode',
                    'aggregation_methods':['min'],
                    'aggregate_window_size': 3,
                    'multiclass':True
                })
                # },
                # local_model=False,
                # model_timestamp={'TimeToFailureEstimatorSrom': '1563442140'})
    df = group.execute()

    print(pmlib.log_df_info(df, head=0))

    # Once all are ready, register the function and create a KPI
    group.register(url='git+https://74ed0460a34403877c1893b70476a78a128c0f0a@github.ibm.com/asset-performance/APM-PM-LIB.git@q1-2020')
    # group.unregister()


if __name__ == '__main__':
    test()

