# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
import pmlib


def test():
    #asset_group_id='4206'
    asset_group_id='4203'
    device_type='MulticlassControllerSensor'
    device_id='MulticlassControllerSensor_D1'

    asset_device_mappings={'LOBA20-____-BEDFORD': ['%s:%s' % (device_type, device_id)]}

    desired_features = ['maxsecondarycurrent','avgvoltage' ]
    device_type_qualified_features = [device_type+':'+col for col in desired_features]

    group = pmlib.TimeToFailureAssetGroupPipeline(
                asset_group_id=asset_group_id, 
                model_pipeline={
                    'features':device_type_qualified_features,
                    'features_for_training': [':faildate',':problemcode'],
                    'predictions': ['predicted_time_to_failure'],
                    'failure_mode': 'PUMPS/STOPPED',
                    
                    'aggregation_methods':['min'],
                    'aggregate_window_size': 3,
                   # 'aggregate_type_for_prediction_interval': 'mean',
                    'multiclass':True
                })
                
    df = group.execute()

    print(pmlib.log_df_info(df, head=0))

    # Once all are ready, register the function and create a KPI
    #group.register()
    group.register(url='git+https://74ed0460a34403877c1893b70476a78a128c0f0a@github.ibm.com/asset-performance/APM-PM-LIB.git@feb-2020')
    # group.unregister()


if __name__ == '__main__':
    test()

