# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
import pmlib
from sklearn.cluster import FeatureAgglomeration
from sklearn.cross_decomposition import PLSRegression
from sklearn.decomposition import NMF, PCA, FastICA, KernelPCA, SparsePCA, TruncatedSVD
from sklearn.ensemble import (
    AdaBoostRegressor,
    BaggingRegressor,
    ExtraTreesRegressor,
    GradientBoostingRegressor,
    RandomForestRegressor,
)
from sklearn.exceptions import NotFittedError
from sklearn.feature_selection import SelectKBest, SelectPercentile, VarianceThreshold
from sklearn.gaussian_process import GaussianProcessRegressor
from sklearn.isotonic import IsotonicRegression
from sklearn.kernel_approximation import (
    AdditiveChi2Sampler,
    Nystroem,
    RBFSampler,
    SkewedChi2Sampler,
)
from sklearn.kernel_ridge import KernelRidge
from sklearn.linear_model import (
    BayesianRidge,
    ElasticNet,
    HuberRegressor,
    Lasso,
    LassoLars,
    LinearRegression,
    OrthogonalMatchingPursuit,
    PassiveAggressiveRegressor,
    RANSACRegressor,
    Ridge,
    SGDRegressor,
    TheilSenRegressor,
)
from sklearn.manifold import Isomap, LocallyLinearEmbedding
from sklearn.neighbors import KNeighborsRegressor
from sklearn.neural_network import MLPRegressor
from sklearn.preprocessing import (
    MaxAbsScaler,
    MinMaxScaler,
    Normalizer,
    OneHotEncoder,
    PolynomialFeatures,
    QuantileTransformer,
    RobustScaler,
    StandardScaler,
)
from sklearn.tree import DecisionTreeRegressor
from srom.auto.base_auto import SROMAutoPipeline
from srom.feature_engineering.model_based_feature_generator import (
    ModelbasedFeatureGenerator,
)
from srom.feature_selection.variance_based_feature_selection import (
    LowVarianceFeatureElimination,
)
from srom.pipeline.hyper_params.regression_fine_grid_for_bayesian import (
    PARAM_GRID as bayesian_paramgrid,
)
from srom.pipeline.hyper_params.regression_sample_grid_for_rbfopt import (
    PARAM_GRID as rbopt_paramgrid,
)
from srom.pipeline.srom_param_grid import SROMParamGrid
from srom.regression.data_partition_based_regression import PartitionRegressor
from srom.regression.gaussian_mixture_regressor import GaussianMixtureRegressor

from srom.utils.no_op import NoOp
from xgboost import XGBRegressor
from sklearn.preprocessing import KBinsDiscretizer, PowerTransformer


def test():
    

    
    asset_group_id='4457'
    #working 07/07/2020


    device_type= 'LOBControllerSensor20200701'
    device_id='LOBControllerSensor20200424_D1'
    site_id = 'BEDFORD'


    from pmlib.time_to_failure import TimeToFailureAssetGroupPipeline

    desired_features = ['maxsecondarycurrent', 'minsecondarycurrent']
    #desired_features = ['avgsecondarycurrent', 'durationcurrent', 'resistance']
    device_type_qualified_features = [device_type+':'+col for col in desired_features]


    


    from pmlib.time_to_failure import TimeToFailureAssetGroupPipeline

    desired_features = ['maxsecondarycurrent', 'minsecondarycurrent']
    #desired_features = ['avgsecondarycurrent', 'durationcurrent', 'resistance']
    device_type_qualified_features = [device_type+':'+col for col in desired_features]

    group = pmlib.TimeToFailureAssetGroupPipeline(
                asset_group_id=asset_group_id, 
                model_pipeline={
                    
                    'features':device_type_qualified_features,
                    
                    'predictions': ['predicted_time_to_failure'],
                    'failure_mode': 'PUMPS/STOPPED',
                    
                    'aggregation_methods':['min'],
                    'aggregate_window_size': 3,
                   # 'aggregate_type_for_prediction_interval': 'mean',
                    'smart_regression':True,
                    'override_training_stages': [
                        [
                            ("skiptransformation", NoOp()),
                            ("normalizer", Normalizer()),
                         ],
                        [
                            ('skipscaling', NoOp()), 
                            ('standardscaler', StandardScaler()),
                            ('robustscaler', RobustScaler()), 
                            ('minmaxscaling', MinMaxScaler())
                        ],
                        [
                            # Rule/Density based Anomaly Models
                           
                            ("xgbregressor", XGBRegressor())
                        ]
                    ]
                })
                # },
                # local_model=False,
                # model_timestamp={'TimeToFailureEstimatorSrom': '1563442140'})
    df = group.execute()

    print(pmlib.log_df_info(df, head=0))

    df_predict = group.execute()

    print('********************* predict  ***********************************')

    print(pmlib.log_df_info(df_predict, head=0))

    # Once all are ready, register the function and create a KPI
    #group.register()
    #group.register(url='git+https://74ed0460a34403877c1893b70476a78a128c0f0a@github.ibm.com/asset-performance/APM-PM-LIB.git@feb-2020')
    # group.unregister()


if __name__ == '__main__':
    test()

