# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
import pmlib


def test():
    asset_group_id='4169'

    group = pmlib.TimeToFailureAssetGroupPipeline(
                asset_group_id=asset_group_id, 
                model_pipeline={
                    'features':["LOBControllerSensor20191022:maxsecondarycurrent","LOBControllerSensor20191022:minsecondarycurrent"],
                    'features_for_training': [':installdate', ':faildate'],
                    'predictions': ['predicted_time_to_failure_leaking','prediction_interval_leaking'],
                    'failureMode': 'leaking',
                    'failure_code' : 'problemcode',
                    'aggregation_methods':['min'],
                    'aggregate_window_size': 3,
                    'multiclass':True
                })
                # },
                # local_model=False,
                # model_timestamp={'TimeToFailureEstimatorSrom': '1563442140'})
    df = group.execute()

    print(pmlib.log_df_info(df, head=0))

    # Once all are ready, register the function and create a KPI
    group.register()
    # group.unregister()


if __name__ == '__main__':
    test()

