# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
import pmlib


def test():
    asset_group_id='1002'
    #working 07/07/2020


    device_type= 'MOTOR_ROBOT_TYPE'
    device_id='MOTOR_ROBOT_TYPE_D1'
    site_id = 'BEDFORD'


    from pmlib.time_to_failure import TimeToFailureAssetGroupPipeline

    desired_features = ['load', 'speed']
    #desired_features = ['avgsecondarycurrent', 'durationcurrent', 'resistance']
    device_type_qualified_features = [device_type+':'+col for col in desired_features]

    group = pmlib.TimeToFailureAssetGroupPipeline(
                asset_group_id=asset_group_id, 
                model_pipeline={
                    #'features':["LOBControllerSensor20200415:maxsecondarycurrent","LOBControllerSensor20200415:minsecondarycurrent"],
                    'features': device_type_qualified_features,
                    'predictions': ['predicted_time_to_failure','predicted_failure_date'],
                    'failure_mode': 'PUMPS/STOPPED',
                   
                    'aggregation_methods':['min','max'],
                    'aggregate_window_size': 3,
                   # 'aggregate_type_for_prediction_interval': 'mean',
                    'smart_regression':True
                })
    df = group.execute()

    print(pmlib.log_df_info(df, head=0))

    print('prediction***********************************************')

    df = group.execute()

    # Once all are ready, register the function and create a KPI
    #group.register()
    #group.register(url='git+https://74ed0460a34403877c1893b70476a78a128c0f0a@github.ibm.com/asset-performance/APM-PM-LIB.git@q1-2020')
    # group.unregister()


if __name__ == '__main__':
    test()

