# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import pmlib
from pmlib.failure_prediction import FailurePredictionAssetGroupPipeline

from srom.feature_engineering.model_based_feature_generator import ModelbasedFeatureGenerator
import os
import time
import warnings
import uuid
import numpy as np
from operator import itemgetter
from multiprocessing import cpu_count

from sklearn.discriminant_analysis import (LinearDiscriminantAnalysis,
                                           QuadraticDiscriminantAnalysis)
from sklearn.naive_bayes import (BernoulliNB, GaussianNB, MultinomialNB)
from sklearn.kernel_approximation import RBFSampler, AdditiveChi2Sampler, Nystroem, SkewedChi2Sampler
from sklearn.cluster import KMeans, FeatureAgglomeration

from sklearn.ensemble import (AdaBoostClassifier, BaggingClassifier,
                              ExtraTreesClassifier, GradientBoostingClassifier,
                              RandomForestClassifier)
from sklearn.linear_model import (LogisticRegression, PassiveAggressiveClassifier,
                                  SGDClassifier, RidgeClassifier, Perceptron)
from sklearn.gaussian_process import GaussianProcessClassifier
from sklearn.neighbors import KNeighborsClassifier
from sklearn.tree import DecisionTreeClassifier
from sklearn.neural_network import MLPClassifier
from sklearn.svm import (LinearSVC, NuSVC, SVC)
from xgboost import XGBClassifier
from sklearn.preprocessing import OneHotEncoder, Normalizer
from srom.pipeline.srom_param_grid import SROMParamGrid
from srom.pipeline.srom_pipeline import SROMPipeline
from srom.utils.no_op import NoOp
from srom.feature_engineering.model_based_feature_generator import ModelbasedFeatureGenerator
from sklearn.feature_selection import VarianceThreshold
from srom.feature_selection.variance_based_feature_selection import LowVarianceFeatureElimination
from srom.auto.base_auto import SROMAutoPipeline
from sklearn.manifold import Isomap, LocallyLinearEmbedding, MDS, SpectralEmbedding, TSNE
from sklearn.exceptions import NotFittedError
from sklearn.preprocessing import KBinsDiscretizer, PowerTransformer

from sklearn.feature_selection import SelectKBest, SelectPercentile
from sklearn.preprocessing import MinMaxScaler, MaxAbsScaler, StandardScaler, RobustScaler
from sklearn.decomposition import PCA, FactorAnalysis, FastICA, IncrementalPCA, KernelPCA, NMF, SparsePCA, TruncatedSVD
from sklearn.preprocessing import PolynomialFeatures, QuantileTransformer

from srom.pipeline.hyper_params.classification_fine_grid_for_bayesian import PARAM_GRID as bayesian_paramgrid
from srom.pipeline.hyper_params.classification_sample_grid_for_rbfopt import PARAM_GRID as rbopt_paramgrid


def test():
    
    asset_group_id='4302'

    device_type= 'LOBControllerSensor20200424'
    device_id='LOBControllerSensor20200424_D1'
    site_id = 'BEDFORD'




    feature_transformation_set = [('skiptransformation', NoOp()),('normalizer', Normalizer())]

    scaler_set = [('skipscaling', NoOp()),('standardscaler', StandardScaler()),('minmaxscaler', MinMaxScaler())]

    feature_preprocessing_set = [('skipfeaturepreprocessing', NoOp()),('pca', PCA()), ('fastica', FastICA()), ('kernelpca', KernelPCA()), ('selectkbest', SelectKBest()), ('variancethreshold', VarianceThreshold())]

    estimator_feature_generator = [('skipmodelfeaturegeneration', NoOp()),('multinomialnbfeature', ModelbasedFeatureGenerator(MultinomialNB())),\
                                                          ('decisiontreeclassifierfeature', ModelbasedFeatureGenerator(DecisionTreeClassifier())), ('extratreesclassifierfeature', ModelbasedFeatureGenerator(ExtraTreesClassifier())), \
                                                          ('randomforestclassifierfeature', ModelbasedFeatureGenerator(RandomForestClassifier()))]

    estimator_set = [('multinomialnb', MultinomialNB()), ('decisiontreeclassifier', DecisionTreeClassifier()), ('randomforestclassifier', RandomForestClassifier())]





    

    estimator_set = [

            ('decisiontreeclassifier', DecisionTreeClassifier()),\

            ('extratreesclassifier', ExtraTreesClassifier()),\

            ('randomforestclassifier', RandomForestClassifier())

           

                    ]

    my_stage = [feature_transformation_set,

                       scaler_set,

                       feature_preprocessing_set,

                       estimator_feature_generator,

                       estimator_set]

    print(my_stage)

    asset_device_mappings={'LOBA20-____-BEDFORD': ['%s:%s' % (device_type, device_id)]}

    desired_features = ['maxsecondarycurrent', 'minsecondarycurrent',  'avgvoltage']
    device_type_qualified_features = [device_type+':'+col for col in desired_features]

    desired_features = ['maxsecondarycurrent', 'minsecondarycurrent',  'avgvoltage']
    device_type_qualified_features = [device_type+':'+col for col in desired_features]

    asset_group_id='4302'
    override_failure_prob=FailurePredictionAssetGroupPipeline(
            asset_group_id=asset_group_id, 
            model_pipeline={
                'features': device_type_qualified_features,
                
                "predictions": ["failure_probability", "rca_path"],
                'aggregation_methods': ['max', 'min', 'std'],
                "prediction_window_size": "2d",
                
                'override_training_stages': my_stage,
                
                
                 
                'scoring':'r2',
                'execution_time_per_pipeline':3
                
            })
    df = override_failure_prob.execute()
    #df = group.execute(start_ts='2017-01-01', end_ts='2017-02-01')

    #group.register()

    print(pmlib.log_df_info(df, head=0))


if __name__ == '__main__':
    test()

