# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import pmlib


def test():
    #workin on 04-28-2020
    

    from pmlib.failure_prediction import FailurePredictionAssetGroupPipeline
    asset_group_id='4227'

    device_type= 'LOBControllerSensor20200415'
    device_id='LOBControllerSensor20200415_D1'
    site_id = 'BEDFORD'

    desired_features = ['maxsecondarycurrent','avgvoltage' ]
    device_type_qualified_features = [device_type+':'+col for col in desired_features]

    
    group = FailurePredictionAssetGroupPipeline(
            asset_group_id=asset_group_id,
            model_pipeline={
                'features': device_type_qualified_features,
                
                
                'predictions': ['failure_probability','rca_path'],
                'aggregation_methods': ['min'],
                'prediction_window_size': '7d',
                'multiclass': True,
                'failure_modes': ['PUMPS/STOPPED/MOTRFAIL','PUMPS/BROKEN/PUMPJAM']
            }
        )
    #df = group.execute(start_ts='2017-01-01', end_ts='2017-02-01')
    df = group.execute()
    #group.register(url='git+https://74ed0460a34403877c1893b70476a78a128c0f0a@github.ibm.com/asset-performance/APM-PM-LIB.git@feb-2020')

    print(pmlib.log_df_info(df, head=0))


if __name__ == '__main__':
    test()

