# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import pmlib


def test():
    # 2020/07/01
    asset_group_id='4457'

    device_type= 'LOBControllerSensor20200701'
    device_id='LOBControllerSensor20200701_D1'

    #asset_device_mappings={'LOBA20-____-BEDFORD': ['%s:%s' % (device_type, device_id)]}

    desired_features = ['maxsecondarycurrent','avgvoltage' ]
    device_type_qualified_features = [device_type+':'+col for col in desired_features]

    group = pmlib.FailurePredictionAssetGroupPipeline(
                asset_group_id=asset_group_id,
                model_pipeline={
                    'features': device_type_qualified_features,
                    #'features_for_training': [':faildate'],
                    'predictions': ['failure_probability', 'rca_path'],
                    'aggregation_methods': ['min'],
                    'prediction_window_size': '1d',
                    'multiclass': True,
                    'failure_modes': ['PUMPS/STOPPED','PUMPS/LEAKING']
                }
            )
    #df = group.execute(start_ts='2017-01-01', end_ts='2017-02-01')
    df = group.execute()
    #group.register()

    print(pmlib.log_df_info(df, head=0))


if __name__ == '__main__':
    test()

