# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import pmlib


def test():
    #asset_group_id='4169'
    asset_group_id='4227'

    device_type='LOBControllerSensor20200415'
    device_id='LOBControllerSensor20191022_D1'

    asset_device_mappings={'LOBA20-____-BEDFORD': ['%s:%s' % (device_type, device_id)]}

    desired_features = ['maxsecondarycurrent', 'minsecondarycurrent',  'avgvoltage']
    device_type_qualified_features = [device_type+':'+col for col in desired_features]

    group = pmlib.FailurePredictionAssetGroupPipeline(
                asset_group_id=asset_group_id,
                model_pipeline={
                    'features': device_type_qualified_features,
                    #'features_for_training': [':faildate'],
                    'predictions': ['failure_probability', 'rca_path'],
                    'aggregation_methods': ['max', 'min', 'std'],
                    'prediction_window_size': '5d',
                    'scoring':'recall',
                    "data_quality_advisor": True,
                    "data_quality_sensor_threshold": 0.5,
                    "data_quality_failure_history_threshold": 0.5

                }
            )
    df = group.execute()
    #df = group.execute(start_ts='2017-01-01', end_ts='2017-02-01')

    #group.register()

    print(pmlib.log_df_info(df, head=0))


if __name__ == '__main__':
    test()

