# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.
import pmlib
from pmlib.anomaly_detection import AnomalyDetectionAssetGroupPipeline
from sklearn.ensemble import IsolationForest
from sklearn.covariance import (EmpiricalCovariance, EllipticEnvelope, LedoitWolf, MinCovDet, OAS, ShrunkCovariance)
from sklearn.preprocessing import StandardScaler, RobustScaler, MinMaxScaler
from srom.anomaly_detection.generalized_anomaly_model import GeneralizedAnomalyModel
from srom.utils.no_op import NoOp


def test():
    asset_group_id='4227' 



    group = AnomalyDetectionAssetGroupPipeline(
            asset_group_id=asset_group_id,
            model_pipeline={
                'features': ['LOBControllerSensor20200415:resistance'],
                "features_for_training": [":faildate"],
                "predictions": ["anomaly_score", "anomaly_threshold"],
                'override_training_stages': [
                    [
                        ('skipscaling', NoOp()), 
                        ('standardscaler', StandardScaler()),
                        ('robustscaler', RobustScaler()), 
                        ('minmaxscaling', MinMaxScaler())
                    ],
                    [
                        #('isolationforest', GeneralizedAnomalyModel(base_learner=IsolationForest(), predict_function='decision_function', score_sign=-1)), 
                         ('empiricalcovariance', GeneralizedAnomalyModel(base_learner=EmpiricalCovariance(), fit_function='fit', predict_function='mahalanobis',score_sign=1)), 
                    ]
                ],
                'features_resampled': {
                    'LOBControllerSensor20200415': {
                        '${freqency}': '1T',
                        'resistance': {
                            
                            'mean': None,
                            },
                    },
                },
            })
    df = group.execute()

    print(pmlib.log_df_info(df, head=0))

    # Once all are ready, register the function and create a KPI
    # group.register()
    group.unregister()


if __name__ == '__main__':
    test()

