# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import numpy as np
import pandas as pd
import pytest

import pmlib
from pmlib import api
from pmlib.anomaly_detection import AnomalyDetectionEstimator
from pmlib.transformer import IdentifyPreFailureWindow, TransformNotNaToEvent
from pmlib.util import current_directory


def test(asset_group_id, model_instance_id):
    group = pmlib.AnomalyDetectionAssetGroupPipeline(
                asset_group_id=asset_group_id, 
                model_instance_id=model_instance_id,
            )
    # resp = group.enable(enabled=True, schedule={'every': '5T'})
    resp = group.enable(enabled=False)
    if resp is not None:
        print(resp.text)


if __name__ == '__main__':
    test(asset_group_id='abcd5', model_instance_id='C78B6264-5017-4FF5-9344-0A432CD5C753')

