# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import numpy as np
import pandas as pd
import pytest

import pmlib


def test(asset_group_id, model_instance_id):
    group = pmlib.AnomalyDetectionAssetGroupPipeline(
                asset_group_id=asset_group_id, 
                model_instance_id=model_instance_id,
                summary={
                    '${predictions[0]}': {
                        'hourly': {
                            'max': None,
                        }
                    }
                },
            )
    group.register()


if __name__ == '__main__':
    test(asset_group_id='abcd5', model_instance_id='69A6C45A-3CE9-4B45-9CA4-764AD5BB6616')

