# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import numpy as np
import pandas as pd
import pytest

import pmlib


def test(asset_group_id, iot_type, deviceid_prefix, assetid_prefix, siteid='BEDFORD'):
    group = pmlib.FailurePredictionAssetGroupPipeline(
                asset_group_id=asset_group_id, 
                model_pipeline={
                    'features': ['%s:axlevibration' % iot_type, '%s:axlemomentum' % iot_type],
                    'features_for_training': [':faildate'],
                    'predictions': ['failure_probability', 'rca_path'],
                    'features_resampled': {
                        iot_type: {
                            '${freqency}': '5T',
                            'axlevibration': {
                                'max': None,
                                'mean': None,
                                'min': None,
                            },
                        },
                    },
                    'aggregation_methods': ['mean', 'max', 'min', 'std'],
                    'prediction_window_size': '6d',
                    'rolling_window_size': '1d',
                },
            )
    df = group.execute(start_ts='2019-07-10')

    print(pmlib.log_df_info(df, head=0))

    group.register(url='git+https://74ed0460a34403877c1893b70476a78a128c0f0a@github.ibm.com/asset-performance/APM-PM-LIB.git@master')

    resp = group.enable(enabled=True)
    if resp is not None:
        print(resp.text)


if __name__ == '__main__':
    test(asset_group_id='abcd', iot_type='BrakeSensor1205', assetid_prefix='BRAKE1205', siteid='BEDFORD', deviceid_prefix='Brake1205')

