# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import numpy as np
import pandas as pd
import pytest

import pmlib


def test(asset_group_id, iot_type, deviceid_prefix, assetid_prefix, siteid='BEDFORD'):
    group = pmlib.FailurePredictionAssetGroupPipeline(
                asset_group_id=asset_group_id, 
                model_pipeline={
                    'features': ['NodeMCU:HUMIDITY','NodeMCU:HYDRAULIC_PRESSURE','NodeMCU:RPM','NodeMCU:OUTLET_TEMPERATURE','NodeMCU:TORQUE','NodeMCU:VOLTAGE','NodeMCU:TEMPERATURE','NodeMCU:VIBRATION','NodeMCU:PRESSURE'],
                    'features_for_training': [':faildate'],
                    'predictions': ['failure_probability','rca_path'],
                    'aggregation_methods': ['mean','max','min','median','std','sum','count'],
                    'prediction_window_size': '10d',
                },
                # model_timestamp={
                #     'FailurePredictionRcaEstimator':'1581707514',
                #     'FailurePredictionEstimator':'1581707476',
                # },
                # local_model=False,
            )
    df = group.execute()

    print(pmlib.log_df_info(df, head=0))
    
    # resp = group.register()
    # print(resp)


if __name__ == '__main__':
    test(asset_group_id='1004', iot_type='NodeMCU', assetid_prefix='BRAKE1205', siteid='BEDFORD', deviceid_prefix='Brake1205')

