# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import numpy as np
import pandas as pd
import pytest

import pmlib


def test(asset_group_id, iot_type, deviceid_prefix, assetid_prefix, siteid='BEDFORD'):
    from sklearn.ensemble import IsolationForest
    from sklearn.covariance import (EmpiricalCovariance, EllipticEnvelope, LedoitWolf, MinCovDet, OAS, ShrunkCovariance)
    from sklearn.preprocessing import StandardScaler, RobustScaler, MinMaxScaler
    from srom.anomaly_detection.generalized_anomaly_model import GeneralizedAnomalyModel
    from srom.utils.no_op import NoOp
    from pmlib.anomaly_detection import AnomalyDetectionAssetGroupPipeline
    from sklearn.covariance import (EmpiricalCovariance, EllipticEnvelope, LedoitWolf, MinCovDet, OAS, ShrunkCovariance)
    
       

    from pmlib.anomaly_detection import AnomalyDetectionAssetGroupPipeline
    from sklearn.ensemble import IsolationForest
    from sklearn.covariance import (EmpiricalCovariance, EllipticEnvelope, LedoitWolf, MinCovDet, OAS, ShrunkCovariance)
    from sklearn.preprocessing import StandardScaler, RobustScaler, MinMaxScaler
    from srom.anomaly_detection.generalized_anomaly_model import GeneralizedAnomalyModel
    from srom.utils.no_op import NoOp
    


    group = AnomalyDetectionAssetGroupPipeline(
            asset_group_id='1010',
            model_pipeline={
                'features': ['vacuum:RobotAir'],
                "features_for_training": [":faildate"],
                "predictions": ["anomaly_score", "anomaly_threshold"],
                'override_training_stages': [
                    [
                        ('skipscaling', NoOp()), 
                        ('standardscaler', StandardScaler()),
                        ('robustscaler', RobustScaler()), 
                        ('minmaxscaling', MinMaxScaler())
                    ],
                    [
                        #('isolationforest', GeneralizedAnomalyModel(base_learner=IsolationForest(), predict_function='decision_function', score_sign=-1)), 
                         ('empiricalcovariance', GeneralizedAnomalyModel(base_learner=EmpiricalCovariance(), fit_function='fit', predict_function='mahalanobis',score_sign=1)), 
                    ]
                ],
                'features_resampled': {
                    'vacuum': {
                        '${freqency}': '1T',
                        'RobotAir': {
                            
                            'mean': None,
                            },
                    },
                },
            })
    df = group.execute()

    df2 = group.execute(start_ts='2020-04-12',end_ts='2020-04-14')


    print(pmlib.log_df_info(df, head=0))

    print('scoring here')

    print(pmlib.log_df_info(df2, head=0))


    
    
    # resp = group.register()
    # print(resp)


if __name__ == '__main__':
    test(asset_group_id='1004', iot_type='NodeMCU', assetid_prefix='BRAKE1205', siteid='BEDFORD', deviceid_prefix='Brake1205')

