# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import numpy as np
import pandas as pd
import pytest

import pmlib


def test(asset_group_id, iot_type, siteid='BEDFORD'):
    group = pmlib.WmlScoringAssetGroupPipeline(
            asset_group_id=asset_group_id, 
            model_pipeline={
                'features': [
                    '%s:st1_pressure_high_count' % iot_type,
                    '%s:st1_pressure_low_count' % iot_type,
                    '%s:st1_discharge_moderate_count' % iot_type,
                    '%s:vfd_speed_moderate_count' % iot_type,
                    '%s:st1_pressure_low' % iot_type,
                    '%s:water_inlet_moderate' % iot_type,
                    '%s:st1_discharge_high' % iot_type,
                    '%s:st2_inlet_low_count' % iot_type,
                    '%s:plant_inlet_moderate' % iot_type,
                    '%s:age_of_impeller' % iot_type,
                ],
                'features_for_training': ['%s:days_to_failure' % iot_type],
                'predictions': ['days_to_failure1'],
                'wml_credentials': {
                    'apikey': '_HM8iWeVM_vxa2r7FH5zlHLekEsgMlq3GVkaOxAifZDH',
                    'iam_apikey_description': 'Auto-generated for key 2ceb0df5-8527-49e8-9a3e-1a6cbe82d8ee',
                    'iam_apikey_name': 'Service credentials-1',
                    'iam_role_crn': 'crn:v1:bluemix:public:iam::::serviceRole:Writer',
                    'iam_serviceid_crn': 'crn:v1:bluemix:public:iam-identity::a/e37a202c62f1a8b5bc461d2e5caaf9cb::serviceid:ServiceId-cc583e2a-96d9-4f80-9da8-326ce5848c85', 'instance_id': '7f7953b3-9ab4-47f5-b5cc-d41e0e64b2cd',
                    'url': 'https://us-south.ml.cloud.ibm.com',
                },
                'wml_deployment_uid': '57009fe4-8144-4c88-9f42-85d77253fb9a',
                'result_value_index': [0],
            },
            asset_device_mappings={
                'AIRCMP1-____-%s' % (siteid): ['%s:pmiac001' % iot_type],
                'AIRCMP2-____-%s' % (siteid): ['%s:pmiac002' % iot_type],
            },
        )
    df = group.execute()

    print(pmlib.log_df_info(df, head=0))

    # group.register(url='git+https://74ed0460a34403877c1893b70476a78a128c0f0a@github.ibm.com/asset-performance/APM-PM-LIB.git@beta')

    # resp = group.enable(enabled=True)
    # if resp is not None:
    #     print(resp.text)


if __name__ == '__main__':
    test(asset_group_id='1004', iot_type='PMIAC', siteid='BEDFORD')

