# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import numpy as np
import pandas as pd
import pytest

import pmlib

your_api_key = "dummy"

def test(asset_group_id, iot_type, siteid='BEDFORD'):
    group = pmlib.WmlScoringAssetGroupPipeline(
            asset_group_id=asset_group_id, 
            model_pipeline={
                'features':[
                    '%s:HIGHSECONDARYCURRENT_STD' % iot_type,
                    '%s:AVGSECONDARYCURRENT_STD' % iot_type,
                    '%s:LOWSECONDARYCURRENT_STD' % iot_type,
                    '%s:HIGHDCBUSVOLTAGE_STD' % iot_type,
                    '%s:AVGDCBUSVOLTAGE_STD' % iot_type,
                    '%s:LOWDCBUSVOLTAGE_STD' % iot_type,
                    '%s:LOWDCBUSVOLTAGECLUSTER_0' % iot_type,
                    '%s:LOWDCBUSVOLTAGECLUSTER_1' % iot_type,
                    '%s:AVGDCBUSVOLTAGECLUSTER_0' % iot_type,
                    '%s:AVGDCBUSVOLTAGECLUSTER_1' % iot_type,
                    '%s:HIGHDCBUSVOLTAGECLUSTER_0' % iot_type,
                    '%s:HIGHDCBUSVOLTAGECLUSTER_1' % iot_type,
                    '%s:LOWSECONDARYCURRENTCLUSTER_0' % iot_type,
                    '%s:LOWSECONDARYCURRENTCLUSTER_1' % iot_type,
                    '%s:LOWSECONDARYCURRENTCLUSTER_2' % iot_type,
                    '%s:AVGSECONDARYCURRENTCLUSTER_0' % iot_type,
                    '%s:AVGSECONDARYCURRENTCLUSTER_1' % iot_type,
                    '%s:HIGHSECONDARYCURRENTCLUSTER_0' % iot_type,
                    '%s:HIGHSECONDARYCURRENTCLUSTER_1' % iot_type,
                ],
                'features_for_training': ['%s:DAYSTOFAILURE_BINS' % iot_type],
                'predictions':['DAYSTOFAILURE_BIN'],
                'wml_credentials': {
                    'apikey': your_api_key,
                    'iam_apikey_description': 'Auto generated apikey during resource-key operation for Instance - crn:v1:bluemix:public:pm-20:us-south:a/aa3e74d48710a3ba6b289f1616b7b44f:4f834848-8809-41aa-8a35-5bf6c209ae7d::',
                    'iam_apikey_name': 'auto-generated-apikey-b649da40-367b-4828-841c-c97b57a738a7',
                    'iam_role_crn': 'crn:v1:bluemix:public:iam::::serviceRole:Writer',
                    'iam_serviceid_crn': 'crn:v1:bluemix:public:iam-identity::a/aa3e74d48710a3ba6b289f1616b7b44f::serviceid:ServiceId-f684fbe1-76b9-4e44-8359-a4bd25b6544d',
                    'instance_id': '4f834848-8809-41aa-8a35-5bf6c209ae7d',
                    'url': 'https://us-south.ml.cloud.ibm.com',
                },
                'wml_deployment_uid': 'f6f4dfeb-c783-47dc-8655-67370d2f0f57 abc',            
                'result_value_index': [0],
            },
            asset_device_mappings={
                'WRA01-____-%s' % siteid: ['%s:pmiwg01' % iot_type],
            },
        )
    df = group.execute(start_ts='2020-02-18 04:02:58', end_ts='2020-02-18 04:03:00')

    print(pmlib.log_df_info(df, head=0))

    # group.register(url='git+https://74ed0460a34403877c1893b70476a78a128c0f0a@github.ibm.com/asset-performance/APM-PM-LIB.git@beta')

    # resp = group.enable(enabled=True)
    # if resp is not None:
    #     print(resp.text)


if __name__ == '__main__':
    test(asset_group_id='1005', iot_type='PMIWGR', siteid='BEDFORD')

