# Licensed Materials - Property of IBM
# 5737-M66, 5900-AAA, 5900-AMG
# (C) Copyright IBM Corp. 2019, 2025 All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication, or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

import pandas as pd

import pmlib
from pmlib import api
from pmlib.util import current_directory


def print_resp(resp, msg=''):
    '''Quick method for printing out response content.
    '''
    print(str(resp))
    if resp is not None:
        print(resp.text)
    else:
        raise RuntimeError(msg)


def test(iot_type, deviceid_prefix, assetid_prefix, siteid='BEDFORD', use_wiotp=False):
    assetid_prefix = assetid_prefix.upper()

    pmlib.setup_logging()
    api.init_environ()

    current_directory = pmlib.util.current_directory(__file__)
    print(current_directory)

    df= pd.read_csv('%s/trainbrake_mappings.csv' % current_directory)
    df['asset'] = df['asset'].str.replace('TRAINBRAKE', assetid_prefix)
    df['site'] = siteid
    df['devicetype'] = iot_type
    df['deviceid'] = df['deviceid'].str.replace('TrainBrake', deviceid_prefix)
    print(df.head())

    db = api._get_db()
    db_schema = None

    pmlib.delete_asset_device_mappings(df=df, db=db, db_schema=db_schema)

    pmlib.delete_iot_type(name=iot_type, use_wiotp=use_wiotp, db=db, db_schema=db_schema)

    df = pd.read_csv('%s/trainbrake_asset_faildates.csv' % current_directory)
    df['asset'] = df['asset'].str.replace('TRAINBRAKE', assetid_prefix)
    df['site'] = siteid
    print(df.head())

    resp = pmlib.delete_asset_failure_history(df, siteid_column='site', assetid_column='asset')
    print_resp(resp)

    df = pd.read_csv('%s/trainbrake_asset_attributes.csv' % current_directory)
    df['asset'] = df['asset'].str.replace('TRAINBRAKE', assetid_prefix)
    df['site'] = siteid
    print(df.head())

    resp = pmlib.delete_assets(df, siteid_column='site', assetid_column='asset')
    print_resp(resp)


if __name__ == '__main__':
    test(iot_type='BrakeSensor1030', assetid_prefix='BRAKE1030', deviceid_prefix='Brake1030', use_wiotp=False)

